/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GoDarkAbility
extends BaseToggleAbility {
    public static final float DETECTABILITY_MULT = 0.5f;

    protected String getActivationText() {
        return "\u533f\u8e2a";
    }

    protected String getDeactivationText() {
        return null;
    }

    protected void activateImpl() {
    }

    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level < 1.0f) {
            level = 0.0f;
        }
        float d = fleet.getStats().getDynamic().getValue("go_dark_effectiveness");
        fleet.getStats().getDetectedRangeMod().modifyMult(this.getModId(), 1.0f + (0.5f * d - 1.0f) * level, "\u533f\u8e2a");
        fleet.goSlowOneFrame();
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), new Color(0, 0, 0, 0), 1.0f, 1.0f, 1.0f);
            view.getContrailDurMult().shift(this.getModId(), 0.0f, 1.0f, 1.0f, 1.0f);
            view.getEngineGlowSizeMult().shift(this.getModId(), 0.5f, 1.0f, 1.0f, 1.0f);
            view.getEngineHeightMult().shift(this.getModId(), 0.5f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    public boolean showProgressIndicator() {
        return false;
    }

    public boolean showActiveIndicator() {
        return this.isActive();
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (\u5173) ";
        if (this.turnedOn) {
            status = " (\u5f00) ";
        }
        LabelAPI title = tooltip.addTitle(String.valueOf(this.spec.getName()) + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("\u5173\u95ed\u4e00\u5207\u975e\u5fc5\u8981\u7684\u7cfb\u7edf\uff0c\u964d\u4f4e %s \u88ab\u4fa6\u6d4b\u8303\u56f4\uff0c\u6b64\u65f6\u8230\u961f\u5c06\u8fdb\u884c %s *\u3002", pad, highlight, "50%", "\u7f13\u901f\u822a\u884c");
        tooltip.addPara("* \u5f53\u5b87\u5b99\u822a\u884c\u901f\u5ea6\u4ec5\u4e3a\u6700\u6162\u8230\u8239\u7684\u4e00\u534a\u65f6\uff0c\u5c31\u89c6\u4e3a\u7f13\u901f\u822a\u884c\u3002", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean hasTooltip() {
        return true;
    }
}

