/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.impl.campaign.abilities.GraviticScanData;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraviticScanAbility
extends BaseToggleAbility {
    public static float SLIPSTREAM_DETECTION_RANGE = 20000.0f;
    public static String COMMODITY_ID = "volatiles";
    public static float COMMODITY_PER_DAY = 1.0f;
    public static float DETECTABILITY_PERCENT = 50.0f;
    protected float phaseAngle;
    protected GraviticScanData data = null;
    protected transient SpriteAPI texture;

    @Override
    protected String getActivationText() {
        if (COMMODITY_ID != null && this.getFleet() != null && this.getFleet().getCargo().getCommodityQuantity(COMMODITY_ID) <= 0.0f && (!Global.getSettings().isDevMode() || Global.getSettings().getBoolean("playtestingMode"))) {
            return null;
        }
        return "\u4e2d\u5fae\u5b50\u63a2\u6d4b\u5668\u6fc0\u6d3b";
    }

    @Override
    protected String getDeactivationText() {
        return null;
    }

    @Override
    protected void activateImpl() {
    }

    @Override
    public boolean showProgressIndicator() {
        return false;
    }

    @Override
    public boolean showActiveIndicator() {
        return this.isActive();
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color bad = Misc.getNegativeHighlightColor();
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (\u5173) ";
        if (this.turnedOn) {
            status = " (\u5f00) ";
        }
        LabelAPI title = tooltip.addTitle(String.valueOf(this.spec.getName()) + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("\u91cd\u65b0\u914d\u7f6e\u8230\u961f\u7684\u9a71\u52a8\u573a\uff0c\u4f7f\u5176\u4f5c\u4e3a\u4e00\u4e2a\u4e2d\u5fae\u5b50\u63a2\u6d4b\u5668\uff0c\u6765\u5141\u8bb8\u4f60\u5728\u6781\u8fdc\u7684\u8ddd\u79bb\u5185\u68c0\u6d4b\u51fa\u4eba\u9020\u7269\u4f53 - \u5076\u5c14\u4e5f\u80fd\u68c0\u6d4b\u51fa\u8230\u961f\u3002", pad);
        tooltip.addSectionHeading("\u666e\u901a\u7a7a\u95f4", Alignment.MID, pad);
        tooltip.addPara("\u9ad8\u8f90\u5c04\u4fe1\u53f7\u6e90\u5982\u6052\u661f\uff0c\u884c\u661f\uff0c\u8df3\u8dc3\u70b9\u548c\u7a7a\u95f4\u7ad9\u5c06\u4ea7\u751f\u6301\u7eed\u4fe1\u53f7\u3002\u5e38\u89c4\u4fe1\u53f7\u6e90\u5c06\u4ea7\u751f\u5468\u671f\u6027\u7684\u77ed\u6682\u4fe1\u53f7\u3002\u4f4e\u8f90\u5c04\u4fe1\u53f7\u6e90\u5c06\u4ea7\u751f\u4e0d\u89c4\u5f8b\u7684\u77ed\u6682\u4fe1\u53f7\u3002", pad);
        tooltip.addPara("\u975e\u5e38\u4e0d\u53ef\u9760\uff0c\u51e0\u4e4e\u53ef\u4ee5\u4fdd\u8bc1\u4f1a\u4ea7\u751f\u5927\u91cf\u9519\u8bef\u8bfb\u6570\u3002", pad);
        if (COMMODITY_ID != null) {
            String \u5355\u4f4d = "\u5355\u4f4d";
            if (COMMODITY_PER_DAY != 1.0f) {
                \u5355\u4f4d = "\u5355\u4f4d";
            }
            CommoditySpecAPI spec = this.getCommodity();
            \u5355\u4f4d = String.valueOf(\u5355\u4f4d) + "\u7684 " + spec.getName().toLowerCase();
            tooltip.addPara("\u63d0\u9ad8 %s \u88ab\u63a2\u6d4b\u8303\u56f4\uff0c\u5e76\u4e14\u6bcf\u5929\u6d88\u8017 %s " + \u5355\u4f4d + " \u5355\u4f4d\u3002", pad, highlight, (int)DETECTABILITY_PERCENT + "%", Misc.getRoundedValueMaxOneAfterDecimal(COMMODITY_PER_DAY));
        } else {
            tooltip.addPara("\u63d0\u9ad8\u8230\u961f\u53ef\u4ee5\u63a2\u6d4b\u5230\u7684\u8303\u56f4 %s}\u3002", pad, highlight, (int)DETECTABILITY_PERCENT + "%");
        }
        int maxRange = Math.round(SLIPSTREAM_DETECTION_RANGE / Misc.getUnitsPerLightYear());
        tooltip.addSectionHeading("\u8d85\u7a7a\u95f4", Alignment.MID, pad);
        tooltip.addPara("\u80fd\u53ef\u9760\u4fa6\u6d4b\u5230 %s \u5149\u5e74\u8303\u56f4\u5185\u7684\u8d85\u7a7a\u95f4\u6ed1\u6d41\u3002\u788d\u4e8e\u80cc\u666f\u566a\u97f3\u6c34\u5e73\uff0c\u8be5\u6280\u80fd\u65e0\u6cd5\u63a2\u6d4b\u5230\u5176\u4ed6\u7684\u4e2d\u5fae\u5b50\u6e90\u3002\u5f53\u8230\u961f\u5728\u6ed1\u6d41\u5185\u822a\u884c\u65f6\uff0c\u63a2\u6d4b\u5668\u4f1a\u56e0\u8fc7\u8f7d\u800c\u5173\u95ed\u3002", pad, highlight, "" + maxRange);
        if (Misc.isInsideSlipstream(this.getFleet())) {
            tooltip.addPara("\u65e0\u6cd5\u5728\u6ed1\u6d41\u5185\u8fd0\u884c\u3002", bad, pad);
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return EnumSet.of(CampaignEngineLayers.ABOVE);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.data != null && !this.isActive() && this.getProgressFraction() <= 0.0f) {
            this.data = null;
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), DETECTABILITY_PERCENT * level, "\u91cd\u529b\u626b\u63cf");
        float days = Global.getSector().getClock().convertToDays(amount);
        this.phaseAngle += days * 360.0f * 10.0f;
        this.phaseAngle = Misc.normalizeAngle(this.phaseAngle);
        if (this.data == null) {
            this.data = new GraviticScanData(this);
        }
        this.data.advance(days);
        if (COMMODITY_ID != null) {
            float cost = days * COMMODITY_PER_DAY;
            if (fleet.getCargo().getCommodityQuantity(COMMODITY_ID) > 0.0f || Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode")) {
                fleet.getCargo().removeCommodity(COMMODITY_ID, cost);
            } else {
                CommoditySpecAPI spec = this.getCommodity();
                fleet.addFloatingText("\u7f3a\u5c11 " + spec.getName().toLowerCase(), Misc.setAlpha(this.entity.getIndicatorColor(), 255), 0.5f);
                this.deactivate();
            }
        }
        if (Misc.isInsideSlipstream(fleet)) {
            this.deactivate();
        }
    }

    public CommoditySpecAPI getCommodity() {
        return Global.getSettings().getCommoditySpec(COMMODITY_ID);
    }

    @Override
    public boolean isUsable() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return false;
        }
        return !Misc.isInsideSlipstream(fleet);
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    public float getRingRadius() {
        return this.getFleet().getRadius() + 75.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        if (this.data == null) {
            return;
        }
        float level = this.getProgressFraction();
        if (level <= 0.0f) {
            return;
        }
        if (this.getFleet() == null) {
            return;
        }
        if (!this.getFleet().isPlayerFleet()) {
            return;
        }
        float alphaMult = viewport.getAlphaMult() * level;
        float bandWidthInTexture = 256.0f;
        float radStart = this.getRingRadius();
        float radEnd = radStart + 75.0f;
        float circ = (float)(Math.PI * 2 * (double)(radStart + radEnd) / 2.0);
        float pixelsPerSegment = circ / 360.0f;
        float segments = Math.round(circ / pixelsPerSegment);
        float startRad = (float)Math.toRadians(0.0);
        float endRad = (float)Math.toRadians(360.0);
        float spanRad = Math.abs(endRad - startRad);
        float anglePerSegment = spanRad / segments;
        Vector2f loc = this.getFleet().getLocation();
        float x = loc.x;
        float y = loc.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glEnable((int)3553);
        if (this.texture == null) {
            this.texture = Global.getSettings().getSprite("abilities", "neutrino_detector");
        }
        this.texture.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        boolean outlineMode = false;
        if (outlineMode) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        float thickness = (radEnd - radStart) * 1.0f;
        float radius = radStart;
        float texProgress = 0.0f;
        float texHeight = this.texture.getTextureHeight();
        float imageHeight = this.texture.getHeight();
        float texPerSegment = pixelsPerSegment * texHeight / imageHeight * bandWidthInTexture / thickness;
        float totalTex = Math.max(1.0f, (float)Math.round((texPerSegment *= 1.0f) * segments));
        texPerSegment = totalTex / segments;
        float texWidth = this.texture.getTextureWidth();
        float imageWidth = this.texture.getWidth();
        Color color = new Color(25, 215, 255, 255);
        int iter = 0;
        while (iter < 2) {
            float bandIndex;
            if (iter == 0) {
                bandIndex = 1.0f;
            } else {
                bandIndex = 0.0f;
                texProgress = segments / 2.0f * texPerSegment;
            }
            if (iter == 1) {
                GL11.glBlendFunc((int)770, (int)1);
            }
            float leftTX = bandIndex * texWidth * bandWidthInTexture / imageWidth;
            float rightTX = (bandIndex + 1.0f) * texWidth * bandWidthInTexture / imageWidth - 0.001f;
            GL11.glBegin((int)8);
            float i = 0.0f;
            while (i < segments + 1.0f) {
                float segIndex = i % (float)((int)segments);
                float phaseAngleRad = iter == 0 ? (float)Math.toRadians(this.phaseAngle) + segIndex * anglePerSegment * 29.0f : (float)Math.toRadians(-this.phaseAngle) + segIndex * anglePerSegment * 17.0f;
                float angle = (float)Math.toDegrees(segIndex * anglePerSegment);
                float pulseSin = (float)Math.sin(phaseAngleRad);
                float pulseMax = thickness * 0.5f;
                pulseMax = thickness * 0.2f;
                pulseMax = 10.0f;
                float pulseAmount = pulseSin * pulseMax;
                float pulseInner = pulseAmount * 0.1f;
                float r = radius;
                float theta = anglePerSegment * segIndex;
                float cos = (float)Math.cos(theta);
                float sin = (float)Math.sin(theta);
                float rInner = r - pulseInner;
                float rOuter = r + thickness - pulseAmount;
                float grav = this.data.getDataAt(angle);
                if (grav > 750.0f) {
                    grav = 750.0f;
                }
                grav *= 0.33333334f;
                float alpha = alphaMult;
                float x1 = cos * rInner;
                float y1 = sin * rInner;
                float x2 = cos * (rOuter += (grav *= level));
                float y2 = sin * rOuter;
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * (alpha *= 0.25f + Math.min(grav / 100.0f, 0.75f)))));
                GL11.glTexCoord2f((float)leftTX, (float)texProgress);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)rightTX, (float)texProgress);
                GL11.glVertex2f((float)(x2 += (float)(Math.cos(phaseAngleRad) * (double)pixelsPerSegment * (double)0.33f)), (float)(y2 += (float)(Math.sin(phaseAngleRad) * (double)pixelsPerSegment * (double)0.33f)));
                texProgress += texPerSegment * 1.0f;
                i += 1.0f;
            }
            GL11.glEnd();
            ++iter;
        }
        GL11.glPopMatrix();
        if (outlineMode) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }
}

