/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class InterdictionPulseAbility
extends BaseDurationAbility {
    public static final float MAX_EFFECT = 1.0f;
    public static final float BASE_RANGE = 500.0f;
    public static final float BASE_SECONDS = 6.0f;
    public static final float STRENGTH_PER_SECOND = 200.0f;
    public static final float DETECTABILITY_PERCENT = 100.0f;
    protected Boolean primed = null;
    protected Float elapsed = null;
    protected Integer numFired = null;

    public static float getRange(CampaignFleetAPI fleet) {
        return 500.0f + fleet.getSensorRangeMod().computeEffective(fleet.getSensorStrength()) / 2.0f;
    }

    protected String getActivationText() {
        return "\u963b\u65ad\u8109\u51b2";
    }

    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Global.getSector().addPing((SectorEntityToken)fleet, "interdict");
        float range = InterdictionPulseAbility.getRange(fleet);
        for (CampaignFleetAPI other : fleet.getContainingLocation().getFleets()) {
            float dist;
            if (other == fleet || (dist = Misc.getDistance(fleet.getLocation(), other.getLocation())) > range + 500.0f) continue;
            other.addScript(new IPReactionScript(fleet, other, this.getActivationDays()));
        }
        this.primed = true;
    }

    protected void showRangePing(float amount) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        SectorEntityToken.VisibilityLevel vis = fleet.getVisibilityLevelToPlayerFleet();
        if (vis == SectorEntityToken.VisibilityLevel.NONE || vis == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
            return;
        }
        boolean fire = false;
        if (this.elapsed == null) {
            this.elapsed = Float.valueOf(0.0f);
            this.numFired = 0;
            fire = true;
        }
        this.elapsed = Float.valueOf(this.elapsed.floatValue() + amount);
        if (this.elapsed.floatValue() > 0.5f && this.numFired < 4) {
            this.elapsed = Float.valueOf(this.elapsed.floatValue() - 0.5f);
            fire = true;
        }
        if (fire) {
            this.numFired = this.numFired + 1;
            float range = InterdictionPulseAbility.getRange(fleet);
            CampaignPingSpec custom = new CampaignPingSpec();
            custom.setUseFactionColor(true);
            custom.setWidth(7.0f);
            custom.setMinRange(range - 100.0f);
            custom.setRange(200.0f);
            custom.setDuration(2.0f);
            custom.setAlphaMult(0.25f);
            custom.setInFraction(0.2f);
            custom.setNum(1);
            Global.getSector().addPing((SectorEntityToken)fleet, custom);
        }
    }

    protected void applyEffect(float amount, float level) {
        boolean playedHit;
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), 100.0f * level, "\u963b\u65ad\u8109\u51b2");
        if (level > 0.0f && level < 1.0f && amount > 0.0f) {
            this.showRangePing(amount);
            fleet.goSlowOneFrame();
            return;
        }
        float range = InterdictionPulseAbility.getRange(fleet);
        boolean bl = playedHit = !this.entity.isInCurrentLocation() || !this.entity.isVisibleToPlayerFleet();
        if (level == 1.0f && this.primed != null) {
            if (this.entity.isInCurrentLocation()) {
                Global.getSector().getMemoryWithoutUpdate().set("$interdictionPulseJustUsed", true, 0.1f);
            }
            fleet.getMemoryWithoutUpdate().set("$justDidInterdictionPulse", true, 0.1f);
            CampaignPingSpec custom = new CampaignPingSpec();
            custom.setUseFactionColor(true);
            custom.setWidth(15.0f);
            custom.setRange(range * 1.3f);
            custom.setDuration(0.5f);
            custom.setAlphaMult(1.0f);
            custom.setInFraction(0.1f);
            custom.setNum(1);
            Global.getSector().addPing((SectorEntityToken)fleet, custom);
            for (CampaignFleetAPI other : fleet.getContainingLocation().getFleets()) {
                SectorEntityToken.VisibilityLevel vis;
                float dist;
                if (other == fleet || other.getFaction() == fleet.getFaction() || other.isInHyperspaceTransition() || (dist = Misc.getDistance(fleet.getLocation(), other.getLocation())) > range) continue;
                float interdictSeconds = InterdictionPulseAbility.getInterdictSeconds(fleet, other);
                if (interdictSeconds > 0.0f && interdictSeconds < 1.0f) {
                    interdictSeconds = 1.0f;
                }
                if ((vis = other.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || vis == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || vis == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT && fleet.isPlayerFleet()) {
                    if (interdictSeconds <= 0.0f) {
                        other.addFloatingText("\u963b\u65ad\u907f\u514d\uff01", fleet.getFaction().getBaseUIColor(), 1.0f, true);
                        continue;
                    }
                    other.addFloatingText("\u963b\u65ad\uff01(" + Math.round(interdictSeconds) + "\u79d2) ", fleet.getFaction().getBaseUIColor(), 1.0f, true);
                }
                float interdictDays = interdictSeconds / Global.getSector().getClock().getSecondsPerDay();
                for (AbilityPlugin ability : other.getAbilities().values()) {
                    if (!ability.getSpec().hasTag("burn+") && !ability.getSpec().hasTag("disabled_by_interdict") && !ability.getId().equals("interdiction_pulse")) continue;
                    float origCooldown = ability.getCooldownLeft();
                    float extra = 0.0f;
                    if (ability.isActiveOrInProgress()) {
                        extra += ability.getSpec().getDeactivationCooldown() * ability.getProgressFraction();
                        ability.deactivate();
                    }
                    if (!ability.getSpec().hasTag("burn+")) continue;
                    float cooldown = interdictDays;
                    cooldown += origCooldown;
                    float max = Math.max(ability.getSpec().getDeactivationCooldown(), 2.0f);
                    if ((cooldown += extra) > max) {
                        cooldown = max;
                    }
                    ability.setCooldownLeft(cooldown);
                }
                if (fleet.isPlayerFleet() && other.knowsWhoPlayerIs() && fleet.getFaction() != other.getFaction()) {
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.INTERDICTED, null, null, false), other.getFaction().getId());
                }
                if (playedHit) continue;
                Global.getSoundPlayer().playSound("world_interdict_hit", 1.0f, 1.0f, other.getLocation(), other.getVelocity());
            }
            this.primed = null;
            this.elapsed = null;
            this.numFired = null;
        }
    }

    public static float getInterdictSeconds(CampaignFleetAPI fleet, CampaignFleetAPI other) {
        float defense;
        float offense = fleet.getSensorRangeMod().computeEffective(fleet.getSensorStrength());
        float diff = offense - (defense = other.getSensorRangeMod().computeEffective(other.getSensorStrength()));
        float extra = diff / 200.0f;
        float total = 6.0f + extra;
        if (total < 0.0f) {
            total = 0.0f;
        }
        return total;
    }

    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        this.primed = null;
    }

    public boolean isUsable() {
        return super.isUsable() && this.getFleet() != null;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle("\u963b\u65ad\u8109\u51b2");
        float pad = 10.0f;
        int range = (int)InterdictionPulseAbility.getRange(fleet);
        tooltip.addPara("\u4f7f\u8230\u961f \u7f13\u901f\u822a\u884c* \u5e76\u8ba9\u4e3b\u52a8\u4f20\u611f\u5668\u7f51\u7edc\u5145\u7535\uff0c\u6765\u91ca\u653e\u5f3a\u5927\u7684\u80fd\u91cf\u8109\u51b2\u3002\u4ece\u800c\u7834\u574f\u9644\u8fd1\u8230\u961f\u7684\u9a71\u52a8\u529b\u573a\u3002", pad);
        Color c = Misc.getTooltipTitleAndLightHighlightColor();
        tooltip.addPara("\u963b\u65ad\u8109\u51b2\u5c06\u6253\u65ad\u4efb\u4f55\u673a\u52a8\u6027\u76f8\u5173\u7684\u6280\u80fd (\u4f8b\u5982 %s)\uff0c\u5e76\u5728\u968f\u540e\u7684\u4e00\u6bb5\u65f6\u95f4\u5185\u963b\u6b62\u5b83\u4eec\u88ab\u4f7f\u7528\u3002\u540c\u65f6\u4e5f\u4f1a\u6253\u65ad\u5176\u4ed6\u963b\u65ad\u8109\u51b2\u7684\u5145\u80fd\u3002", pad, highlight, "\u6301\u7eed\u52a0\u901f");
        tooltip.addPara("\u57fa\u7840\u7684\u963b\u65ad\u65f6\u95f4\u662f %s \u79d2\uff0c\u4e14\u6839\u636e\u8230\u961f\u95f4\u63a2\u6d4b\u8303\u56f4\u7684\u5dee\u8ddd \u4f1a\u6709\u589e\u51cf\u53d8\u52a8\uff0c\u6bcf %s \u79d2\u7684\u53d8\u52a8\u662f\u7531 %s \u5355\u4f4d\u7684\u5dee\u8ddd\u9020\u6210\u7684\u3002", pad, highlight, "6", "1", "200");
        tooltip.addPara("\u4f5c\u7528\u8ddd\u79bb\u4e3a\u57fa\u7840\u7684 %s* \u5355\u4f4d\u518d\u52a0\u4e0a\u4f60\u7684\u8230\u961f\u4f20\u611f\u5668\u63a2\u6d4b\u5f3a\u5ea6\u7684\u4e00\u534a\uff0c\u5171\u8ba1 %s \u5355\u4f4d\u3002\u5f53\u8109\u51b2\u5145\u80fd\u65f6\uff0c\u8230\u961f\u80fd\u88ab\u53d1\u73b0\u7684\u8ddd\u79bb\u5c06\u9010\u6e10\u589e\u52a0\u5230\u6700\u9ad8 %s}\u3002", pad, highlight, "500", "" + range, "100%");
        tooltip.addPara("\u6210\u529f\u963b\u65ad\u4f1a\u88ab\u8ba4\u4e3a\u662f\u654c\u5bf9\u884c\u4e3a\uff0c\u4f46\u4e0d\u5982\u516c\u5f00\u4ea4\u6218\u90a3\u822c\u4e25\u91cd\u3002", pad);
        tooltip.addPara("* 2000 \u5355\u4f4d = 1 \u5730\u56fe\u7f51\u683c\u5355\u5143", gray, pad);
        tooltip.addPara("* \u5f53\u5b87\u5b99\u822a\u884c\u901f\u5ea6\u4ec5\u4e3a\u6700\u6162\u8230\u8239\u7684\u4e00\u534a\u65f6\uff0c\u5c31\u89c6\u4e3a\u7f13\u901f\u822a\u884c\u3002", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean hasTooltip() {
        return true;
    }

    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
        if (engagedInHostilities) {
            this.deactivate();
        }
    }

    public void fleetOpenedMarket(MarketAPI market) {
        this.deactivate();
    }

    public static class IPReactionScript
    implements EveryFrameScript {
        float delay;
        boolean done;
        CampaignFleetAPI other;
        CampaignFleetAPI fleet;
        float activationDays;

        public IPReactionScript(CampaignFleetAPI fleet, CampaignFleetAPI other, float activationDays) {
            this.fleet = fleet;
            this.other = other;
            this.activationDays = activationDays;
            this.delay = 0.3f + 0.3f * (float)Math.random();
        }

        public void advance(float amount) {
            if (this.done) {
                return;
            }
            this.delay -= amount;
            if (this.delay > 0.0f) {
                return;
            }
            SectorEntityToken.VisibilityLevel level = this.fleet.getVisibilityLevelTo(this.other);
            if (level == SectorEntityToken.VisibilityLevel.NONE || level == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
                this.done = true;
                return;
            }
            if (!(this.other.getAI() instanceof ModularFleetAIAPI)) {
                this.done = true;
                return;
            }
            ModularFleetAIAPI ai = (ModularFleetAIAPI)this.other.getAI();
            float dist = Misc.getDistance(this.fleet.getLocation(), this.other.getLocation());
            float speed = Math.max(1.0f, this.other.getTravelSpeed());
            float eta = dist / speed;
            float rushTime = this.activationDays * Global.getSector().getClock().getSecondsPerDay();
            rushTime += 0.5f + 0.5f * (float)Math.random();
            MemoryAPI mem = this.other.getMemoryWithoutUpdate();
            CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
            if (eta < rushTime && pursueTarget == this.fleet) {
                this.done = true;
                return;
            }
            float range = InterdictionPulseAbility.getRange(this.fleet);
            float getAwayTime = 1.0f + (range - dist) / speed;
            AbilityPlugin sb = this.other.getAbility("sensor_burst");
            if (getAwayTime > rushTime && sb != null && sb.isUsable() && (float)Math.random() > 0.67f) {
                sb.activate();
                this.done = true;
                return;
            }
            float avoidRange = InterdictionPulseAbility.getRange(this.other) + 100.0f;
            ai.getNavModule().avoidLocation(this.fleet.getContainingLocation(), this.fleet.getLocation(), avoidRange, avoidRange + 50.0f, this.activationDays + 0.01f);
            ai.getNavModule().avoidLocation(this.fleet.getContainingLocation(), Misc.getPointAtRadius(this.fleet.getLocation(), avoidRange * 0.5f), avoidRange, avoidRange * 1.5f + 50.0f, this.activationDays + 0.05f);
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return false;
        }
    }
}

