/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSurveyAbility
extends BaseDurationAbility {
    public static final float SURVEY_RANGE = 10000.0f;
    public static final float DETECTABILITY_RANGE_BONUS = 5000.0f;
    public static final float ACCELERATION_MULT = 4.0f;
    protected boolean performed = false;

    @Override
    protected void activateImpl() {
        if (this.entity.isInCurrentLocation()) {
            SectorEntityToken.VisibilityLevel level = this.entity.getVisibilityLevelToPlayerFleet();
            if (level != SectorEntityToken.VisibilityLevel.NONE) {
                Global.getSector().addPing(this.entity, "remote_survey");
            }
            this.performed = false;
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getFleetwideMaxBurnMod().modifyMult(this.getModId(), 0.0f, "\u8fdc\u7a0b\u8c03\u67e5");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 5000.0f * level, "\u8fdc\u7a0b\u8c03\u67e5");
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f + 3.0f * level);
        if (!this.performed && level >= 1.0f) {
            for (PlanetAPI planet : this.getSurveyableInRange()) {
                MarketAPI market = planet.getMarket();
                MarketAPI.SurveyLevel surveyLevel = market.getSurveyLevel();
                if (market == null || surveyLevel != MarketAPI.SurveyLevel.SEEN && surveyLevel != MarketAPI.SurveyLevel.NONE) continue;
                Misc.setPreliminarySurveyed(market, null, true);
            }
            this.performed = true;
        }
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet.isInHyperspace() || fleet.isInHyperspaceTransition()) {
            return false;
        }
        return !this.getSurveyableInRange().isEmpty();
    }

    protected List<PlanetAPI> getAllPlanetsInRange() {
        ArrayList<PlanetAPI> result = new ArrayList<PlanetAPI>();
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        if (fleet.isInHyperspace()) {
            return result;
        }
        for (PlanetAPI planet : fleet.getContainingLocation().getPlanets()) {
            float dist;
            if (planet.isStar() || planet.getMarket() == null || !((dist = Misc.getDistance(fleet.getLocation(), planet.getLocation())) <= 10000.0f)) continue;
            result.add(planet);
        }
        return result;
    }

    protected List<PlanetAPI> getSurveyableInRange() {
        List<PlanetAPI> result = this.getAllPlanetsInRange();
        Iterator<PlanetAPI> iter = result.iterator();
        while (iter.hasNext()) {
            PlanetAPI curr = iter.next();
            MarketAPI.SurveyLevel level = curr.getMarket().getSurveyLevel();
            if (level == MarketAPI.SurveyLevel.SEEN || level == MarketAPI.SurveyLevel.NONE) continue;
            iter.remove();
        }
        return result;
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle(this.spec.getName());
        float pad = 10.0f;
        tooltip.addPara("\u534f\u8c03\u8230\u961f\u7684\u4e3b\u52a8\u4f20\u611f\u5668\u7f51\u7edc\uff0c\u4ee5\u4fbf\u5bf9 %s* \u5355\u4f4d\u5185\u7684\u6240\u6709\u672a\u63a2\u7d22\u884c\u661f\u8fdb\u884c\u521d\u6b65\u8c03\u67e5\u3002", pad, highlight, "10000");
        tooltip.addPara("\u63d0\u9ad8 %s* \u5355\u4f4d\u88ab\u63a2\u6d4b\u8303\u56f4\uff0c\u5e76\u6682\u505c\u5f15\u64ce\u4f9b\u80fd\uff0c\u4ee5\u964d\u4f4e\u5e72\u6270\u3002", pad, highlight, "5000");
        List<PlanetAPI> planets = this.getSurveyableInRange();
        if (planets.isEmpty()) {
            if (this.getAllPlanetsInRange().isEmpty()) {
                tooltip.addPara("\u8303\u56f4\u5185\u6ca1\u6709\u884c\u661f\u3002", bad, pad);
            } else {
                tooltip.addPara("\u4f60\u5df2\u7ecf\u83b7\u5f97\u4e86\u8303\u56f4\u5185\u6240\u6709\u884c\u661f\u7684\u5b8c\u6574\u6216\u521d\u6b65\u8c03\u67e5\u6570\u636e\u3002", bad, pad);
            }
        } else {
            tooltip.addPara("\u4ee5\u4e0b\u672a\u88ab\u63a2\u7d22\u7684\u884c\u661f\u5728\u8303\u56f4\u5185\uff1a", pad);
            float currPad = 3.0f;
            String indent = "    ";
            for (PlanetAPI planet : planets) {
                LabelAPI label = tooltip.addPara(String.valueOf(indent) + planet.getName() + ", %s", currPad, planet.getSpec().getIconColor(), planet.getTypeNameWithWorld().toLowerCase());
                currPad = 0.0f;
            }
        }
        tooltip.addPara("* 2000 \u5355\u4f4d = 1 \u5730\u56fe\u7f51\u683c\u5355\u5143", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }
}

