/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.ToggleAbilityWithCost;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ReversePolarityToggle
extends ToggleAbilityWithCost {
    public static String REVERSED_POLARITY = "$reversedPolarity";
    public static String POLARITY_SPEED_MULT = "$polaritySpeedMult";
    public static String POLARITY_WIND_GLOW_COLOR_KEY = "$polarityWindGlowColor";
    public static Color POLARITY_WIND_GLOW_COLOR = new Color(1.0f, 0.25f, 1.0f, 0.75f);
    public static float SLIPSTREAM_SPEED_MULT = 0.75f;
    public static float CR_COST_MULT = 0.25f;
    public static float FUEL_COST_MULT = 1.0f;
    public static float ACTIVATION_DAMAGE_PROB = 0.33f;

    public float getFuelCostMult(boolean forTooltip) {
        if (!forTooltip && !this.isFleetInSlipstream()) {
            return 0.0f;
        }
        return FUEL_COST_MULT;
    }

    public float getCRCostMult(boolean forTooltip) {
        if (!forTooltip && !this.isFleetInSlipstream()) {
            return 0.0f;
        }
        return CR_COST_MULT;
    }

    public boolean canRecoverCRWhileActive(boolean forTooltip) {
        return true;
    }

    protected String getActivationText() {
        return "\u9a71\u52a8\u529b\u573a\u6781\u6027\u53cd\u8f6c";
    }

    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        return fleet.isInHyperspace();
    }

    protected void applyStatsEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (fleet.getContainingLocation() == null || !fleet.getContainingLocation().isHyperspace()) {
            this.deactivate();
            return;
        }
        if (level >= 1.0f && this.turnedOn) {
            fleet.getMemoryWithoutUpdate().set(REVERSED_POLARITY, true, this.getDeactivationDays());
            float speedMult = SLIPSTREAM_SPEED_MULT;
            fleet.getMemoryWithoutUpdate().set(POLARITY_SPEED_MULT, Float.valueOf(speedMult), this.getDeactivationDays());
            fleet.getMemoryWithoutUpdate().set(POLARITY_WIND_GLOW_COLOR_KEY, POLARITY_WIND_GLOW_COLOR, this.getDeactivationDays());
        }
        if (level <= 0.0f) {
            this.cleanupImpl();
        }
    }

    protected void applyFleetVisual(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color c = new Color(255, 0, 255, 255);
        Color cDim = new Color(255, 0, 255, 50);
        Color cDim2 = new Color(255, 0, 255, 120);
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), cDim2, 1.0f, 1.0f, 0.75f);
            view.getEngineGlowColor().shift(this.getModId(), cDim, 1.0f, 1.0f, 0.5f);
            view.getEngineGlowSizeMult().shift(this.getModId(), 3.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean isFleetInSlipstream() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return false;
        }
        return Misc.isInsideSlipstream(fleet);
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (\u5173) ";
        if (this.turnedOn) {
            status = " (\u5f00) ";
        }
        LabelAPI title = tooltip.addTitle("\u6781\u6027\u9006\u8f6c" + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("\u5c06\u9a71\u52a8\u529b\u573a\u7684\u6781\u6027\u53cd\u8f6c\uff0c\u8ba9\u8230\u961f\u6cbf\u7740\u5f53\u524d\u8d85\u7a7a\u95f4\u6ed1\u6d41\u7684\u53cd\u65b9\u5411\u524d\u8fdb\u3002", pad);
        if (SLIPSTREAM_SPEED_MULT != 1.0f) {
            tooltip.addPara("\u6cbf\u8d85\u7a7a\u95f4\u6ed1\u6d41\u7684\u53cd\u65b9\u5411\u524d\u8fdb\u662f\u6548\u7387\u4e0d\u4f73\u7684\uff0c\u5c06\u5bfc\u81f4\u5176\u822a\u901f\u589e\u76ca\u964d\u4f4e %s}\u3002", pad, highlight, Math.round(100.0f * (1.0f - SLIPSTREAM_SPEED_MULT)) + "%");
        }
        tooltip.addPara("\u5728\u8d85\u7a7a\u95f4\u6ed1\u6d41\u5916\u4f7f\u7528\u65f6\uff0c\u4e0d\u4f1a\u4ea7\u751f\u8017\u8d39\u6216\u4efb\u4f55\u60e9\u7f5a\u3002", pad);
        tooltip.addSectionHeading("\u5728\u8d85\u7a7a\u95f4\u6ed1\u6d41\u5185\u4f7f\u7528", Alignment.MID, pad);
        this.addCostTooltipSection(tooltip, expanded, "\u4e00\u79cd\u53ef\u5728\u8d85\u7a7a\u95f4\u6ed1\u6d41\u5185\u65bd\u5c55\u7684\u7d27\u6025\u63aa\u65bd\uff0c\u5c06\u9a71\u52a8\u529b\u573a\u7684\u6781\u6027\u53cd\u8f6c\u3002");
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public void addOtherNotUsableReason(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color bad = Misc.getNegativeHighlightColor();
        if (!fleet.isInHyperspace()) {
            tooltip.addPara("\u53ea\u80fd\u5728\u8d85\u7a7a\u95f4\u4e2d\u4f7f\u7528\u3002", bad, 10.0f);
        }
    }

    protected boolean showAlarm() {
        if (!this.isFleetInSlipstream()) {
            return false;
        }
        return super.showAlarm() || this.isFleetInSlipstream();
    }

    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            if (!super.showAlarm()) {
                color = Misc.getHighlightColor();
            }
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }
}

