/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SensorBurstAbility
extends BaseDurationAbility {
    public static final float SENSOR_RANGE_BONUS = 3000.0f;
    public static final float DETECTABILITY_RANGE_BONUS = 5000.0f;

    protected void activateImpl() {
        SectorEntityToken.VisibilityLevel level;
        if (this.entity.isInCurrentLocation() && (level = this.entity.getVisibilityLevelToPlayerFleet()) != SectorEntityToken.VisibilityLevel.NONE) {
            Global.getSector().addPing(this.entity, "sensor_burst");
        }
    }

    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (this.entity.isInCurrentLocation()) {
            Global.getSector().getMemoryWithoutUpdate().set("$sensorBurstJustUsed", true, 0.1f);
        }
        fleet.getMemoryWithoutUpdate().set("$justDidSensorBurst", true, 0.1f);
        fleet.getStats().getSensorRangeMod().modifyFlat(this.getModId(), 3000.0f * level, "\u4f20\u611f\u5668\u626b\u63cf");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 5000.0f * level, "\u4f20\u611f\u5668\u626b\u63cf");
        fleet.goSlowOneFrame();
    }

    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getSensorRangeMod().unmodify(this.getModId());
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        LabelAPI title = tooltip.addTitle(this.spec.getName());
        float pad = 10.0f;
        tooltip.addPara("\u8fde\u63a5\u8230\u961f\u6240\u6709\u4f20\u611f\u5668\u5e76\u8fdb\u884c\u4e00\u6b21\u5927\u8303\u56f4\u7f51\u7edc\u626b\u63cf\uff0c\u4f46\u5fc5\u987b\u5173\u95ed\u5f15\u64ce\u4ee5\u964d\u4f4e\u5e72\u6270\u3002", pad);
        tooltip.addPara("\u63d0\u9ad8 %s* \u5355\u4f4d\u7684\u4f20\u611f\u5668\u63a2\u6d4b\u8303\u56f4\u548c %s* \u5355\u4f4d\u7684\u8230\u961f\u88ab\u4fa6\u6d4b\u8303\u56f4\u3002\u80fd\u529b\u542f\u52a8\u65f6\u8230\u961f\u53ea\u80fd %s**\u3002", pad, highlight, "3000", "5000", "\u7f13\u901f\u822a\u884c");
        tooltip.addPara("* 2000 \u5355\u4f4d = 1 \u5730\u56fe\u7f51\u683c\u5355\u5143", gray, pad);
        tooltip.addPara("** \u5f53\u5b87\u5b99\u822a\u884c\u901f\u5ea6\u4ec5\u4e3a\u6700\u6162\u8230\u8239\u7684\u4e00\u534a\u65f6\uff0c\u5c31\u89c6\u4e3a\u7f13\u901f\u822a\u884c\u3002", gray, 0.0f);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean hasTooltip() {
        return true;
    }
}

