/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class SustainedBurnAbility
extends BaseToggleAbility {
    public static String SB_NO_STOP = "$sb_active";
    public static String SB_NO_SLOW = "$sb_no_slow";
    public static float DETECTABILITY_PERCENT = 100.0f;
    public static float MAX_BURN_PERCENT = 100.0f;
    public static float ACCELERATION_MULT = 0.2f;

    protected String getActivationText() {
        return super.getActivationText();
    }

    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (!fleet.getMemoryWithoutUpdate().is(SB_NO_STOP, true)) {
            fleet.setVelocity(0.0f, 0.0f);
        }
    }

    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level > 0.0f && !fleet.isAIMode() && fleet.getCargo().getFuel() <= 0.0f && fleet.getContainingLocation() != null && fleet.getContainingLocation().isHyperspace()) {
            this.deactivate();
            return;
        }
        fleet.getMemoryWithoutUpdate().set(SB_NO_STOP, true, 0.3f);
        if (level > 0.0f && level < 1.0f && amount > 0.0f && !fleet.getMemoryWithoutUpdate().is(SB_NO_SLOW, true)) {
            float activateSeconds = this.getActivationDays() * Global.getSector().getClock().getSecondsPerDay();
            float speed = fleet.getVelocity().length();
            float acc = Math.max(speed, 200.0f) / activateSeconds + fleet.getAcceleration();
            float ds = acc * amount;
            if (ds > speed) {
                ds = speed;
            }
            Vector2f dv = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(fleet.getVelocity()));
            dv.scale(ds);
            fleet.setVelocity(fleet.getVelocity().x - dv.x, fleet.getVelocity().y - dv.y);
            return;
        }
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), DETECTABILITY_PERCENT * level, "\u6301\u7eed\u52a0\u901f");
        int burnModifier = 0;
        float burnMult = 1.0f;
        float b = fleet.getStats().getDynamic().getValue("sustained_burn_bonus", 0.0f);
        burnModifier = (int)(b * level);
        fleet.getStats().getFleetwideMaxBurnMod().modifyFlat(this.getModId(), burnModifier, "\u6301\u7eed\u52a0\u901f");
        fleet.getStats().getFleetwideMaxBurnMod().modifyMult(this.getModId(), burnMult, "\u6301\u7eed\u52a0\u901f");
        fleet.getStats().getFleetwideMaxBurnMod().modifyPercent(this.getModId(), MAX_BURN_PERCENT, "\u6301\u7eed\u52a0\u901f");
        float accImpact = 0.0f;
        float burn = Misc.getBurnLevelForSpeed(fleet.getVelocity().length());
        if (burn > 1.0f) {
            float dir = Misc.getDesiredMoveDir(fleet);
            float velDir = Misc.getAngleInDegrees(fleet.getVelocity());
            float diff = Misc.getAngleDiff(dir, velDir);
            float pad = 120.0f;
            if ((diff -= pad) < 0.0f) {
                diff = 0.0f;
            }
            accImpact = 1.0f - 0.5f * Math.min(1.0f, diff / (180.0f - pad));
        }
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f - (1.0f - ACCELERATION_MULT) * accImpact);
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), view.getEngineColor().getBase(), 1.0f, 1.0f, 0.5f * level);
            view.getEngineGlowSizeMult().shift(this.getModId(), 1.5f, 1.0f, 1.0f, 1.0f * level);
            view.getEngineHeightMult().shift(this.getModId(), 3.0f, 1.0f, 1.0f, 1.0f * level);
            view.getEngineWidthMult().shift(this.getModId(), 2.0f, 1.0f, 1.0f, 1.0f * level);
        }
        if (level <= 0.0f) {
            this.cleanupImpl();
        }
    }

    protected void deactivateImpl() {
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    public boolean showProgressIndicator() {
        return super.showProgressIndicator();
    }

    public boolean showActiveIndicator() {
        return this.isActive();
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (\u5173) ";
        if (this.turnedOn) {
            status = " (\u5f00) ";
        }
        LabelAPI title = tooltip.addTitle("\u6301\u7eed\u52a0\u901f" + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("\u5c06\u8230\u961f\u5f15\u64ce\u5207\u6362\u5230\u957f\u9014\u65c5\u884c\u6a21\u5f0f\u3002\u4f46\u987b\u6682\u65f6\u7184\u706b\u6765\u8fdb\u884c\u5207\u6362\u3002", pad);
        tooltip.addPara("\u4ee5\u964d\u4f4e\u8230\u961f\u52a0\u901f\u5ea6\u4e3a\u4ee3\u4ef7\uff0c\u63d0\u9ad8 %s \u6700\u5927\u5b87\u5b99\u822a\u901f\uff0c\u4e14\u6b64\u671f\u95f4\u8230\u961f\u7684\u8f6c\u5411\u6027\u80fd\u5c06\u53d7\u663e\u8457\u5f71\u54cd\u3002\u540c\u65f6\uff0c\u4f7f\u8230\u961f\u7684\u88ab\u4fa6\u6d4b\u8303\u56f4\u6269\u5927 %s}\u3002", pad, highlight, Math.round(MAX_BURN_PERCENT) + "%", (int)DETECTABILITY_PERCENT + "%");
        tooltip.addPara("\u6240\u63d0\u9ad8\u7684\u822a\u901f\u4e0d\u5305\u62ec\u5176\u4ed6\u56e0\u7d20\u5e26\u6765\u589e\u76ca\uff0c\u5982\u5bfc\u822a\u6d6e\u6807\u6216\u62d6\u8239\u3002", pad);
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet != null && !fleet.isAIMode() && fleet.getCargo().getFuel() <= 0.0f && fleet.getContainingLocation() != null && fleet.getContainingLocation().isHyperspace()) {
            tooltip.addPara("\u71c3\u6599\u8017\u5c3d\u3002", Misc.getNegativeHighlightColor(), pad);
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        return fleet.isAIMode() || !(fleet.getCargo().getFuel() <= 0.0f) || fleet.getContainingLocation() == null || !fleet.getContainingLocation().isHyperspace();
    }

    public boolean hasTooltip() {
        return true;
    }

    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
    }

    public void fleetJoinedBattle(BattleAPI battle) {
        if (!battle.isPlayerInvolved()) {
            this.deactivate();
        }
    }
}

