/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.impl.campaign.terrain.CRRecoveryBuff;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleAbilityWithCost
extends BaseToggleAbility {
    public float getFuelCostMult(boolean forTooltip) {
        return 1.0f;
    }

    public float getCRCostMult(boolean forTooltip) {
        return 0.25f;
    }

    public float getActivationAtLowCRShipDamageProbability(boolean forTooltip) {
        return 0.33f;
    }

    public Misc.FleetMemberDamageLevel getActivationDamageLevel(boolean forTooltip) {
        return Misc.FleetMemberDamageLevel.LOW;
    }

    public boolean canRecoverCRWhileActive(boolean forTooltip) {
        return true;
    }

    public boolean shouldApplyCostWhenDeactivating(boolean forTooltip) {
        return true;
    }

    @Override
    protected void activateImpl() {
        this.deductCost();
    }

    protected void deductCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        float crCostMult = this.getCRCostMult(false);
        if (crCostMult > 0.0f) {
            for (FleetMemberAPI member : this.getNonReadyShips(false)) {
                if (!((float)Math.random() < this.getActivationAtLowCRShipDamageProbability(false))) continue;
                Misc.applyDamage(member, null, this.getActivationDamageLevel(false), false, null, null, true, null, String.valueOf(member.getShipName()) + " \u4e0d\u614e\u56e0\u6fc0\u6d3b " + this.spec.getName() + " \u800c\u53d7\u5230\u4e86\u635f\u4f24");
            }
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                float crLoss = this.getCRCost(member, false);
                member.getRepairTracker().applyCREvent(-crLoss, Misc.ucFirst(this.spec.getName().toLowerCase()));
            }
        }
        float cost = this.computeFuelCost(false);
        fleet.getCargo().removeFuel(cost);
    }

    protected void applyStatsEffect(float amount, float level) {
    }

    protected void unapplyStatsEffect() {
    }

    protected void applyFleetVisual(float amount, float level) {
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        this.applyStatsEffect(amount, level);
        this.applyFleetVisual(amount, level);
        if (!this.canRecoverCRWhileActive(false)) {
            String buffId = this.getModId();
            float buffDur = 0.1f;
            boolean needsSync = false;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                if (level <= 0.0f) {
                    member.getBuffManager().removeBuff(buffId);
                    needsSync = true;
                    continue;
                }
                BuffManagerAPI.Buff test = member.getBuffManager().getBuff(buffId);
                if (test instanceof CRRecoveryBuff) {
                    CRRecoveryBuff buff = (CRRecoveryBuff)test;
                    buff.setDur(buffDur);
                    continue;
                }
                member.getBuffManager().addBuff(new CRRecoveryBuff(buffId, 0.0f, buffDur));
                needsSync = true;
            }
            if (needsSync) {
                fleet.forceSync();
            }
        }
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
        if (this.shouldApplyCostWhenDeactivating(false)) {
            this.deductCost();
        }
    }

    @Override
    protected void cleanupImpl() {
        this.unapplyStatsEffect();
    }

    protected List<FleetMemberAPI> getNonReadyShips(boolean forTooltip) {
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        if (this.getCRCostMult(forTooltip) <= 0.0f) {
            return result;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float crLoss = this.getCRCost(member, forTooltip);
            if (Math.round(member.getRepairTracker().getCR() * 100.0f) >= Math.round(crLoss * 100.0f)) continue;
            result.add(member);
        }
        return result;
    }

    public float getCRCost(FleetMemberAPI member, boolean forTooltip) {
        float crCostMult = this.getCRCostMult(forTooltip);
        float crLoss = member.getDeployCost() * crCostMult;
        return (float)Math.round(crLoss * 100.0f) / 100.0f;
    }

    protected float computeFuelCost(boolean forTooltip) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float cost = fleet.getLogistics().getFuelCostPerLightYear() * this.getFuelCostMult(forTooltip);
        return cost;
    }

    protected float computeSupplyCost(boolean forTooltip) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float crCostMult = this.getCRCostMult(forTooltip);
        float cost = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            cost += member.getDeploymentCostSupplies() * crCostMult;
        }
        return cost;
    }

    public void addOtherNotUsableReason(TooltipMakerAPI tooltip, boolean expanded) {
    }

    public void addCostTooltipSection(TooltipMakerAPI tooltip, boolean expanded, String prefix) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        float pad = 10.0f;
        float fuelCost = this.computeFuelCost(true);
        float supplyCost = this.computeSupplyCost(true);
        String preventsRecovery = "";
        if (!this.canRecoverCRWhileActive(true)) {
            preventsRecovery = " \u6fc0\u6d3b\u65f6\u65e0\u6cd5\u6062\u590d\u6218\u5907\u503c\u3002";
        }
        String deactivateCost = "";
        if (this.shouldApplyCostWhenDeactivating(true)) {
            deactivateCost = " \u5173\u95ed\u65f6\u5c06\u518d\u6b21\u6d88\u8017\u7b49\u91cf\u8d44\u6e90\u3002";
        }
        preventsRecovery = String.valueOf(preventsRecovery) + deactivateCost;
        if (supplyCost > 0.0f && fuelCost > 0.0f) {
            prefix = prefix == null ? "" : String.valueOf(prefix) + "";
            tooltip.addPara(String.valueOf(prefix) + "\u6d88\u8017 %s \u71c3\u6599\uff0c\u5e76\u5bfc\u81f4\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c\u4e0b\u964d\uff0c" + "\u9700\u8981\u6d88\u8017 %s \u8865\u7ed9\u8fdb\u884c\u6062\u590d\u3002" + preventsRecovery, pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost), Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else if (supplyCost > 0.0f) {
            prefix = prefix == null ? "" : String.valueOf(prefix) + "";
            tooltip.addPara(String.valueOf(prefix) + "\u5bfc\u81f4\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c\u4e0b\u964d\uff0c" + "\u9700\u8981\u6d88\u8017 %s \u8865\u7ed9\u8fdb\u884c\u6062\u590d\u3002" + preventsRecovery, pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else if (fuelCost > 0.0f) {
            prefix = prefix == null ? "" : String.valueOf(prefix) + "";
            tooltip.addPara(String.valueOf(prefix) + "\u6d88\u8017 %s \u71c3\u6599\u3002" + preventsRecovery, pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost));
        }
        if (fuelCost > 0.0f && fuelCost > fleet.getCargo().getFuel()) {
            tooltip.addPara("\u71c3\u6599\u4e0d\u8db3\u3002", bad, pad);
        } else {
            this.addOtherNotUsableReason(tooltip, expanded);
        }
        List<FleetMemberAPI> nonReady = this.getNonReadyShips(true);
        if (!nonReady.isEmpty()) {
            tooltip.addPara("\u4ee5\u4e0b\u8230\u8239\u7684\u6218\u5907\u503c\u4e0d\u8db3\uff0c\u5982\u679c\u5f3a\u884c\u6fc0\u6d3b\u5c06\u6709\u53ef\u80fd\u906d\u53d7\u635f\u4f24\uff1a", pad, Misc.getNegativeHighlightColor(), "\u6709\u53ef\u80fd\u906d\u53d7\u635f\u4f24");
            int j = 0;
            int max = 4;
            float initPad = 5.0f;
            for (FleetMemberAPI member : nonReady) {
                if (j >= max && nonReady.size() > max + 1) {
                    tooltip.addPara("     ... \u4ee5\u53ca\u5176\u4ed6\u51e0\u8258\u8230\u8239", initPad);
                    break;
                }
                String str = "";
                if (!member.isFighterWing()) {
                    str = String.valueOf(str) + member.getShipName() + "\u3002";
                    str = String.valueOf(str) + member.getHullSpec().getHullNameWithDashClass();
                } else {
                    str = String.valueOf(str) + member.getVariant().getFullDesignationWithHullName();
                }
                tooltip.addPara("      " + str, initPad);
                initPad = 0.0f;
                ++j;
            }
        }
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public boolean isOnCooldown() {
        return super.getCooldownFraction() < 1.0f;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && this.getFleet() != null && (this.getFleet().isAIMode() || this.computeFuelCost(false) <= this.getFleet().getCargo().getFuel());
    }

    protected boolean showAlarm() {
        return !this.getNonReadyShips(false).isEmpty() && !this.isOnCooldown() && !this.isActiveOrInProgress() && this.isUsable();
    }

    @Override
    public float getCooldownFraction() {
        if (this.showAlarm()) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return this.showAlarm();
    }
}

