/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransponderAbility
extends BaseToggleAbility {
    public static final float DETECTABILITY_MULT = 1.0f;
    public static final float DETECTABILITY_FLAT = 1000.0f;
    private transient boolean showAlarm = false;
    public static final float CONFIRM_DURATION = 5.0f;
    transient float sinceWarning = 1000.0f;

    @Override
    protected String getActivationText() {
        return "\u5e94\u7b54\u5668";
    }

    @Override
    protected String getDeactivationText() {
        return null;
    }

    @Override
    protected void activateImpl() {
        List<FactionAPI> factions;
        if (this.entity.isPlayerFleet() && !(factions = this.getFactionsThatWouldBecomeHostile()).isEmpty()) {
            Global.getSector().getCampaignUI().addMessage("\u4f60\u7684\u8eab\u4efd\u5df2\u7ecf\u66b4\u9732\uff0c\u800c\u8fd9\u4e5f\u95f4\u63a5\u5bfc\u81f4\u4f60\u6700\u8fd1\u7684\u654c\u5bf9\u884c\u52a8\u65e0\u6cd5\u63a9\u76d6\uff01");
            for (FactionAPI faction : factions) {
                Global.getSector().adjustPlayerReputation((Object)CoreReputationPlugin.RepActions.COMBAT_NORMAL, faction.getId());
            }
        }
        this.entity.setTransponderOn(true);
        this.entity.getMemoryWithoutUpdate().set("$justToggledTransponder", true, 0.1f);
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level > 0.0f) {
            level = 1.0f;
        }
        fleet.getStats().getDetectedRangeMod().modifyMult(this.getModId(), 1.0f + 0.0f * level, "\u5e94\u7b54\u5668");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 1000.0f * level, "\u5e94\u7b54\u5668");
        if (level <= 0.0f) {
            this.cleanupImpl();
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.entity.isTransponderOn()) {
            this.entity.setTransponderOn(false);
            this.entity.getMemoryWithoutUpdate().set("$justToggledTransponder", true, 0.1f);
        }
    }

    @Override
    protected void deactivateImpl() {
        this.entity.setTransponderOn(false);
        this.entity.getMemoryWithoutUpdate().set("$justToggledTransponder", true, 0.1f);
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        String status = " (\u5173) ";
        if (this.entity.isTransponderOn()) {
            status = " (\u5f00) ";
        }
        LabelAPI title = tooltip.addTitle(String.valueOf(this.spec.getName()) + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("\u5e94\u7b54\u5668\u4f1a\u5411\u8303\u56f4\u5185\u7684\u6240\u6709\u8230\u961f\u53d1\u9001\u8bc6\u522b\u4fe1\u606f\u3002", pad);
        List<FactionAPI> factions = this.getFactionsThatWouldBecomeHostile();
        if (!factions.isEmpty()) {
            String text = "\u6253\u5f00\u5e94\u7b54\u5668\u65f6\u4f1a\u66b4\u9732\u4f60\u7684\u654c\u5bf9\u884c\u4e3a";
            boolean first = true;
            boolean last = false;
            for (FactionAPI faction : factions) {
                last = factions.indexOf(faction) == factions.size() - 1;
                text = first || !last ? String.valueOf(text) + " " + faction.getDisplayNameWithArticle() + "," : String.valueOf(text) + " \u548c " + faction.getDisplayNameWithArticle() + ",";
            }
            text = String.valueOf(text.substring(0, text.length() - 1)) + ".";
            tooltip.addPara(text, red, pad);
        }
        tooltip.addPara("\u5f53\u5e94\u7b54\u5668\u5f00\u542f\u65f6\uff0c\u4f60\u7684\u8230\u961f\u4e0d\u4ec5\u53ef\u4ee5\u5bf9\u66f4\u8fdc\u7684\u8303\u56f4\u8fdb\u884c\u68c0\u6d4b\uff0c\u5e76\u5728\u6700\u5927\u8303\u56f4\u5185\u53d1\u9001\u4f60\u7684\u7ec4\u6210\u4fe1\u606f\u3002", pad);
        tooltip.addPara("\u5e94\u7b54\u5668\u7684\u72b6\u6001\u4e5f\u5f71\u54cd\u4e86\u6218\u6597\u548c\u8d38\u6613\u7684\u58f0\u8a89\u53d8\u5316\u3002\u5f53\u5b83\u5173\u95ed\u65f6\uff0c\u4f60\u53ef\u4ee5\u7528\u5b83\u53bb\u5371\u9669\u548c\u654c\u5bf9\u533a\u57df\u4ea4\u6613\u3002", pad);
        tooltip.addPara("\u5728\u5927\u591a\u6570\u5730\u533a\uff0c\u5173\u95ed\u5e94\u7b54\u5668\u822a\u884c\u4f1a\u5f15\u8d77\u5468\u56f4\u5de1\u903b\u90e8\u961f\u7684\u6ce8\u610f\u3002\u4e0d\u8fc7\u4e00\u4e9b\u52bf\u529b\u548c\u81ea\u7531\u6e2f\u5730\u533a\u5141\u8bb8\u5173\u95ed\u5e94\u7b54\u5668\u901a\u884c\u3002\u5173\u95ed\u5e94\u7b54\u5668\u5e76\u4e0d\u80fd\u5b8c\u7f8e\u4fdd\u8bc1\u8eab\u4efd\u4e0d\u88ab\u66b4\u9732\u3002", pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public String getFactionList(List<FactionAPI> factions) {
        String text = "";
        boolean first = true;
        boolean last = false;
        for (FactionAPI faction : factions) {
            last = factions.indexOf(faction) == factions.size() - 1;
            text = first || !last ? String.valueOf(text) + " " + faction.getDisplayNameLongWithArticle() + "," : String.valueOf(text) + " \u548c " + faction.getDisplayNameLongWithArticle() + ",";
        }
        text = String.valueOf(text.substring(0, text.length() - 1));
        return text.trim();
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public List<FactionAPI> getFactionsThatWouldBecomeHostile() {
        return TransponderAbility.getFactionsThatWouldBecomeHostile(this.getFleet());
    }

    public static List<FactionAPI> getFactionsThatWouldBecomeHostile(CampaignFleetAPI fleet) {
        ArrayList<FactionAPI> result = new ArrayList<FactionAPI>();
        if (fleet == null) {
            return result;
        }
        if (fleet.getContainingLocation() == null) {
            return result;
        }
        if (fleet.isTransponderOn()) {
            return result;
        }
        List<CampaignFleetAPI> fleets = fleet.getContainingLocation().getFleets();
        for (CampaignFleetAPI other : fleets) {
            MemoryAPI mem;
            if (other.getFleetData().getNumMembers() <= 0) continue;
            float dist = Misc.getDistance(fleet.getLocation(), other.getLocation());
            fleet.setTransponderOn(true);
            float detectRange = (other.getMaxSensorRangeToDetect(fleet) + 1000.0f) * 1.0f * 1.25f;
            fleet.setTransponderOn(false);
            if (dist > detectRange || (mem = other.getMemoryWithoutUpdate()).getBoolean("$lowRepImpact") || result.contains(other.getFaction()) || !mem.getBoolean("$cfai_makeHostileWhileTOff") || other.getFaction().isHostileTo(fleet.getFaction())) continue;
            result.add(other.getFaction());
        }
        return result;
    }

    @Override
    public void advance(float amount) {
        CampaignFleetAPI fleet;
        if (!Global.getSector().isPaused()) {
            super.advance(amount);
        }
        if ((fleet = this.getFleet()) == null || !fleet.isPlayerFleet()) {
            return;
        }
        this.sinceWarning += amount;
        List<FactionAPI> factions = this.getFactionsThatWouldBecomeHostile();
        this.showAlarm = !factions.isEmpty();
    }

    @Override
    public boolean runWhilePaused() {
        return this.getFleet() != null && this.getFleet().isPlayerFleet();
    }

    @Override
    public boolean showProgressIndicator() {
        return this.showAlarm;
    }

    @Override
    public float getProgressFraction() {
        return 1.0f;
    }

    @Override
    public Color getProgressColor() {
        Color color = Misc.getNegativeHighlightColor();
        return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness());
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.sinceWarning = 1000.0f;
        return this;
    }

    @Override
    public void pressButton() {
        if (this.getFleet().isPlayerFleet()) {
            if (this.sinceWarning < 5.0f) {
                if (this.entity.isPlayerFleet()) {
                    List<FactionAPI> factions = this.getFactionsThatWouldBecomeHostile();
                    if (!factions.isEmpty()) {
                        String list = this.getFactionList(factions);
                        String text = "\u6253\u5f00\u5e94\u7b54\u5668\u5c06\u4f1a\u66b4\u9732\u4f60\u4e0e " + list + " hostile.\n\n" + "\u4f60\u786e\u5b9a\u8981\u8fd9\u4e48\u505a\u5417\uff1f";
                        Global.getSector().getCampaignUI().showConfirmDialog(text, "\u786e\u8ba4", "\u53d6\u6d88", new Script(){

                            public void run() {
                                TransponderAbility.super.pressButton();
                                Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(TransponderAbility.this.getDeactivationMessage());
                                Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(TransponderAbility.this.getActivationMessage());
                                TransponderAbility.this.sinceWarning = 1000.0f;
                            }
                        }, null);
                    } else {
                        super.pressButton();
                        Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getDeactivationMessage());
                        Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getActivationMessage());
                        this.sinceWarning = 1000.0f;
                    }
                } else {
                    super.pressButton();
                    Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getDeactivationMessage());
                    Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getActivationMessage());
                    this.sinceWarning = 1000.0f;
                }
            } else {
                this.sinceWarning = 0.0f;
                if (this.isActive()) {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.getDeactivationMessage());
                } else if (this.showAlarm) {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.getActivationMessage(), Misc.getNegativeHighlightColor());
                } else {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.getActivationMessage());
                }
            }
        } else {
            super.pressButton();
        }
    }

    protected String getDeactivationMessage() {
        return "\u5e94\u7b54\u5668\u51c6\u5907\u505c\u7528 - \u518d\u6b21\u4f7f\u7528\u5173\u95ed";
    }

    protected String getActivationMessage() {
        if (this.showAlarm) {
            return "\u6fc0\u6d3b\u5e94\u7b54\u5668\u4f1a\u663e\u793a\u4f60\u7684\u8eab\u4efd - \u518d\u6b21\u4f7f\u7528\u786e\u8ba4";
        }
        return "\u5e94\u7b54\u5668\u5f85\u547d - \u518d\u6b21\u4f7f\u7528\u6fc0\u6d3b";
    }

    @Override
    public float getCooldownFraction() {
        if (this.sinceWarning < 5.0f) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public boolean isOnCooldown() {
        return false;
    }

    @Override
    public Color getCooldownColor() {
        if (this.sinceWarning < 5.0f) {
            Color color = Misc.getNegativeHighlightColor();
            if (!this.showAlarm) {
                color = Misc.getHighlightColor();
            }
            float b = 1.0f;
            float t = 0.25f;
            if (this.sinceWarning < t) {
                b = this.sinceWarning / t;
            }
            if (this.sinceWarning > 5.0f - t) {
                b = 1.0f - (this.sinceWarning - (5.0f - t)) / t;
            }
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.75f * b);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return true;
    }
}

