/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.command;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ObjectiveEventListener;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.Objectives;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.plugins.BuildObjectiveTypePicker;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarSimScript
implements EveryFrameScript,
ObjectiveEventListener {
    public static final String KEY = "$core_warSimScript";
    public static final float CHECK_DAYS = 10.0f;
    public static final float CHECK_PROB = 0.5f;
    protected TimeoutTracker<String> timeouts = new TimeoutTracker();
    protected List<StarSystemAPI> queue = new ArrayList<StarSystemAPI>();

    public static WarSimScript getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (WarSimScript)test;
    }

    public WarSimScript() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getListenerManager().addListener(this);
        for (StarSystemAPI system : Global.getSector().getEconomy().getStarSystemsWithMarkets()) {
            String sid = this.getStarSystemTimeoutId(system);
            this.timeouts.add(sid, 2.0f + (float)Math.random() * 3.0f);
        }
    }

    protected Object readResolve() {
        if (this.timeouts == null) {
            this.timeouts = new TimeoutTracker();
        }
        return this;
    }

    @Override
    public void advance(float amount) {
        if (TutorialMissionIntel.isTutorialInProgress()) {
            return;
        }
        float days = Misc.getDays(amount);
        this.timeouts.advance(days);
        if (this.queue.isEmpty()) {
            this.queue = Global.getSector().getEconomy().getStarSystemsWithMarkets();
        }
        if (!this.queue.isEmpty()) {
            StarSystemAPI curr = this.queue.remove(0);
            this.processStarSystem(curr);
        }
    }

    public void processStarSystem(StarSystemAPI system) {
        String sid = this.getStarSystemTimeoutId(system);
        if (this.timeouts.contains(sid)) {
            return;
        }
        this.timeouts.add(sid, 2.0f + (float)Math.random() * 3.0f);
        CountingMap<FactionAPI> str = WarSimScript.getFactionStrengths(system);
        boolean inSpawnRange = RouteManager.isPlayerInSpawnRange(system.getCenter());
        ArrayList factions = new ArrayList(str.keySet());
        for (SectorEntityToken obj : system.getEntitiesWithTag("objective")) {
            float curr;
            String id;
            ArrayList<FactionAPI> contenders = new ArrayList<FactionAPI>();
            for (FactionAPI faction : factions) {
                if (this.wantsToOwnObjective(faction, str, obj)) {
                    contenders.add(faction);
                    String id2 = this.getControlTimeoutId(obj, faction);
                    if (this.timeouts.contains(id2)) continue;
                    this.addObjectiveActionResponse(obj, faction, obj.getFaction());
                    continue;
                }
                if (faction != obj.getFaction()) continue;
                contenders.add(faction);
            }
            if (inSpawnRange || this.timeouts.contains(id = this.getControlSimTimeoutId(obj))) continue;
            this.timeouts.add(id, 10.0f + (float)Math.random() * 30.0f);
            WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>();
            float max = 0.0f;
            for (FactionAPI faction : contenders) {
                curr = (float)str.getCount(faction) + WarSimScript.getStationStrength(faction, system, obj);
                if (!(curr > max)) continue;
                max = curr;
            }
            if (max <= 0.0f) continue;
            for (FactionAPI faction : contenders) {
                curr = (float)str.getCount(faction) + WarSimScript.getStationStrength(faction, system, obj);
                float w = curr / max - 0.5f;
                picker.add(faction, w);
            }
            FactionAPI winner = (FactionAPI)picker.pick();
            if (winner == null || winner == obj.getFaction()) continue;
            Objectives o = new Objectives(obj);
            o.control(winner.getId());
        }
        for (SectorEntityToken sLoc : system.getEntitiesWithTag("stable_location")) {
            String id;
            if (sLoc.hasTag("non_clickable") || sLoc.hasTag("fading_out_and_expiring") || inSpawnRange || this.timeouts.contains(id = this.getBuildSimTimeoutId(sLoc))) continue;
            this.timeouts.add(id, 20.0f + (float)Math.random() * 20.0f);
            WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>();
            float max = 0.0f;
            for (FactionAPI faction : factions) {
                float curr = (float)str.getCount(faction) + WarSimScript.getStationStrength(faction, system, sLoc);
                if (!(curr > max)) continue;
                max = curr;
            }
            if (max <= 0.0f) continue;
            for (FactionAPI faction : factions) {
                float curr = (float)str.getCount(faction) + WarSimScript.getStationStrength(faction, system, sLoc);
                float w = curr / max - 0.5f;
                picker.add(faction, w);
            }
            FactionAPI winner = (FactionAPI)picker.pick();
            if (winner == null || winner == sLoc.getFaction()) continue;
            BuildObjectiveTypePicker.BuildObjectiveParams params = new BuildObjectiveTypePicker.BuildObjectiveParams();
            params.faction = winner;
            params.fleet = null;
            params.stableLoc = sLoc;
            BuildObjectiveTypePicker pick = Global.getSector().getGenericPlugins().pickPlugin(BuildObjectiveTypePicker.class, params);
            String type = null;
            if (pick != null) {
                type = pick.pickObjectiveToBuild(params);
            }
            if (type == null) continue;
            Objectives o = new Objectives(sLoc);
            o.build(type, winner.getId());
        }
    }

    protected boolean wantsToOwnObjective(FactionAPI faction, CountingMap<FactionAPI> str, SectorEntityToken o) {
        if (o.getFaction() == faction) {
            return false;
        }
        if (!o.getFaction().isHostileTo(faction) && !o.getFaction().isNeutralFaction()) {
            boolean ownerHasColonyInSystem = false;
            for (MarketAPI curr : Misc.getMarketsInLocation(o.getContainingLocation())) {
                if (curr.getFaction() != o.getFaction() || curr.getFaction().isNeutralFaction()) continue;
                ownerHasColonyInSystem = true;
                break;
            }
            return !ownerHasColonyInSystem;
        }
        float minDist = Float.MAX_VALUE;
        MarketAPI closest = null;
        boolean haveInSystemMarkets = false;
        for (MarketAPI market : Misc.getMarketsInLocation(o.getContainingLocation())) {
            float dist = Misc.getDistance(market.getPrimaryEntity(), o);
            if (dist < minDist) {
                minDist = dist;
                closest = market;
            }
            if (faction != market.getFaction()) continue;
            haveInSystemMarkets = true;
        }
        if (closest != null && closest.getFaction() == faction) {
            return true;
        }
        if (faction.getCustomBoolean("pirateBehavior") && minDist > 8000.0f) {
            return true;
        }
        if (!haveInSystemMarkets && closest != null && !closest.getFaction().isHostileTo(faction)) {
            return false;
        }
        int maxStr = 0;
        FactionAPI strongest = null;
        for (FactionAPI curr : str.keySet()) {
            int s = str.getCount(curr);
            if (s <= maxStr) continue;
            maxStr = s;
            strongest = curr;
        }
        return strongest == faction;
    }

    @Override
    public void reportObjectiveChangedHands(SectorEntityToken objective, FactionAPI from, FactionAPI to) {
        this.addObjectiveActionResponse(objective, from, to);
    }

    @Override
    public void reportObjectiveDestroyed(SectorEntityToken objective, SectorEntityToken stableLocation, FactionAPI enemy) {
        String id = this.getBuildSimTimeoutId(stableLocation);
        this.timeouts.add(id, 40.0f + (float)Math.random() * 20.0f, 100.0f);
        this.addObjectiveActionResponse(objective, objective.getFaction(), null);
    }

    protected String getStarSystemTimeoutId(StarSystemAPI system) {
        String id = "starsystem_" + system.getId();
        return id;
    }

    protected String getBuildSimTimeoutId(SectorEntityToken objective) {
        String id = "sim_build_" + objective.getId();
        return id;
    }

    protected String getControlSimTimeoutId(SectorEntityToken objective) {
        String id = "sim_changedhands_" + objective.getId();
        return id;
    }

    protected String getControlTimeoutId(SectorEntityToken objective, FactionAPI faction) {
        String id = String.valueOf(faction.getId()) + "_" + objective.getId();
        return id;
    }

    protected void addObjectiveActionResponse(SectorEntityToken objective, FactionAPI faction, FactionAPI enemy) {
        if (faction.isNeutralFaction()) {
            return;
        }
        if (faction.getCustomBoolean("noWarSim")) {
            return;
        }
        if (enemy != null && enemy.isNeutralFaction()) {
            return;
        }
        if (enemy != null && !faction.isHostileTo(enemy)) {
            return;
        }
        String id = this.getControlTimeoutId(objective, faction);
        if (this.timeouts.contains(id)) {
            return;
        }
        if (WarSimScript.isAlreadyFightingFor(objective, faction)) {
            return;
        }
        MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, objective.getId(), faction, objective, 0.4f, 20.0f + (float)Math.random() * 20.0f);
        MilitaryResponseScript script = new MilitaryResponseScript(params);
        objective.getContainingLocation().addScript(script);
        this.timeouts.add(id, params.responseDuration * 2.0f);
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public static CountingMap<FactionAPI> getFactionStrengths(StarSystemAPI system) {
        CountingMap<FactionAPI> result = new CountingMap<FactionAPI>();
        LinkedHashSet<FactionAPI> factions = new LinkedHashSet<FactionAPI>();
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (fleet.getMemoryWithoutUpdate().getBoolean("$isTradeFleet") || fleet.getMemoryWithoutUpdate().getBoolean("$isSmuggler")) continue;
            factions.add(fleet.getFaction());
        }
        for (RouteManager.RouteData route : RouteManager.getInstance().getRoutesInLocation(system)) {
            String id = route.getFactionId();
            if (id == null) continue;
            FactionAPI faction = Global.getSector().getFaction(id);
            factions.add(faction);
        }
        for (FactionAPI faction : factions) {
            int strength;
            if (faction.getCustomBoolean("noWarSim") || (strength = (int)WarSimScript.getFactionStrength(faction, system)) <= 0) continue;
            result.add(faction, strength);
        }
        return result;
    }

    public static float getRelativeEnemyStrength(String factionId, StarSystemAPI system) {
        float enemyStrength = WarSimScript.getEnemyStrength(factionId, system);
        float factionStrength = WarSimScript.getFactionStrength(factionId, system);
        float f = enemyStrength / Math.max(1.0f, factionStrength + enemyStrength);
        return f;
    }

    public static float getRelativeFactionStrength(String factionId, StarSystemAPI system) {
        float enemyStrength = WarSimScript.getEnemyStrength(factionId, system);
        float factionStrength = WarSimScript.getFactionStrength(factionId, system);
        float f = factionStrength / Math.max(1.0f, factionStrength + enemyStrength);
        return f;
    }

    public static float getEnemyStrength(String factionId, StarSystemAPI system) {
        return WarSimScript.getEnemyStrength(Global.getSector().getFaction(factionId), system, false);
    }

    public static float getEnemyStrength(FactionAPI faction, StarSystemAPI system) {
        return WarSimScript.getEnemyStrength(faction, system, false);
    }

    public static float getEnemyStrength(String factionId, StarSystemAPI system, boolean assumeHostileToPlayer) {
        return WarSimScript.getEnemyStrength(Global.getSector().getFaction(factionId), system, assumeHostileToPlayer);
    }

    public static float getEnemyStrength(FactionAPI faction, StarSystemAPI system, boolean assumeHostileToPlayer) {
        HostileActivityEventIntel intel;
        float enemyStr = 0.0f;
        HashSet<String> seen = new HashSet<String>();
        for (MarketAPI target : Misc.getMarketsInLocation(system)) {
            if ((!assumeHostileToPlayer || !target.getFaction().isPlayerFaction()) && !target.getFaction().isHostileTo(faction) || seen.contains(target.getFactionId())) continue;
            seen.add(target.getFactionId());
            enemyStr += WarSimScript.getFactionStrength(target.getFaction(), system);
        }
        if (faction.isPlayerFaction() && (intel = HostileActivityEventIntel.get()) != null) {
            enemyStr += intel.getVeryApproximateFPStrength(system);
        }
        return enemyStr;
    }

    public static float getFactionStrength(String factionId, StarSystemAPI system) {
        return WarSimScript.getFactionStrength(Global.getSector().getFaction(factionId), system);
    }

    public static float getFactionStrength(FactionAPI faction, StarSystemAPI system) {
        float strength = 0.0f;
        HashSet<CampaignFleetAPI> seenFleets = new HashSet<CampaignFleetAPI>();
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (fleet.getFaction() != faction || fleet.isStationMode() || fleet.getMemoryWithoutUpdate().getBoolean("$isTradeFleet") || fleet.getMemoryWithoutUpdate().getBoolean("$isSmuggler") || fleet.isPlayerFleet()) continue;
            strength += fleet.getEffectiveStrength();
            seenFleets.add(fleet);
        }
        for (RouteManager.RouteData route : RouteManager.getInstance().getRoutesInLocation(system)) {
            RouteManager.OptionalFleetData data;
            if (route.getActiveFleet() != null && seenFleets.contains(route.getActiveFleet()) || (data = route.getExtra()) == null || route.getFactionId() == null || !faction.getId().equals(route.getFactionId())) continue;
            strength += data.getStrengthModifiedByDamage();
        }
        return strength;
    }

    public static float getStationStrength(FactionAPI faction, StarSystemAPI system, SectorEntityToken from) {
        float strength = 0.0f;
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (!fleet.isStationMode() || fleet.getFaction() != faction) continue;
            float maxDist = Misc.getBattleJoinRange() * 3.0f;
            float dist = Misc.getDistance(from, fleet);
            if (!(dist < maxDist)) continue;
            strength += fleet.getEffectiveStrength();
        }
        return strength;
    }

    public TimeoutTracker<String> getTimeouts() {
        return this.timeouts;
    }

    public static void removeFightOrdersFor(SectorEntityToken target, FactionAPI faction) {
        for (EveryFrameScript s : target.getContainingLocation().getScripts()) {
            MilitaryResponseScript script;
            if (!(s instanceof MilitaryResponseScript) || (script = (MilitaryResponseScript)s).getParams() == null || script.getParams().target != target || script.getParams().faction != faction) continue;
            script.forceDone();
        }
    }

    public static void setNoFightingForObjective(SectorEntityToken objective, FactionAPI faction, float timeout) {
        WarSimScript.removeFightOrdersFor(objective, faction);
        if (timeout > 0.0f) {
            WarSimScript wss = WarSimScript.getInstance();
            String id = wss.getControlTimeoutId(objective, faction);
            wss.timeouts.add(id, timeout);
        }
    }

    public static void removeNoFightingTimeoutForObjective(SectorEntityToken objective, FactionAPI faction) {
        WarSimScript wss = WarSimScript.getInstance();
        String id = wss.getControlTimeoutId(objective, faction);
        wss.timeouts.remove(id);
    }

    public static boolean isAlreadyFightingFor(SectorEntityToken objective, FactionAPI faction) {
        for (EveryFrameScript s : objective.getContainingLocation().getScripts()) {
            MilitaryResponseScript script;
            if (!(s instanceof MilitaryResponseScript) || (script = (MilitaryResponseScript)s).getParams() == null || script.getParams().target != objective || script.getParams().faction != faction) continue;
            return true;
        }
        return false;
    }

    public static LocationDanger getDangerFor(FactionAPI faction, StarSystemAPI system) {
        if (system == null) {
            return LocationDanger.NONE;
        }
        return WarSimScript.getDangerFor(WarSimScript.getFactionStrength(faction, system), WarSimScript.getEnemyStrength(faction, system));
    }

    public static LocationDanger getDangerFor(String factionId, StarSystemAPI system) {
        if (system == null) {
            return LocationDanger.NONE;
        }
        return WarSimScript.getDangerFor(WarSimScript.getFactionStrength(factionId, system), WarSimScript.getEnemyStrength(factionId, system));
    }

    public static LocationDanger getDangerFor(float factionStrength, float enemyStrength) {
        if (enemyStrength < 100.0f) {
            return LocationDanger.NONE;
        }
        float f = enemyStrength / Math.max(1.0f, factionStrength + enemyStrength);
        LocationDanger[] locationDangerArray = LocationDanger.vals;
        int n = LocationDanger.vals.length;
        int n2 = 0;
        while (n2 < n) {
            LocationDanger level = locationDangerArray[n2];
            float test = level.enemyStrengthFraction + (level.next().enemyStrengthFraction - level.enemyStrengthFraction) * 0.5f;
            if (level == LocationDanger.NONE) {
                test = LocationDanger.NONE.enemyStrengthFraction;
            }
            if (test >= f) {
                return level;
            }
            ++n2;
        }
        return LocationDanger.EXTREME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationDanger {
        NONE(0.01f),
        MINIMAL(0.1f),
        LOW(0.2f),
        MEDIUM(0.3f),
        HIGH(0.5f),
        EXTREME(0.8f);

        public static LocationDanger[] vals;
        public float enemyStrengthFraction;

        static {
            vals = LocationDanger.values();
        }

        private LocationDanger(float enemyStrengthFraction) {
            this.enemyStrengthFraction = enemyStrengthFraction;
        }

        public LocationDanger next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public LocationDanger prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }
}

