/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMarketConditionPlugin
implements MarketConditionPlugin {
    protected MarketAPI market;
    protected MarketConditionAPI condition;

    @Override
    public void init(MarketAPI market, MarketConditionAPI condition) {
        this.market = market;
        this.condition = condition;
    }

    @Override
    public void apply(String id) {
    }

    @Override
    public void unapply(String id) {
    }

    @Override
    public void advance(float amount) {
    }

    public String getModId() {
        return this.condition.getIdForPluginModifications();
    }

    public static float getLowStabilityBonusMult(MarketAPI market) {
        float s = market.getStabilityValue();
        return 1.0f + (10.0f - s) * 0.1f;
    }

    public static float getLowStabilityPenaltyMult(MarketAPI market) {
        float s = market.getStabilityValue();
        return 0.5f + s * 0.05f;
    }

    public static float getHighStabilityBonusMult(MarketAPI market) {
        float s = market.getStabilityValue();
        return 1.0f + s * 0.1f;
    }

    public static float getHighStabilityPenaltyMult(MarketAPI market) {
        float s = market.getStabilityValue();
        return 0.5f + (10.0f - s) * 0.05f;
    }

    public static void main(String[] args) {
    }

    @Override
    public List<String> getRelatedCommodities() {
        return null;
    }

    @Override
    public void setParam(Object param) {
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        CampaignFleetAPI playerFleet;
        LinkedHashMap<String, String> tokens = new LinkedHashMap<String, String>();
        tokens.put("$playerName", Global.getSector().getCharacterData().getName());
        if (this.market != null) {
            tokens.put("$marketFaction", this.market.getFaction().getDisplayName());
            tokens.put("$TheMarketFaction", Misc.ucFirst(this.market.getFaction().getDisplayNameWithArticle()));
            tokens.put("$theMarketFaction", this.market.getFaction().getDisplayNameWithArticle());
            if (this.market.getPrimaryEntity().getLocation() instanceof StarSystemAPI) {
                tokens.put("$marketSystem", ((StarSystemAPI)this.market.getPrimaryEntity().getLocation()).getBaseName());
            } else {
                tokens.put("$marketSystem", "hyperspace");
            }
            tokens.put("$marketName", this.market.getName());
            tokens.put("$market", this.market.getName());
        }
        if ((playerFleet = Global.getSector().getPlayerFleet()) != null) {
            String fleetOrShip = "fleet";
            if (playerFleet.getFleetData().getMembersListCopy().size() == 1) {
                fleetOrShip = "ship";
                if (playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                    fleetOrShip = "fighter wing";
                }
            }
            tokens.put("$playerShipOrFleet", fleetOrShip);
        }
        return tokens;
    }

    @Override
    public String[] getHighlights() {
        return null;
    }

    @Override
    public Color[] getHighlightColors() {
        String[] highlights = this.getHighlights();
        if (highlights != null) {
            Color c = Global.getSettings().getColor("buttonShortcut");
            Object[] colors = new Color[highlights.length];
            Arrays.fill(colors, c);
            return colors;
        }
        return null;
    }

    public void addTokensToList(List<String> list, String ... keys) {
        Map<String, String> tokens = this.getTokenReplacements();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (tokens.containsKey(key)) {
                list.add(tokens.get(key));
            }
            ++n2;
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public boolean showIcon() {
        return true;
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float opad = 10.0f;
        Color color = this.market.getTextColorForFactionOrPlanet();
        tooltip.addTitle(this.condition.getName(), color);
        String text = this.condition.getSpec().getDesc();
        Map<String, String> tokens = this.getTokenReplacements();
        if (tokens != null) {
            for (String token : tokens.keySet()) {
                String value = tokens.get(token);
                text = text.replaceAll("(?s)\\" + token, value);
            }
        }
        if (!text.isEmpty()) {
            LabelAPI body = tooltip.addPara(text, opad);
            if (this.getHighlights() != null) {
                if (this.getHighlightColors() != null) {
                    body.setHighlightColors(this.getHighlightColors());
                } else {
                    body.setHighlightColor(Misc.getHighlightColor());
                }
                body.setHighlight(this.getHighlights());
            }
        }
        this.createTooltipAfterDescription(tooltip, expanded);
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public float getTooltipWidth() {
        return 500.0f;
    }

    @Override
    public boolean isPlanetary() {
        if (this.condition == null) {
            return true;
        }
        return this.condition.getSpec().isPlanetary();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public String getIconName() {
        return this.condition.getSpec().getIcon();
    }

    @Override
    public String getName() {
        return this.condition.getSpec().getName();
    }
}

