/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommRelayCondition
extends BaseMarketConditionPlugin {
    public static String COMM_RELAY_MOD_ID = "core_comm_relay";
    public static float NO_RELAY_PENALTY = -1.0f;
    public static float COMM_RELAY_BONUS = 2.0f;
    public static float MAKESHIFT_COMM_RELAY_BONUS = 1.0f;
    protected LinkedHashSet<SectorEntityToken> relays = new LinkedHashSet();

    public static CommRelayCondition get(MarketAPI market) {
        MarketConditionAPI mc = market.getCondition("comm_relay");
        if (mc != null && mc.getPlugin() instanceof CommRelayCondition) {
            return (CommRelayCondition)mc.getPlugin();
        }
        return null;
    }

    public LinkedHashSet<SectorEntityToken> getRelays() {
        return this.relays;
    }

    @Override
    public void advance(float amount) {
        Iterator iter = this.relays.iterator();
        while (iter.hasNext()) {
            SectorEntityToken relay = (SectorEntityToken)iter.next();
            if (relay.isAlive() && relay.getContainingLocation() == this.market.getContainingLocation()) continue;
            iter.remove();
        }
        if (this.relays.isEmpty()) {
            this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
        }
    }

    protected boolean isMakeshift(SectorEntityToken relay) {
        return relay.hasTag("makeshift");
    }

    protected SectorEntityToken getBestRelay() {
        if (this.market.getContainingLocation() == null) {
            return null;
        }
        SectorEntityToken best = null;
        for (SectorEntityToken relay : this.relays) {
            if (relay.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional") || relay.getFaction() != this.market.getFaction() || best != null && (!this.isMakeshift(best) || this.isMakeshift(relay))) continue;
            best = relay;
        }
        return best;
    }

    @Override
    public void apply(String id) {
        SectorEntityToken relay = this.getBestRelay();
        if (relay == null) {
            this.unapply(id);
            return;
        }
        if (this.isMakeshift(relay)) {
            this.market.getStability().modifyFlat(COMM_RELAY_MOD_ID, MAKESHIFT_COMM_RELAY_BONUS, "\u4e34\u65f6\u901a\u8baf\u4e2d\u7ee7\u7ad9");
        } else {
            this.market.getStability().modifyFlat(COMM_RELAY_MOD_ID, COMM_RELAY_BONUS, "\u901a\u8baf\u4e2d\u7ee7\u7ad9");
        }
    }

    @Override
    public void unapply(String id) {
        this.market.getStability().unmodifyFlat(COMM_RELAY_MOD_ID);
    }

    @Override
    public boolean showIcon() {
        return false;
    }
}

