/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseHazardCondition;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class DecivilizedSubpop
extends BaseHazardCondition
implements MarketImmigrationModifier {
    public static float STABILITY_PENALTY = 2.0f;

    public void apply(String id) {
        super.apply(id);
        this.market.getStability().modifyFlat(id, -STABILITY_PENALTY, "\u6cd5\u5916\u4e4b\u5730");
        this.market.addTransientImmigrationModifier(this);
    }

    public void unapply(String id) {
        super.unapply(id);
        this.market.getStability().unmodify(id);
        this.market.removeTransientImmigrationModifier(this);
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("poor", 10.0f);
        incoming.getWeight().modifyFlat(this.getModId(), this.getImmigrationBonus(), Misc.ucFirst(this.condition.getName().toLowerCase()));
    }

    protected float getImmigrationBonus() {
        return this.market.getSize();
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        tooltip.addPara("%s \u7a33\u5b9a\u6027", 10.0f, Misc.getHighlightColor(), "-" + (int)STABILITY_PENALTY);
        tooltip.addPara("%s \u4eba\u53e3\u589e\u957f (\u57fa\u4e8e\u6b96\u6c11\u5730\u89c4\u6a21) ", 10.0f, Misc.getHighlightColor(), "+" + (int)this.getImmigrationBonus());
    }
}

