/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class FreeMarket
extends BaseMarketConditionPlugin
implements MarketImmigrationModifier {
    public static float OFFICER_MERC_PROB_MOD = 0.25f;
    public static float MIN_STABILITY_PENALTY = 1.0f;
    public static float MAX_STABILITY_PENALTY = 3.0f;
    public static float MIN_ACCESS_BONUS = 0.05f;
    public static float MAX_ACCESS_BONUS = 0.25f;
    public static float MIN_GROWTH = 3.0f;
    public static float MAX_GROWTH = 10.0f;
    public static float MAX_DAYS = 365.0f;
    private float daysActive = 0.0f;

    public static FreeMarket get(MarketAPI market) {
        MarketConditionAPI mc = market.getCondition("free_market");
        if (mc != null && mc.getPlugin() instanceof FreeMarket) {
            return (FreeMarket)mc.getPlugin();
        }
        return null;
    }

    public void advance(float amount) {
        if (!this.market.hasSpaceport()) {
            this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
            this.market.setFreePort(false);
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysActive += days;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public float getDaysActive() {
        return this.daysActive;
    }

    public void setDaysActive(float daysActive) {
        this.daysActive = daysActive;
    }

    public void apply(String id) {
        this.market.addTransientImmigrationModifier(this);
        this.market.getAccessibilityMod().modifyFlat(id, this.getAccessBonus(), "\u81ea\u7531\u6e2f");
        this.market.getStability().modifyFlat(id, -this.getStabilityPenalty(), "\u81ea\u7531\u6e2f");
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").modifyFlat(id, OFFICER_MERC_PROB_MOD);
    }

    public boolean isTransient() {
        return false;
    }

    public void unapply(String id) {
        this.market.removeTransientImmigrationModifier(this);
        this.market.getStability().unmodifyFlat(id);
        this.market.getAccessibilityMod().unmodifyFlat(id);
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").unmodifyFlat(id);
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("pirates", 5.0f);
        incoming.add("poor", 5.0f);
        incoming.add("independent", 5.0f);
        incoming.getWeight().modifyFlat(this.getModId(), this.getImmigrationBonus(), Misc.ucFirst(this.condition.getName().toLowerCase()));
    }

    protected float getImmigrationBonus() {
        float growth = MIN_GROWTH + this.daysActive / MAX_DAYS * (MAX_GROWTH - MIN_GROWTH);
        if ((growth = (float)Math.round(growth)) > MAX_GROWTH) {
            growth = MAX_GROWTH;
        }
        if (growth < 1.0f) {
            growth = 1.0f;
        }
        return growth;
    }

    protected float getAccessBonus() {
        float access = MIN_ACCESS_BONUS + this.daysActive / MAX_DAYS * (MAX_ACCESS_BONUS - MIN_ACCESS_BONUS);
        if ((access = (float)Math.round(access * 100.0f) / 100.0f) > MAX_ACCESS_BONUS) {
            access = MAX_ACCESS_BONUS;
        }
        if (access < 0.01f) {
            access = 0.01f;
        }
        return access;
    }

    protected float getStabilityPenalty() {
        float s = MIN_STABILITY_PENALTY + this.daysActive / MAX_DAYS * (MAX_STABILITY_PENALTY - MIN_STABILITY_PENALTY);
        if ((s = (float)Math.round(s)) > MAX_STABILITY_PENALTY) {
            s = MAX_STABILITY_PENALTY;
        }
        if (s < 1.0f) {
            s = 1.0f;
        }
        return s;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        if (!this.market.hasSpaceport()) {
            tooltip.addPara("\u9700\u8981\u4e00\u5904\u592a\u7a7a\u6e2f\u624d\u80fd\u53d1\u6325\u4f5c\u7528", Misc.getNegativeHighlightColor(), 10.0f);
            return;
        }
        tooltip.addPara("%s \u7a33\u5b9a\u6027 (\u6700\u591a %s}\uff0c\u9884\u8ba1\u6301\u7eed %s \u5929) ", 10.0f, Misc.getHighlightColor(), "-" + (int)this.getStabilityPenalty(), "-" + (int)MAX_STABILITY_PENALTY, "" + (int)MAX_DAYS);
        tooltip.addPara("%s \u4eba\u53e3\u589e\u957f (\u6700\u591a %s}\uff0c\u9884\u8ba1\u6301\u7eed %s \u5929) ", 10.0f, Misc.getHighlightColor(), "+" + (int)this.getImmigrationBonus(), "+" + (int)MAX_GROWTH, "" + (int)MAX_DAYS);
        tooltip.addPara("%s \u6d41\u901a\u6027 (\u6700\u591a %s}\uff0c\u9884\u8ba1\u6301\u7eed %s \u5929) ", 10.0f, Misc.getHighlightColor(), "+" + Math.round(this.getAccessBonus() * 100.0f) + "%", "+" + Math.round(MAX_ACCESS_BONUS * 100.0f) + "%", "" + (int)MAX_DAYS);
        tooltip.addPara("\u5728\u5df1\u65b9\u6b96\u6c11\u5730\u5185\u65e0\u9700\u6253\u5f00\u5e94\u7b54\u5668\u5c31\u53ef\u8fdb\u884c\u516c\u5f00\u4ea4\u6613\u3002\u4e14\u6240\u6709\u7684\u5546\u54c1\u4ea4\u6613\u90fd\u662f\u5408\u6cd5\u7684\u3002", 10.0f);
        tooltip.addPara("\u6b96\u6c11\u5730\u53ef\u4ece\u8d70\u79c1\u4e2d\u83b7\u5f97\u6536\u76ca\u3002", 10.0f);
    }
}

