/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashMap;
import java.util.Map;

public class LuddicMajority
extends BaseMarketConditionPlugin
implements MarketImmigrationModifier {
    public static float STABILITY = 1.0f;
    public static float IMMIGRATION_BASE = 5.0f;
    public static float PRODUCTION_BASE_RURAL = 1.0f;
    public static Map<String, Integer> PRODUCTION_OVERRIDES = new LinkedHashMap<String, Integer>();
    public static int BONUS_MULT_DEFEATED_EXPEDITION = 2;
    @Deprecated
    public static String[] luddicFactions = new String[]{"knights_of_ludd", "luddic_church", "luddic_path"};

    public void apply(String id) {
        if (!LuddicMajority.matchesBonusConditions(this.market)) {
            this.unapply(id);
            return;
        }
        this.market.addTransientImmigrationModifier(this);
        int stability = Math.round(STABILITY * this.getEffectMult());
        if (stability != 0) {
            this.market.getStability().modifyFlat(id, stability, "\u5362\u5fb7\u6559\u4f17");
        }
        float mult = this.getEffectMult();
        for (Industry ind : this.market.getIndustries()) {
            if (!ind.getSpec().hasTag("rural") && !PRODUCTION_OVERRIDES.containsKey(ind.getId())) continue;
            int production = Math.round(PRODUCTION_BASE_RURAL * mult);
            if (PRODUCTION_OVERRIDES.containsKey(ind.getId())) {
                production = Math.round((float)PRODUCTION_OVERRIDES.get(ind.getId()).intValue() * mult);
            }
            if (production == 0) continue;
            ind.getSupplyBonusFromOther().modifyFlat(id, production, "\u5362\u5fb7\u6559\u4f17");
        }
    }

    public void unapply(String id) {
        this.market.removeTransientImmigrationModifier(this);
        this.market.getStability().unmodify(id);
        for (Industry ind : this.market.getIndustries()) {
            if (!ind.getSpec().hasTag("rural") && !PRODUCTION_OVERRIDES.containsKey(ind.getId())) continue;
            ind.getSupplyBonusFromOther().unmodifyFlat(id);
        }
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        float bonus = this.getImmigrationBonus(true);
        if (bonus > 0.0f) {
            incoming.add("luddic_church", bonus);
            incoming.getWeight().modifyFlat(this.getModId(), bonus, "\u5362\u5fb7\u79fb\u6c11 (\u5362\u5fb7\u6559\u4f17)");
        }
    }

    public float getImmigrationBonus(boolean withEffectMult) {
        float bonus = IMMIGRATION_BASE * (float)this.market.getSize();
        if (withEffectMult) {
            bonus *= this.getEffectMult();
        }
        return bonus;
    }

    public float getEffectMult() {
        if (this.market.isPlayerOwned() && LuddicChurchHostileActivityFactor.isDefeatedExpedition()) {
            return BONUS_MULT_DEFEATED_EXPEDITION;
        }
        return 1.0f;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        String name = this.market.getName();
        float opad = 10.0f;
        tooltip.addPara("\u4f4d\u4e8e " + name + " \u7684\u5927\u591a\u6570\u4eba\u53e3\u662f\u5362\u5fb7\u4fe1\u5f92\u3002" + "\u53ef\u80fd\u56e0\u6b64\u5f97\u5230\u7a33\u5b9a\u6027\u548c\u4ea7\u91cf\u7684" + "\u6301\u7eed\u589e\u76ca\u3002", opad);
        tooltip.addPara("\u5bf9\u4e8e\u6838\u5fc3\u661f\u57df\u4e4b\u5916\u7684\u6b96\u6c11\u5730\uff0c\u4e5f\u53ef\u80fd\u56e0\u6b64\u63d0\u9ad8\u4eba\u53e3\u589e\u957f\uff0c\u56e0\u4e3a\u67d0\u4e9b\u5362\u5fb7\u4fe1\u5f92\u6b63\u4e3a\u8eb2\u907f\u6559\u4f1a\u4e3b\u6d41\u653f\u89c1\u7684\u5076\u53d1\u6027\u538b\u8feb\u800c\u5bfb\u6c42\u5b89\u5168\u7684\u5e87\u62a4\u6240\u3002", opad);
        tooltip.addPara("%s \u7a33\u5b9a\u6027", opad, Misc.getHighlightColor(), "+" + (int)STABILITY);
        tooltip.addPara("%s \u519c\u4e1a\u3001\u8f7b\u5de5\u4e1a\u4e0e\u7c7b\u4f3c\u8bbe\u65bd\u7684\u4ea7\u91cf", opad, Misc.getHighlightColor(), "+" + (int)PRODUCTION_BASE_RURAL);
        if (this.market.isPlayerOwned()) {
            tooltip.addPara("%s \u4eba\u53e3\u589e\u957f", opad, Misc.getHighlightColor(), "+" + (int)this.getImmigrationBonus(false));
        }
        LuddicMajority.addConditions(tooltip, this.market, opad);
    }

    public static void addConditions(TooltipMakerAPI tooltip, MarketAPI market, float opad) {
        boolean madeDeal = LuddicChurchHostileActivityFactor.isMadeDeal() && market.isPlayerOwned();
        boolean freePort = market.isFreePort();
        freePort = false;
        boolean habitable = market.hasCondition("habitable");
        boolean hasRural = false;
        boolean hasIndustrial = false;
        boolean hasMilitary = false;
        String heavy = null;
        String military = null;
        String rural = null;
        for (Industry ind : market.getIndustries()) {
            if (ind.getSpec().hasTag("industrial")) {
                if (heavy == null) {
                    heavy = ind.getCurrentName();
                }
                hasIndustrial = true;
            }
            if (ind.getSpec().hasTag("military") || ind.getSpec().hasTag("command")) {
                if (military == null) {
                    military = ind.getCurrentName();
                }
                hasMilitary = true;
            }
            if (!ind.getSpec().hasTag("rural")) continue;
            if (rural == null) {
                rural = ind.getCurrentName();
            }
            hasRural = true;
        }
        boolean matches = LuddicMajority.matchesBonusConditions(market);
        if (!matches) {
            if (market.isPlayerOwned()) {
                tooltip.addPara("\u4ee5\u4e0b\u56e0\u7d20\u5bfc\u81f4\u589e\u76ca\u88ab\u62b5\u6d88\uff0c\u4e14\u9664\u975e\u56e0\u7d20\u88ab\u6d88\u9664\uff0c\u5426\u5219\u53ef\u80fd\u5bfc\u81f4\u6b96\u6c11\u5730\u589e\u957f\u65f6 \u5931\u53bb \"\u5362\u5fb7\u6559\u4f17\" \u8fd9\u4e00\u7279\u8d28\uff1a", opad, Misc.getNegativeHighlightColor(), "\u62b5\u6d88", "\u5931\u53bb");
            } else {
                tooltip.addPara("\u4ee5\u4e0b\u56e0\u7d20\u5bfc\u81f4\u589e\u76ca\u88ab\u62b5\u6d88\uff1a", opad, Misc.getNegativeHighlightColor(), "\u62b5\u6d88", "\u5931\u53bb");
            }
            tooltip.setBulletedListMode("    - ");
            if (madeDeal) {
                tooltip.addPara("\u4e0e\u5362\u5fb7\u6559\u4f1a\u8fbe\u6210\u9650\u5236\u79fb\u6c11\u7684\u534f\u8bae", opad);
                opad = 0.0f;
            }
            if (freePort) {
                tooltip.addPara("\u6b96\u6c11\u5730\u662f\u4e00\u4e2a\u81ea\u7531\u6e2f", opad);
                opad = 0.0f;
            }
            if (!habitable) {
                tooltip.addPara("\u6b96\u6c11\u5730\u672a\u5305\u542b \u5b9c\u5c45 \u7279\u8d28", opad);
                opad = 0.0f;
            }
            if (!hasRural) {
                tooltip.addPara("\u6b96\u6c11\u5730\u6ca1\u6709\u7b26\u5408\u4fe1\u5f92\u52b3\u4f5c\u8981\u6c42\u7684\u8bbe\u65bd\uff0c\u4f8b\u5982 \u519c\u4e1a \u6216 \u8f7b\u5de5\u4e1a", opad);
                opad = 0.0f;
            }
            if (hasIndustrial) {
                tooltip.addPara("\u6b96\u6c11\u5730\u6709\u91cd\u5de5\u4e1a\u8bbe\u65bd (" + heavy + ")", opad);
                opad = 0.0f;
            }
            if (hasMilitary) {
                tooltip.addPara("\u6b96\u6c11\u5730\u6709\u519b\u4e8b\u8bbe\u65bd (" + military + ")", opad);
                opad = 0.0f;
            }
            tooltip.setBulletedListMode(null);
        } else if (market.isPlayerOwned() && LuddicChurchHostileActivityFactor.isDefeatedExpedition()) {
            tooltip.addPara("\u589e\u76ca\u5df2\u7ffb\u500d\uff0c\u56e0\u4e3a\u4f4d\u4e8e " + market.getOnOrAt() + " " + market.getName() + " \u7684\u4fe1\u5f92\u8eab\u5904\u5362\u5fb7\u6559\u4f1a\u7684\u4e16\u4fd7\u6743\u529b\u5f71\u54cd\u4e4b\u5916\u8fdb\u800c " + " \u611f\u5230\u975e\u5e38\u5b89\u5168\u3002", opad, Misc.getPositiveHighlightColor(), "\u7ffb\u500d");
        }
        tooltip.setBulletedListMode("    - ");
        tooltip.setBulletedListMode(null);
    }

    public static boolean matchesBonusConditions(MarketAPI market) {
        if (market.isPlayerOwned() && LuddicChurchHostileActivityFactor.isMadeDeal()) {
            return false;
        }
        if (!market.hasCondition("habitable")) {
            return false;
        }
        boolean hasRural = false;
        for (Industry ind : market.getIndustries()) {
            if (ind.getSpec().hasTag("industrial")) {
                return false;
            }
            if (ind.getSpec().hasTag("military")) {
                return false;
            }
            if (ind.getSpec().hasTag("command")) {
                return false;
            }
            hasRural |= ind.getSpec().hasTag("rural");
        }
        return hasRural;
    }

    public String getIconName() {
        if (!LuddicMajority.matchesBonusConditions(this.market)) {
            return Global.getSettings().getSpriteName("events", "luddic_majority_unhappy");
        }
        return super.getIconName();
    }
}

