/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.PiracyRespiteScript;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class PiracyRespite
extends BaseMarketConditionPlugin {
    public static float ACCESSIBILITY_BONUS = 0.1f;
    public static float ACCESSIBILITY_BONUS_KANTA = 0.1f;

    public static float getBonus() {
        float bonus = ACCESSIBILITY_BONUS;
        if (KantaCMD.playerHasProtection()) {
            bonus += ACCESSIBILITY_BONUS_KANTA;
        }
        return bonus;
    }

    public void apply(String id) {
        String text = Misc.ucFirst(this.getName().toLowerCase());
        if (KantaCMD.playerHasProtection()) {
            text = String.valueOf(text) + " (\u5728 Kanta \u7684\u4fdd\u62a4 \u4e4b\u4e0b)";
        }
        this.market.getAccessibilityMod().modifyFlat(id, PiracyRespite.getBonus(), text);
    }

    public void unapply(String id) {
        this.market.getAccessibilityMod().unmodifyFlat(id);
    }

    public void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        String \u5929;
        PiracyRespiteScript script = PiracyRespiteScript.get();
        if (script == null) {
            return;
        }
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        int rem = Math.round(script.getDaysRemaining());
        String string = \u5929 = rem == 1 ? "\u5929" : "\u5929";
        if (KantaCMD.playerHasProtection()) {
            tooltip.addPara("\u4f60\u7684\u6b96\u6c11\u5730\u53d7\u5230 %s}\uff0c\u6d41\u901a\u6027\u5f97\u4ee5\u63d0\u9ad8\u3002", opad, Misc.getPositiveHighlightColor(), "Kanta \u7684\u4fdd\u62a4");
        }
        if (rem >= 0) {
            tooltip.addPara("%s \u6d41\u901a\u6027 (%s " + \u5929 + " \u5269\u4f59)\u3002", opad, h, "+" + Math.round(PiracyRespite.getBonus() * 100.0f) + "%", "" + rem);
        } else {
            tooltip.addPara("%s \u6d41\u901a\u6027\u3002", opad, h, "+" + Math.round(PiracyRespite.getBonus() * 100.0f) + "%");
        }
    }

    public boolean hasCustomTooltip() {
        return true;
    }
}

