/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;

public class RecentUnrest
extends BaseMarketConditionPlugin {
    public static float DECREASE_DAYS = 90.0f;
    protected int penalty;
    protected float untilDecrease = DECREASE_DAYS;
    protected TimeoutTracker<String> reasons = new TimeoutTracker();

    public static RecentUnrest get(MarketAPI market) {
        return RecentUnrest.get(market, true);
    }

    public static RecentUnrest get(MarketAPI market, boolean addIfNeeded) {
        MarketConditionAPI mc = market.getCondition("recent_unrest");
        if (mc == null && !addIfNeeded) {
            return null;
        }
        if (mc == null) {
            String id = market.addCondition("recent_unrest");
            mc = market.getSpecificCondition(id);
        }
        return (RecentUnrest)mc.getPlugin();
    }

    public static int getPenalty(MarketAPI market) {
        RecentUnrest ru = RecentUnrest.get(market, false);
        if (ru == null) {
            return 0;
        }
        return ru.getPenalty();
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void apply(String id) {
        this.market.getStability().modifyFlat(id, -1 * this.penalty, "\u6700\u8fd1\u7684\u52a8\u4e71");
    }

    public void unapply(String id) {
        this.market.getStability().unmodify(id);
    }

    public void add(int stability, String reason) {
        this.penalty += stability;
        float dur = this.reasons.getRemaining(reason) + (float)stability * DECREASE_DAYS;
        this.reasons.add(reason, dur);
    }

    public void counter(int points, String reason) {
        points = Math.min(points, this.penalty);
        this.penalty -= points;
        if (this.penalty < 0) {
            this.penalty = 0;
        }
        float dur = this.reasons.getRemaining(reason) + (float)points * DECREASE_DAYS;
        this.reasons.add(reason, dur);
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.reasons.advance(days);
        if (this.penalty > 0) {
            this.untilDecrease -= days;
            if (this.untilDecrease <= 0.0f) {
                --this.penalty;
                if (this.penalty < 0) {
                    this.penalty = 0;
                }
                this.untilDecrease = DECREASE_DAYS;
            }
        }
        if (this.penalty <= 0) {
            this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
        }
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltip(tooltip, expanded);
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        float pad = 3.0f;
        float opad = 10.0f;
        tooltip.addPara("%s \u7a33\u5b9a\u6027\u3002\u6bcf\u4e09\u4e2a\u6708\u6062\u590d\u4e00\u70b9\u3002", opad, Misc.getHighlightColor(), "-" + this.penalty);
        if (!this.reasons.getItems().isEmpty()) {
            tooltip.addPara("\u6700\u8fd1\u7684\u4fc3\u6210\u56e0\u7d20\uff1a", opad);
            float initPad = pad;
            for (String reason : this.reasons.getItems()) {
                tooltip.addPara("    - " + reason, initPad);
                initPad = 0.0f;
            }
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }
}

