/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseHazardCondition;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDepositsCondition
extends BaseHazardCondition
implements MarketImmigrationModifier {
    public static Map<String, String> COMMODITY = new HashMap<String, String>();
    public static Map<String, Integer> MODIFIER = new HashMap<String, Integer>();
    public static Map<String, String> INDUSTRY = new HashMap<String, String>();
    public static Map<String, Integer> BASE_MODIFIER = new HashMap<String, Integer>();
    public static Set<String> BASE_ZERO = new HashSet<String>();

    static {
        COMMODITY.put("ore_sparse", "ore");
        COMMODITY.put("ore_moderate", "ore");
        COMMODITY.put("ore_abundant", "ore");
        COMMODITY.put("ore_rich", "ore");
        COMMODITY.put("ore_ultrarich", "ore");
        COMMODITY.put("rare_ore_sparse", "rare_ore");
        COMMODITY.put("rare_ore_moderate", "rare_ore");
        COMMODITY.put("rare_ore_abundant", "rare_ore");
        COMMODITY.put("rare_ore_rich", "rare_ore");
        COMMODITY.put("rare_ore_ultrarich", "rare_ore");
        COMMODITY.put("organics_trace", "organics");
        COMMODITY.put("organics_common", "organics");
        COMMODITY.put("organics_abundant", "organics");
        COMMODITY.put("organics_plentiful", "organics");
        COMMODITY.put("volatiles_trace", "volatiles");
        COMMODITY.put("volatiles_diffuse", "volatiles");
        COMMODITY.put("volatiles_abundant", "volatiles");
        COMMODITY.put("volatiles_plentiful", "volatiles");
        COMMODITY.put("farmland_poor", "food");
        COMMODITY.put("farmland_adequate", "food");
        COMMODITY.put("farmland_rich", "food");
        COMMODITY.put("farmland_bountiful", "food");
        COMMODITY.put("volturnian_lobster_pens", "lobster");
        COMMODITY.put("water_surface", "food");
        MODIFIER.put("ore_sparse", -1);
        MODIFIER.put("ore_moderate", 0);
        MODIFIER.put("ore_abundant", 1);
        MODIFIER.put("ore_rich", 2);
        MODIFIER.put("ore_ultrarich", 3);
        MODIFIER.put("rare_ore_sparse", -1);
        MODIFIER.put("rare_ore_moderate", 0);
        MODIFIER.put("rare_ore_abundant", 1);
        MODIFIER.put("rare_ore_rich", 2);
        MODIFIER.put("rare_ore_ultrarich", 3);
        MODIFIER.put("organics_trace", -1);
        MODIFIER.put("organics_common", 0);
        MODIFIER.put("organics_abundant", 1);
        MODIFIER.put("organics_plentiful", 2);
        MODIFIER.put("volatiles_trace", -1);
        MODIFIER.put("volatiles_diffuse", 0);
        MODIFIER.put("volatiles_abundant", 1);
        MODIFIER.put("volatiles_plentiful", 2);
        MODIFIER.put("farmland_poor", -1);
        MODIFIER.put("farmland_adequate", 0);
        MODIFIER.put("farmland_rich", 1);
        MODIFIER.put("farmland_bountiful", 2);
        MODIFIER.put("water_surface", 0);
        MODIFIER.put("volturnian_lobster_pens", 1);
        INDUSTRY.put("ore", "mining");
        INDUSTRY.put("rare_ore", "mining");
        INDUSTRY.put("volatiles", "mining");
        INDUSTRY.put("organics", "mining");
        INDUSTRY.put("food", "farming");
        INDUSTRY.put("lobster", "farming");
        BASE_MODIFIER.put("ore", 0);
        BASE_MODIFIER.put("rare_ore", -2);
        BASE_MODIFIER.put("volatiles", -2);
        BASE_MODIFIER.put("organics", 0);
        BASE_MODIFIER.put("food", 0);
        BASE_MODIFIER.put("lobster", 0);
        BASE_ZERO.add("lobster");
    }

    @Override
    public void apply(String id) {
        super.apply(id);
        String commodityId = COMMODITY.get(this.condition.getId());
        if (commodityId == null) {
            return;
        }
        Integer mod = MODIFIER.get(this.condition.getId());
        if (mod == null) {
            return;
        }
        Integer baseMod = BASE_MODIFIER.get(commodityId);
        if (baseMod == null) {
            return;
        }
        String industryId = INDUSTRY.get(commodityId);
        if (industryId == null) {
            return;
        }
        Industry industry = this.market.getIndustry(industryId);
        if (industry == null) {
            if ("farming".equals(industryId)) {
                industryId = "aquaculture";
                industry = this.market.getIndustry(industryId);
            }
            if (industry == null) {
                return;
            }
        }
        int size = this.market.getSize();
        if (BASE_ZERO.contains(commodityId)) {
            size = 0;
        }
        int base = size + baseMod;
        if (industry.isFunctional()) {
            industry.supply(String.valueOf(id) + "_0", commodityId, base, "\u6b96\u6c11\u5730\u89c4\u6a21");
            industry.supply(String.valueOf(id) + "_1", commodityId, mod, Misc.ucFirst(this.condition.getName().toLowerCase()));
        } else {
            industry.getSupply(commodityId).getQuantity().unmodifyFlat(String.valueOf(id) + "_0");
            industry.getSupply(commodityId).getQuantity().unmodifyFlat(String.valueOf(id) + "_1");
        }
        if ("food".equals(commodityId)) {
            this.market.addImmigrationModifier(this);
        }
    }

    @Override
    public void unapply(String id) {
        super.unapply(id);
        this.market.removeImmigrationModifier(this);
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        return super.getTokenReplacements();
    }

    @Override
    public String[] getHighlights() {
        return super.getHighlights();
    }

    @Override
    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        Integer mod;
        super.createTooltipAfterDescription(tooltip, expanded);
        String commodityId = COMMODITY.get(this.condition.getId());
        if (commodityId != null && (mod = MODIFIER.get(this.condition.getId())) != null) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(commodityId);
            String industryId = INDUSTRY.get(commodityId);
            IndustrySpecAPI ind = Global.getSettings().getIndustrySpec(industryId);
            String str = "" + mod;
            if (mod > 0) {
                str = "+" + mod;
            }
            String text = "";
            text = mod == 0 ? "\u4e0d\u4f1a\u63d0\u9ad8\u6216\u964d\u4f4e " + spec.getName().toLowerCase() + " \u7684\u4ea7\u91cf (" + ind.getName() + ")" : str + " " + spec.getName().toLowerCase() + " \u7684\u4ea7\u91cf (" + ind.getName() + ")";
            float pad = 10.0f;
            tooltip.addPara(text, pad, Misc.getHighlightColor(), str);
        }
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        float qty = 0.0f;
        if ("farmland_poor".equals(this.condition.getId())) {
            qty = 5.0f;
        } else if ("farmland_adequate".equals(this.condition.getId())) {
            qty = 10.0f;
        } else if ("farmland_rich".equals(this.condition.getId())) {
            qty = 20.0f;
        } else if ("farmland_bountiful".equals(this.condition.getId())) {
            qty = 30.0f;
        } else if ("water_surface".equals(this.condition.getId())) {
            qty = 10.0f;
        }
        if (qty > 0.0f) {
            incoming.add("luddic_church", qty);
        }
    }
}

