/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class RogueAICore
extends BaseMarketConditionPlugin
implements MarketImmigrationModifier {
    public static final float STABILITY_PENALTY = 1.0f;
    private float daysActive = 0.0f;

    public static RogueAICore get(MarketAPI market) {
        MarketConditionAPI mc = market.getCondition("rogue_ai_core");
        if (mc != null && mc.getPlugin() instanceof RogueAICore) {
            return (RogueAICore)mc.getPlugin();
        }
        return null;
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysActive += days;
    }

    public float getDaysActive() {
        return this.daysActive;
    }

    public void setDaysActive(float daysActive) {
        this.daysActive = daysActive;
    }

    public void apply(String id) {
        this.market.addTransientImmigrationModifier(this);
        this.market.getStability().modifyFlat(id, -1.0f, "\u5931\u63a7\u7684 AI \u6838\u5fc3");
    }

    public boolean isTransient() {
        return false;
    }

    public void unapply(String id) {
        this.market.removeTransientImmigrationModifier(this);
        this.market.getStability().unmodifyFlat(id);
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("luddic_path", 10.0f);
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        tooltip.addPara("%s \u7a33\u5b9a\u6027\u3002", 10.0f, Misc.getHighlightColor(), "-1");
    }
}

