/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShippingDisruption
extends BaseMarketConditionPlugin {
    public static String COMMODITY_LOSS_PREFIX = "sh_loss";
    public static float ACCESS_LOSS_DURATION = 90.0f;
    public static float ACCESS_PER_UNITS_LOST = 0.1f;
    protected MutableStatWithTempMods shippingLost = new MutableStatWithTempMods(0.0f);
    protected float disruptionTimeLeft = 0.0f;

    public static float getPenaltyForShippingLost(float marketSize, float unitsLost) {
        float result = (float)Math.round(unitsLost / marketSize * ACCESS_PER_UNITS_LOST * 100.0f) / 100.0f;
        if (result == 0.0f) {
            result = 0.01f;
        }
        return result;
    }

    public static ShippingDisruption getDisruption(MarketAPI market) {
        MarketConditionAPI mc = market.getCondition("shipping_disruption");
        if (mc == null) {
            String id = market.addCondition("shipping_disruption");
            mc = market.getSpecificCondition(id);
        }
        return (ShippingDisruption)mc.getPlugin();
    }

    public void addShippingLost(float units) {
        this.shippingLost.addTemporaryModFlat(ACCESS_LOSS_DURATION, String.valueOf(this.getModId()) + Misc.genUID(), units);
        this.updatePenaltyValue();
    }

    protected void updatePenaltyValue() {
        this.unapply(this.getModId());
        this.apply(this.getModId());
    }

    public float getDisruptionTimeLeft() {
        return this.disruptionTimeLeft;
    }

    public void setDisruptionTimeLeft(float disruptionTimeLeft) {
        this.disruptionTimeLeft = disruptionTimeLeft;
    }

    public void notifyDisrupted(float duration) {
        this.disruptionTimeLeft = Math.max(this.disruptionTimeLeft, duration);
    }

    @Override
    public void apply(String id) {
        float penalty = ShippingDisruption.getPenaltyForShippingLost(this.market.getSize(), this.shippingLost.getModifiedValue());
        String name = "\u5931\u53bb\u8d38\u6613\u5546\u961f";
        this.market.getAccessibilityMod().modifyFlat(id, -penalty, name);
        if (this.market.isPlayerOwned()) {
            for (CommodityOnMarketAPI com : this.market.getCommoditiesCopy()) {
                ArrayList<String> unmodify = new ArrayList<String>();
                if (com.getMaxSupply() >= com.getAvailable() + 1) {
                    for (String key : com.getAvailableStat().getFlatMods().keySet()) {
                        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(key);
                        int val = Math.round(Math.abs(mod.value));
                        if (!key.startsWith(COMMODITY_LOSS_PREFIX) || val == 0) continue;
                        unmodify.add(mod.source);
                    }
                }
                for (String modId : unmodify) {
                    com.getAvailableStat().unmodifyFlat(modId);
                }
            }
        }
    }

    @Override
    public void unapply(String id) {
        this.market.getAccessibilityMod().unmodifyFlat(id);
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.shippingLost.advance(days);
        this.updatePenaltyValue();
        this.disruptionTimeLeft -= days;
        if (this.disruptionTimeLeft <= 0.0f) {
            this.disruptionTimeLeft = 0.0f;
            if (this.shippingLost.isUnmodified()) {
                this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
            }
        }
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        return super.getTokenReplacements();
    }

    @Override
    public String[] getHighlights() {
        return super.getHighlights();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        tooltip.addTitle("\u8fd0\u8f93\u4e2d\u65ad");
        int loss = this.shippingLost.getModifiedInt();
        int penalty = Math.round(ShippingDisruption.getPenaltyForShippingLost(this.market.getSize(), this.shippingLost.getModifiedValue()) * 100.0f);
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        float pad = 3.0f;
        float small = 5.0f;
        float opad = 10.0f;
        if (penalty > 0) {
            tooltip.addPara("\u7531\u4e8e\u901a\u5f80 " + this.market.getName() + " \u7684\u8d38\u6613\u5546\u961f\u5728\u9014\u4e2d\u906d\u53d7\u5de8\u5927\u635f\u5931\uff0c" + "\u5bfc\u81f4\u6d41\u901a\u6027\u6682\u65f6\u964d\u4f4e %s.", opad, h, penalty + "%");
        }
        CountingMap<CommodityOnMarketAPI> losses = new CountingMap<CommodityOnMarketAPI>();
        for (CommodityOnMarketAPI com : this.market.getCommoditiesCopy()) {
            for (String key : com.getAvailableStat().getFlatMods().keySet()) {
                MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(key);
                int val = Math.round(Math.abs(mod.value));
                if (!key.startsWith(COMMODITY_LOSS_PREFIX) || val == 0) continue;
                losses.add(com, val);
            }
        }
        if (!losses.isEmpty()) {
            tooltip.addPara("\u76ee\u524d\u5f53\u5730\u90e8\u5206\u5546\u54c1\u7684\u4f9b\u5e94\u91cf\u56e0\u8d38\u6613\u8239\u961f\u7684\u635f\u5931\u800c\u4e0b\u964d\u3002\u5047\u5982\u4e0d\u518d\u6709\u8fdb\u4e00\u6b65\u7684\u635f\u5931\uff0c\u5546\u54c1\u4f9b\u5e94\u91cf\u6062\u590d\u5230\u6b63\u5e38\u6c34\u5e73\u6240\u9700\u7684\u65f6\u95f4\u4e0d\u8d85\u8fc7\u4e09\u4e2a\u6708\u3002", opad);
            tooltip.beginGridFlipped(400.0f, 1, 30.0f, opad);
            int j = 0;
            for (CommodityOnMarketAPI com : losses.keySet()) {
                tooltip.addToGrid(0, j++, com.getCommodity().getName(), "-" + losses.getCount(com), h);
            }
            tooltip.addGrid(pad);
        }
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public boolean isTooltipExpandable() {
        return super.isTooltipExpandable();
    }
}

