/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInstallableItemEffect
implements InstallableItemEffect {
    public String id;
    public SpecialItemSpecAPI spec;

    public BaseInstallableItemEffect(String id) {
        this.id = id;
        this.spec = Global.getSettings().getSpecialItemSpec(id);
    }

    public float getItemDescPad(InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        float pad = 0.0f;
        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP) {
            pad = 10.0f;
        }
        return pad;
    }

    public String getItemInstalledText(TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        String name = Misc.ucFirst(this.spec.getName().toLowerCase());
        String pre = "";
        float pad = 0.0f;
        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_LIST || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = String.valueOf(name) + ". ";
        } else if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_INSTALLED || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP) {
            pre = String.valueOf(name) + " \u5df2\u88ab\u5b89\u88c5\u3002";
        }
        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP) {
            pad = 10.0f;
        }
        return pre;
    }

    @Override
    public void addItemDescription(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        String pre = this.getItemInstalledText(text, data, mode);
        float pad = this.getItemDescPad(mode);
        this.addItemDescriptionImpl(industry, text, data, mode, pre, pad);
    }

    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
    }

    public String[] getSimpleReqs(Industry industry) {
        return new String[0];
    }

    @Override
    public List<String> getRequirements(Industry industry) {
        ArrayList<String> reqs = new ArrayList<String>();
        String[] stringArray = this.getSimpleReqs(industry);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            reqs.add(curr);
            ++n2;
        }
        return reqs;
    }

    @Override
    public List<String> getUnmetRequirements(Industry industry) {
        ArrayList<String> unmet = new ArrayList<String>();
        if (industry == null) {
            return unmet;
        }
        MarketAPI market = industry.getMarket();
        for (String curr : this.getRequirements(industry)) {
            if (ItemEffectsRepo.NO_ATMOSPHERE.equals(curr)) {
                if (market.hasCondition("no_atmosphere")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.HABITABLE.equals(curr)) {
                if (market.hasCondition("habitable")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_HABITABLE.equals(curr)) {
                if (!market.hasCondition("habitable")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.GAS_GIANT.equals(curr)) {
                if (market.getPlanetEntity() == null || market.getPlanetEntity().isGasGiant()) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_A_GAS_GIANT.equals(curr)) {
                if (market.getPlanetEntity() == null || !market.getPlanetEntity().isGasGiant()) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_EXTREME_WEATHER.equals(curr)) {
                if (!market.hasCondition("extreme_weather")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_EXTREME_TECTONIC_ACTIVITY.equals(curr)) {
                if (!market.hasCondition("extreme_tectonic_activity")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NO_TRANSPLUTONIC_ORE_DEPOSITS.equals(curr)) {
                if (!market.hasCondition("rare_ore_sparse") && !market.hasCondition("rare_ore_moderate") && !market.hasCondition("rare_ore_abundant") && !market.hasCondition("rare_ore_rich") && !market.hasCondition("rare_ore_ultrarich")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NO_VOLATILES_DEPOSITS.equals(curr)) {
                if (!market.hasCondition("volatiles_trace") && !market.hasCondition("volatiles_diffuse") && !market.hasCondition("volatiles_abundant") && !market.hasCondition("volatiles_plentiful")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.HOT_OR_EXTREME_HEAT.equals(curr)) {
                if (market.hasCondition("hot") || market.hasCondition("very_hot")) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.COLD_OR_EXTREME_COLD.equals(curr)) {
                if (market.hasCondition("cold") || market.hasCondition("very_cold")) continue;
                unmet.add(curr);
                continue;
            }
            if (!ItemEffectsRepo.CORONAL_TAP_RANGE.equals(curr)) continue;
            Pair<SectorEntityToken, Float> p = PopulationAndInfrastructure.getNearestCoronalTap(market.getLocationInHyperspace(), true);
            float dist = Float.MAX_VALUE;
            if (p != null) {
                dist = ((Float)p.two).floatValue();
            }
            if (!(dist > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS)) continue;
            unmet.add(curr);
        }
        return unmet;
    }

    protected void addRequirements(TooltipMakerAPI text, boolean canInstall, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String ... reqs) {
        if (canInstall) {
            return;
        }
        float opad = 10.0f;
        String list = "";
        String[] stringArray = reqs;
        int n = reqs.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            curr = curr.trim();
            list = String.valueOf(list) + curr + ", ";
            ++n2;
        }
        Color reqColor = Misc.getBasePlayerColor();
        if (mode != InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP) {
            reqColor = Misc.getNegativeHighlightColor();
            opad = 0.0f;
        }
        if (!list.isEmpty()) {
            list = list.substring(0, list.length() - 2);
        }
        if (!list.isEmpty()) {
            text.addPara("\u8981\u6c42\uff1a" + list, opad, Misc.getGrayColor(), reqColor, reqs);
        }
    }
}

