/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.listeners.ColonyOtherFactorsListener;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cryorevival
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float ALPHA_CORE_BONUS = 1.0f;
    public static float IMPROVE_BONUS = 1.0f;
    public static float MIN_BONUS_MULT = 0.1f;
    public static float MAX_BONUS_DIST_LY = 10.0f;
    public static float MAX_BONUS_WHEN_UNMET_DEMAND = 0.5f;

    @Override
    public void apply() {
        super.apply(true);
        this.demand("organics", 10);
    }

    @Override
    public void unapply() {
        super.unapply();
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            Color h = Misc.getHighlightColor();
            float opad = 10.0f;
            float bonus = this.getImmigrationBonus();
            float max = this.getMaxImmigrationBonus();
            float distMult = Cryorevival.getDistancePopulationMult(this.market.getLocationInHyperspace());
            float demandMult = this.getDemandMetPopulationMult();
            Pair<SectorEntityToken, Float> p = Cryorevival.getNearestCryosleeper(this.market.getLocationInHyperspace(), true);
            if (p != null) {
                String dStr = Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue());
                String lights = "\u5149\u5e74";
                if (dStr.equals("1")) {
                    lights = "\u5149\u5e74";
                }
                tooltip.addPara("\u56e0\u4e0e\u6700\u8fd1\u7684\u4f4e\u6e29\u4f11\u7720\u8230\u76f8\u8ddd\uff1a%s " + lights + "\uff0c\u6240\u4ee5\u4eba\u53e3\u589e\u957f\u589e\u76ca\u4e3a\uff1a%s.", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), Math.round(distMult * 100.0f) + "%");
            }
            if (mode != Industry.IndustryTooltipMode.NORMAL) {
                tooltip.addPara("\u5982\u679c\u6709\u4efb\u4f55\u9700\u6c42\u672a\u88ab\u6ee1\u8db3\uff0c\u5219\u6700\u5927\u589e\u957f\u589e\u76ca\u964d\u4f4e %s}\u3002", opad, h, Math.round(MAX_BONUS_WHEN_UNMET_DEMAND * 100.0f) + "%");
            } else {
                tooltip.addPara("%s \u7684\u4eba\u53e3\u589e\u957f\u589e\u76ca\u6e90\u4e8e\u5176\u9700\u6c42\u5f97\u5230\u6ee1\u8db3\u7684\u7a0b\u5ea6\u3002\u5982\u679c\u6709\u4efb\u4f55\u9700\u6c42\u6ca1\u6709\u5f97\u5230\u6ee1\u8db3\uff0c\u5219\u6700\u5927\u589e\u957f\u589e\u76ca\u964d\u4f4e %s}\u3002", opad, h, Math.round(demandMult * 100.0f) + "%", Math.round(MAX_BONUS_WHEN_UNMET_DEMAND * 100.0f) + "%");
            }
            tooltip.addPara("\u4eba\u53e3\u589e\u957f\uff1a%s (\u6b96\u6c11\u5730\u89c4\u6a21\u6700\u5927\u503c\uff1a%s) ", opad, h, "+" + Math.round(bonus), "+" + Math.round(max));
        }
    }

    @Override
    public boolean isAvailableToBuild() {
        return Cryorevival.getDistancePopulationMult(this.market.getLocationInHyperspace()) > 0.0f;
    }

    @Override
    public boolean showWhenUnavailable() {
        return false;
    }

    @Override
    public String getUnavailableReason() {
        return "\u9700\u8981\u4f4e\u6e29\u4f11\u7720\u8230";
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        if (this.isFunctional()) {
            incoming.add("sleeper", this.getImmigrationBonus() * 2.0f);
            incoming.getWeight().modifyFlat(this.getModId(), this.getImmigrationBonus(), this.getNameForModifier());
            if ("alpha_core".equals(this.getAICoreId())) {
                incoming.getWeight().modifyFlat(this.getModId(1), (int)(this.getImmigrationBonus() * ALPHA_CORE_BONUS), "\u963f\u5c14\u6cd5\u6838\u5fc3 (" + this.getNameForModifier() + ")");
            }
            if (this.isImproved()) {
                incoming.getWeight().modifyFlat(this.getModId(2), (int)(this.getImmigrationBonus() * IMPROVE_BONUS), String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
            }
        }
    }

    @Override
    protected void applyAlphaCoreModifiers() {
    }

    @Override
    protected void applyNoAICoreModifiers() {
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "\u963f\u5c14\u6cd5\u6838\u5fc3");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "\u76ee\u524d\u5df2\u88ab\u5206\u914d\u7684 \u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "\u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        }
        float a = this.getImmigrationBonus() * ALPHA_CORE_BONUS;
        String str = "+" + Math.round(a);
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "%s \u4eba\u53e3\u589e\u957f\u3002", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "%s \u4eba\u53e3\u589e\u957f\u3002", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = this.getImmigrationBonus() * IMPROVE_BONUS;
        String str = "" + Math.round(a);
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("\u4eba\u53e3\u589e\u957f\u63d0\u9ad8 %s.", 0.0f, highlight, str);
        } else {
            info.addPara("\u4eba\u53e3\u589e\u957f\u63d0\u9ad8 %s.", 0.0f, highlight, str);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    public static Pair<SectorEntityToken, Float> getNearestCryosleeper(Vector2f locInHyper, boolean usable) {
        SectorEntityToken nearest = null;
        float minDist = Float.MAX_VALUE;
        for (SectorEntityToken entity : Global.getSector().getCustomEntitiesWithTag("cryosleeper")) {
            if (usable && !entity.getMemoryWithoutUpdate().contains("$usable")) continue;
            float dist = Misc.getDistanceLY(locInHyper, entity.getLocationInHyperspace());
            if (dist > MAX_BONUS_DIST_LY && (float)Math.round(dist * 10.0f) <= MAX_BONUS_DIST_LY * 10.0f) {
                dist = MAX_BONUS_DIST_LY;
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = entity;
        }
        if (nearest == null) {
            return null;
        }
        return new Pair<Object, Float>(nearest, Float.valueOf(minDist));
    }

    public static float getDistancePopulationMult(Vector2f locInHyper) {
        Pair<SectorEntityToken, Float> p = Cryorevival.getNearestCryosleeper(locInHyper, true);
        if (p == null) {
            return 0.0f;
        }
        if (((Float)p.two).floatValue() > MAX_BONUS_DIST_LY) {
            return 0.0f;
        }
        float f = 1.0f - ((Float)p.two).floatValue() / MAX_BONUS_DIST_LY;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float mult = MIN_BONUS_MULT + (1.0f - MIN_BONUS_MULT) * f;
        return mult;
    }

    protected float getDemandMetPopulationMult() {
        Pair<String, Integer> deficit = this.getMaxDeficit("organics");
        float demand = this.getDemand("organics").getQuantity().getModifiedValue();
        float def = ((Integer)deficit.two).intValue();
        if (def > demand) {
            def = demand;
        }
        float mult = 1.0f;
        if (def > 0.0f && demand > 0.0f) {
            mult = (demand - def) / demand;
            mult *= MAX_BONUS_WHEN_UNMET_DEMAND;
        }
        return mult;
    }

    protected float getImmigrationBonus() {
        return this.getMaxImmigrationBonus() * this.getDemandMetPopulationMult() * Cryorevival.getDistancePopulationMult(this.market.getLocationInHyperspace());
    }

    protected float getMaxImmigrationBonus() {
        return this.getSizeMult() * 10.0f;
    }

    public static class CryosleeperFactor
    implements ColonyOtherFactorsListener {
        public boolean isActiveFactorFor(SectorEntityToken entity) {
            return Cryorevival.getNearestCryosleeper(entity.getLocationInHyperspace(), true) != null;
        }

        public void printOtherFactors(TooltipMakerAPI text, SectorEntityToken entity) {
            float distMult = Cryorevival.getDistancePopulationMult(entity.getLocationInHyperspace());
            Pair<SectorEntityToken, Float> p = Cryorevival.getNearestCryosleeper(entity.getLocationInHyperspace(), true);
            if (p != null) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                String dStr = Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue());
                String lights = "\u5149\u5e74";
                if (dStr.equals("1")) {
                    lights = "\u5149\u5e74";
                }
                if (((Float)p.two).floatValue() > MAX_BONUS_DIST_LY) {
                    text.addPara("\u6700\u8fd1\u7684\u4f4e\u6e29\u4f11\u7720\u8230\u4f4d\u4e8e " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + "\uff0c\u8ddd\u6b64\u5730 %s " + lights + " \u4e4b\u5916\u3002" + "\u800c\u4f11\u7720\u8005\u88ab\u5b89\u5168\u5e26\u6765\u5e76\u82cf\u9192\u7684\u6700\u5927\u8303\u56f4\u662f %s \u5149\u5e74\u3002", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), "" + (int)MAX_BONUS_DIST_LY);
                } else {
                    text.addPara("\u6700\u8fd1\u7684\u4f4e\u6e29\u4f11\u7720\u8230\u4f4d\u4e8e " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + "\uff0c\u8ddd\u6b64\u5730 %s " + lights + " \u4e4b\u5185\u3002" + "\u56e0\u6b64\u5728\u8fd9\u91cc\u5efa\u9020\u7684\u4f4e\u6e29\u590d\u82cf\u8bbe\u65bd\u80fd\u4ee5 %s \u7684\u6548\u7387\u8fd0\u884c\u3002", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), Math.round(distMult * 100.0f) + "%");
                }
            }
        }
    }
}

