/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.GenericSpecialItemPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseInstallableIndustryItemPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.util.HashSet;
import java.util.List;

public class GenericInstallableItemPlugin
extends BaseInstallableIndustryItemPlugin {
    protected Industry industry;

    public GenericInstallableItemPlugin(Industry industry) {
        this.industry = industry;
    }

    public String getMenuItemTitle() {
        if (this.getCurrentlyInstalledItemData() == null) {
            return "\u5b89\u88c5\u5236\u54c1...";
        }
        return "\u7ba1\u7406\u5236\u54c1...";
    }

    public String getUninstallButtonText() {
        return "\u79fb\u9664\u5236\u54c1";
    }

    public boolean isInstallableItem(CargoStackAPI stack) {
        if (!stack.isSpecialStack()) {
            return false;
        }
        String[] industries = stack.getPlugin().getSpec().getParams().split(",");
        HashSet<String> all = new HashSet<String>();
        String[] stringArray = industries;
        int n = industries.length;
        int n2 = 0;
        while (n2 < n) {
            String ind = stringArray[n2];
            all.add(ind.trim());
            ++n2;
        }
        if (!all.contains(this.industry.getId())) {
            return false;
        }
        return ItemEffectsRepo.ITEM_EFFECTS.containsKey(stack.getSpecialDataIfSpecial().getId());
    }

    public SpecialItemData getCurrentlyInstalledItemData() {
        return this.industry.getSpecialItem();
    }

    public void setCurrentlyInstalledItemData(SpecialItemData data) {
        this.industry.setSpecialItem(data);
    }

    public String getNoItemCurrentlyInstalledText() {
        return "\u76ee\u524d\u6ca1\u6709\u5b89\u88c5\u4efb\u4f55\u5236\u54c1";
    }

    public String getNoItemsAvailableText() {
        return "\u6ca1\u6709\u5408\u9002\u7684\u5236\u54c1\u53ef\u4f9b\u5b89\u88c5";
    }

    public String getNoItemsAvailableTextRemote() {
        return "\u4ed3\u5e93\u91cc\u6ca1\u6709\u5408\u9002\u7684\u5236\u54c1";
    }

    public String getSelectItemToAssignToIndustryText() {
        return "\u9009\u62e9\u9700\u5b89\u88c5\u7684\u5236\u54c1 - " + this.industry.getCurrentName();
    }

    public boolean canBeInstalled(SpecialItemData data) {
        InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
        if (effect != null) {
            List<String> unmet = effect.getUnmetRequirements(this.industry);
            return unmet == null || unmet.isEmpty();
        }
        return true;
    }

    public void addItemDescription(TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
        if (effect != null) {
            boolean canInstall;
            List<String> unmet = effect.getUnmetRequirements(this.industry);
            boolean bl = canInstall = unmet == null || unmet.isEmpty();
            if (!canInstall) {
                GenericSpecialItemPlugin.addReqsSection(this.industry, effect, text, true, 0.0f);
            } else {
                effect.addItemDescription(this.industry, text, data, mode);
            }
        }
    }

    public boolean isMenuItemTooltipExpandable() {
        return false;
    }

    public float getMenuItemTooltipWidth() {
        return super.getMenuItemTooltipWidth();
    }

    public boolean hasMenuItemTooltip() {
        return super.hasMenuItemTooltip();
    }

    public void createMenuItemTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 3.0f;
        float opad = 10.0f;
        tooltip.addPara("\u6b64\u5730\u53ef\u5b89\u88c5\u67d0\u4e9b\u4eba\u4e4b\u9886\u65f6\u4ee3\u7684\u5236\u54c1\u6765\u6539\u5584\u6b96\u6c11\u5730\u3002\u4e00\u5904\u8bbe\u65bd\u4ec5\u80fd\u5b89\u88c5\u4e00\u4ef6\u5236\u54c1\u3002", 0.0f);
        SpecialItemData data = this.industry.getSpecialItem();
        if (data == null) {
            tooltip.addPara(String.valueOf(this.getNoItemCurrentlyInstalledText()) + ".", opad);
        } else {
            InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
            SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(data.getId());
            TooltipMakerAPI text = tooltip.beginImageWithText(spec.getIconName(), 48.0f);
            effect.addItemDescription(this.industry, text, data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP);
            tooltip.addImageWithText(opad);
        }
    }
}

