/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.campaign.FusionLampEntityPlugin;
import com.fs.starfarer.api.impl.campaign.econ.ResourceDepositsCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseInstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.BoostIndustryInstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ItemEffectsRepo {
    public static String NOT_A_GAS_GIANT = "\u975e\u6c14\u6001\u5de8\u884c\u661f";
    public static String NOT_HABITABLE = "\u4e0d\u5b9c\u5c45\u4f4f";
    public static String HABITABLE = "\u5b9c\u5c45";
    public static String GAS_GIANT = "\u6c14\u6001\u5de8\u884c\u661f";
    public static String NO_ATMOSPHERE = "\u6ca1\u6709\u5927\u6c14\u5c42";
    public static String NOT_EXTREME_WEATHER = "\u6ca1\u6709\u6781\u7aef\u6c14\u5019";
    public static String NOT_EXTREME_TECTONIC_ACTIVITY = "\u6ca1\u6709\u6781\u7aef\u6784\u9020\u6d3b\u52a8\u6027";
    public static String NO_TRANSPLUTONIC_ORE_DEPOSITS = "\u65e0\u7a00\u6709\u77ff\u77f3\u77ff\u5e8a";
    public static String NO_VOLATILES_DEPOSITS = "\u65e0\u6325\u53d1\u7269\u50a8\u91cf";
    public static String HOT_OR_EXTREME_HEAT = "\u708e\u70ed\u6216\u6781\u7aef\u708e\u70ed";
    public static String COLD_OR_EXTREME_COLD = "\u5bd2\u51b7\u6216\u6781\u7aef\u5bd2\u51b7";
    public static int CORONAL_TAP_LIGHT_YEARS = 10;
    public static String CORONAL_TAP_RANGE = "\u661f\u5195\u5206\u6d41\u5668\u5728 " + CORONAL_TAP_LIGHT_YEARS + " \u5149\u5e74\u4ee5\u5185";
    public static int CORONAL_TAP_TRANSPLUTONICS = 10;
    public static int CORONAL_TAP_INDUSTRIES = 1;
    public static int FUSION_LAMP_FARMING_BONUS = 0;
    public static int FUSION_LAMP_VOLATILES = 10;
    public static float FUSION_LAMP_SHORTAGE_HAZARD = 0.5f;
    public static List<String> FUSION_LAMP_CONDITIONS = new ArrayList<String>();
    public static float CORRUPTED_NANOFORGE_QUALITY_BONUS;
    public static float PRISTINE_NANOFORGE_QUALITY_BONUS;
    public static int CORRUPTED_NANOFORGE_PROD;
    public static int PRISTINE_NANOFORGE_PROD;
    public static int SYNCHROTRON_FUEL_BONUS;
    public static int MANTLE_BORE_MINING_BONUS;
    public static List<String> MANTLE_BORE_COMMODITIES;
    public static int PLASMA_DYNAMO_MINING_BONUS;
    public static List<String> PLASMA_DYNAMO_COMMODITIES;
    public static int BIOFACTORY_PROD_BONUS;
    public static int CATALYTIC_CORE_BONUS;
    public static float FULLERENE_SPOOL_ACCESS_BONUS;
    public static int SOIL_NANITES_BONUS;
    public static float CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT;
    public static float CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT;
    public static float DRONE_REPLICATOR_BONUS_MULT;
    public static int DEALMAKER_INCOME_PERCENT_BONUS;
    public static Map<String, InstallableItemEffect> ITEM_EFFECTS;

    static {
        FUSION_LAMP_CONDITIONS.add("cold");
        FUSION_LAMP_CONDITIONS.add("very_cold");
        FUSION_LAMP_CONDITIONS.add("poor_light");
        FUSION_LAMP_CONDITIONS.add("dark");
        CORRUPTED_NANOFORGE_QUALITY_BONUS = 0.2f;
        PRISTINE_NANOFORGE_QUALITY_BONUS = 0.5f;
        CORRUPTED_NANOFORGE_PROD = 1;
        PRISTINE_NANOFORGE_PROD = 3;
        SYNCHROTRON_FUEL_BONUS = 3;
        MANTLE_BORE_MINING_BONUS = 3;
        MANTLE_BORE_COMMODITIES = new ArrayList<String>();
        MANTLE_BORE_COMMODITIES.add("ore");
        MANTLE_BORE_COMMODITIES.add("rare_ore");
        MANTLE_BORE_COMMODITIES.add("organics");
        PLASMA_DYNAMO_MINING_BONUS = 3;
        PLASMA_DYNAMO_COMMODITIES = new ArrayList<String>();
        PLASMA_DYNAMO_COMMODITIES.add("volatiles");
        BIOFACTORY_PROD_BONUS = 2;
        CATALYTIC_CORE_BONUS = 3;
        FULLERENE_SPOOL_ACCESS_BONUS = 0.3f;
        SOIL_NANITES_BONUS = 2;
        CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT = 0.25f;
        CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT = 1.0f;
        DRONE_REPLICATOR_BONUS_MULT = 1.5f;
        DEALMAKER_INCOME_PERCENT_BONUS = 50;
        ITEM_EFFECTS = new HashMap<String, InstallableItemEffect>(){
            {
                this.put("orbital_fusion_lamp", new BaseInstallableItemEffect("orbital_fusion_lamp"){

                    public void apply(Industry industry) {
                        Industry farming = this.getFarming(industry);
                        if (farming != null && FUSION_LAMP_FARMING_BONUS > 0) {
                            if (farming.isFunctional()) {
                                farming.getSupplyBonusFromOther().modifyFlat(this.spec.getId(), FUSION_LAMP_FARMING_BONUS, String.valueOf(Misc.ucFirst(this.spec.getName().toLowerCase())) + " (" + industry.getCurrentName() + ")");
                            } else {
                                farming.getSupplyBonusFromOther().unmodifyFlat(this.spec.getId());
                            }
                        }
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(9, "volatiles", FUSION_LAMP_VOLATILES, Misc.ucFirst(this.spec.getName().toLowerCase()));
                            MemoryAPI memory = this.getLampMemory(industry);
                            float h = this.getShortageHazard(industry);
                            if (h > 0.0f) {
                                industry.getMarket().getHazard().modifyFlat(this.spec.getId(), h, String.valueOf(Misc.ucFirst(this.spec.getName().toLowerCase())) + " \u6325\u53d1\u7269\u77ed\u7f3a");
                                if (memory != null) {
                                    memory.set(FusionLampEntityPlugin.VOLATILES_SHORTAGE_KEY, Float.valueOf(h / FUSION_LAMP_SHORTAGE_HAZARD));
                                }
                            }
                        }
                        for (String id : FUSION_LAMP_CONDITIONS) {
                            industry.getMarket().suppressCondition(id);
                        }
                    }

                    public void unapply(Industry industry) {
                        Industry farming = this.getFarming(industry);
                        if (farming != null && FUSION_LAMP_FARMING_BONUS > 0) {
                            farming.getSupplyBonusFromOther().unmodifyFlat(this.spec.getId());
                        }
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(9, "volatiles", 0, null);
                            industry.getMarket().getHazard().unmodifyFlat(this.spec.getId());
                            MemoryAPI memory = this.getLampMemory(industry);
                            if (memory != null) {
                                memory.unset(FusionLampEntityPlugin.VOLATILES_SHORTAGE_KEY);
                            }
                        }
                        for (String id : FUSION_LAMP_CONDITIONS) {
                            industry.getMarket().unsuppressCondition(id);
                        }
                    }

                    protected MemoryAPI getLampMemory(Industry industry) {
                        if (industry instanceof PopulationAndInfrastructure) {
                            PopulationAndInfrastructure b = (PopulationAndInfrastructure)industry;
                            if (b.lamp != null) {
                                return b.lamp.getMemoryWithoutUpdate();
                            }
                        }
                        return null;
                    }

                    protected float getShortageHazard(Industry industry) {
                        int volatilesDemand = industry.getDemand("volatiles").getQuantity().getModifiedInt();
                        if (volatilesDemand <= 0 || FUSION_LAMP_SHORTAGE_HAZARD <= 0.0f) {
                            return 0.0f;
                        }
                        float v = industry.getMarket().getCommodityData("volatiles").getAvailable();
                        float f = 1.0f - v / (float)volatilesDemand;
                        float h = (float)Math.round(f * FUSION_LAMP_SHORTAGE_HAZARD * 100.0f) / 100.0f;
                        if (h > 0.0f) {
                            industry.getMarket().getHazard().modifyFlat(this.spec.getId(), h, String.valueOf(Misc.ucFirst(this.spec.getName().toLowerCase())) + " \u6325\u53d1\u7269\u77ed\u7f3a");
                        }
                        return h;
                    }

                    protected Industry getFarming(Industry industry) {
                        String farmingId = "farming";
                        Industry farming = industry.getMarket().getIndustry(farmingId);
                        if (farming == null) {
                            farmingId = "aquaculture";
                            farming = industry.getMarket().getIndustry(farmingId);
                        }
                        return farming;
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        ArrayList<String> conds = new ArrayList<String>();
                        for (String id : FUSION_LAMP_CONDITIONS) {
                            MarketConditionSpecAPI mc = Global.getSettings().getMarketConditionSpec(id);
                            conds.add(mc.getName());
                        }
                        text.addPara(String.valueOf(pre) + "\u62b5\u6d88 " + Misc.getAndJoined(conds) + " \u7684\u5f71\u54cd\u3002\u4f46\u63d0\u9ad8\u975e\u5bd2\u51b7\u884c\u661f\u7684\u5730\u8868\u6e29\u5ea6\u3002" + "\u5e76\u63d0\u9ad8 %s \u5355\u4f4d\u7684\u6325\u53d1\u7269\u9700\u6c42\u3002", pad, Misc.getHighlightColor(), "" + FUSION_LAMP_VOLATILES);
                    }
                });
                this.put("corrupted_nanoforge", new BoostIndustryInstallableItemEffect("corrupted_nanoforge", CORRUPTED_NANOFORGE_PROD, 0){

                    public void apply(Industry industry) {
                        super.apply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").modifyFlat("nanoforge", CORRUPTED_NANOFORGE_QUALITY_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    public void unapply(Industry industry) {
                        super.unapply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").unmodifyFlat("nanoforge");
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        String heavyIndustry = "\u4ea7\u91cf\u63d0\u9ad8";
                        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_LIST) {
                            heavyIndustry = "";
                        }
                        text.addPara(String.valueOf(pre) + "\u63d0\u9ad8 %s \u8230\u8239\u4e0e\u6b66\u5668\u7684\u8d28\u91cf\uff0c" + "\u4e14\u91cd\u5de5\u4e1a" + heavyIndustry + " %s \u5355\u4f4d\u3002" + "\u4f46\u4f1a\u9020\u6210\u6c38\u4e45\u6027\u6c61\u67d3\u3002", pad, Misc.getHighlightColor(), Math.round(CORRUPTED_NANOFORGE_QUALITY_BONUS * 100.0f) + "%", "" + CORRUPTED_NANOFORGE_PROD);
                    }
                });
                this.put("pristine_nanoforge", new BoostIndustryInstallableItemEffect("pristine_nanoforge", PRISTINE_NANOFORGE_PROD, 0){

                    public void apply(Industry industry) {
                        super.apply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").modifyFlat("nanoforge", PRISTINE_NANOFORGE_QUALITY_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    public void unapply(Industry industry) {
                        super.unapply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").unmodifyFlat("nanoforge");
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        String heavyIndustry = "\u4ea7\u91cf\u63d0\u9ad8";
                        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_LIST) {
                            heavyIndustry = "";
                        }
                        text.addPara(String.valueOf(pre) + "\u63d0\u9ad8 %s \u8230\u8239\u4e0e\u6b66\u5668\u7684\u8d28\u91cf\uff0c" + "\u4e14\u91cd\u5de5\u4e1a" + heavyIndustry + " %s \u5355\u4f4d\u3002" + "\u4f46\u4f1a\u9020\u6210\u6c38\u4e45\u6027\u6c61\u67d3\u3002", pad, Misc.getHighlightColor(), Math.round(PRISTINE_NANOFORGE_QUALITY_BONUS * 100.0f) + "%", "" + PRISTINE_NANOFORGE_PROD);
                    }
                });
                this.put("synchrotron", new BoostIndustryInstallableItemEffect("synchrotron", SYNCHROTRON_FUEL_BONUS, 0){

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u71c3\u6599\u4ea7\u91cf\u63d0\u9ad8 %s \u5355\u4f4d\u3002", pad, Misc.getHighlightColor(), "" + SYNCHROTRON_FUEL_BONUS);
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NO_ATMOSPHERE};
                    }
                });
                this.put("mantle_bore", new BaseInstallableItemEffect("mantle_bore"){

                    protected Set<String> getAffectedCommodities(Industry industry) {
                        MarketAPI market = industry.getMarket();
                        LinkedHashSet<String> result = new LinkedHashSet<String>();
                        for (MarketConditionAPI mc : market.getConditions()) {
                            String cid = mc.getId();
                            String commodity = ResourceDepositsCondition.COMMODITY.get(cid);
                            for (String curr : MANTLE_BORE_COMMODITIES) {
                                if (!curr.equals(commodity)) continue;
                                result.add(curr);
                            }
                        }
                        return result;
                    }

                    @Override
                    public void apply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            Set<String> list = this.getAffectedCommodities(industry);
                            if (!list.isEmpty()) {
                                for (String curr : list) {
                                    b.supply(this.spec.getId(), curr, MANTLE_BORE_MINING_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                                }
                            }
                        }
                    }

                    @Override
                    public void unapply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            for (String curr : MANTLE_BORE_COMMODITIES) {
                                b.supply(this.spec.getId(), curr, 0, null);
                            }
                        }
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        ArrayList<String> commodities = new ArrayList<String>();
                        for (String curr : MANTLE_BORE_COMMODITIES) {
                            CommoditySpecAPI c = Global.getSettings().getCommoditySpec(curr);
                            commodities.add(c.getName().toLowerCase());
                        }
                        text.addPara(String.valueOf(pre) + "\u5c06 " + Misc.getAndJoined(commodities) + " \u7684\u4ea7\u91cf\u63d0\u9ad8 %s \u5355\u4f4d\u3002", pad, Misc.getHighlightColor(), "" + MANTLE_BORE_MINING_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NOT_A_GAS_GIANT, NOT_HABITABLE};
                    }
                });
                this.put("plasma_dynamo", new BaseInstallableItemEffect("plasma_dynamo"){

                    protected Set<String> getAffectedCommodities(Industry industry) {
                        MarketAPI market = industry.getMarket();
                        LinkedHashSet<String> result = new LinkedHashSet<String>();
                        for (MarketConditionAPI mc : market.getConditions()) {
                            String cid = mc.getId();
                            String commodity = ResourceDepositsCondition.COMMODITY.get(cid);
                            for (String curr : PLASMA_DYNAMO_COMMODITIES) {
                                if (!curr.equals(commodity)) continue;
                                result.add(curr);
                            }
                        }
                        return result;
                    }

                    @Override
                    public void apply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            Set<String> list = this.getAffectedCommodities(industry);
                            if (!list.isEmpty()) {
                                for (String curr : list) {
                                    b.supply(this.spec.getId(), curr, PLASMA_DYNAMO_MINING_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                                }
                            }
                        }
                    }

                    @Override
                    public void unapply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            for (String curr : PLASMA_DYNAMO_COMMODITIES) {
                                b.supply(this.spec.getId(), curr, 0, null);
                            }
                        }
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        ArrayList<String> commodities = new ArrayList<String>();
                        for (String curr : PLASMA_DYNAMO_COMMODITIES) {
                            CommoditySpecAPI c = Global.getSettings().getCommoditySpec(curr);
                            commodities.add(c.getName().toLowerCase());
                        }
                        text.addPara(String.valueOf(pre) + "\u5c06 " + Misc.getAndJoined(commodities) + " \u7684\u4ea7\u91cf\u63d0\u9ad8 %s \u5355\u4f4d\u3002", pad, Misc.getHighlightColor(), "" + PLASMA_DYNAMO_MINING_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{GAS_GIANT};
                    }
                });
                this.put("biofactory_embryo", new BoostIndustryInstallableItemEffect("biofactory_embryo", BIOFACTORY_PROD_BONUS, 0){

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u8f7b\u5de5\u4e1a\u4ea7\u91cf\u63d0\u9ad8 %s \u5355\u4f4d\u3002", pad, Misc.getHighlightColor(), "" + BIOFACTORY_PROD_BONUS);
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{HABITABLE};
                    }
                });
                this.put("catalytic_core", new BoostIndustryInstallableItemEffect("catalytic_core", CATALYTIC_CORE_BONUS, 0){

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u51b6\u70bc\u5382\u4ea7\u91cf\u63d0\u9ad8 %s \u5355\u4f4d\u3002", pad, Misc.getHighlightColor(), "" + CATALYTIC_CORE_BONUS);
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NO_ATMOSPHERE};
                    }
                });
                this.put("fullerene_spool", new BaseInstallableItemEffect("fullerene_spool"){

                    public void apply(Industry industry) {
                        industry.getMarket().getAccessibilityMod().modifyFlat(this.spec.getId(), FULLERENE_SPOOL_ACCESS_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    public void unapply(Industry industry) {
                        industry.getMarket().getAccessibilityMod().unmodifyFlat(this.spec.getId());
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u6b96\u6c11\u5730\u6d41\u901a\u6027\u63d0\u9ad8 %s.", pad, Misc.getHighlightColor(), Math.round(FULLERENE_SPOOL_ACCESS_BONUS * 100.0f) + "%");
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NOT_A_GAS_GIANT, NOT_EXTREME_WEATHER, NOT_EXTREME_TECTONIC_ACTIVITY};
                    }
                });
                this.put("soil_nanites", new BoostIndustryInstallableItemEffect("soil_nanites", SOIL_NANITES_BONUS, 0){

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u519c\u4e1a\u4ea7\u91cf\u63d0\u9ad8 %s \u5355\u4f4d\u3002", pad, Misc.getHighlightColor(), "" + SOIL_NANITES_BONUS);
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NO_TRANSPLUTONIC_ORE_DEPOSITS, NO_VOLATILES_DEPOSITS};
                    }
                });
                this.put("cryoarithmetic_engine", new BaseInstallableItemEffect("cryoarithmetic_engine"){

                    public void apply(Industry industry) {
                        float bonus = 0.0f;
                        if (industry.getMarket().hasCondition("hot")) {
                            bonus = CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT;
                        } else if (industry.getMarket().hasCondition("very_hot")) {
                            bonus = CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT;
                        }
                        industry.getMarket().getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat(this.spec.getId(), bonus, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    public void unapply(Industry industry) {
                        industry.getMarket().getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(this.spec.getId());
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u82e5\u73af\u5883\u4e3a \u708e\u70ed\uff0c\u5219\u672c\u5730\u8230\u961f\u89c4\u6a21\u63d0\u9ad8 %s}\uff0c" + "\u82e5 \u6781\u7aef\u708e\u70ed\uff0c\u5219\u8230\u961f\u89c4\u6a21\u63d0\u9ad8 %s.", pad, Misc.getHighlightColor(), Math.round(CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT * 100.0f) + "%", Math.round(CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT * 100.0f) + "%");
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{HOT_OR_EXTREME_HEAT};
                    }
                });
                this.put("drone_replicator", new BaseInstallableItemEffect("drone_replicator"){

                    public void apply(Industry industry) {
                        industry.getMarket().getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.spec.getId(), DRONE_REPLICATOR_BONUS_MULT, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    public void unapply(Industry industry) {
                        industry.getMarket().getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.spec.getId());
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u5730\u9762\u9632\u5fa1 %s.", pad, Misc.getHighlightColor(), "\u00d7" + DRONE_REPLICATOR_BONUS_MULT);
                    }
                });
                this.put("dealmaker_holosuite", new BaseInstallableItemEffect("dealmaker_holosuite"){

                    public void apply(Industry industry) {
                        industry.getMarket().getIncomeMult().modifyPercent(this.spec.getId(), DEALMAKER_INCOME_PERCENT_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    public void unapply(Industry industry) {
                        industry.getMarket().getIncomeMult().unmodifyPercent(this.spec.getId());
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u6b96\u6c11\u5730\u6536\u5165\u63d0\u9ad8 %s.", pad, Misc.getHighlightColor(), DEALMAKER_INCOME_PERCENT_BONUS + "%");
                    }
                });
                this.put("coronal_portal", new BaseInstallableItemEffect("coronal_portal"){

                    public void apply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(8, "rare_metals", CORONAL_TAP_TRANSPLUTONICS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                            if (!this.hasShortage(industry)) {
                                industry.getMarket().getStats().getDynamic().getMod("max_industries").modifyFlat(this.spec.getId(), CORONAL_TAP_INDUSTRIES);
                            } else {
                                industry.getMarket().getStats().getDynamic().getMod("max_industries").unmodifyFlat(this.spec.getId());
                            }
                        }
                    }

                    public void unapply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(8, "rare_metals", 0, null);
                            industry.getMarket().getStats().getDynamic().getMod("max_industries").unmodifyFlat(this.spec.getId());
                        }
                    }

                    protected boolean hasShortage(Industry industry) {
                        int transplutonicsDemand = industry.getDemand("rare_metals").getQuantity().getModifiedInt();
                        float v = industry.getMarket().getCommodityData("rare_metals").getAvailable();
                        float f = 1.0f - v / (float)transplutonicsDemand;
                        return f > 0.0f;
                    }

                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "\u60f3\u8981\u5c06\u6b96\u6c11\u5730\u5de5\u4e1a\u8bbe\u65bd\u4e0a\u9650\u63d0\u9ad8 %s, " + "\u5c31\u5fc5\u987b\u6ee1\u8db3 %s \u5355\u4f4d\u7684\u7a00\u6709\u5143\u7d20\u4f9b\u5e94\u3002", pad, Misc.getHighlightColor(), "" + CORONAL_TAP_INDUSTRIES, "" + CORONAL_TAP_TRANSPLUTONICS);
                    }

                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{CORONAL_TAP_RANGE};
                    }
                });
            }
        };
    }
}

