/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class PlanetaryShield
extends BaseIndustry {
    public static float DEFENSE_BONUS = 2.0f;
    public static float ALPHA_CORE_BONUS = 0.5f;
    public static float IMPROVE_DEFENSE_BONUS = 0.25f;

    public void apply() {
        super.apply(false);
        int size = 5;
        this.applyIncomeAndUpkeep(size);
        float bonus = DEFENSE_BONUS;
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(), 1.0f + bonus, this.getNameForModifier());
        if (this.isFunctional()) {
            this.market.suppressCondition("meteor_impacts");
            PlanetaryShield.applyVisuals(this.market.getPlanetEntity());
        } else {
            this.unapply();
        }
    }

    public static void applyVisuals(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        planet.getSpec().setShieldTexture(Global.getSettings().getSpriteName("industry", "shield_texture"));
        planet.getSpec().setShieldThickness(0.1f);
        planet.getSpec().setShieldColor(new Color(255, 255, 255, 175));
        planet.applySpecChanges();
    }

    public static void unapplyVisuals(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        planet.getSpec().setShieldTexture(null);
        planet.getSpec().setShieldThickness(0.0f);
        planet.getSpec().setShieldColor(null);
        planet.applySpecChanges();
    }

    public void unapply() {
        super.unapply();
        this.market.unsuppressCondition("meteor_impacts");
        PlanetaryShield.unapplyVisuals(this.market.getPlanetEntity());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
    }

    public boolean isAvailableToBuild() {
        if (!Global.getSector().getPlayerFaction().knowsIndustry(this.getId())) {
            return false;
        }
        return this.market.getPlanetEntity() != null && !this.market.getPlanetEntity().isGasGiant();
    }

    public String getUnavailableReason() {
        if (!super.isAvailableToBuild()) {
            return super.getUnavailableReason();
        }
        return "\u65e0\u6cd5\u5728\u6c14\u6001\u5de8\u884c\u661f\u4e0a\u5efa\u9020";
    }

    public boolean showWhenUnavailable() {
        return Global.getSector().getPlayerFaction().knowsIndustry(this.getId());
    }

    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            float bonus = DEFENSE_BONUS;
            this.addGroundDefensesImpactSection(tooltip, bonus, null);
        }
    }

    protected void applyAlphaCoreModifiers() {
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(1), 1.0f + ALPHA_CORE_BONUS, "\u963f\u5c14\u6cd5\u6838\u5fc3 (" + this.getNameForModifier() + ")");
    }

    protected void applyNoAICoreModifiers() {
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(1));
    }

    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "\u963f\u5c14\u6cd5\u6838\u5fc3");
    }

    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "\u76ee\u524d\u5df2\u88ab\u5206\u914d\u7684 \u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "\u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        }
        float a = ALPHA_CORE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u5730\u9762\u9632\u5fa1 %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u5730\u9762\u9632\u5fa1 %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    public boolean canImprove() {
        return true;
    }

    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(2), 1.0f + IMPROVE_DEFENSE_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(2));
        }
    }

    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_DEFENSE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("\u5730\u9762\u9632\u5fa1 %s.", 0.0f, highlight, str);
        } else {
            info.addPara("\u5730\u9762\u9632\u5fa1 %s.", 0.0f, highlight, str);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

