/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.CommodityMarketDataAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.listeners.ColonyOtherFactorsListener;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.CommRelayCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulationAndInfrastructure
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float OFFICER_BASE_PROB = Global.getSettings().getFloat("officerBaseProb");
    public static float OFFICER_PROB_PER_SIZE = Global.getSettings().getFloat("officerProbPerColonySize");
    public static float OFFICER_ADDITIONAL_BASE_PROB = Global.getSettings().getFloat("officerAdditionalBaseProb");
    public static float OFFICER_BASE_MERC_PROB = Global.getSettings().getFloat("officerBaseMercProb");
    public static float ADMIN_BASE_PROB = Global.getSettings().getFloat("adminBaseProb");
    public static float ADMIN_PROB_PER_SIZE = Global.getSettings().getFloat("adminProbPerColonySize");
    public static float IMPROVE_STABILITY_BONUS = 1.0f;
    public static boolean HAZARD_INCREASES_DEFENSE = false;
    public static int[] MAX_IND = null;
    protected String addedHeatCondition = null;
    protected String removedHeatCondition = null;
    protected SectorEntityToken lamp;

    @Override
    public void apply() {
        float sizeBonus;
        PopulationAndInfrastructure.modifyStability(this, this.market, this.getModId(3));
        super.apply(true);
        int size = this.market.getSize();
        this.demand("food", size);
        if (!this.market.hasCondition("habitable")) {
            this.demand("organics", size - 1);
        }
        int luxuryThreshold = 3;
        this.demand("domestic_goods", size - 1);
        this.demand("luxury_goods", size - luxuryThreshold);
        this.demand("drugs", size - 2);
        this.demand("organs", size - 3);
        this.demand("supplies", Math.min(size, 3));
        this.supply("crew", size - 3);
        this.supply("drugs", size - 4);
        this.supply("organs", size - 5);
        Pair<String, Integer> deficit = this.getMaxDeficit("domestic_goods");
        if ((Integer)deficit.two <= 0) {
            this.market.getStability().modifyFlat(this.getModId(0), 1.0f, "\u672c\u5730\u5546\u54c1\u9700\u6c42\u5f97\u5230\u6ee1\u8db3");
        } else {
            this.market.getStability().unmodifyFlat(this.getModId(0));
        }
        deficit = this.getMaxDeficit("luxury_goods");
        if ((Integer)deficit.two <= 0 && size > luxuryThreshold) {
            this.market.getStability().modifyFlat(this.getModId(1), 1.0f, "\u5962\u4f88\u54c1\u9700\u6c42\u5f97\u5230\u6ee1\u8db3");
        } else {
            this.market.getStability().unmodifyFlat(this.getModId(1));
        }
        deficit = this.getMaxDeficit("food");
        if (!this.market.hasCondition("habitable")) {
            deficit = this.getMaxDeficit("food", "organics");
        }
        if ((Integer)deficit.two > 0) {
            this.market.getStability().modifyFlat(this.getModId(2), -((Integer)deficit.two).intValue(), PopulationAndInfrastructure.getDeficitText((String)deficit.one));
        } else {
            this.market.getStability().unmodifyFlat(this.getModId(2));
        }
        boolean spaceportFirstInQueue = false;
        Iterator<ConstructionQueue.ConstructionQueueItem> iterator = this.market.getConstructionQueue().getItems().iterator();
        if (iterator.hasNext()) {
            ConstructionQueue.ConstructionQueueItem item = iterator.next();
            IndustrySpecAPI spec = Global.getSettings().getIndustrySpec(item.id);
            if (spec.hasTag("spaceport")) {
                spaceportFirstInQueue = true;
            }
        }
        if (spaceportFirstInQueue && Misc.getCurrentlyBeingConstructed(this.market) != null) {
            spaceportFirstInQueue = false;
        }
        if (!this.market.hasSpaceport() && !spaceportFirstInQueue) {
            float accessibilityNoSpaceport = Global.getSettings().getFloat("accessibilityNoSpaceport");
            this.market.getAccessibilityMod().modifyFlat(this.getModId(0), accessibilityNoSpaceport, "\u65e0\u592a\u7a7a\u6e2f");
        }
        if ((sizeBonus = PopulationAndInfrastructure.getAccessibilityBonus(size)) > 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(1), sizeBonus, "\u6b96\u6c11\u5730\u89c4\u6a21");
        }
        float stability = this.market.getPrevStability();
        float stabilityQualityMod = FleetFactoryV3.getShipQualityModForStability(stability);
        float doctrineQualityMod = this.market.getFaction().getDoctrine().getShipQualityContribution();
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.getModId(0), stabilityQualityMod, "\u7a33\u5b9a\u6027");
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.getModId(1), doctrineQualityMod, String.valueOf(Misc.ucFirst(this.market.getFaction().getEntityNamePrefix())) + " \u8230\u961f\u5b66\u8bf4");
        float stabilityDefenseMult = 0.25f + stability / 10.0f * 0.75f;
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMultAlways(this.getModId(), stabilityDefenseMult, "\u7a33\u5b9a\u6027");
        float baseDef = PopulationAndInfrastructure.getBaseGroundDefenses(this.market.getSize());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyFlatAlways(this.getModId(), baseDef, "\u89c4\u6a21\u4e3a " + this.market.getSize() + " \u7684\u6b96\u6c11\u5730");
        if (HAZARD_INCREASES_DEFENSE) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMultAlways(this.getModId(1), Math.max(this.market.getHazardValue(), 1.0f), "\u6b96\u6c11\u5730\u5371\u9669\u7b49\u7ea7");
        }
        this.market.getStats().getDynamic().getMod("max_industries").modifyFlat(this.getModId(), this.getMaxIndustries(), null);
        FactionDoctrineAPI doctrine = this.market.getFaction().getDoctrine();
        float doctrineShipsMult = FleetFactoryV3.getDoctrineNumShipsMult(doctrine.getNumShips());
        float marketSizeShipsMult = FleetFactoryV3.getNumShipsMultForMarketSize(this.market.getSize());
        float deficitShipsMult = FleetFactoryV3.getShipDeficitFleetSizeMult(this.market);
        float stabilityShipsMult = FleetFactoryV3.getNumShipsMultForStability(stability);
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlatAlways(this.getModId(0), marketSizeShipsMult, "\u6b96\u6c11\u5730\u89c4\u6a21");
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMultAlways(this.getModId(1), doctrineShipsMult, String.valueOf(Misc.ucFirst(this.market.getFaction().getEntityNamePrefix())) + " \u8230\u961f\u5b66\u8bf4");
        if (deficitShipsMult != 1.0f) {
            this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMult(this.getModId(2), deficitShipsMult, PopulationAndInfrastructure.getDeficitText("ships"));
        } else {
            this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMultAlways(this.getModId(2), deficitShipsMult, PopulationAndInfrastructure.getDeficitText("ships").replaceAll("shortage", "\u9700\u6c42\u5f97\u5230\u6ee1\u8db3"));
        }
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMultAlways(this.getModId(3), stabilityShipsMult, "\u7a33\u5b9a\u6027");
        this.market.getStats().getDynamic().getMod("officer_prob").modifyFlat(this.getModId(0), OFFICER_BASE_PROB);
        this.market.getStats().getDynamic().getMod("officer_prob").modifyFlat(this.getModId(1), OFFICER_PROB_PER_SIZE * (float)Math.max(0, this.market.getSize() - 3));
        this.market.getStats().getDynamic().getMod("additional_officer_prob_mult").modifyFlat(this.getModId(0), OFFICER_ADDITIONAL_BASE_PROB);
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").modifyFlat(this.getModId(0), OFFICER_BASE_MERC_PROB);
        this.market.getStats().getDynamic().getMod("admin_prob").modifyFlat(this.getModId(0), ADMIN_BASE_PROB);
        this.market.getStats().getDynamic().getMod("admin_prob").modifyFlat(this.getModId(1), ADMIN_PROB_PER_SIZE * (float)Math.max(0, this.market.getSize() - 3));
        PopulationAndInfrastructure.modifyStability2(this, this.market, this.getModId(3));
        this.market.addTransientImmigrationModifier(this);
    }

    public static float getAccessibilityBonus(int marketSize) {
        if (marketSize <= 4) {
            return 0.0f;
        }
        if (marketSize == 5) {
            return 0.1f;
        }
        if (marketSize == 6) {
            return 0.15f;
        }
        if (marketSize == 7) {
            return 0.2f;
        }
        if (marketSize == 8) {
            return 0.25f;
        }
        return 0.3f;
    }

    public static float getBaseGroundDefenses(int marketSize) {
        if (marketSize <= 1) {
            return 10.0f;
        }
        if (marketSize <= 2) {
            return 20.0f;
        }
        if (marketSize <= 3) {
            return 50.0f;
        }
        return (marketSize - 3) * 100;
    }

    @Override
    public void unapply() {
        super.unapply();
        this.market.getStability().unmodify(this.getModId(0));
        this.market.getStability().unmodify(this.getModId(1));
        this.market.getStability().unmodify(this.getModId(2));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(0));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(1));
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").unmodifyFlat(this.getModId(1));
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
        if (HAZARD_INCREASES_DEFENSE) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(1));
        }
        this.market.getStats().getDynamic().getMod("max_industries").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId(1));
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId(2));
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId(3));
        this.market.getStats().getDynamic().getMod("officer_prob").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("officer_prob").unmodifyFlat(this.getModId(1));
        this.market.getStats().getDynamic().getMod("additional_officer_prob_mult").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("admin_prob").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("admin_prob").unmodifyFlat(this.getModId(1));
        PopulationAndInfrastructure.unmodifyStability(this.market, this.getModId(3));
        this.market.removeTransientImmigrationModifier(this);
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return true;
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            MutableStat stabilityMods = new MutableStat(0.0f);
            float total = 0.0f;
            for (MutableStat.StatMod mod : this.market.getStability().getFlatMods().values()) {
                if (!mod.source.startsWith(this.getModId())) continue;
                stabilityMods.modifyFlat(mod.source, mod.value, mod.desc);
                total += mod.value;
            }
            String totalStr = "+" + Math.round(total);
            Color h = Misc.getHighlightColor();
            if (total < 0.0f) {
                totalStr = "" + Math.round(total);
                h = Misc.getNegativeHighlightColor();
            }
            float opad = 10.0f;
            float pad = 3.0f;
            if (total >= 0.0f) {
                tooltip.addPara("\u7a33\u5b9a\u6027\u589e\u76ca\uff1a%s", opad, h, totalStr);
            } else {
                tooltip.addPara("\u7a33\u5b9a\u6027\u60e9\u7f5a\uff1a%s", opad, h, totalStr);
            }
            tooltip.addStatModGrid(400.0f, 30.0f, opad, pad, stabilityMods, new TooltipMakerAPI.StatModValueGetter(){

                public String getPercentValue(MutableStat.StatMod mod) {
                    return null;
                }

                public String getMultValue(MutableStat.StatMod mod) {
                    return null;
                }

                public Color getModColor(MutableStat.StatMod mod) {
                    if (mod.value < 0.0f) {
                        return Misc.getNegativeHighlightColor();
                    }
                    return null;
                }

                public String getFlatValue(MutableStat.StatMod mod) {
                    return null;
                }
            });
        }
    }

    @Override
    public String getCurrentImage() {
        float size = this.market.getSize();
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "pop_low");
        }
        if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "pop_high");
        }
        return super.getCurrentImage();
    }

    public static float getIncomeStabilityMult(float stability) {
        if (stability <= 5.0f) {
            return Math.max(0.0f, stability / 5.0f);
        }
        return 1.0f;
    }

    public static float getUpkeepHazardMult(float hazard) {
        float hazardMult = hazard;
        float min = Global.getSettings().getFloat("minUpkeepMult");
        if (hazardMult < min) {
            hazardMult = min;
        }
        return hazardMult;
    }

    public static int getMismanagementPenalty() {
        int outposts = 0;
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!curr.isPlayerOwned() || !curr.getAdmin().isPlayer()) continue;
            ++outposts;
        }
        MutableCharacterStatsAPI stats = Global.getSector().getCharacterData().getPerson().getStats();
        int maxOutposts = stats.getOutpostNumber().getModifiedInt();
        int overOutposts = outposts - maxOutposts;
        int penaltyOrBonus = (int)((float)overOutposts * Misc.getOutpostPenalty());
        return penaltyOrBonus;
    }

    public static void modifyStability2(Industry industry, MarketAPI market, String modId) {
        if (Misc.getNumIndustries(market) > Misc.getMaxIndustries(market)) {
            market.getStability().modifyFlat("_" + modId + "_overmax", -Misc.OVER_MAX_INDUSTRIES_PENALTY, "\u8d85\u8fc7\u6700\u5927\u5de5\u4e1a\u8bbe\u65bd\u4e0a\u9650");
        } else {
            market.getStability().unmodifyFlat("_" + modId + "_overmax");
        }
    }

    public static void modifyUpkeepByHazardRating(MarketAPI market, String modId) {
        market.getUpkeepMult().modifyMultAlways(modId, PopulationAndInfrastructure.getUpkeepHazardMult(market.getHazardValue()), "\u5371\u9669\u7b49\u7ea7");
    }

    public static void modifyStability(Industry industry, MarketAPI market, String modId) {
        market.getIncomeMult().modifyMultAlways(modId, PopulationAndInfrastructure.getIncomeStabilityMult(market.getPrevStability()), "\u7a33\u5b9a\u6027");
        market.getStability().modifyFlat("_" + modId + "_ms", Global.getSettings().getFloat("stabilityBaseValue"), "\u57fa\u7840\u503c");
        float inFactionSupply = 0.0f;
        float totalDemand = 0.0f;
        for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
            int d;
            if (com.isNonEcon() || (d = com.getMaxDemand()) <= 0) continue;
            totalDemand += (float)d;
            CommodityMarketDataAPI cmd = com.getCommodityMarketData();
            int inFaction = Math.max(Math.min(com.getMaxSupply(), com.getAvailable()), Math.min(cmd.getMaxShipping(market, true), cmd.getMaxExport(market.getFactionId())));
            if (inFaction > d) {
                inFaction = d;
            }
            if (inFaction < d) {
                inFaction = Math.max(Math.min(com.getMaxSupply(), com.getAvailable()), 0);
            }
            inFactionSupply += (float)Math.max(0, Math.min(inFaction, com.getAvailable()));
        }
        if (totalDemand > 0.0f) {
            float max = Global.getSettings().getFloat("upkeepReductionFromInFactionImports");
            float f = inFactionSupply / totalDemand;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f > 0.0f) {
                float mult = (float)Math.round(100.0f - f * max * 100.0f) / 100.0f;
                String desc = "\u52bf\u529b\u5185\u90e8\u9700\u6c42 (" + Math.round(f * 100.0f) + "%)";
                if (f == 1.0f) {
                    desc = "\u6240\u6709\u9700\u6c42\u5747\u7531\u6240\u5c5e\u52bf\u529b\u6ee1\u8db3";
                }
                market.getUpkeepMult().modifyMultAlways(String.valueOf(modId) + "ifi", mult, desc);
            } else {
                market.getUpkeepMult().modifyMultAlways(String.valueOf(modId) + "ifi", 1.0f, "\u90e8\u5206\u9700\u6c42\u8981\u501f\u52a9\u5916\u90e8\u52bf\u529b\u7684\u5e2e\u52a9 - \u4e0d\u964d\u4f4e\u7ef4\u62a4\u8d39\u7528");
            }
        }
        if (market.isPlayerOwned() && market.getAdmin().isPlayer()) {
            int penalty = PopulationAndInfrastructure.getMismanagementPenalty();
            if (penalty > 0) {
                market.getStability().modifyFlat("_" + modId + "_mm", -penalty, "\u7ba1\u7406\u4e0d\u5584");
            } else if (penalty < 0) {
                market.getStability().modifyFlat("_" + modId + "_mm", -penalty, "\u884c\u653f\u589e\u76ca");
            } else {
                market.getStability().unmodifyFlat("_" + modId + "_mm");
            }
        } else {
            market.getStability().unmodifyFlat(String.valueOf(modId) + "_mm");
        }
        if (!market.hasCondition("comm_relay")) {
            market.getStability().modifyFlat(CommRelayCondition.COMM_RELAY_MOD_ID, CommRelayCondition.NO_RELAY_PENALTY, "\u661f\u7cfb\u5185\u65e0\u6709\u6548\u7684\u901a\u8baf\u4e2d\u7ee7\u7ad9");
        }
    }

    public static void unmodifyStability(MarketAPI market, String modId) {
        market.getIncomeMult().unmodifyMult(modId);
        market.getUpkeepMult().unmodifyMult(modId);
        market.getUpkeepMult().unmodifyMult(String.valueOf(modId) + "ifi");
        market.getStability().unmodifyFlat(modId);
        market.getStability().unmodifyFlat("_" + modId + "_mm");
        market.getStability().unmodifyFlat("_" + modId + "_ms");
        market.getStability().unmodifyFlat("_" + modId + "_overmax");
        if (!market.hasCondition("comm_relay")) {
            market.getStability().unmodifyFlat(CommRelayCondition.COMM_RELAY_MOD_ID);
        }
    }

    @Override
    public boolean showShutDown() {
        return false;
    }

    @Override
    public String getCanNotShutDownReason() {
        return null;
    }

    @Override
    public boolean canShutDown() {
        return false;
    }

    @Override
    protected String getDescriptionOverride() {
        int size = this.market.getSize();
        String cid = null;
        if (size >= 1 && size <= 9) {
            cid = "population_" + size;
            MarketConditionSpecAPI mcs = Global.getSettings().getMarketConditionSpec(cid);
            if (mcs != null) {
                return String.valueOf(this.spec.getDesc()) + "\n\n" + mcs.getDesc().replaceAll("\\$marketName", this.market.getName());
            }
        }
        return super.getDescriptionOverride();
    }

    @Override
    public String getBuildOrUpgradeProgressText() {
        if (this.isUpgrading()) {
            return "\u603b\u53d1\u5c55\u5ea6\uff1a" + Misc.getRoundedValue(Misc.getMarketSizeProgress(this.market) * 100.0f) + "%";
        }
        return super.getBuildOrUpgradeProgressText();
    }

    @Override
    public float getBuildOrUpgradeProgress() {
        if (!super.isBuilding() && this.market.getSize() < Misc.MAX_COLONY_SIZE) {
            return Misc.getMarketSizeProgress(this.market);
        }
        return super.getBuildOrUpgradeProgress();
    }

    @Override
    public boolean isBuilding() {
        if (!super.isBuilding() && this.market.getSize() < Misc.MAX_COLONY_SIZE && this.getBuildOrUpgradeProgress() > 0.0f) {
            return true;
        }
        return super.isBuilding();
    }

    @Override
    public boolean isUpgrading() {
        if (!super.isBuilding() && this.market.getSize() < Misc.MAX_COLONY_SIZE) {
            return true;
        }
        return super.isUpgrading();
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        float patherLevel = 0.0f;
        for (Industry curr : market.getIndustries()) {
            patherLevel += this.getAICoreImpact(curr.getAICoreId());
        }
        String adminCoreId = market.getAdmin().getAICoreId();
        if (adminCoreId != null) {
            patherLevel += 10.0f * this.getAICoreImpact(adminCoreId);
        }
        ArrayList<String> targeted = new ArrayList<String>();
        targeted.add("techmining");
        targeted.add("heavyindustry");
        targeted.add("fuelprod");
        targeted.add("starfortress");
        for (String curr : targeted) {
            if (!market.hasIndustry(curr)) continue;
            patherLevel += 10.0f;
        }
        if (patherLevel > 0.0f) {
            incoming.add("luddic_path", patherLevel * 0.2f);
        }
    }

    private float getAICoreImpact(String coreId) {
        if ("alpha_core".equals(coreId)) {
            return 10.0f;
        }
        if ("beta_core".equals(coreId)) {
            return 4.0f;
        }
        if ("gamma_core".equals(coreId)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean canBeDisrupted() {
        return false;
    }

    public int getMaxIndustries() {
        return PopulationAndInfrastructure.getMaxIndustries(this.market.getSize());
    }

    public static int getMaxIndustries(int size) {
        if (MAX_IND == null) {
            try {
                MAX_IND = new int[10];
                JSONArray a = Global.getSettings().getJSONArray("maxIndustries");
                int i = 0;
                while (i < MAX_IND.length) {
                    PopulationAndInfrastructure.MAX_IND[i] = a.getInt(i);
                    ++i;
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        if (--size < 0) {
            size = 0;
        }
        if (size > 9) {
            size = 9;
        }
        return MAX_IND[size];
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStability().modifyFlat("PAI_improve", IMPROVE_STABILITY_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getStability().unmodifyFlat("PAI_improve");
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("\u7a33\u5b9a\u6027\u63d0\u9ad8 %s.", 0.0f, highlight, "" + (int)IMPROVE_STABILITY_BONUS);
        } else {
            info.addPara("\u7a33\u5b9a\u6027\u63d0\u9ad8 %s.", 0.0f, highlight, "" + (int)IMPROVE_STABILITY_BONUS);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    @Override
    public void setSpecialItem(SpecialItemData special) {
        super.setSpecialItem(special);
        if (!(this.addedHeatCondition == null || special != null && special.getId().equals("orbital_fusion_lamp"))) {
            this.market.removeCondition(this.addedHeatCondition);
            this.addedHeatCondition = null;
            if (this.removedHeatCondition != null) {
                this.market.addCondition(this.removedHeatCondition);
                this.removedHeatCondition = null;
            }
        }
        if (special != null && special.getId().equals("orbital_fusion_lamp")) {
            if (this.lamp == null) {
                SectorEntityToken focus = this.market.getPlanetEntity();
                if (focus == null) {
                    focus = this.market.getPrimaryEntity();
                }
                if (focus != null) {
                    BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
                    float radius = focus.getRadius() + 100.0f;
                    loc.orbit = Global.getFactory().createCircularOrbit(focus, (float)Math.random() * 360.0f, radius, radius / (10.0f + 10.0f * (float)Math.random()));
                    BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(this.market.getContainingLocation(), loc, "fusion_lamp", this.getMarket().getFactionId());
                    if (added != null) {
                        this.lamp = added.entity;
                        this.market.getContainingLocation().addScript(new LampRemover(this.lamp, this.market, this));
                    }
                }
            }
            if (!(this.addedHeatCondition != null || this.market.hasCondition("cold") || this.market.hasCondition("very_cold") || this.market.hasCondition("very_hot"))) {
                if (this.market.hasCondition("hot")) {
                    this.addedHeatCondition = "very_hot";
                    this.removedHeatCondition = "hot";
                } else {
                    this.addedHeatCondition = "hot";
                }
                if (this.removedHeatCondition != null) {
                    this.market.removeCondition(this.removedHeatCondition);
                }
                if (this.addedHeatCondition != null) {
                    this.market.addCondition(this.addedHeatCondition);
                }
            }
        }
    }

    @Override
    public boolean wantsToUseSpecialItem(SpecialItemData data) {
        if (this.special != null) {
            return false;
        }
        if ("orbital_fusion_lamp".equals(data.getId())) {
            for (String mc : ItemEffectsRepo.FUSION_LAMP_CONDITIONS) {
                if (!this.market.hasCondition(mc)) continue;
                return true;
            }
            return false;
        }
        return super.wantsToUseSpecialItem(data);
    }

    public static Pair<SectorEntityToken, Float> getNearestCoronalTap(Vector2f locInHyper, boolean usable) {
        SectorEntityToken nearest = null;
        float minDist = Float.MAX_VALUE;
        for (SectorEntityToken entity : Global.getSector().getCustomEntitiesWithTag("coronal_tap")) {
            if (usable && !entity.getMemoryWithoutUpdate().contains("$usable")) continue;
            float dist = Misc.getDistanceLY(locInHyper, entity.getLocationInHyperspace());
            if (dist > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS && (float)Math.round(dist * 10.0f) <= (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS * 10.0f) {
                dist = ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS;
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = entity;
        }
        if (nearest == null) {
            return null;
        }
        return new Pair<Object, Float>(nearest, Float.valueOf(minDist));
    }

    public static class CoronalTapFactor
    implements ColonyOtherFactorsListener {
        public boolean isActiveFactorFor(SectorEntityToken entity) {
            return PopulationAndInfrastructure.getNearestCoronalTap(entity.getLocationInHyperspace(), true) != null;
        }

        public void printOtherFactors(TooltipMakerAPI text, SectorEntityToken entity) {
            Pair<SectorEntityToken, Float> p = PopulationAndInfrastructure.getNearestCoronalTap(entity.getLocationInHyperspace(), true);
            if (p != null) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                String dStr = Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue());
                String lights = "\u5149\u5e74";
                if (dStr.equals("1")) {
                    lights = "\u5149\u5e74";
                }
                if (((Float)p.two).floatValue() > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS) {
                    text.addPara("\u6700\u8fd1\u7684\u661f\u5195\u5206\u6d41\u5668\u4f4d\u4e8e " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + "\uff0c\u8ddd\u6b64\u5730 %s " + lights + " \u4e4b\u5916\u3002" + "\u800c\u80fd\u4e0e\u4e4b\u76f8\u8fde\u7684\u6700\u5927\u8303\u56f4\u662f %s \u5149\u5e74\u3002", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), "" + ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS);
                } else {
                    text.addPara("\u6700\u8fd1\u7684\u661f\u5195\u5206\u6d41\u5668\u4f4d\u4e8e " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + "\uff0c\u8ddd\u6b64\u5730 %s " + lights + " \u4e4b\u5185\u3002" + "\u56e0\u6b64\u53ef\u4ee5\u8ba9\u4f4d\u4e8e\u6b64\u5730\u7684\u8d85\u5206\u6d41\u9600\u95e8\u4e0e\u4e4b\u76f8\u8fde\u3002", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()));
                }
            }
        }
    }

    protected static class LampRemover
    implements EveryFrameScript {
        protected SectorEntityToken lamp;
        protected MarketAPI market;
        protected PopulationAndInfrastructure industry;

        public LampRemover(SectorEntityToken lamp, MarketAPI market, PopulationAndInfrastructure industry) {
            this.lamp = lamp;
            this.market = market;
            this.industry = industry;
        }

        public void advance(float amount) {
            SpecialItemData item;
            Industry ind = this.market.getIndustry("population");
            SpecialItemData specialItemData = item = ind == null ? null : ind.getSpecialItem();
            if (item == null || !item.getId().equals("orbital_fusion_lamp")) {
                Misc.fadeAndExpire(this.lamp);
                this.industry.lamp = null;
                this.lamp = null;
            }
        }

        public boolean isDone() {
            return this.lamp == null;
        }

        public boolean runWhilePaused() {
            return false;
        }
    }
}

