/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.campaign.impl.items.ModSpecItemPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TechMining
extends BaseIndustry
implements MarketImmigrationModifier {
    public static final String TECH_MINING_MULT = "$core_techMiningMult";
    public static float ALPHA_CORE_FINDS_BONUS = 0.25f;
    public static float IMPROVE_FINDS_BONUS = 0.25f;

    public void apply() {
        super.apply(false);
        int size = this.market.getSize();
        int max = 0;
        if (this.market.hasCondition("ruins_vast")) {
            max = 4;
        } else if (this.market.hasCondition("ruins_extensive")) {
            max = 3;
        } else if (this.market.hasCondition("ruins_widespread")) {
            max = 2;
        } else if (this.market.hasCondition("ruins_scattered")) {
            max = 1;
        }
        size = Math.min(size, max);
        this.applyIncomeAndUpkeep(size);
        if (!this.isFunctional()) {
            this.supply.clear();
        }
        this.market.addTransientImmigrationModifier(this);
    }

    public void unapply() {
        this.market.removeTransientImmigrationModifier(this);
    }

    public boolean isAvailableToBuild() {
        if (!super.isAvailableToBuild()) {
            return false;
        }
        return this.market.hasCondition("ruins_vast") || this.market.hasCondition("ruins_extensive") || this.market.hasCondition("ruins_widespread") || this.market.hasCondition("ruins_scattered");
    }

    public String getUnavailableReason() {
        if (!super.isAvailableToBuild()) {
            return super.getUnavailableReason();
        }
        return "\u9700\u8981\u5e9f\u589f";
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("tritachyon", 10.0f);
    }

    public float getPatherInterest() {
        float base = 1.0f;
        if (this.market.hasCondition("ruins_vast")) {
            base = 8.0f;
        } else if (this.market.hasCondition("ruins_extensive")) {
            base = 6.0f;
        } else if (this.market.hasCondition("ruins_widespread")) {
            base = 4.0f;
        } else if (this.market.hasCondition("ruins_scattered")) {
            base = 2.0f;
        }
        return base + super.getPatherInterest();
    }

    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return true;
    }

    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        float opad = 10.0f;
        tooltip.addPara("\u9664\u4e86\u80fd\u91c7\u96c6\u5230\u57fa\u7840\u8d44\u6e90\u4e4b\u5916\uff0c\u8be5\u8bbe\u65bd\u8fd8\u6709\u673a\u4f1a\u627e\u5230\u84dd\u56fe\u53ca\u5176\u4ed6\u7a00\u6709\u7269\u54c1\u3002\u627e\u5230\u7684\u6240\u6709\u7269\u54c1\u5c06\u88ab\u8fd0\u9001\u5230\u6210\u54c1\u96c6\u6563\u5730\u3002", opad);
        boolean hasRuins = true;
        if (this.market.hasCondition("ruins_vast")) {
            tooltip.addPara("\u8fd9\u91cc\u5de8\u5927\u7684\u5e9f\u589f\u63d0\u4f9b\u4e86\u96be\u4ee5\u7f6e\u4fe1\u7684\u4ef7\u503c\u6f5c\u529b\u3002", opad);
        } else if (this.market.hasCondition("ruins_extensive")) {
            tooltip.addPara("\u8fd9\u91cc\u5927\u91cf\u7684\u5e9f\u589f\u5c06\u4e3a\u6709\u4ef7\u503c\u7684\u53d1\u73b0\u63d0\u4f9b\u4e86\u4e0d\u4fd7\u673a\u4f1a\u3002", opad);
        } else if (this.market.hasCondition("ruins_widespread")) {
            tooltip.addPara("\u5982\u679c\u65f6\u95f4\u5141\u8bb8\uff0c\u8fd9\u4e9b\u5927\u91cf\u7684\u5e9f\u589f\u5c06\u4e3a\u6709\u4ef7\u503c\u7684\u53d1\u73b0\u63d0\u4f9b\u53ef\u9760\u7684\u673a\u4f1a\u3002", opad);
        } else if (this.market.hasCondition("ruins_scattered")) {
            tooltip.addPara("\u8fd9\u91cc\u6563\u843d\u7684\u5e9f\u589f\u5c06\u4e3a\u6709\u4ef7\u503c\u7684\u53d1\u73b0\u63d0\u4f9b\u5fae\u5c0f\u7684\u673a\u4f1a\uff0c\u5c3d\u7ba1\u62e5\u6709\u8db3\u591f\u7684\u65f6\u95f4\uff0c\u4f46\u4eba\u4eec\u6c38\u8fdc\u4e0d\u4f1a\u77e5\u9053\u80fd\u627e\u5230\u4e9b\u4ec0\u4e48\u3002", opad);
        } else {
            hasRuins = false;
        }
        if (hasRuins) {
            float mult = this.getTechMiningMult();
            if (mult >= 0.9f) {
                tooltip.addPara("\u8fd9\u91cc\u7684\u5e9f\u589f\u57fa\u672c\u5904\u4e8e\u5c1a\u672a\u5f00\u53d1\u7684\u72b6\u6001\u3002", opad);
            } else if (mult >= 0.5f) {
                tooltip.addPara("\u8fd9\u91cc\u7684\u5e9f\u589f\u4ec5\u7ecf\u8fc7\u7b80\u5355\u7684\u68b3\u7406\uff0c\u800c\u90a3\u4e9b\u96be\u4ee5\u52d8\u63a2\u7684\u533a\u57df\u4f9d\u65e7\u5145\u6ee1\u4e86\u5e0c\u671b\u3002", opad);
            } else if (mult >= 0.25f) {
                tooltip.addPara("\u8fd9\u91cc\u7684\u5e9f\u589f\u5df2\u7ecf\u7ecf\u8fc7\u4e86\u4e00\u6b21\u5168\u9762\u68b3\u7406\uff0c\u4e0d\u8fc7\u4ecd\u6709\u673a\u4f1a\u83b7\u5f97\u4e00\u4e9b\u65b0\u7684\u53d1\u73b0\u3002", opad);
            } else {
                tooltip.addPara("\u7531\u4e8e\u8fd9\u91cc\u7684\u5e9f\u589f\u5df2\u7ecf\u8fdb\u884c\u8fc7\u591a\u6b21\u5168\u9762\u68b3\u7406\uff0c\u6240\u4ee5\u7ee7\u7eed\u8fdb\u884c\u52d8\u63a2\u5df2\u7ecf\u6ca1\u6709\u591a\u5927\u610f\u4e49\u3002", opad);
            }
        }
    }

    protected float getEffectivenessMult() {
        float mult = this.market.getStats().getDynamic().getStat("tech_mining_mult").getModifiedValue();
        return mult;
    }

    public float getTechMiningMult() {
        MemoryAPI mem = this.market.getMemoryWithoutUpdate();
        if (mem.contains(TECH_MINING_MULT)) {
            return mem.getFloat(TECH_MINING_MULT);
        }
        mem.set(TECH_MINING_MULT, Float.valueOf(1.0f));
        return 1.0f;
    }

    public void setTechMiningMult(float value) {
        MemoryAPI mem = this.market.getMemoryWithoutUpdate();
        mem.set(TECH_MINING_MULT, Float.valueOf(value));
    }

    public float getTechMiningRuinSizeModifier() {
        return TechMining.getTechMiningRuinSizeModifier(this.market);
    }

    public static float getTechMiningRuinSizeModifier(MarketAPI market) {
        float mod = 0.0f;
        if (market.hasCondition("ruins_vast")) {
            mod = 1.0f;
        } else if (market.hasCondition("ruins_extensive")) {
            mod = 0.6f;
        } else if (market.hasCondition("ruins_widespread")) {
            mod = 0.35f;
        } else if (market.hasCondition("ruins_scattered")) {
            mod = 0.2f;
        }
        return mod;
    }

    public CargoAPI generateCargoForGatheringPoint(Random random) {
        if (!this.isFunctional()) {
            return null;
        }
        float mult = this.getTechMiningMult();
        float decay = Global.getSettings().getFloat("techMiningDecay");
        float base = this.getTechMiningRuinSizeModifier();
        this.setTechMiningMult(mult * decay);
        base *= this.getEffectivenessMult();
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        ArrayList<SalvageEntityGenDataSpec.DropData> dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "blueprints_low";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "rare_tech_low";
        d.valueMult = 0.1f;
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "ai_cores3";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "any_hullmod_low";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 5;
        d.group = "weapons2";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.group = "basic";
        d.value = 10000;
        dropValue.add(d);
        if (mult >= 1.0f) {
            float num = base * (5.0f + random.nextFloat() * 2.0f);
            if (num < 1.0f) {
                num = 1.0f;
            }
            d = new SalvageEntityGenDataSpec.DropData();
            d.chances = Math.round(num);
            d.group = "techmining_first_find";
            dropRandom.add(d);
        }
        CargoAPI result = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, base * mult, 1.0f, dropValue, dropRandom);
        FactionAPI pf = Global.getSector().getPlayerFaction();
        block0: for (CargoStackAPI stack : result.getStacksCopy()) {
            ModSpecItemPlugin mod;
            if (stack.getPlugin() instanceof BlueprintProviderItem) {
                BlueprintProviderItem bp = (BlueprintProviderItem)((Object)stack.getPlugin());
                List<String> list = bp.getProvidedShips();
                if (list != null) {
                    for (String id : list) {
                        if (!pf.knowsShip(id)) continue block0;
                    }
                }
                if ((list = bp.getProvidedWeapons()) != null) {
                    for (String id : list) {
                        if (!pf.knowsWeapon(id)) continue block0;
                    }
                }
                if ((list = bp.getProvidedFighters()) != null) {
                    for (String id : list) {
                        if (!pf.knowsFighter(id)) continue block0;
                    }
                }
                if ((list = bp.getProvidedIndustries()) != null) {
                    for (String id : list) {
                        if (!pf.knowsIndustry(id)) continue block0;
                    }
                }
                result.removeStack(stack);
                continue;
            }
            if (!(stack.getPlugin() instanceof ModSpecItemPlugin) || !pf.knowsHullMod((mod = (ModSpecItemPlugin)stack.getPlugin()).getModId())) continue;
            result.removeStack(stack);
        }
        return result;
    }

    protected void applyAlphaCoreModifiers() {
        this.market.getStats().getDynamic().getStat("tech_mining_mult").modifyMult(this.getModId(0), 1.0f + ALPHA_CORE_FINDS_BONUS);
    }

    protected void applyNoAICoreModifiers() {
        this.market.getStats().getDynamic().getStat("tech_mining_mult").unmodifyMult(this.getModId(0));
    }

    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "\u963f\u5c14\u6cd5\u6838\u5fc3");
    }

    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "\u76ee\u524d\u5df2\u88ab\u5206\u914d\u7684 \u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "\u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        }
        float a = ALPHA_CORE_FINDS_BONUS;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u63d0\u9ad8\u53d1\u6398\u7269\u6570\u91cf %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u63d0\u9ad8\u53d1\u6398\u7269\u6570\u91cf %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
    }

    public boolean canImprove() {
        return true;
    }

    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStats().getDynamic().getStat("tech_mining_mult").modifyMult(this.getModId(1), 1.0f + IMPROVE_FINDS_BONUS);
        } else {
            this.market.getStats().getDynamic().getStat("tech_mining_mult").unmodifyMult(this.getModId(1));
        }
    }

    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_FINDS_BONUS;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("\u53d1\u6398\u7269\u63d0\u9ad8 %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("\u63d0\u9ad8\u53d1\u6398\u7269\u6570\u91cf %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

