/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class TradeCenter
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float BASE_BONUS = 25.0f;
    public static float ALPHA_CORE_BONUS = 25.0f;
    public static float IMPROVE_BONUS = 25.0f;
    public static float STABILITY_PELANTY = 3.0f;
    protected transient SubmarketAPI saved = null;

    public void apply() {
        super.apply(true);
        if (this.isFunctional() && this.market.isPlayerOwned()) {
            SubmarketAPI open = this.market.getSubmarket("open_market");
            if (open == null) {
                if (this.saved != null) {
                    this.market.addSubmarket(this.saved);
                } else {
                    this.market.addSubmarket("open_market");
                    SubmarketAPI sub = this.market.getSubmarket("open_market");
                    sub.setFaction(Global.getSector().getFaction("independent"));
                    Global.getSector().getEconomy().forceStockpileUpdate(this.market);
                }
            }
        } else if (this.market.isPlayerOwned()) {
            this.market.removeSubmarket("open_market");
        }
        this.market.getStability().modifyFlat(this.getModId(), -STABILITY_PELANTY, this.getNameForModifier());
        this.market.getIncomeMult().modifyPercent(this.getModId(0), BASE_BONUS, this.getNameForModifier());
        if (!this.isFunctional()) {
            this.unapply();
        }
    }

    public void unapply() {
        super.unapply();
        if (this.market.isPlayerOwned()) {
            SubmarketAPI open;
            this.saved = open = this.market.getSubmarket("open_market");
            this.market.removeSubmarket("open_market");
        }
        this.market.getStability().unmodifyFlat(this.getModId());
        this.market.getIncomeMult().unmodifyPercent(this.getModId(0));
    }

    protected void addStabilityPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        float a = BASE_BONUS;
        String aStr = "+" + Math.round(a * 1.0f) + "%";
        tooltip.addPara("\u6b96\u6c11\u5730\u6536\u5165\uff1a%s", opad, h, aStr);
        h = Misc.getNegativeHighlightColor();
        tooltip.addPara("\u7a33\u5b9a\u6027\u60e9\u7f5a\uff1a%s", opad, h, "" + -((int)STABILITY_PELANTY));
    }

    protected void addRightAfterDescriptionSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
        if (this.market.isPlayerOwned() || this.currTooltipMode == Industry.IndustryTooltipMode.ADD_INDUSTRY) {
            tooltip.addPara("\u65b0\u589e\u4e00\u4e2a\u72ec\u7acb\u7684 '\u5f00\u653e\u5e02\u573a' \u8ba9\u6b96\u6c11\u5730\u7684\u6240\u6709\u8005\u80fd\u5728\u6b64\u8fdb\u884c\u4ea4\u6613\u3002\u8fd8\u80fd\u6839\u636e\u654c\u5bf9\u6d3b\u52a8\u7684\u7a0b\u5ea6\u53d1\u5e03\u4e00\u4e9b\u4f4e\u6c34\u5e73\u534a\u6c38\u4e45\u6027\u8d4f\u91d1\u3002", 10.0f);
        }
    }

    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            this.addStabilityPostDemandSection(tooltip, hasDemand, mode);
        }
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("tritachyon", 10.0f);
    }

    public boolean isAvailableToBuild() {
        return this.market.hasSpaceport();
    }

    public String getUnavailableReason() {
        return "\u9700\u8981\u592a\u7a7a\u6e2f";
    }

    public String getCurrentImage() {
        float size = this.market.getSize();
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "commerce_low");
        }
        if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "commerce_high");
        }
        return super.getCurrentImage();
    }

    protected void applyAlphaCoreModifiers() {
        this.market.getIncomeMult().modifyPercent(this.getModId(1), ALPHA_CORE_BONUS, "\u963f\u5c14\u6cd5\u6838\u5fc3 (" + this.getNameForModifier() + ")");
    }

    protected void applyNoAICoreModifiers() {
        this.market.getIncomeMult().unmodifyPercent(this.getModId(1));
    }

    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "\u963f\u5c14\u6cd5\u6838\u5fc3");
    }

    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "\u76ee\u524d\u5df2\u88ab\u5206\u914d\u7684 \u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "\u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        }
        float a = ALPHA_CORE_BONUS;
        String str = Math.round(a) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u6b96\u6c11\u5730\u6536\u5165\u63d0\u9ad8 %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u6b96\u6c11\u5730\u6536\u5165\u63d0\u9ad8 %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    public boolean canImprove() {
        return true;
    }

    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getIncomeMult().modifyPercent(this.getModId(2), IMPROVE_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getIncomeMult().unmodifyPercent(this.getModId(2));
        }
    }

    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_BONUS;
        String aStr = Math.round(a * 1.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("\u6b96\u6c11\u5730\u6536\u5165\u63d0\u9ad8 %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("\u6b96\u6c11\u5730\u6536\u5165\u63d0\u9ad8 %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

