/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.submarkets.LocalResourcesSubmarketPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Waystation
extends BaseIndustry {
    public static float UPKEEP_MULT_PER_DEFICIT = 0.1f;
    public static float BASE_ACCESSIBILITY = 0.1f;
    public static float IMPROVE_ACCESSIBILITY = 0.2f;
    public static float ALPHA_CORE_ACCESSIBILITY = 0.2f;

    @Override
    public void apply() {
        HyperspaceTopographyEventIntel intel;
        SubmarketPlugin sub;
        super.apply(true);
        int size = this.market.getSize();
        this.demand("fuel", size);
        this.demand("supplies", size);
        this.demand("crew", size);
        this.demand("volatiles", 1);
        this.demand("rare_metals", 1);
        String desc = this.getNameForModifier();
        this.market.setHasWaystation(true);
        float a = BASE_ACCESSIBILITY;
        if (a > 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(0), a, desc);
        }
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            float mult = Global.getSettings().getFloat("stockpileMultExcess");
            lr.getStockpilingBonus("fuel").modifyFlat(this.getModId(0), (float)size * mult);
            lr.getStockpilingBonus("supplies").modifyFlat(this.getModId(0), (float)size * mult);
            lr.getStockpilingBonus("crew").modifyFlat(this.getModId(0), (float)size * mult);
            lr.getStockpilingBonus("volatiles").modifyFlat(this.getModId(0), 1.0f * mult);
            lr.getStockpilingBonus("rare_metals").modifyFlat(this.getModId(0), 1.0f * mult);
        }
        if ((intel = HyperspaceTopographyEventIntel.get()) != null && intel.isStageActive((Object)HyperspaceTopographyEventIntel.Stage.SLIPSTREAM_DETECTION)) {
            this.market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod").modifyFlat(this.getModId(0), HyperspaceTopographyEventIntel.WAYSTATION_BONUS, this.getNameForModifier());
        }
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
        }
    }

    @Override
    public void unapply() {
        SubmarketPlugin sub;
        super.unapply();
        this.market.setHasWaystation(false);
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(0));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(1));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(2));
        this.market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod").unmodifyFlat(this.getModId(0));
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            lr.getStockpilingBonus("fuel").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("supplies").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("crew").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("volatiles").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("rare_metals").unmodifyFlat(this.getModId(0));
        }
    }

    protected float getUpkeepPenalty(Pair<String, Integer> deficit) {
        float loss = (float)((Integer)deficit.two).intValue() * UPKEEP_MULT_PER_DEFICIT;
        if (loss < 0.0f) {
            loss = 0.0f;
        }
        return loss;
    }

    protected Pair<String, Integer> getUpkeepAffectingDeficit() {
        return this.getMaxDeficit("fuel", "supplies", "crew");
    }

    @Override
    protected void addPostDescriptionSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
        if (!this.market.isPlayerOwned()) {
            return;
        }
        float opad = 10.0f;
        tooltip.addPara("\u5982\u679c\u6b96\u6c11\u5730\u80fd\u8fdb\u884c\u6ed1\u6d41\u63a2\u6d4b\uff0c\u53ef\u5c06\u63a2\u6d4b\u8303\u56f4\u63d0\u9ad8 %s}\u3002", opad, Misc.getHighlightColor(), "" + (int)HyperspaceTopographyEventIntel.WAYSTATION_BONUS);
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            MutableStat fake = new MutableStat(0.0f);
            String desc = this.getNameForModifier();
            float a = BASE_ACCESSIBILITY;
            if (a > 0.0f) {
                fake.modifyFlat(this.getModId(0), a, desc);
            }
            float total = a;
            String totalStr = "+" + Math.round(total * 100.0f) + "%";
            Color h = Misc.getHighlightColor();
            if (total < 0.0f) {
                h = Misc.getNegativeHighlightColor();
                totalStr = Math.round(total * 100.0f) + "%";
            }
            float opad = 10.0f;
            float pad = 3.0f;
            if (total >= 0.0f) {
                tooltip.addPara("\u6d41\u901a\u6027\u589e\u76ca\uff1a%s", opad, h, totalStr);
            } else {
                tooltip.addPara("\u6d41\u901a\u6027\u60e9\u7f5a\uff1a%s", opad, h, totalStr);
            }
            tooltip.addPara("\u5728\u6ee1\u8db3\u9700\u6c42\u7684\u524d\u63d0\u4e0b\u4e3a\u6b96\u6c11\u5730\u50a8\u5907\u71c3\u6599\u3001\u8865\u7ed9\u548c\u8239\u5458\uff0c\u5373\u4fbf\u5f53\u5730\u6ca1\u6709\u76f8\u5e94\u8d44\u6e90\u7684\u4ea7\u51fa\u3002\u5176\u50a8\u5907\u80fd\u529b\u6bd4\u5f53\u5730\u4ea7\u4e1a\u8bbe\u65bd\u66f4\u9ad8\u3002", opad);
        }
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        SubmarketPlugin sub;
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            float bonus = (float)this.market.getSize() * Global.getSettings().getFloat("stockpileMultExcess");
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            lr.getStockpilingBonus("fuel").modifyFlat(this.getModId(1), bonus);
            lr.getStockpilingBonus("supplies").modifyFlat(this.getModId(1), bonus);
            lr.getStockpilingBonus("crew").modifyFlat(this.getModId(1), bonus);
        }
    }

    @Override
    protected void applyNoAICoreModifiers() {
        SubmarketPlugin sub;
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            lr.getStockpilingBonus("fuel").unmodifyFlat(this.getModId(1));
            lr.getStockpilingBonus("supplies").unmodifyFlat(this.getModId(1));
            lr.getStockpilingBonus("crew").unmodifyFlat(this.getModId(1));
        }
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "\u963f\u5c14\u6cd5\u6838\u5fc3");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "\u76ee\u524d\u5df2\u88ab\u5206\u914d\u7684 \u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "\u963f\u5c14\u6cd5\u7ea7 AI \u6838\u5fc3\u3002";
        }
        float a = ALPHA_CORE_ACCESSIBILITY;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u5927\u5e45\u5ea6\u63d0\u9ad8\u5e93\u5b58\u91cf", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "\u7ef4\u62a4\u6210\u672c\u964d\u4f4e %s}\u3002\u9700\u6c42\u964d\u4f4e %s \u5355\u4f4d\u3002" + "\u5927\u5e45\u5ea6\u63d0\u9ad8\u5e93\u5b58\u91cf", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
    }

    @Override
    public boolean isAvailableToBuild() {
        return this.market.hasSpaceport();
    }

    @Override
    public String getUnavailableReason() {
        return "\u9700\u8981\u592a\u7a7a\u6e2f";
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(3), IMPROVE_ACCESSIBILITY, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getAccessibilityMod().unmodifyFlat(this.getModId(3));
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_ACCESSIBILITY;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("\u6d41\u901a\u6027\u63d0\u9ad8\u4e86 %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("\u6d41\u901a\u6027\u63d0\u9ad8 %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

