/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalNoEPEC;
import com.fs.starfarer.api.impl.campaign.enc.EPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceAbyssPluginImpl;

public class AbyssalFrequencies {
    public static float NO_ABYSS_ENCOUNTER_MULT = 10.0f;
    public static float LIGHT_FREQ = 10.0f;
    public static float ROGUE_REGULAR_FREQ = 5.0f;
    public static float ROGUE_HINTS_FREQ = 5.0f;

    public static float getNoAbyssalEncounterFrequency(EncounterManager manager, EncounterPoint point) {
        if (!HyperspaceAbyssPluginImpl.EP_TYPE_ABYSSAL.equals(point.type)) {
            return 0.0f;
        }
        float total = 0.0f;
        for (EPEncounterCreator c : EncounterManager.CREATORS) {
            if (c instanceof AbyssalNoEPEC) continue;
            float f = c.getFrequencyForPoint(manager, point);
            total += f;
        }
        return Math.min(10000.0f, Math.max(100.0f, total *= NO_ABYSS_ENCOUNTER_MULT));
    }

    public static boolean isPointSuited(EncounterPoint point, boolean allowNearStar, float depthRequired) {
        if (!HyperspaceAbyssPluginImpl.EP_TYPE_ABYSSAL.equals(point.type)) {
            return false;
        }
        HyperspaceAbyssPluginImpl.AbyssalEPData data = (HyperspaceAbyssPluginImpl.AbyssalEPData)point.custom;
        if (data.depth < depthRequired) {
            return false;
        }
        return allowNearStar || data.nearest == null;
    }

    public static float getAbyssalLightFrequency(EncounterManager manager, EncounterPoint point) {
        if (!AbyssalFrequencies.isPointSuited(point, false, HyperspaceAbyssPluginImpl.DEPTH_THRESHOLD_FOR_ABYSSAL_LIGHT)) {
            return 0.0f;
        }
        return LIGHT_FREQ;
    }

    public static float getAbyssalRogueStellarObjectFrequency(EncounterManager manager, EncounterPoint point) {
        if (!AbyssalFrequencies.isPointSuited(point, false, HyperspaceAbyssPluginImpl.DEPTH_THRESHOLD_FOR_ABYSSAL_STELLAR_OBJECT)) {
            return 0.0f;
        }
        return ROGUE_REGULAR_FREQ;
    }

    public static float getAbyssalRogueStellarObjectDireHintsFrequency(EncounterManager manager, EncounterPoint point) {
        if (!AbyssalFrequencies.isPointSuited(point, false, HyperspaceAbyssPluginImpl.DEPTH_THRESHOLD_FOR_ABYSSAL_STELLAR_OBJECT)) {
            return 0.0f;
        }
        if (DebugFlags.ABYSSAL_GHOST_SHIPS_DEBUG) {
            return 1.0E9f;
        }
        return ROGUE_HINTS_FREQ;
    }
}

