/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamLuddicPathEPEC
extends BaseEPEncounterCreator {
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        CampaignFleetAPI fleet;
        Random random = manager.getRandom();
        LuddicPathBaseIntel intel = SlipstreamLuddicPathEPEC.getClosestLuddicPathBase(point.getLocInHyper());
        float f = SlipstreamLuddicPathEPEC.getProximityFactor(point.getLocInHyper());
        int difficulty = 0;
        difficulty += Math.round(f * 3.0f);
        if (intel != null) {
            difficulty = intel.isLarge() ? (difficulty += 4) : (difficulty += 2);
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = point.getLocInHyper();
        m.createStandardFleet(difficulty += random.nextInt(4), "luddic_path", loc);
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        m.triggerFleetAllowLongPursuit();
        if (intel != null && intel.getMarket() != null) {
            m.triggerSetFleetMemoryValue("$sourceMarket", intel.getMarket().getId());
        }
        if ((fleet = m.createFleet()) != null) {
            point.where.addEntity(fleet);
            fleet.setLocation(point.loc.x, point.loc.y);
            Vector2f spawnLoc = Misc.getPointWithinRadius(point.loc, 1000.0f);
            SectorEntityToken e = point.where.createToken(spawnLoc);
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 30.0f * random.nextFloat(), "\u57cb\u4f0f\u4e2d");
            fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
            fleet.addScript(new MissionFleetAutoDespawn(null, fleet));
        }
    }

    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        if (!EncounterManager.EP_TYPE_SLIPSTREAM.equals(point.type)) {
            return 0.0f;
        }
        LuddicPathBaseIntel intel = SlipstreamLuddicPathEPEC.getClosestLuddicPathBase(point.getLocInHyper());
        float f = SlipstreamLuddicPathEPEC.getProximityFactor(point.getLocInHyper());
        if (intel != null && f > 0.0f) {
            f = 0.25f + 0.75f * f;
            f = intel.isLarge() ? (f *= 5.0f) : (f *= 3.0f);
        }
        return 10.0f * f;
    }

    public static float getProximityFactor(Vector2f locInHyper) {
        LuddicPathBaseIntel intel = SlipstreamLuddicPathEPEC.getClosestLuddicPathBase(locInHyper);
        float f = SlipstreamLuddicPathEPEC.getLuddicPathBaseProximityFactor(intel, locInHyper);
        return f;
    }
}

