/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuelTutorialPanel
extends BaseCustomUIPanelPlugin {
    protected InteractionDialogAPI dialog;
    protected CustomVisualDialogDelegate.DialogCallbacks callbacks;
    protected CustomPanelAPI panel;
    protected PositionAPI p;
    protected TutStage curr = null;
    protected TooltipMakerAPI info;
    protected float untilNext = 0.0f;
    protected boolean triggeredNext = false;
    protected FaderUtil flash = new FaderUtil(0.0f, 0.125f, 0.5f, false, true);

    public void init(CustomPanelAPI panel, CustomVisualDialogDelegate.DialogCallbacks callbacks, InteractionDialogAPI dialog) {
        this.panel = panel;
        this.callbacks = callbacks;
        this.dialog = dialog;
        this.curr = TutStage.INIT;
        this.showNext();
    }

    public void showNext() {
        if (this.curr == TutStage.LEAVE) {
            return;
        }
        this.curr = this.curr.next();
        if (this.info != null) {
            this.panel.removeComponent(this.info);
        }
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        this.info = this.panel.createUIElement(this.p.getWidth() - 20.0f, 1000.0f, false);
        this.info.setParaInsigniaLarge();
        if (this.curr == TutStage.MOVE_FORWARD) {
            this.info.addPara("\u6309 \u53f3\u65b9\u5411\u952e \u524d\u8fdb\u3002", 0.0f, h, "\u53f3\u65b9\u5411\u952e");
        } else if (this.curr == TutStage.MOVE_BACK) {
            this.info.addPara("\u6309 \u5de6\u65b9\u5411\u952e \u540e\u9000\u3002", 0.0f, h, "\u5de6\u65b9\u5411\u952e");
        } else if (this.curr == TutStage.ATTACK) {
            this.info.addPara("\u6309 \u7a7a\u683c\u952e \u653b\u51fb\u3002", 0.0f, h, "\u7a7a\u683c\u952e");
        } else if (this.curr == TutStage.BLOCK) {
            LabelAPI label = this.info.addPara("\u6309 \u4e0a\u65b9\u5411\u952e \u6765\u683c\u6321\u6216\u62db\u67b6\u3002\u4e00\u540d \u719f\u7ec3\u7684\u6218\u58eb \u4e5f\u53ef\u5229\u7528\u5b83\u6765\u5feb\u901f\u653b\u51fb\uff0c\u5373\u5728\u62b5\u6321\u5bf9\u624b\u653b\u51fb\u540e\u7684\u77ac\u95f4\u7acb\u523b\u8fdb\u884c \"\u53cd\u51fb\".", 0.0f, h, "\u4e0a\u65b9\u5411\u952e");
            label.setHighlightColors(h, Misc.getStoryOptionColor());
            label.setHighlight("\u4e0a\u65b9\u5411\u952e", "\u719f\u7ec3\u7684\u6218\u58eb");
        } else if (this.curr == TutStage.LEAVE) {
            this.info.addPara("\u5c4f\u5e55\u5de6\u4e0a\u89d2\u663e\u793a\u7684\u662f\u60a8\u7684\u751f\u547d\u503c\u3002\n\n\u5148\u8bd5\u7740\u79fb\u52a8\u51e0\u4e0b\uff0c\u7136\u540e\u6309 ESC \u952e\u7ee7\u7eed\u3002", 0.0f, h, "ESCAPE");
        }
        this.panel.addUIElement(this.info).inTL(opad, opad);
        this.flash.fadeIn();
    }

    public void reportAction(String actionId) {
        boolean triggered = false;
        triggered |= this.curr == TutStage.MOVE_FORWARD && "MOVE_FORWARD".equals(actionId);
        triggered |= this.curr == TutStage.MOVE_BACK && "MOVE_BACK".equals(actionId);
        triggered |= this.curr == TutStage.ATTACK && "ATTACK".equals(actionId);
        if (triggered |= this.curr == TutStage.BLOCK && "BLOCK".equals(actionId)) {
            this.triggeredNext = true;
            this.untilNext = 1.0f;
        }
    }

    public CustomPanelAPI getPanel() {
        return this.panel;
    }

    public PositionAPI getPosition() {
        return this.p;
    }

    @Override
    public void positionChanged(PositionAPI position) {
        this.p = position;
    }

    @Override
    public void render(float alphaMult) {
    }

    @Override
    public void renderBelow(float alphaMult) {
        if (this.p == null) {
            return;
        }
        float x = this.p.getX();
        float y = this.p.getY();
        float cx = this.p.getCenterX();
        float cy = this.p.getCenterY();
        float w = this.p.getWidth();
        float h = this.p.getHeight();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color c = Misc.getBasePlayerColor();
        float a = alphaMult;
        Misc.renderQuad(x, y, w, 1.0f, c, a);
        Misc.renderQuad(x, y + h - 1.0f, w, 1.0f, c, a);
        Misc.renderQuad(x, y + 1.0f, 1.0f, h - 2.0f, c, a);
        Misc.renderQuad(x + w - 1.0f, y + 1.0f, 1.0f, h - 2.0f, c, a);
        Misc.renderQuad(x + w, y - 1.0f, 1.0f, h, Color.black, a);
        Misc.renderQuad(x + 1.0f, y - 1.0f, w - 1.0f, 1.0f, Color.black, a);
        Misc.renderQuad(x + 1.0f, y + 1.0f, w - 2.0f, h - 2.0f, Color.black, a * 0.67f);
        GL11.glBlendFunc((int)770, (int)1);
        Misc.renderQuad(x + 1.0f, y + 1.0f, w - 2.0f, h - 2.0f, Misc.getBrightPlayerColor(), a * 0.25f * this.flash.getBrightness());
    }

    @Override
    public void advance(float amount) {
        if (this.p == null) {
            return;
        }
        if (this.triggeredNext) {
            this.untilNext -= amount;
            if (this.untilNext <= 0.0f) {
                this.triggeredNext = false;
                this.showNext();
            }
        }
        this.flash.advance(amount);
    }

    @Override
    public void processInput(List<InputEventAPI> events) {
        if (this.p == null) {
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TutStage {
        INIT,
        MOVE_FORWARD,
        MOVE_BACK,
        ATTACK,
        BLOCK,
        LEAVE;

        private static TutStage[] vals;

        static {
            vals = TutStage.values();
        }

        public TutStage next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }
    }
}

