/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.eventide.BaseDuelBackground;
import com.fs.starfarer.api.impl.campaign.eventide.DuelPanel;
import com.fs.starfarer.api.ui.PositionAPI;

public class EventideDuelBackground
extends BaseDuelBackground {
    protected SpriteAPI bg = this.loadTex("graphics/misc/eventide_bg.jpg");
    protected SpriteAPI column = this.loadTex("graphics/misc/column.png");
    protected SpriteAPI platform = this.loadTex("graphics/misc/fight_platform.png");
    protected SpriteAPI tower = this.loadTex("graphics/misc/midground_tower1.png");
    protected SpriteAPI conduits = this.loadTex("graphics/misc/under_conduits.png");
    protected SpriteAPI foreground_side = this.loadTex("graphics/misc/foreground_side.png");

    public void advance(float amount) {
    }

    public void render(DuelPanel panel, float xOffset, float yOffset, float alphaMult) {
        PositionAPI p = panel.getPosition();
        float x = p.getX();
        float y = p.getY();
        float w = p.getWidth();
        this.bg.render(x, y);
        float columnXOffset = xOffset * 0.5f;
        float columnYOffset = yOffset * 0.5f;
        float towerXOffset = xOffset * 0.25f;
        float towerYOffset = yOffset * 0.25f;
        float platformY = panel.getFloorLevel() - this.platform.getHeight() + 40.0f + yOffset;
        float columnY = platformY + 92.0f + columnYOffset;
        float columnSpacing = this.column.getWidth() - 60.0f;
        float columnX = x + columnXOffset - 375.0f;
        this.tower.render(x + w - this.tower.getWidth() + towerXOffset, y + towerYOffset);
        this.column.render(columnX + columnSpacing * 3.0f, columnY);
        this.column.render(columnX + columnSpacing * 2.0f, columnY);
        this.column.render(columnX + columnSpacing, columnY);
        this.column.render(columnX, columnY);
        this.conduits.setWidth(this.getStageWidth());
        this.conduits.render(p.getX() - (this.getStageWidth() - p.getWidth()) / 2.0f + xOffset, platformY - this.conduits.getHeight() + 130.0f);
        this.platform.setWidth(this.getStageWidth());
        this.platform.render(p.getX() - (this.getStageWidth() - p.getWidth()) / 2.0f + xOffset, platformY);
    }

    public void renderForeground(DuelPanel panel, float xOffset, float yOffset, float alphaMult) {
        PositionAPI p = panel.getPosition();
        float x = p.getX();
        float y = p.getY();
        this.foreground_side.render(this.getStageWidth() - this.foreground_side.getWidth() + xOffset, y);
    }

    public float getStageWidth() {
        return 2048.0f;
    }
}

