/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.events.EventProbabilityAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.PriceUpdate;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoodShortageEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(FoodShortageEvent.class);
    public static String PRICE_MOD_ID = "fse_priceMod";
    public static float FOOD_PRICE_MULT = 1.5f;
    public static float FOOD_PRICE_FLAT = 50.0f;
    public static float MAX_POSSIBLE_DURATION = 60.0f;
    public static float MIN_FRACTION_FOR_PLAYER_ENDING_EVENT = 0.5f;
    private boolean ended = false;
    private float maxDurationDays;
    private float daysBeforeReliefCheck;
    private float daysBeforeReliefSend;
    private float elapsedDays = 0.0f;
    private int stage = 0;
    private float preEventFoodLevel;
    private float baseFoodToMeetShortage = 0.0f;
    private float netDeliveredByPlayerBlack = 0.0f;
    private float netDeliveredByPlayerOther = 0.0f;
    private float originalReliefFleetPoints = 0.0f;
    private CampaignFleetAPI reliefFleet;
    private MessagePriority messagePriority = MessagePriority.CLUSTER;
    private String foodShortageConditionToken = null;
    private MarketAPI reliefMarket;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
    }

    @Override
    public void startEvent() {
        SubmarketAPI black;
        super.startEvent(true);
        if (this.market == null) {
            return;
        }
        switch (this.market.getSize()) {
            case 1: 
            case 2: 
            case 3: {
                this.messagePriority = MessagePriority.SYSTEM;
                break;
            }
            case 4: 
            case 5: {
                this.messagePriority = MessagePriority.CLUSTER;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.messagePriority = MessagePriority.SECTOR;
            }
        }
        this.baseFoodToMeetShortage = this.getBaseShortageAmount();
        this.maxDurationDays = 20.0f + (float)Math.random() * 20.0f;
        this.daysBeforeReliefCheck = 7.0f + (float)Math.random() * 7.0f;
        this.daysBeforeReliefSend = this.daysBeforeReliefCheck + (float)Math.random() * 7.0f;
        this.foodShortageConditionToken = this.market.addCondition("event_food_shortage", this);
        CommodityOnMarketAPI com = this.market.getCommodityData("food");
        this.preEventFoodLevel = com.getStockpile();
        com.setStockpile(com.getStockpile() * this.getStockpileMult());
        com.getPlayerSupplyPriceMod().modifyMult(PRICE_MOD_ID, FOOD_PRICE_MULT);
        com.getPlayerSupplyPriceMod().modifyFlat(PRICE_MOD_ID, FOOD_PRICE_FLAT);
        SubmarketAPI open = this.market.getSubmarket("open_market");
        if (open != null) {
            float food = open.getCargo().getQuantity(CargoAPI.CargoItemType.RESOURCES, "food");
            open.getCargo().removeItems(CargoAPI.CargoItemType.RESOURCES, "food", food);
        }
        if ((black = this.market.getSubmarket("black_market")) != null) {
            black.getPlugin().updateCargoPrePlayerInteraction();
            black.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, "food", (int)Math.max(1.0f, this.baseFoodToMeetShortage * (0.1f + (float)Math.random() * 0.05f)));
        }
        Global.getSector().reportEventStage(this, "start", this.messagePriority);
        log.info((Object)(String.valueOf(this.getLoggingId()) + " \u98df\u54c1\u77ed\u7f3a" + "\uff0c\u9700\u8981\u98df\u54c1\uff1a" + (int)this.baseFoodToMeetShortage + "\uff0c\u5e93\u5b58\u91cf\u8f83\u591a\uff1a" + this.getStockpileMult() + "\uff0c\u6700\u5927\u6301\u7eed\u65f6\u95f4\uff1a" + (int)this.maxDurationDays + " \u5929"));
    }

    private float getBaseShortageAmount() {
        float stockpileMult = this.getStockpileMult();
        CommodityOnMarketAPI com = this.market.getCommodityData("food");
        float amount = com.getStockpile() * (1.0f - stockpileMult);
        if (amount < 50.0f) {
            amount = 50.0f;
        }
        return Misc.getRounded(amount);
    }

    private float getStockpileMult() {
        switch (this.market.getSize()) {
            case 0: 
            case 1: {
                return 0.0f;
            }
            case 2: 
            case 3: {
                return 0.2f;
            }
            case 4: 
            case 5: {
                return 0.3f;
            }
            case 6: 
            case 7: {
                return 0.5f;
            }
            case 8: 
            case 9: {
                return 0.9f;
            }
        }
        return 1.0f;
    }

    public float getStabilityImpact() {
        switch (this.market.getSize()) {
            case 0: 
            case 1: {
                return 4.0f;
            }
            case 2: 
            case 3: {
                return 3.0f;
            }
            case 4: 
            case 5: {
                return 2.0f;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    public float getReliefAbortUnrest() {
        return 2.0f;
    }

    public float getAddedExpiredUnrest() {
        return 1.0f;
    }

    public float getReducedEndedUnrest() {
        return 1.0f;
    }

    public float getEndBlackUnrest() {
        float base = this.getStabilityImpact();
        float mult = Math.min(1.0f, this.netDeliveredByPlayerBlack / this.baseFoodToMeetShortage);
        return Math.round(base * mult);
    }

    @Override
    public void advance(float amount) {
        float currPoints;
        if (Global.getSector().isPaused()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        this.elapsedDays += days;
        if (this.elapsedDays > this.daysBeforeReliefCheck && this.stage == 0) {
            ++this.stage;
            this.reliefMarket = FoodShortageEvent.findNearestMarket(this.market, new BaseEventPlugin.MarketFilter(){

                public boolean acceptMarket(MarketAPI market) {
                    if (market == FoodShortageEvent.this.market) {
                        return false;
                    }
                    if (market.getFaction().isHostileTo(FoodShortageEvent.this.market.getFaction())) {
                        return false;
                    }
                    if (SharedData.getData().getMarketsThatSentRelief().contains(market.getId())) {
                        return false;
                    }
                    if (market.getCommodityData("food").getStockpile() < FoodShortageEvent.this.baseFoodToMeetShortage) {
                        return false;
                    }
                    CampaignEventManagerAPI manager = Global.getSector().getEventManager();
                    EventProbabilityAPI ep = manager.getProbability("food_shortage", market);
                    if ((double)ep.getProbability() > 0.1) {
                        return false;
                    }
                    if (manager.isOngoing(ep)) {
                        return false;
                    }
                    if ((float)Math.random() * 10.0f > market.getStabilityValue()) {
                        return false;
                    }
                    return market.getSize() >= FoodShortageEvent.this.market.getSize();
                }
            });
            if (this.market.getFaction().getId().equals("pirates")) {
                this.reliefMarket = null;
            }
            if (this.reliefMarket != null) {
                SharedData.getData().getMarketsThatSentRelief().add(this.reliefMarket.getId(), 14.0f + (float)Math.random() * 14.0f);
                Global.getSector().reportEventStage(this, "warning_relief", this.reliefMarket.getPrimaryEntity(), this.messagePriority);
            } else {
                log.info((Object)(String.valueOf(this.getLoggingId()) + " \u6ca1\u6709\u6551\u6d4e\u7684\u5e02\u573a"));
                this.applyReliefFleetDidNotMakeItConsequences();
                Global.getSector().reportEventStage(this, "relief_unavailable", this.messagePriority);
            }
        }
        if (this.elapsedDays > this.daysBeforeReliefSend && this.stage == 1) {
            ++this.stage;
            if (this.reliefMarket != null) {
                this.createReliefFleet();
                if (this.reliefFleet == null) {
                    log.info((Object)(String.valueOf(this.getLoggingId()) + " \u672a\u80fd\u6d3e\u51fa\u6551\u63f4\u8239\u961f"));
                    this.applyReliefFleetDidNotMakeItConsequences();
                    Global.getSector().reportEventStage(this, "relief_unavailable", this.messagePriority);
                } else {
                    this.originalReliefFleetPoints = this.reliefFleet.getFleetPoints();
                    SectorEntityToken entity = this.reliefMarket.getPrimaryEntity();
                    this.reliefMarket.getPrimaryEntity().getContainingLocation().addEntity(this.reliefFleet);
                    this.reliefFleet.setLocation(entity.getLocation().x, entity.getLocation().y);
                    this.reliefFleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.reliefMarket.getPrimaryEntity(), 2.0f, "\u4ece\u4e2d\u88c5\u8f7d\u98df\u54c1 " + this.reliefMarket.getName(), new Script(){

                        public void run() {
                            FoodShortageEvent.this.reliefFleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, "food", FoodShortageEvent.this.reliefFleet.getCargo().getMaxCapacity() * 1.0f);
                        }
                    });
                    this.reliefFleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, this.market.getPrimaryEntity(), 1000.0f, "\u63d0\u4f9b\u98df\u54c1\u6551\u6d4e " + this.reliefMarket.getName() + " \u5230 " + this.market.getName());
                    this.reliefFleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.market.getPrimaryEntity(), 2.0f, "\u5378\u8f7d\u98df\u54c1 " + this.market.getName(), new Script(){

                        public void run() {
                            FoodShortageEvent.this.endEvent(Ending.RELIEF_ARRIVED);
                        }
                    });
                    this.reliefFleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.reliefMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.reliefMarket.getName() + " \u628a\u98df\u54c1\u6551\u6d4e\u9001\u5f80 " + this.market.getName());
                    Global.getSector().reportEventStage(this, "relief_sent", this.reliefMarket.getPrimaryEntity(), this.messagePriority);
                    log.info((Object)(String.valueOf(this.getLoggingId()) + " \u6d3e\u9063\u6551\u63f4\u8239\u961f\u4ece " + this.reliefMarket.getName()));
                }
            }
        }
        if (this.reliefFleet != null && (currPoints = (float)this.reliefFleet.getFleetPoints()) < this.originalReliefFleetPoints * 0.5f) {
            Global.getSector().reportEventStage(this, "relief_aborted", this.reliefMarket.getPrimaryEntity(), this.messagePriority);
            log.info((Object)(String.valueOf(this.getLoggingId()) + " \u6551\u63f4\u5931\u8d25\uff0c\u8230\u961f\u8fd4\u56de " + this.reliefMarket.getName()));
            this.reliefFleet.clearAssignments();
            this.reliefFleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.reliefMarket.getPrimaryEntity(), 1000.0f);
            this.applyReliefFleetDidNotMakeItConsequences();
            this.reliefFleet = null;
        }
        if ((this.elapsedDays > this.maxDurationDays || this.elapsedDays > MAX_POSSIBLE_DURATION) && this.stage == 2) {
            this.endEvent(Ending.DURATION_EXPIRED);
            ++this.stage;
        }
    }

    private void applyReliefFleetDidNotMakeItConsequences() {
        float abortUnrest = this.getReliefAbortUnrest();
        this.increaseRecentUnrest((int)abortUnrest);
        log.info((Object)(" +" + abortUnrest + " \u52a8\u8361 " + this.market.getName()));
    }

    private void createReliefFleet() {
        this.reliefFleet = FleetFactory.createEmptyFleet(this.reliefMarket.getFactionId(), "foodReliefFleet", this.reliefMarket);
        int size = this.market.getSize();
        float combat = size;
        float freighter = (float)size * 1.5f;
        float transport = (float)size * 0.25f;
        this.reliefFleet = FleetFactoryV3.createFleet(new FleetParamsV3(this.reliefMarket, "foodReliefFleet", combat *= 5.0f, freighter *= 3.0f, 0.0f, transport *= 3.0f, 0.0f, 0.0f, 0.0f));
    }

    private void endEvent(Ending ending) {
        if (this.market != null) {
            this.market.removeCondition("event_food_shortage");
        }
        this.ended = true;
        CommodityOnMarketAPI com = this.market.getCommodityData("food");
        com.setStockpile(com.getStockpile() / this.getStockpileMult());
        com.getPlayerSupplyPriceMod().unmodifyMult(PRICE_MOD_ID);
        com.getPlayerSupplyPriceMod().unmodifyFlat(PRICE_MOD_ID);
        float ongoingStabilityImpact = this.getStabilityImpact();
        Misc.unsetAll("$market.foodShortage", "market", this.market.getMemoryWithoutUpdate());
        final InteractionDialogAPI dialog = Global.getSector().getCampaignUI().getCurrentInteractionDialog();
        switch (ending) {
            case DURATION_EXPIRED: {
                Global.getSector().reportEventStage(this, "end_expired", this.messagePriority);
                log.info((Object)(String.valueOf(this.getLoggingId()) + " \u5230\u671f"));
                ongoingStabilityImpact += this.getAddedExpiredUnrest();
                this.market.getMemoryWithoutUpdate().set("$foodShortageExpired", true, 10.0f);
                break;
            }
            case PLAYER_ENDED: {
                if (dialog != null && dialog.getPlugin().getMemoryMap() != null && dialog.getTextPanel() != null) {
                    dialog.getTextPanel().addParagraph("\u4ea4\u6613\u5b8c\u6bd5", Global.getSettings().getColor("buttonText"));
                }
                if (this.elapsedDays < 7.0f) {
                    ongoingStabilityImpact = 0.0f;
                    Global.getSector().reportEventStage(this, "end_player_fast", null, MessagePriority.DELIVER_IMMEDIATELY, new BaseOnMessageDeliveryScript(){

                        public void beforeDelivery(CommMessageAPI message) {
                            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.FOOD_SHORTAGE_PLAYER_ENDED_FAST, (Object)FoodShortageEvent.this.market, message, dialog.getTextPanel(), true), FoodShortageEvent.this.market.getFaction().getId());
                        }
                    });
                    log.info((Object)(String.valueOf(this.getLoggingId()) + " \u88ab\u73a9\u5bb6\u5728 7 \u5929\u5185\u7ed3\u675f\u4e86"));
                    this.market.getMemoryWithoutUpdate().set("$foodShortageEndedByPlayerFast", true, 10.0f);
                } else {
                    ongoingStabilityImpact = Math.max(0.0f, ongoingStabilityImpact - this.getReducedEndedUnrest());
                    Global.getSector().reportEventStage(this, "end_player", null, MessagePriority.DELIVER_IMMEDIATELY, new BaseOnMessageDeliveryScript(){

                        public void beforeDelivery(CommMessageAPI message) {
                            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.FOOD_SHORTAGE_PLAYER_ENDED_NORMAL, (Object)FoodShortageEvent.this.market, message, dialog.getTextPanel(), true), FoodShortageEvent.this.market.getFaction().getId());
                        }
                    });
                    log.info((Object)(String.valueOf(this.getLoggingId()) + " \u88ab\u73a9\u5bb6\u7ed3\u675f\u4e86"));
                    this.market.getMemoryWithoutUpdate().set("$foodShortageEndedByPlayer", true, 10.0f);
                }
                if (dialog == null || dialog.getPlugin().getMemoryMap() == null) break;
                dialog.getVisualPanel().hideCore();
                FireBest.fire(null, dialog, dialog.getPlugin().getMemoryMap(), "FoodShortageEndedByPlayerSale");
                break;
            }
            case PLAYER_ENDED_BLACK: {
                if (dialog != null && dialog.getPlugin().getMemoryMap() != null && dialog.getTextPanel() != null) {
                    dialog.getTextPanel().addParagraph("\u4ea4\u6613\u5b8c\u6bd5", Global.getSettings().getColor("buttonText"));
                }
                ongoingStabilityImpact += this.getEndBlackUnrest();
                Global.getSector().reportEventStage(this, "end_player_black", null, MessagePriority.DELIVER_IMMEDIATELY, new BaseOnMessageDeliveryScript(){

                    public void beforeDelivery(CommMessageAPI message) {
                    }
                });
                log.info((Object)(String.valueOf(this.getLoggingId()) + " \u88ab\u73a9\u5bb6\u9ed1\u5e02\u4ea4\u6613\u7ed3\u675f\u4e86"));
                this.market.getMemoryWithoutUpdate().set("$foodShortageEndedByPlayerBlack", true, 10.0f);
                if (dialog == null || dialog.getPlugin().getMemoryMap() == null) break;
                dialog.getVisualPanel().hideCore();
                FireBest.fire(null, dialog, dialog.getPlugin().getMemoryMap(), "FoodShortageEndedByPlayerSale");
                break;
            }
            case RELIEF_ARRIVED: {
                Global.getSector().reportEventStage(this, "end_relief_arrived", null, this.messagePriority);
                ongoingStabilityImpact = Math.max(0.0f, ongoingStabilityImpact - this.getReducedEndedUnrest());
                log.info((Object)(String.valueOf(this.getLoggingId()) + " \u901a\u8fc7\u6551\u63f4\u8239\u961f\u7684\u5230\u6765\u7ed3\u675f\u4e86"));
                this.market.getMemoryWithoutUpdate().set("$foodShortageEndedByNPC", true, 10.0f);
            }
        }
        for (SubmarketAPI sub : this.market.getSubmarketsCopy()) {
            if (sub.getPlugin().isFreeTransfer()) continue;
            float food = sub.getCargo().getQuantity(CargoAPI.CargoItemType.RESOURCES, "food");
            sub.getCargo().removeItems(CargoAPI.CargoItemType.RESOURCES, "food", food);
        }
        this.increaseRecentUnrest((int)ongoingStabilityImpact);
        log.info((Object)(String.valueOf(this.getLoggingId()) + " \u52a8\u4e71 +" + (int)ongoingStabilityImpact));
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    @Override
    public MessagePriority getWarningWhenPossiblePriority() {
        return this.messagePriority;
    }

    @Override
    public MessagePriority getWarningWhenLikelyPriority() {
        return this.messagePriority;
    }

    @Override
    public String getStageIdForLikely() {
        return "\u5bb9\u6613";
    }

    @Override
    public String getStageIdForPossible() {
        return "possible";
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        float sold;
        if (!this.isEventStarted()) {
            return;
        }
        if (this.market == null) {
            return;
        }
        if (transaction.getMarket() != this.market) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        SubmarketPlugin plugin = transaction.getSubmarket().getPlugin();
        if (!plugin.isParticipatesInEconomy()) {
            return;
        }
        float bought = transaction.getQuantityBought("food");
        float netBought = bought - (sold = transaction.getQuantitySold("food"));
        if (netBought == 0.0f) {
            return;
        }
        CommodityOnMarketAPI com = this.market.getCommodityData("food");
        float postTransactionLevel = com.getStockpile();
        if (plugin.isBlackMarket()) {
            this.netDeliveredByPlayerBlack -= bought;
            this.netDeliveredByPlayerBlack += sold;
        } else {
            this.netDeliveredByPlayerOther -= bought;
            this.netDeliveredByPlayerOther += sold;
        }
        if (postTransactionLevel >= this.preEventFoodLevel && this.netDeliveredByPlayerOther + this.netDeliveredByPlayerBlack >= MIN_FRACTION_FOR_PLAYER_ENDING_EVENT * this.baseFoodToMeetShortage) {
            if (this.netDeliveredByPlayerBlack >= MIN_FRACTION_FOR_PLAYER_ENDING_EVENT * this.baseFoodToMeetShortage) {
                this.endEvent(Ending.PLAYER_ENDED_BLACK);
            } else {
                this.endEvent(Ending.PLAYER_ENDED);
            }
        }
    }

    @Override
    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (fleet == this.reliefFleet) {
            Global.getSector().reportEventStage(this, "relief_lost", this.reliefMarket.getPrimaryEntity(), this.messagePriority);
            this.applyReliefFleetDidNotMakeItConsequences();
            this.reliefFleet = null;
        }
    }

    public float getRemainingFoodToMeetShortage() {
        return Math.max(0.0f, this.baseFoodToMeetShortage - this.netDeliveredByPlayerBlack - this.netDeliveredByPlayerOther);
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        map.put("$targetFaction", this.eventTarget.getEntity().getFaction().getDisplayName());
        if (this.reliefMarket != null) {
            SectorEntityToken primary = this.reliefMarket.getPrimaryEntity();
            LocationAPI loc = primary.getContainingLocation();
            if (loc instanceof StarSystemAPI) {
                map.put("$reliefSystem", ((StarSystemAPI)loc).getBaseName());
            } else {
                map.put("$reliefSystem", "hyperspace");
            }
            map.put("$reliefMarket", primary.getName());
            if (this.reliefFleet != null) {
                float dist = Misc.getDistance(primary.getLocationInHyperspace(), this.market.getPrimaryEntity().getLocationInHyperspace());
                float eta = dist / this.reliefFleet.getFleetData().getTravelSpeed();
                eta /= Global.getSector().getClock().getSecondsPerDay();
                String s = null;
                s = eta <= 3.0f ? "\u51e0\u5929\u4e4b\u5185" : (eta <= 7.0f ? "\u4e00\u5468\u4e4b\u5185" : (eta <= 14.0f ? "\u51e0\u5468\u4e4b\u5185" : ((eta += 2.0f) <= 30.0f ? "\u4e00\u4e2a\u6708\u4e4b\u5185" : "\u5728\u672a\u6765\u7684\u51e0\u4e2a\u6708")));
                map.put("$eta", s);
            }
        }
        int needed = (int)Misc.getRounded(this.getRemainingFoodToMeetShortage());
        map.put("$neededFood", "" + needed);
        map.put("$stabilityPenalty", "" + (int)this.getStabilityImpact());
        map.put("$stabilityPenaltyRelief", "" + (int)this.getReliefAbortUnrest());
        map.put("$stabilityPenaltyExpire", "" + (int)(this.getAddedExpiredUnrest() + this.getStabilityImpact()));
        map.put("$stabilityPenaltyEnd", "" + (int)Math.max(0.0f, this.getStabilityImpact() - this.getReducedEndedUnrest()));
        map.put("$stabilityPenaltyEndBlack", "" + (int)(this.getStabilityImpact() + this.getEndBlackUnrest()));
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        ArrayList<String> result = new ArrayList<String>();
        if ("start".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenalty", "$neededFood");
        }
        if ("relief_unavailable".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyRelief");
        }
        if ("relief_aborted".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyRelief");
        }
        if ("relief_lost".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyRelief");
        }
        if ("end_relief_arrived".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyEnd");
        }
        if ("end_expired".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyExpire");
        }
        if ("end_player".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyEnd");
        }
        if ("end_player_black".equals(stageId)) {
            this.addTokensToList(result, "$stabilityPenaltyEndBlack");
        }
        "end_player_fast".equals(stageId);
        return result.toArray(new String[0]);
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        return super.getHighlightColors(stageId);
    }

    @Override
    public List<String> getRelatedCommodities() {
        ArrayList<String> commodities = new ArrayList<String>();
        commodities.add("food");
        return commodities;
    }

    @Override
    public List<CampaignEventPlugin.PriceUpdatePlugin> getPriceUpdates() {
        ArrayList<CampaignEventPlugin.PriceUpdatePlugin> updates = new ArrayList<CampaignEventPlugin.PriceUpdatePlugin>();
        updates.add(new PriceUpdate(this.market.getCommodityData("food")));
        return updates;
    }

    @Override
    public String getEventName() {
        if (!this.isEventStarted()) {
            return "\u53ef\u80fd\u98df\u54c1\u77ed\u7f3a - " + this.market.getName();
        }
        if (this.isDone()) {
            return "\u98df\u54c1\u77ed\u7f3a - " + this.market.getName() + " (\u7ed3\u675f) ";
        }
        return "\u98df\u54c1\u77ed\u7f3a - " + this.market.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ending {
        DURATION_EXPIRED,
        RELIEF_ARRIVED,
        PLAYER_ENDED,
        PLAYER_ENDED_BLACK;

    }

    public static class PlayerFoodTransaction {
        public long timestamp;
        public float quantity;
    }
}

