/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvestigationEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(InvestigationEvent.class);
    private float elapsedDays = 0.0f;
    private float initialDelay = 0.0f;
    private float duration = 0.0f;
    private InvestigationEventParams params;
    private int stage = 0;
    private boolean ended = false;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    @Override
    public void setParam(Object param) {
        this.params = (InvestigationEventParams)param;
    }

    @Override
    public void startEvent() {
        super.startEvent();
        if (this.market != null && this.market.hasCondition("decivilized")) {
            this.endEvent();
            return;
        }
        this.initialDelay = this.params.minInitialDelay + (this.params.maxInitialDelay - this.params.minInitialDelay) * (float)Math.random();
        this.duration = this.params.minDuration + (this.params.maxDuration - this.params.minDuration) * (float)Math.random();
        log.info((Object)String.format("\u5f00\u59cb\u8c03\u67e5 suffix \"%s\" \u5728 %s}\u3002\u5ef6\u671f\uff1a%f\uff0c\u6301\u7eed\uff1a%f", this.params.startStage, this.getTargetName(), Float.valueOf(this.initialDelay), Float.valueOf(this.duration)));
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= this.initialDelay && this.stage == 0) {
            ++this.stage;
            log.info((Object)("\u62a5\u544a\u8c03\u67e5\u7684\u9636\u6bb5 " + this.params.startStage + " \u4f18\u5148 " + this.params.warningPriority.name()));
            Global.getSector().reportEventStage(this, this.params.startStage, this.params.warningPriority);
        }
        if (this.elapsedDays >= this.initialDelay + this.duration && this.stage == 1) {
            InvestigationResult result2;
            WeightedRandomPicker<InvestigationResult> picker = new WeightedRandomPicker<InvestigationResult>();
            for (InvestigationResult result2 : this.params.results) {
                picker.add(result2, result2.weight);
            }
            result2 = (InvestigationResult)picker.pick();
            if (result2.stageName != null) {
                Global.getSector().reportEventStage(this, result2.stageName, null, result2.priority, result2.onDelivery);
                log.info((Object)("\u8c03\u67e5\u7ed3\u679c\uff1a" + result2.stageName + " \u4f18\u5148 " + (Object)((Object)result2.priority)));
            }
            this.endEvent();
        }
    }

    @Override
    public String getEventName() {
        return this.params.name;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        if (this.params.warningSender != null) {
            map.put("$sender", this.params.warningSender);
        }
        return map;
    }

    protected void endEvent() {
        this.ended = true;
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    public static float getPlayerRepGuiltMult(FactionAPI faction) {
        FactionAPI player = Global.getSector().getFaction("player");
        RepLevel level = faction.getRelationshipLevel(player);
        switch (level) {
            case COOPERATIVE: {
                return 0.1f;
            }
            case FRIENDLY: {
                return 0.2f;
            }
            case WELCOMING: {
                return 0.3f;
            }
            case FAVORABLE: {
                return 0.5f;
            }
            case NEUTRAL: {
                return 1.0f;
            }
            case SUSPICIOUS: {
                return 1.5f;
            }
            case INHOSPITABLE: {
                return 2.0f;
            }
            case HOSTILE: {
                return 5.0f;
            }
            case VENGEFUL: {
                return 10.0f;
            }
        }
        return 1.0f;
    }

    public static class InvestigationEventParams {
        public String name;
        public String startStage;
        public String warningSender = null;
        public MessagePriority warningPriority = MessagePriority.SECTOR;
        public List<InvestigationResult> results = new ArrayList<InvestigationResult>();
        public float minInitialDelay = 1.0f;
        public float maxInitialDelay = 6.0f;
        public float minDuration = 10.0f;
        public float maxDuration = 15.0f;

        public InvestigationEventParams(String name, String startStage) {
            this.name = name;
            this.startStage = startStage;
        }
    }

    public static class InvestigationResult {
        public String stageName;
        public float weight = 0.0f;
        public MessagePriority priority = MessagePriority.SECTOR;
        public OnMessageDeliveryScript onDelivery = null;

        public InvestigationResult(String stage, MessagePriority priority) {
            this.stageName = stage;
            this.priority = priority;
        }
    }
}

