/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvestigationEventGoodRepWithOther
extends BaseEventPlugin {
    public static final String PERSON_CHECKOUT_REASON = "IGR_investigator";
    public static Logger log = Global.getLogger(InvestigationEventGoodRepWithOther.class);
    private float elapsedDays = 0.0f;
    private float duration = 0.0f;
    private InvestigationGoodRepData target = null;
    private float guiltProb = 0.0f;
    private int bribeAmount = 1;
    private boolean bribed = false;
    private PersonAPI investigator;
    private FactionAPI other;
    private boolean ended = false;
    private float numPrior;
    private CoreReputationPlugin.RepActions punishment = null;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    @Override
    public void startEvent() {
        super.startEvent();
        if (!(this.eventTarget.getCustom() instanceof InvestigationGoodRepData)) {
            this.endEvent();
            return;
        }
        this.target = (InvestigationGoodRepData)this.eventTarget.getCustom();
        this.faction = this.target.faction;
        this.other = this.target.other;
        this.numPrior = this.faction.getMemoryWithoutUpdate().getFloat("$numGRInvestigations");
        this.pickMarket();
        if (this.market == null) {
            this.endEvent();
            return;
        }
        if (this.faction.isAtBest("player", RepLevel.HOSTILE) || this.other.isAtBest("player", RepLevel.FAVORABLE) || this.faction.isAtWorst(this.other, RepLevel.COOPERATIVE) || !this.faction.getCustom().optBoolean("investigatesPlayerForGoodRepWithOtherFactions") || !this.other.getCustom().optBoolean("worthInvestigatingPlayerForGoodRepWith") || this.faction == this.other) {
            this.endEvent();
            return;
        }
        float repFaction = this.faction.getRelationship("player");
        float repOther = this.other.getRelationship("player");
        RepLevel relFaction = this.faction.getRelationshipLevel("player");
        RepLevel relOther = this.other.getRelationshipLevel("player");
        switch ((int)this.numPrior) {
            case 0: {
                this.guiltProb = 0.25f;
                this.punishment = CoreReputationPlugin.RepActions.OTHER_FACTION_GOOD_REP_INVESTIGATION_MINOR;
                break;
            }
            case 1: {
                this.guiltProb = 0.5f;
                this.punishment = CoreReputationPlugin.RepActions.OTHER_FACTION_GOOD_REP_INVESTIGATION_MAJOR;
                break;
            }
            default: {
                this.guiltProb = 1.0f;
                this.punishment = CoreReputationPlugin.RepActions.OTHER_FACTION_GOOD_REP_INVESTIGATION_CRITICAL;
            }
        }
        this.bribeAmount = 10000 + (int)(10000.0f * (this.numPrior + this.guiltProb * 2.0f + (float)Math.random())) / 1000 * 1000;
        this.duration = 60.0f + 30.0f * (float)Math.random();
        log.info((Object)String.format("\u5f00\u59cb\u9635\u8425\u8c03\u67e5 %s}\uff0c%s -> %s", this.market.getName(), this.faction.getDisplayName(), this.other.getDisplayName()));
        this.investigator = Global.getSector().getImportantPeople().getPerson(this.market.getFaction(), this.market, PERSON_CHECKOUT_REASON, Ranks.CITIZEN, Ranks.POST_INVESTIGATOR).getPerson();
        this.market.getCommDirectory().addPerson(this.investigator);
        this.investigator.getMemoryWithoutUpdate().set("$igr_eventRef", this, this.duration);
        this.investigator.getMemoryWithoutUpdate().set("$igr_investigator", true, this.duration);
        this.investigator.getMemoryWithoutUpdate().set("$igr_bribeAmount", "" + this.bribeAmount, this.duration);
        this.investigator.getMemoryWithoutUpdate().set("$igr_bribeAmountDGS", Misc.getWithDGS(this.bribeAmount), this.duration);
        Misc.setFlagWithReason(this.investigator.getMemoryWithoutUpdate(), "$requiresDiscretionToDeal", "igr", true, this.duration);
        Global.getSector().reportEventStage(this, "start_goodrep", null, MessagePriority.ENSURE_DELIVERY, null);
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= this.duration) {
            if (!this.bribed && !this.other.isAtBest("player", RepLevel.FAVORABLE) && (float)Math.random() < this.guiltProb) {
                Global.getSector().reportEventStage(this, "player_guilty_goodrep", null, MessagePriority.ENSURE_DELIVERY, new BaseOnMessageDeliveryScript(){

                    public void beforeDelivery(CommMessageAPI message) {
                        if (InvestigationEventGoodRepWithOther.this.punishment != null) {
                            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(InvestigationEventGoodRepWithOther.this.punishment, null, null, true), InvestigationEventGoodRepWithOther.this.market.getFactionId());
                        }
                    }
                });
            } else if (this.bribed) {
                Global.getSector().reportEventStage(this, "clear_goodrep_bribe", null, MessagePriority.ENSURE_DELIVERY, null);
            } else {
                Global.getSector().reportEventStage(this, "clear_goodrep", null, MessagePriority.ENSURE_DELIVERY, null);
            }
            this.numPrior += 1.0f;
            this.faction.getMemoryWithoutUpdate().set("$numGRInvestigations", Float.valueOf(this.numPrior));
            this.endEvent();
        }
    }

    @Override
    public String getEventName() {
        if (this.isDone()) {
            return String.valueOf(this.other.getDisplayName()) + " \u5173\u7cfb\u8c03\u67e5 - " + this.faction.getDisplayName() + " (\u7ed3\u675f) ";
        }
        return String.valueOf(this.other.getDisplayName()) + " \u5173\u7cfb\u8c03\u67e5 - " + this.faction.getDisplayName();
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        if (action.equals("paidBribe")) {
            return this.bribed;
        }
        if (action.equals("setBribePaid")) {
            this.bribed = true;
            return true;
        }
        return true;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        map.put("$otherFaction", this.other.getDisplayName());
        map.put("$OtherFaction", Misc.ucFirst(this.other.getDisplayName()));
        map.put("$TheOtherFaction", Misc.ucFirst(this.other.getDisplayNameWithArticle()));
        map.put("$theOtherFaction", this.other.getDisplayNameWithArticle());
        map.put("$TheOtherFactionLong", Misc.ucFirst(this.other.getDisplayNameLongWithArticle()));
        map.put("$theOtherFactionLong", this.other.getDisplayNameLongWithArticle());
        map.put("$InvestigatorPost", Misc.ucFirst(this.investigator.getPost()));
        map.put("$investigatorName", this.investigator.getName().getFullName());
        if (this.investigator.isMale()) {
            map.put("$invHimOrHer", "\u4ed6");
        } else {
            map.put("$invHimOrHer", "\u5979");
        }
        map.put("$sender", "\u4e0d\u660e");
        map.put("$duration", Misc.getAtLeastStringForDays((int)this.duration));
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        ArrayList<String> result = new ArrayList<String>();
        this.addTokensToList(result, "$duration");
        return result.toArray(new String[0]);
    }

    protected void endEvent() {
        if (this.investigator != null) {
            this.investigator.getMemoryWithoutUpdate().unset("$igr_eventRef");
            this.investigator.getMemoryWithoutUpdate().unset("$igr_investigator");
            this.investigator.getMemoryWithoutUpdate().unset("$igr_bribeAmount");
            this.investigator.getMemoryWithoutUpdate().unset("$igr_bribeAmountDGS");
            Misc.setFlagWithReason(this.investigator.getMemoryWithoutUpdate(), "$requiresDiscretionToDeal", "igr", false, 0.0f);
            Global.getSector().getImportantPeople().returnPerson(this.investigator, PERSON_CHECKOUT_REASON);
            if (!Global.getSector().getImportantPeople().isCheckedOutForAnything(this.investigator)) {
                this.market.getCommDirectory().removePerson(this.investigator);
            }
        }
        this.ended = true;
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    private void pickMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getFaction() != this.faction || market.hasCondition("decivilized") || market.getSize() < 5) continue;
            float weight = market.getSize();
            picker.add(market, weight);
        }
        this.market = (MarketAPI)picker.pick();
        if (this.market == null) {
            return;
        }
        this.eventTarget.setEntity(this.market.getPrimaryEntity());
        this.eventTarget.setLocation(this.market.getContainingLocation());
    }

    public static class InvestigationGoodRepData {
        protected FactionAPI faction;
        protected FactionAPI other;

        public InvestigationGoodRepData(FactionAPI faction, FactionAPI other) {
            this.faction = faction;
            this.other = other;
        }

        public InvestigationGoodRepData(String faction, String other) {
            this.faction = Global.getSector().getFaction(faction);
            this.other = Global.getSector().getFaction(other);
        }

        public FactionAPI getFaction() {
            return this.faction;
        }

        public FactionAPI getOther() {
            return this.other;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.faction == null ? 0 : this.faction.hashCode());
            result = 31 * result + (this.other == null ? 0 : this.other.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvestigationGoodRepData other = (InvestigationGoodRepData)obj;
            if (this.faction == null ? other.faction != null : this.faction != other.faction) {
                return false;
            }
            return !(this.other == null ? other.other != null : this.other != other.other);
        }
    }
}

