/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvestigationEventSmugglingV2
extends BaseEventPlugin {
    public static final String PERSON_CHECKOUT_REASON = "ISE_investigator";
    public static Logger log = Global.getLogger(InvestigationEventSmugglingV2.class);
    private float elapsedDays = 0.0f;
    private float duration = 0.0f;
    private InvSmugglingParams params;
    private boolean bribed = false;
    private PersonAPI investigator;
    private boolean ended = false;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new InvSmugglingParams();
    }

    @Override
    public void startEvent() {
        super.startEvent();
        if (this.market == null || this.market.hasCondition("decivilized")) {
            this.endEvent();
            return;
        }
        if (this.market.getFaction().isAtBest("player", RepLevel.HOSTILE)) {
            this.endEvent();
            return;
        }
        this.params.guiltChance = Math.max(0.1f, Math.min(this.startProbability, 0.9f));
        this.params.bribeAmount = (int)((10000.0f + this.params.guiltChance * 90000.0f) / 1000.0f) * 1000;
        this.duration = 90.0f + 30.0f * (float)Math.random();
        log.info((Object)String.format("\u5f00\u59cb\u8d70\u79c1\u8c03\u67e5 %s", this.market.getName()));
        this.investigator = Global.getSector().getImportantPeople().getPerson(this.market.getFaction(), this.market, PERSON_CHECKOUT_REASON, Ranks.CITIZEN, Ranks.POST_INVESTIGATOR).getPerson();
        this.market.getCommDirectory().addPerson(this.investigator);
        this.investigator.getMemoryWithoutUpdate().set("$ise_eventRef", this, this.duration);
        this.investigator.getMemoryWithoutUpdate().set("$ise_investigator", true, this.duration);
        this.investigator.getMemoryWithoutUpdate().set("$ise_bribeAmount", "" + this.params.bribeAmount, this.duration);
        this.investigator.getMemoryWithoutUpdate().set("$ise_bribeAmountDGS", Misc.getWithDGS(this.params.bribeAmount), this.duration);
        Misc.setFlagWithReason(this.investigator.getMemoryWithoutUpdate(), "$requiresDiscretionToDeal", "ies", true, this.duration);
        Global.getSector().reportEventStage(this, "start_smuggling", null, MessagePriority.ENSURE_DELIVERY, null);
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= this.duration) {
            if (!this.bribed && (float)Math.random() < this.params.guiltChance) {
                Global.getSector().reportEventStage(this, "player_guilty_smuggling", null, MessagePriority.ENSURE_DELIVERY, new BaseOnMessageDeliveryScript(){

                    public void beforeDelivery(CommMessageAPI message) {
                        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.SMUGGLING_INVESTIGATION_GUILTY, null, null, true), InvestigationEventSmugglingV2.this.market.getFactionId());
                    }
                });
            } else if (this.bribed) {
                Global.getSector().reportEventStage(this, "clear_smuggling_bribe", null, MessagePriority.ENSURE_DELIVERY, null);
            } else {
                Global.getSector().reportEventStage(this, "clear_smuggling", null, MessagePriority.ENSURE_DELIVERY, null);
            }
            this.endEvent();
        }
    }

    @Override
    public String getEventName() {
        if (this.isDone()) {
            return "\u8d70\u79c1\u8c03\u67e5 - " + this.market.getName() + " (\u7ed3\u675f) ";
        }
        return "\u8d70\u79c1\u8c03\u67e5 - " + this.market.getName();
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        if (action.equals("paidBribe")) {
            return this.bribed;
        }
        if (action.equals("setBribePaid")) {
            this.bribed = true;
            return true;
        }
        return true;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        map.put("$InvestigatorPost", Misc.ucFirst(this.investigator.getPost()));
        map.put("$investigatorName", this.investigator.getName().getFullName());
        if (this.investigator.isMale()) {
            map.put("$invHimOrHer", "\u4ed6");
        } else {
            map.put("$invHimOrHer", "\u5979");
        }
        map.put("$sender", "\u4e0d\u660e");
        map.put("$duration", Misc.getAtLeastStringForDays((int)this.duration));
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        ArrayList<String> result = new ArrayList<String>();
        this.addTokensToList(result, "$duration");
        return result.toArray(new String[0]);
    }

    protected void endEvent() {
        if (this.investigator != null) {
            this.investigator.getMemoryWithoutUpdate().unset("$ise_eventRef");
            this.investigator.getMemoryWithoutUpdate().unset("$ise_investigator");
            this.investigator.getMemoryWithoutUpdate().unset("$ise_bribeAmount");
            this.investigator.getMemoryWithoutUpdate().unset("$ise_bribeAmountDGS");
            Misc.setFlagWithReason(this.investigator.getMemoryWithoutUpdate(), "$requiresDiscretionToDeal", "ies", false, 0.0f);
            Global.getSector().getImportantPeople().returnPerson(this.investigator, PERSON_CHECKOUT_REASON);
            if (!Global.getSector().getImportantPeople().isCheckedOutForAnything(this.investigator)) {
                this.market.getCommDirectory().removePerson(this.investigator);
            }
        }
        this.ended = true;
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    public static class InvSmugglingParams {
        public float guiltChance;
        public int bribeAmount;
    }
}

