/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeProfitabilityData;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepTrackerEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(RepTrackerEvent.class);
    private IntervalUtil tracker;
    private IntervalUtil repDecayTracker;
    private Map<String, FactionTradeRepData> repData = new HashMap<String, FactionTradeRepData>();

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.readResolve();
    }

    Object readResolve() {
        if (this.repDecayTracker == null) {
            this.repDecayTracker = new IntervalUtil(130.0f, 170.0f);
        }
        if (this.tracker == null) {
            this.tracker = new IntervalUtil(3.0f, 7.0f);
        }
        return this;
    }

    @Override
    public void startEvent() {
        super.startEvent();
    }

    private float[] getRepPointsAndVolumeUsedFor(float volume, FactionAPI faction) {
        FactionTradeRepData data = this.repData.get(faction.getId());
        if (data == null) {
            data = new FactionTradeRepData();
            this.repData.put(faction.getId(), data);
        }
        return data.getRepPointsAndVolumeUsedFor(volume);
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            for (FactionAPI faction : Global.getSector().getAllFactions()) {
                if (faction.isPlayerFaction() || faction.isNeutralFaction()) continue;
                this.checkForTradeReputationChanges(faction);
            }
            this.checkForXPGain();
        }
    }

    private void checkForXPGain() {
        PlayerTradeProfitabilityData data = SharedData.getData().getPlayerActivityTracker().getProfitabilityData();
        long gain = data.getAccruedXP();
        if (gain > 0L) {
            data.setAccruedXP(0L);
            Global.getSector().getCampaignUI().addMessage("\u4f60\u4ece\u8d38\u6613\u4e2d\u6c72\u53d6\u4e86\u7ecf\u9a8c", Misc.getBasePlayerColor());
            Global.getSector().getCharacterData().getPerson().getStats().addXP(gain);
        }
    }

    private void checkForTradeReputationChanges(FactionAPI faction) {
        CoreReputationPlugin.RepActions action;
        float[] repMinus;
        float playerTradeVolume = 0.0f;
        float playerSmugglingVolume = 0.0f;
        ArrayList<MarketTradeInfo> info = new ArrayList<MarketTradeInfo>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            MarketTradeInfo curr = new MarketTradeInfo();
            curr.market = market;
            for (SubmarketAPI submarket : market.getSubmarketsCopy()) {
                SubmarketPlugin plugin = submarket.getPlugin();
                if (!plugin.isParticipatesInEconomy()) continue;
                PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
                if (market.getFaction() == faction && (submarket.getFaction().isHostileTo(faction) || submarket.getPlugin().isBlackMarket())) {
                    curr.smugglingTotal += tradeData.getAccumulatedPlayerTradeValueForNegative();
                    continue;
                }
                if (submarket.getFaction() != faction) continue;
                curr.tradeTotal += tradeData.getAccumulatedPlayerTradeValueForPositive();
            }
            if (curr.tradeTotal == 0.0f && curr.smugglingTotal == 0.0f) continue;
            info.add(curr);
            playerTradeVolume += curr.tradeTotal;
            playerSmugglingVolume += curr.smugglingTotal;
        }
        float[] repPlus = this.getRepPointsAndVolumeUsedFor(playerTradeVolume, faction);
        float repChange = repPlus[0] - (repMinus = this.getRepPointsAndVolumeUsedFor(playerSmugglingVolume, faction))[0];
        if (Math.abs(repChange) < 1.0f) {
            log.info((Object)("\u6ca1\u6709\u8db3\u591f\u7684\u8d38\u6613/\u8d70\u79c1\u4e0e " + faction.getDisplayNameWithArticle() + " \u4e00\u4e2a\u58f0\u671b\u6539\u53d8 (" + playerTradeVolume + ", " + playerSmugglingVolume + ")"));
            return;
        }
        log.info((Object)("\u53d1\u51fa\u7684\u58f0\u671b\u6539\u53d8 " + repChange + " \u643a\u5e26 " + faction.getDisplayNameWithArticle() + " \u7531\u4e8e\u8d38\u6613/\u8d70\u79c1"));
        float tradeUsed = repPlus[1];
        float smugglingUsed = repMinus[1];
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            for (SubmarketAPI submarket : market.getSubmarketsCopy()) {
                float value;
                SubmarketPlugin plugin = submarket.getPlugin();
                if (!plugin.isParticipatesInEconomy() || market.getFaction() != faction && submarket.getFaction() != faction) continue;
                PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
                if (playerSmugglingVolume > 0.0f && market.getFaction() == faction && (submarket.getFaction().isHostileTo(faction) || submarket.getPlugin().isBlackMarket())) {
                    value = tradeData.getAccumulatedPlayerTradeValueForNegative();
                    tradeData.setAccumulatedPlayerTradeValueForNegative(value - smugglingUsed * value / playerSmugglingVolume);
                    continue;
                }
                if (!(playerTradeVolume > 0.0f) || submarket.getFaction() != faction) continue;
                value = tradeData.getAccumulatedPlayerTradeValueForPositive();
                tradeData.setAccumulatedPlayerTradeValueForPositive(value - tradeUsed * value / playerTradeVolume);
            }
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (repChange > 0.0f) {
            Collections.sort(info, new Comparator<MarketTradeInfo>(){

                @Override
                public int compare(MarketTradeInfo o1, MarketTradeInfo o2) {
                    return (int)(o2.tradeTotal - o1.tradeTotal);
                }
            });
            action = CoreReputationPlugin.RepActions.TRADE_EFFECT;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, new Float(Math.abs(repChange)), null, null, false, true, "\u56e0\u4e0e\u5176\u6240\u5c5e\u5e02\u573a\u8fdb\u884c\u5927\u5b97\u8d38\u6613"), faction.getId());
            this.causeNegativeRepChangeWithEnemies(info);
        } else if (repChange < 0.0f) {
            Collections.sort(info, new Comparator<MarketTradeInfo>(){

                @Override
                public int compare(MarketTradeInfo o1, MarketTradeInfo o2) {
                    return (int)(o2.smugglingTotal - o1.smugglingTotal);
                }
            });
            action = CoreReputationPlugin.RepActions.SMUGGLING_EFFECT;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, new Float(Math.abs(repChange)), null, null, false, true, "\u56e0\u4e0e\u9ed1\u5e02\u8fdb\u884c\u8d38\u6613"), faction.getId());
            this.causeNegativeRepChangeWithEnemies(info);
        }
    }

    public void causeNegativeRepChangeWithEnemies(List<MarketTradeInfo> info) {
        int maxToSend = 3;
        int sent = 0;
        for (final MarketTradeInfo curr : info) {
            float actionableTotal = curr.tradeTotal * 2.0f + curr.smugglingTotal * 0.5f;
            ArrayList<FactionAPI> factions = new ArrayList<FactionAPI>(Global.getSector().getAllFactions());
            Collections.shuffle(factions);
            for (final FactionAPI faction : factions) {
                float[] repMinus;
                float dist;
                MarketAPI other;
                if (faction.getCustom().optBoolean("ignoreTradeWithEnemiesForReputation") || faction.isPlayerFaction() || (other = BaseEventPlugin.findNearestMarket(curr.market, new BaseEventPlugin.MarketFilter(){

                    public boolean acceptMarket(MarketAPI market) {
                        if (!market.getFactionId().equals(faction.getId())) {
                            return false;
                        }
                        return market.getFaction().isAtBest(curr.market.getFaction(), RepLevel.HOSTILE);
                    }
                })) == null || (dist = Misc.getDistanceLY(curr.market.getLocationInHyperspace(), other.getLocationInHyperspace())) > Global.getSettings().getFloat("economyMaxRangeForNegativeTradeRepImpactLY") || (repMinus = this.getRepPointsAndVolumeUsedFor(actionableTotal, faction))[0] <= 0.0f) continue;
                if (dist <= 0.0f) {
                    repMinus[0] = repMinus[0] * 2.0f;
                }
                float repChange = -repMinus[0];
                log.info((Object)("\u53d1\u51fa\u7684\u58f0\u671b\u6539\u53d8 " + repChange + " \u643a\u5e26 " + other.getFaction().getDisplayNameWithArticle() + " \u7531\u4e8e\u4e0e\u654c\u5bf9\u52bf\u529b\u8fdb\u884c\u8d38\u6613 (" + curr.market.getFaction().getDisplayNameWithArticle() + ")"));
                CoreReputationPlugin.RepActions action = CoreReputationPlugin.RepActions.TRADE_WITH_ENEMY;
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, new Float(Math.abs(repChange)), null, null, false, true, "\u56e0\u4e0e\u654c\u4eba\u8fdb\u884c\u8d38\u6613"), other.getFactionId());
                if (++sent >= maxToSend) break;
            }
            if (sent >= maxToSend) break;
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public static class FactionTradeRepData {
        public float currVolumePerPoint = Global.getSettings().getFloat("economyPlayerTradeVolumeForRepChangeMin");

        public float[] getRepPointsAndVolumeUsedFor(float volume) {
            float max = Global.getSettings().getFloat("economyPlayerTradeVolumeForRepChangeMax");
            float incr = Global.getSettings().getFloat("economyPlayerTradeVolumeForRepChangeIncr");
            float points = 0.0f;
            float used = 0.0f;
            while (volume >= this.currVolumePerPoint) {
                points += 1.0f;
                used += this.currVolumePerPoint;
                volume -= this.currVolumePerPoint;
                if (this.currVolumePerPoint < max) {
                    this.currVolumePerPoint += incr;
                }
                if (!(this.currVolumePerPoint > max)) continue;
                this.currVolumePerPoint = max;
            }
            return new float[]{points, used};
        }
    }

    public static class MarketTradeInfo {
        public MarketAPI market;
        public float tradeTotal;
        public float smugglingTotal;
    }
}

