/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events.nearby;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class DistressCallPirateAmbushTrapAssignmentAI
extends BaseAssignmentAI {
    protected StarSystemAPI system;
    protected SectorEntityToken jumpPoint;
    protected float elapsed = 0.0f;
    protected float dur = 30.0f + (float)Math.random() * 20.0f;

    public DistressCallPirateAmbushTrapAssignmentAI(CampaignFleetAPI fleet, StarSystemAPI system, SectorEntityToken jumpPoint) {
        this.fleet = fleet;
        this.system = system;
        this.jumpPoint = jumpPoint;
        this.giveInitialAssignments();
    }

    protected void giveInitialAssignments() {
        this.pickNext();
    }

    protected void pickNext() {
        float angle = Misc.getAngleInDegrees(this.system.getCenter().getLocation(), this.jumpPoint.getLocation());
        float dist = Misc.getDistance(this.system.getCenter().getLocation(), this.jumpPoint.getLocation()) + 3000.0f;
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle += (float)Math.random() * 10.0f - 20.0f);
        loc.scale(dist += (float)Math.random() * 500.0f);
        Vector2f.add((Vector2f)this.system.getCenter().getLocation(), (Vector2f)loc, (Vector2f)loc);
        SectorEntityToken token = this.system.createToken(loc.x, loc.y);
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, token, 3.0f, "laying in wait");
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsed += days;
        if (this.elapsed >= this.dur) {
            Misc.giveStandardReturnToSourceAssignments(this.fleet);
        }
    }
}

