/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events.nearby;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.nearby.DistressCallNormalAssignmentAI;
import com.fs.starfarer.api.impl.campaign.events.nearby.DistressCallPirateAmbushAssignmentAI;
import com.fs.starfarer.api.impl.campaign.events.nearby.DistressCallPirateAmbushTrapAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.PirateFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.misc.DistressCallIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RuinsFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearbyEventsEvent
extends BaseEventPlugin
implements RouteManager.RouteFleetSpawner {
    public static float DISTRESS_REPEAT_TIMEOUT = 90.0f;
    public static float DISTRESS_ALREADY_WAS_NEARBY_TIMEOUT = 30.0f;
    public static float DISTRESS_MIN_SINCE_PLAYER_IN_SYSTEM = 90.0f;
    public static float DISTRESS_MIN_CHECK_INTERVAL = 5.0f;
    public static float DISTRESS_MAX_CHECK_INTERVAL = 15.0f;
    public static float DISTRESS_PROB_PER_SYSTEM = 0.2f;
    public static float DISTRESS_MAX_PROB = 0.6f;
    public static float DERELICT_SKIP_PROB = 0.5f;
    public static float DERELICT_SKIP_PROB_ABYSS = 0.85f;
    protected IntervalUtil derelictShipInterval = new IntervalUtil(1.0f, 10.0f);
    protected IntervalUtil distressCallInterval = new IntervalUtil(DISTRESS_MIN_CHECK_INTERVAL, DISTRESS_MAX_CHECK_INTERVAL);
    protected TimeoutTracker<String> skipForDistressCalls = new TimeoutTracker();
    public static boolean TEST_MODE = false;
    public static Set<String> distressCallAllowedThemes = new HashSet<String>();

    static {
        distressCallAllowedThemes.add("theme_misc");
        distressCallAllowedThemes.add("theme_misc_skip");
        distressCallAllowedThemes.add("theme_ruins");
        distressCallAllowedThemes.add("theme_remnant_suppressed");
        distressCallAllowedThemes.add("theme_remnant_destroyed");
        distressCallAllowedThemes.add("theme_remnant_no_fleets");
        distressCallAllowedThemes.add("theme_derelict");
    }

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.readResolve();
    }

    Object readResolve() {
        if (this.skipForDistressCalls == null) {
            this.skipForDistressCalls = new TimeoutTracker();
        }
        if (this.distressCallInterval == null) {
            this.distressCallInterval = new IntervalUtil(DISTRESS_MIN_CHECK_INTERVAL, DISTRESS_MAX_CHECK_INTERVAL);
        }
        return this;
    }

    @Override
    public void startEvent() {
        super.startEvent();
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (Global.getSector().isInFastAdvance()) {
            return;
        }
        if (Global.getSector().getPlayerFleet() == null) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.derelictShipInterval.advance(days);
        if (this.derelictShipInterval.intervalElapsed()) {
            this.maybeSpawnDerelictShip();
        }
        this.skipForDistressCalls.advance(days);
        this.distressCallInterval.advance(days);
        if (this.distressCallInterval.intervalElapsed() || TEST_MODE) {
            this.maybeSpawnDistressCall();
        }
    }

    protected void maybeSpawnDerelictShip() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerFleet.isInHyperspace()) {
            return;
        }
        float skipProb = DERELICT_SKIP_PROB;
        if (Misc.isInAbyss(playerFleet)) {
            skipProb = DERELICT_SKIP_PROB_ABYSS;
        }
        if ((float)Math.random() < skipProb) {
            return;
        }
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(null, playerFleet, 15.0f, 5.0f, 5.0f);
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom(factions.pick(), null, null, 0.0f);
        if (params != null) {
            ShipVariantAPI variant = Global.getSettings().getVariant(params.ship.variantId);
            params.durationDays = DerelictShipEntityPlugin.getBaseDuration(variant.getHullSize());
            CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(Global.getSector().getHyperspace(), "wreck", "neutral", params);
            entity.addTag("expires");
            entity.setDiscoverable(false);
            SalvageSpecialAssigner.assignSpecials(entity, false);
            float distFromPlayer = 3000.0f + (float)Math.random() * 2000.0f;
            Vector2f loc = Misc.getPointAtRadius(playerFleet.getLocationInHyperspace(), distFromPlayer, new Random());
            entity.getLocation().x = loc.x;
            entity.getLocation().y = loc.y;
            float angle = Misc.getAngleInDegrees(loc, playerFleet.getLocation());
            float arc = 90.0f;
            angle = angle - arc / 2.0f + arc * (float)Math.random();
            float speed = 10.0f + 10.0f * (float)Math.random();
            float depth = Misc.getAbyssalDepth(loc);
            Vector2f vel = Misc.getUnitVectorAtDegreeAngle(angle);
            vel.scale(speed *= 0.5f + 0.5f * (1.0f - depth));
            entity.getVelocity().set((ReadableVector2f)vel);
        }
    }

    protected void maybeSpawnDistressCall() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerFleet.isInHyperspace()) {
            return;
        }
        if (playerFleet.isInHyperspaceTransition()) {
            return;
        }
        WeightedRandomPicker<StarSystemAPI> systems = new WeightedRandomPicker<StarSystemAPI>();
        block0: for (StarSystemAPI system : Misc.getNearbyStarSystems(playerFleet, Global.getSettings().getFloat("distressCallEventRangeLY"))) {
            float sincePlayerVisit;
            if (this.skipForDistressCalls.contains(system.getId()) || system.hasPulsar() || system.hasTag("system_cut_off_from_hyper") || system.hasTag("theme_hidden") || (sincePlayerVisit = system.getDaysSinceLastPlayerVisit()) < DISTRESS_MIN_SINCE_PLAYER_IN_SYSTEM) continue;
            boolean validTheme = false;
            for (String tag : system.getTags()) {
                if (!distressCallAllowedThemes.contains(tag)) continue;
                validTheme = true;
                break;
            }
            if (!validTheme) continue;
            for (CampaignFleetAPI fleet : system.getFleets()) {
                if (!fleet.getFaction().isHostileTo("independent")) continue block0;
            }
            if (!Misc.getMarketsInLocation(system).isEmpty()) continue;
            this.skipForDistressCalls.add(system.getId(), DISTRESS_ALREADY_WAS_NEARBY_TIMEOUT);
            systems.add(system);
        }
        float p = (float)systems.getItems().size() * DISTRESS_PROB_PER_SYSTEM;
        if (p > DISTRESS_MAX_PROB) {
            p = DISTRESS_MAX_PROB;
        }
        if ((float)Math.random() >= p && !TEST_MODE) {
            return;
        }
        StarSystemAPI system = (StarSystemAPI)systems.pick();
        if (system == null) {
            return;
        }
        this.skipForDistressCalls.set(system.getId(), DISTRESS_REPEAT_TIMEOUT);
        WeightedRandomPicker<DistressEventType> picker = new WeightedRandomPicker<DistressEventType>();
        picker.add(DistressEventType.NORMAL, 10.0f);
        picker.add(DistressEventType.PIRATE_AMBUSH, 10.0f);
        picker.add(DistressEventType.PIRATE_AMBUSH_TRAP, 10.0f);
        picker.add(DistressEventType.DERELICT_SHIP, 10.0f);
        DistressEventType type = (DistressEventType)((Object)picker.pick());
        if (TEST_MODE) {
            type = DistressEventType.PIRATE_AMBUSH;
        }
        if (type == DistressEventType.NORMAL) {
            this.generateDistressCallNormal(system);
        } else if (type == DistressEventType.PIRATE_AMBUSH) {
            this.generateDistressCallAmbush(system);
        } else if (type == DistressEventType.PIRATE_AMBUSH_TRAP || TEST_MODE) {
            this.generateDistressCallAmbushTrap(system);
        } else if (type == DistressEventType.DERELICT_SHIP) {
            this.generateDistressDerelictShip(system);
        }
        DistressCallIntel intel = new DistressCallIntel(system);
        Global.getSector().getIntelManager().addIntel(intel);
    }

    protected void generateDistressDerelictShip(StarSystemAPI system) {
        JumpPointAPI jumpPoint = Misc.getDistressJumpPoint(system);
        if (jumpPoint == null) {
            return;
        }
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(null, system.getLocation(), 15.0f, 5.0f, 5.0f);
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom(factions.pick(), null, null, DerelictShipEntityPlugin.getDefaultSModProb());
        if (params == null) {
            return;
        }
        params.durationDays = 60.0f;
        CustomCampaignEntityAPI derelict = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(system, "wreck", "neutral", params);
        derelict.addTag("expires");
        float radius = 400.0f + 400.0f * (float)Math.random();
        float maxRadius = Math.max(300.0f, jumpPoint.getCircularOrbitRadius() * 0.33f);
        if (radius > maxRadius) {
            radius = maxRadius;
        }
        float orbitDays = radius / (5.0f + Misc.random.nextFloat() * 20.0f);
        float angle = (float)Math.random() * 360.0f;
        derelict.setCircularOrbit(jumpPoint, angle, radius, orbitDays);
        SalvageSpecialAssigner.assignSpecialForDistressDerelict(derelict);
    }

    protected void generateDistressCallAmbushTrap(StarSystemAPI system) {
        JumpPointAPI jumpPoint = Misc.getDistressJumpPoint(system);
        if (jumpPoint == null) {
            return;
        }
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(null, system.getLocation(), 15.0f, 5.0f, 5.0f);
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom(factions.pick(), null, null, DerelictShipEntityPlugin.getDefaultSModProb());
        if (params == null) {
            return;
        }
        params.durationDays = 60.0f;
        CustomCampaignEntityAPI derelict = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(system, "wreck", "neutral", params);
        derelict.addTag("expires");
        float radius = 400.0f + 400.0f * (float)Math.random();
        float maxRadius = Math.max(300.0f, jumpPoint.getCircularOrbitRadius() * 0.33f);
        if (radius > maxRadius) {
            radius = maxRadius;
        }
        float orbitDays = radius / (5.0f + Misc.random.nextFloat() * 20.0f);
        float angle = (float)Math.random() * 360.0f;
        derelict.setCircularOrbit(jumpPoint, angle, radius, orbitDays);
        TransmitterTrapSpecial.TransmitterTrapSpecialData data = new TransmitterTrapSpecial.TransmitterTrapSpecialData();
        data.prob = 1.0f;
        data.maxRange = 20000.0f;
        data.nearbyFleetFaction = "pirates";
        data.useAllFleetsInRange = true;
        Misc.setSalvageSpecial(derelict, data);
        int numPirates = new Random().nextInt(3) + 1;
        int i = 0;
        while (i < numPirates) {
            NESpawnData dcd = new NESpawnData();
            dcd.type = DistressEventType.PIRATE_AMBUSH_TRAP;
            dcd.location = system;
            dcd.jumpPoint = jumpPoint;
            RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData();
            extra.factionId = "pirates";
            RouteManager.RouteData route = RouteManager.getInstance().addRoute("dcd_" + this.getId(), null, Misc.genRandomSeed(), extra, this, dcd);
            float waitDays = 30.0f + (float)Math.random() * 10.0f;
            route.addSegment(new RouteManager.RouteSegment(waitDays, jumpPoint));
            ++i;
        }
    }

    protected void generateDistressCallAmbush(StarSystemAPI system) {
        JumpPointAPI jumpPoint = Misc.getDistressJumpPoint(system);
        if (jumpPoint == null) {
            return;
        }
        int numPirates = new Random().nextInt(3) + 1;
        int i = 0;
        while (i < numPirates) {
            NESpawnData dcd = new NESpawnData();
            dcd.type = DistressEventType.PIRATE_AMBUSH;
            dcd.location = system;
            dcd.jumpPoint = jumpPoint;
            RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData();
            extra.factionId = "pirates";
            RouteManager.RouteData route = RouteManager.getInstance().addRoute("dcd_" + this.getId(), null, Misc.genRandomSeed(), extra, this, dcd);
            float waitDays = 30.0f + (float)Math.random() * 10.0f;
            route.addSegment(new RouteManager.RouteSegment(waitDays, jumpPoint));
            ++i;
        }
    }

    protected void generateDistressCallNormal(StarSystemAPI system) {
        JumpPointAPI jumpPoint = Misc.getDistressJumpPoint(system);
        if (jumpPoint == null) {
            return;
        }
        NESpawnData dcd = new NESpawnData();
        dcd.type = DistressEventType.NORMAL;
        dcd.location = system;
        dcd.jumpPoint = jumpPoint;
        RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData();
        extra.factionId = "independent";
        RouteManager.RouteData route = RouteManager.getInstance().addRoute("dcd_" + this.getId(), null, Misc.genRandomSeed(), extra, this, dcd);
        float waitDays = 30.0f + (float)Math.random() * 10.0f;
        route.addSegment(new RouteManager.RouteSegment(waitDays, jumpPoint));
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
        route.expire();
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        NESpawnData data = (NESpawnData)route.getCustom();
        if (data.type == DistressEventType.PIRATE_AMBUSH_TRAP) {
            float tf = PirateBaseManager.getInstance().getStandardTimeFactor();
            int points = (int)(10.0f + (float)new Random().nextInt(20) * tf);
            CampaignFleetAPI fleet = PirateFleetManager.createPirateFleet(points, null, data.location.getLocation());
            if (fleet != null) {
                fleet.getMemoryWithoutUpdate().set("$lowRepImpact", true);
                data.location.addEntity(fleet);
                Vector2f loc = Misc.getPointAtRadius(data.jumpPoint.getLocation(), 500.0f + (float)Math.random() * 200.0f);
                fleet.setLocation(loc.x, loc.y);
                fleet.addScript(new DistressCallPirateAmbushTrapAssignmentAI(fleet, (StarSystemAPI)data.location, data.jumpPoint));
                Misc.makeHostile(fleet);
            }
            return fleet;
        }
        if (data.type == DistressEventType.PIRATE_AMBUSH) {
            float tf = PirateBaseManager.getInstance().getStandardTimeFactor();
            int points = (int)(10.0f + (float)new Random().nextInt(20) * tf);
            CampaignFleetAPI fleet = PirateFleetManager.createPirateFleet(points, null, data.location.getLocation());
            if (fleet != null) {
                fleet.getMemoryWithoutUpdate().set("$lowRepImpact", true);
                data.location.addEntity(fleet);
                Vector2f loc = Misc.getPointAtRadius(data.jumpPoint.getLocation(), 500.0f + (float)Math.random() * 200.0f);
                fleet.setLocation(loc.x, loc.y);
                fleet.addScript(new DistressCallPirateAmbushAssignmentAI(fleet, (StarSystemAPI)data.location, data.jumpPoint));
                Misc.makeHostile(fleet);
            }
            return fleet;
        }
        if (data.type == DistressEventType.NORMAL) {
            CampaignFleetAPI fleet;
            boolean pirate;
            WeightedRandomPicker<String> typePicker = new WeightedRandomPicker<String>();
            typePicker.add("scavengerSmall", 10.0f);
            typePicker.add("scavengerMedium", 10.0f);
            typePicker.add("scavengerLarge", 10.0f);
            String type = (String)typePicker.pick();
            type = "scavengerSmall";
            boolean bl = pirate = (float)Math.random() < 0.5f;
            if (TEST_MODE) {
                pirate = true;
            }
            if ((fleet = RuinsFleetRouteManager.createScavenger(type, data.location.getLocation(), null, pirate, null)) == null) {
                return null;
            }
            if (Misc.getSourceMarket(fleet) == null) {
                return null;
            }
            data.location.addEntity(fleet);
            fleet.removeAbility("emergency_burn");
            fleet.getMemoryWithoutUpdate().set("$cfai_noJump", true);
            Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$missionImportant", "distress", true, 1000.0f);
            fleet.getMemoryWithoutUpdate().set("$ne_eventRef", this);
            fleet.getMemoryWithoutUpdate().set("$distress", true);
            if (pirate) {
                fleet.getMemoryWithoutUpdate().set("$distressTurnHostile", true);
            }
            Vector2f loc = Misc.getPointAtRadius(data.jumpPoint.getLocation(), 400.0f + (float)Math.random() * 200.0f);
            fleet.setLocation(loc.x, loc.y);
            fleet.addScript(new DistressCallNormalAssignmentAI(fleet, (StarSystemAPI)data.location, data.jumpPoint));
            return fleet;
        }
        return null;
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        FactionAPI playerFaction = playerFleet.getFaction();
        Color color = playerFaction.getColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color highlight = Misc.getHighlightColor();
        TextPanelAPI text = dialog.getTextPanel();
        MemoryAPI memory = BaseCommandPlugin.getEntityMemory(memoryMap);
        boolean tookCrew = memory.getBoolean("$playerTookDistressCrewRecently");
        if (action.equals("initDistress")) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
            MarketAPI source = Misc.getSourceMarket(fleet);
            float returnDistLY = 0.0f;
            returnDistLY = source != null ? Misc.getDistanceLY(fleet.getLocationInHyperspace(), source.getLocationInHyperspace()) : Misc.getDistanceLY(fleet.getLocationInHyperspace(), new Vector2f());
            int fuel = (int)(returnDistLY * Math.max(1.0f, fleet.getLogistics().getFuelCostPerLightYear()));
            if ((fuel = (int)((float)fuel * 0.5f)) < 10) {
                fuel = 10;
            }
            fuel = (int)(Math.ceil((float)fuel / 10.0f) * 10.0);
            int credits = fuel * (int)Global.getSettings().getFloat("distressCallFuelCost");
            int crew = (int)(fleet.getFleetData().getMinCrew() * 0.33f);
            int takeOnCrew = Math.min(crew, cargo.getFreeCrewSpace());
            memory.set("$distressFuel", fuel, 0.0f);
            memory.set("$distressCredits", Misc.getWithDGS(credits), 0.0f);
            memory.set("$distressCrewTakeOn", takeOnCrew, 0.0f);
            memory.set("$distressCrew", crew, 0.0f);
            if (memory.getBoolean("$distressTurnHostile")) {
                memory.set("$distressFuelHostileThreshold", fuel, 0.0f);
            }
        } else if (action.equals("takeDistressCrew")) {
            int needed;
            int crew = (int)memory.getFloat("$distressCrewTakeOn");
            boolean enough = crew >= (needed = (int)memory.getFloat("$distressCrew"));
            cargo.addCrew(crew);
            AddRemoveCommodity.addCommodityGainText("crew", crew, text);
            float repChange = crew / 20;
            if (repChange < 1.0f) {
                repChange = 1.0f;
            }
            if (repChange > 5.0f) {
                repChange = 5.0f;
            }
            this.adjustRep(repChange, null, dialog.getInteractionTarget().getActivePerson().getFaction(), dialog.getInteractionTarget().getActivePerson(), text);
            if (enough) {
                DistressCallNormalAssignmentAI.undistress(dialog.getInteractionTarget());
                CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
                DistressCallNormalAssignmentAI.scuttleShips(fleet, crew);
            }
        } else if (action.equals("sellDistressFuel")) {
            int fuel = (int)memory.getFloat("$distressFuel");
            int credits = (int)memory.getFloat("$distressCredits");
            cargo.removeFuel(fuel);
            cargo.getCredits().add(credits);
            AddRemoveCommodity.addCommodityLossText("fuel", fuel, text);
            AddRemoveCommodity.addCreditsGainText(credits, text);
            DistressCallNormalAssignmentAI.undistress(dialog.getInteractionTarget());
            if (tookCrew) {
                int crew = (int)memory.getFloat("$distressCrewTakeOn");
                float repChange = crew / 20;
                if (repChange < 1.0f) {
                    repChange = 1.0f;
                }
                if (repChange > 5.0f) {
                    repChange = 5.0f;
                }
                this.adjustRep(-repChange, RepLevel.INHOSPITABLE, dialog.getInteractionTarget().getActivePerson().getFaction(), dialog.getInteractionTarget().getActivePerson(), text);
            }
        } else if (action.equals("scaredDistressFuel")) {
            int fuel = (int)memory.getFloat("$distressFuel");
            cargo.removeFuel(fuel);
            AddRemoveCommodity.addCommodityLossText("fuel", fuel, text);
            DistressCallNormalAssignmentAI.undistress(dialog.getInteractionTarget());
        } else if (action.equals("giveDistressFuel")) {
            int fuel = (int)memory.getFloat("$distressFuel");
            int credits = (int)memory.getFloat("$distressCredits");
            cargo.removeFuel(fuel);
            AddRemoveCommodity.addCommodityLossText("fuel", fuel, text);
            if (!tookCrew) {
                float repChange = credits / 1000;
                if (repChange > 10.0f) {
                    repChange = 10.0f;
                }
                this.adjustRep(repChange, null, dialog.getInteractionTarget().getActivePerson().getFaction(), dialog.getInteractionTarget().getActivePerson(), text);
            }
            DistressCallNormalAssignmentAI.undistress(dialog.getInteractionTarget());
        }
        return true;
    }

    protected void adjustRep(float repChangePercent, RepLevel limit, FactionAPI faction, PersonAPI person, TextPanelAPI text) {
        if (repChangePercent != 0.0f) {
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = repChangePercent * 0.01f;
            impact.limit = limit;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true), faction.getId());
            if (person != null) {
                impact.delta *= 2.0f;
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true), person);
            }
        }
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        return null;
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        return super.getHighlightColors(stageId);
    }

    @Override
    public CampaignEventTarget getEventTarget() {
        return super.getEventTarget();
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    @Override
    public boolean showAllMessagesIfOngoing() {
        return false;
    }

    public static void main(String[] args) throws ParseException {
        Locale.setDefault(Locale.GERMAN);
        DecimalFormat format = new DecimalFormat("###,###,###,###,###");
        System.out.println(format.parse("25,000").floatValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistressEventType {
        NORMAL,
        PIRATE_AMBUSH,
        PIRATE_AMBUSH_TRAP,
        DERELICT_SHIP;

    }

    public static class NESpawnData {
        public DistressEventType type;
        public LocationAPI location;
        public SectorEntityToken jumpPoint;
    }
}

