/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.plugins.AutofitPlugin;
import com.fs.starfarer.api.plugins.impl.CoreAutofitPlugin;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFleetInflater
implements FleetInflater,
AutofitPlugin.AutofitPluginDelegate {
    public static float GOAL_VARIANT_PROBABILITY = 0.5f;
    protected DefaultFleetInflaterParams p;
    protected transient FleetMemberAPI currMember = null;
    protected transient ShipVariantAPI currVariant = null;
    protected transient List<AutofitPlugin.AvailableFighter> fighters;
    protected transient List<AutofitPlugin.AvailableWeapon> weapons;
    protected transient List<String> hullmods;
    protected transient CampaignFleetAPI fleet;
    protected transient FactionAPI faction;

    public DefaultFleetInflater(DefaultFleetInflaterParams p) {
        this.p = p;
    }

    public static float getTierProbability(int tier, float quality) {
        if (tier == 1) {
            return Math.min(0.9f, 0.75f + quality);
        }
        if (tier == 2) {
            return Math.min(0.9f, 0.5f + quality * 0.5f);
        }
        if (tier == 3) {
            return Math.min(0.9f, 0.25f + quality * 0.25f);
        }
        return 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inflate(CampaignFleetAPI fleet) {
        Random random = new Random();
        if (this.p.seed != null) {
            random = new Random(this.p.seed);
        }
        Random dmodRandom = new Random();
        if (this.p.seed != null) {
            dmodRandom = Misc.getRandom(this.p.seed, 5);
        }
        CoreAutofitPlugin auto = new CoreAutofitPlugin(fleet.getCommander());
        auto.setRandom(random);
        boolean upgrade = random.nextFloat() < Math.min(0.1f + this.p.quality * 0.5f, 0.5f);
        auto.setChecked(CoreAutofitPlugin.UPGRADE, upgrade);
        this.fleet = fleet;
        this.faction = fleet.getFaction();
        if (this.p.factionId != null) {
            this.faction = Global.getSector().getFaction(this.p.factionId);
        }
        this.hullmods = new ArrayList<String>(this.faction.getKnownHullMods());
        SortedWeapons nonPriorityWeapons = new SortedWeapons();
        SortedWeapons priorityWeapons = new SortedWeapons();
        LinkedHashSet<Object> weaponCategories = new LinkedHashSet<Object>();
        for (String weaponId : this.faction.getKnownWeapons()) {
            List<AutofitPlugin.AvailableWeapon> list;
            if (!this.faction.isWeaponKnownAt(weaponId, this.p.timestamp)) continue;
            WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(weaponId);
            if (spec == null) {
                throw new RuntimeException("Weapon with spec id [" + weaponId + "] not found");
            }
            int tier = spec.getTier();
            String cat = spec.getAutofitCategory();
            if (this.isPriority(spec)) {
                list = priorityWeapons.getWeapons(tier).getWeapons(cat).getWeapons(spec.getSize());
                list.add(new AvailableWeaponImpl(spec, 1000));
            } else {
                list = nonPriorityWeapons.getWeapons(tier).getWeapons(cat).getWeapons(spec.getSize());
                list.add(new AvailableWeaponImpl(spec, 1000));
            }
            weaponCategories.add(cat);
        }
        ListMap<AvailableFighterImpl> nonPriorityFighters = new ListMap<AvailableFighterImpl>();
        ListMap<AvailableFighterImpl> priorityFighters = new ListMap<AvailableFighterImpl>();
        LinkedHashSet<String> fighterCategories = new LinkedHashSet<String>();
        for (String wingId : this.faction.getKnownFighters()) {
            if (!this.faction.isFighterKnownAt(wingId, this.p.timestamp)) continue;
            FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
            if (spec == null) {
                throw new RuntimeException("Fighter wing with spec id [" + wingId + "] not found");
            }
            String cat = spec.getAutofitCategory();
            if (this.isPriority(spec)) {
                priorityFighters.add(cat, new AvailableFighterImpl(spec, 1000));
            } else {
                nonPriorityFighters.add(cat, new AvailableFighterImpl(spec, 1000));
            }
            fighterCategories.add(cat);
        }
        float averageDmods = DefaultFleetInflater.getAverageDmodsForQuality(this.p.quality);
        boolean forceAutofit = fleet.getMemoryWithoutUpdate().getBoolean("$overrideNoAutofit");
        int memberIndex = 0;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            int addDmods;
            boolean randomize;
            void var18_23;
            if (!forceAutofit && member.getHullSpec().hasTag("no_autofit") || !forceAutofit && member.getVariant() != null && member.getVariant().hasTag("no_autofit") || !this.faction.isPlayerFaction() && (!forceAutofit && member.getHullSpec().hasTag("no_autofit_unless_player") || !forceAutofit && member.getVariant() != null && member.getVariant().hasTag("no_autofit_unless_player"))) continue;
            if (this.p.seed != null) {
                int extra = member.getShipName().hashCode();
                random = new Random(this.p.seed * (long)extra);
                auto.setRandom(random);
                dmodRandom = Misc.getRandom(this.p.seed * (long)extra, 5);
            }
            ArrayList<WeaponAPI.WeaponSize> sizes = new ArrayList<WeaponAPI.WeaponSize>();
            sizes.add(WeaponAPI.WeaponSize.SMALL);
            sizes.add(WeaponAPI.WeaponSize.MEDIUM);
            sizes.add(WeaponAPI.WeaponSize.LARGE);
            this.weapons = new ArrayList<AutofitPlugin.AvailableWeapon>();
            for (String string : weaponCategories) {
                for (WeaponAPI.WeaponSize size : sizes) {
                    boolean foundSome = false;
                    int tier = 0;
                    while (tier < 4) {
                        boolean tierAvailable;
                        float p = DefaultFleetInflater.getTierProbability(tier, this.p.quality);
                        if (this.p.allWeapons != null && this.p.allWeapons.booleanValue()) {
                            p = 1.0f;
                        }
                        List<AutofitPlugin.AvailableWeapon> priority = priorityWeapons.getWeapons(tier).getWeapons(string).getWeapons(size);
                        List<AutofitPlugin.AvailableWeapon> nonPriority = nonPriorityWeapons.getWeapons(tier).getWeapons(string).getWeapons(size);
                        if (!foundSome) {
                            p = 1.0f;
                        }
                        boolean bl = tierAvailable = random.nextFloat() < p;
                        if (tierAvailable || !foundSome) {
                            AutofitPlugin.AvailableWeapon w;
                            int num = 2;
                            switch (size) {
                                case LARGE: {
                                    num = 2;
                                    break;
                                }
                                case MEDIUM: {
                                    num = 2;
                                    break;
                                }
                                case SMALL: {
                                    num = 2;
                                }
                            }
                            if (this.p.allWeapons != null && this.p.allWeapons.booleanValue()) {
                                num = 500;
                            }
                            Set<Integer> picks = DefaultFleetInflater.makePicks(num, priority.size(), random);
                            for (Integer index : picks) {
                                w = (AutofitPlugin.AvailableWeapon)priority.get(index);
                                this.weapons.add(w);
                                foundSome = true;
                            }
                            if ((num -= picks.size()) > 0) {
                                picks = DefaultFleetInflater.makePicks(num, nonPriority.size(), random);
                                for (Integer index : picks) {
                                    w = nonPriority.get(index);
                                    this.weapons.add(w);
                                    foundSome = true;
                                }
                            }
                        }
                        ++tier;
                    }
                }
            }
            this.fighters = new ArrayList<AutofitPlugin.AvailableFighter>();
            for (String string : fighterCategories) {
                int num;
                Object priority = priorityFighters.get(string);
                boolean madePriorityPicks = false;
                if (priority != null) {
                    num = random.nextInt(2) + 1;
                    if (this.p.allWeapons != null && this.p.allWeapons.booleanValue()) {
                        num = 100;
                    }
                    Set<Integer> picks = DefaultFleetInflater.makePicks(num, priority.size(), random);
                    for (Integer index : picks) {
                        AutofitPlugin.AvailableFighter f = (AutofitPlugin.AvailableFighter)priority.get(index);
                        this.fighters.add(f);
                        madePriorityPicks = true;
                    }
                }
                if (madePriorityPicks) continue;
                num = random.nextInt(2) + 1;
                if (this.p.allWeapons != null && this.p.allWeapons.booleanValue()) {
                    num = 100;
                }
                Object nonPriority = nonPriorityFighters.get(string);
                Set<Integer> picks = DefaultFleetInflater.makePicks(num, nonPriority.size(), random);
                for (Integer index : picks) {
                    AutofitPlugin.AvailableFighter f = (AutofitPlugin.AvailableFighter)nonPriority.get(index);
                    this.fighters.add(f);
                }
            }
            ShipVariantAPI shipVariantAPI = member.getVariant();
            if (shipVariantAPI.getOriginalVariant() != null) {
                ShipVariantAPI shipVariantAPI2 = Global.getSettings().getVariant(shipVariantAPI.getOriginalVariant());
            }
            if (this.faction.isPlayerFaction() && random.nextFloat() < GOAL_VARIANT_PROBABILITY) {
                List<ShipVariantAPI> targets = Global.getSector().getAutofitVariants().getTargetVariants(member.getHullId());
                WeightedRandomPicker<ShipVariantAPI> alts = new WeightedRandomPicker<ShipVariantAPI>(random);
                for (ShipVariantAPI curr : targets) {
                    void var18_30;
                    if (!curr.getHullSpec().getHullId().equals(var18_30.getHullSpec().getHullId())) continue;
                    alts.add(curr);
                }
                if (!alts.isEmpty()) {
                    ShipVariantAPI shipVariantAPI3 = (ShipVariantAPI)alts.pick();
                }
            }
            this.currVariant = Global.getSettings().createEmptyVariant(String.valueOf(fleet.getId()) + "_" + memberIndex, var18_23.getHullSpec());
            this.currMember = member;
            if (var18_23.isStockVariant()) {
                this.currVariant.setOriginalVariant(var18_23.getHullVariantId());
            }
            float rProb = this.faction.getDoctrine().getAutofitRandomizeProbability();
            if (this.p.rProb != null) {
                rProb = this.p.rProb.floatValue();
            }
            boolean bl = randomize = random.nextFloat() < rProb;
            if (member.isStation()) {
                randomize = false;
            }
            auto.setChecked(CoreAutofitPlugin.RANDOMIZE, randomize);
            ++memberIndex;
            int maxSmods = 0;
            if (this.p.averageSMods != null && !member.isCivilian()) {
                maxSmods = DefaultFleetInflater.getMaxSMods(this.currVariant, this.p.averageSMods, dmodRandom) - this.currVariant.getSMods().size();
            }
            auto.doFit(this.currVariant, (ShipVariantAPI)var18_23, maxSmods, this);
            this.currVariant.setSource(VariantSource.REFIT);
            member.setVariant(this.currVariant, false, false);
            if (this.currMember.isStation() || (addDmods = DefaultFleetInflater.getNumDModsToAdd(this.currVariant, averageDmods, dmodRandom)) <= 0) continue;
            DModManager.setDHull(this.currVariant);
            DModManager.addDMods(member, true, addDmods, dmodRandom);
        }
        fleet.getFleetData().setSyncNeeded();
        fleet.getFleetData().syncIfNeeded();
    }

    public static int getNumDModsToAdd(ShipVariantAPI variant, float averageDMods, Random random) {
        int dmods = (int)Math.round((double)averageDMods + random.nextDouble() * 3.0 - 2.0);
        if (dmods > 5) {
            dmods = 5;
        }
        int dmodsAlready = DModManager.getNumDMods(variant);
        return Math.max(0, dmods -= dmodsAlready);
    }

    public static int getMaxSMods(ShipVariantAPI variant, int averageSMods, Random random) {
        float f = random.nextFloat();
        int sMods = averageSMods;
        if (f < 0.25f) {
            sMods = averageSMods - 1;
        } else if (f < 0.5f) {
            sMods = averageSMods + 1;
        }
        if (sMods > 3) {
            sMods = 3;
        }
        if (sMods < 0) {
            sMods = 0;
        }
        return sMods;
    }

    public static float getAverageDmodsForQuality(float quality) {
        float averageDmods = (1.0f - quality) / Global.getSettings().getFloat("qualityPerDMod");
        return averageDmods;
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Integer> makePicks(int num, int max, Random random) {
        if (num > max) {
            num = max;
        }
        result = new LinkedHashSet<Integer>();
        if (num == 0) {
            return result;
        }
        if (num != max) ** GOTO lbl17
        i = 0;
        while (i < max) {
            result.add(i);
            ++i;
        }
        return result;
lbl-1000:
        // 1 sources

        {
            add = random.nextInt(max);
            result.add(add);
lbl17:
            // 2 sources

            ** while (result.size() < num)
        }
lbl18:
        // 1 sources

        return result;
    }

    @Override
    public boolean removeAfterInflating() {
        return this.p.persistent == null || this.p.persistent == false;
    }

    @Override
    public void setRemoveAfterInflating(boolean removeAfterInflating) {
        this.p.persistent = !removeAfterInflating;
        if (!this.p.persistent.booleanValue()) {
            this.p.persistent = null;
        }
    }

    @Override
    public void clearFighterSlot(int index, ShipVariantAPI variant) {
        variant.setWingId(index, null);
        for (AutofitPlugin.AvailableFighter curr : this.fighters) {
            if (!curr.getId().equals(curr.getId())) continue;
            curr.setQuantity(curr.getQuantity() + 1);
            break;
        }
    }

    @Override
    public void clearWeaponSlot(WeaponSlotAPI slot, ShipVariantAPI variant) {
        variant.clearSlot(slot.getId());
        for (AutofitPlugin.AvailableWeapon curr : this.weapons) {
            if (!curr.getId().equals(curr.getId())) continue;
            curr.setQuantity(curr.getQuantity() + 1);
            break;
        }
    }

    @Override
    public void fitFighterInSlot(int index, AutofitPlugin.AvailableFighter fighter, ShipVariantAPI variant) {
        fighter.setQuantity(fighter.getQuantity() - 1);
        variant.setWingId(index, fighter.getId());
    }

    @Override
    public void fitWeaponInSlot(WeaponSlotAPI slot, AutofitPlugin.AvailableWeapon weapon, ShipVariantAPI variant) {
        weapon.setQuantity(weapon.getQuantity() - 1);
        variant.addWeapon(slot.getId(), weapon.getId());
    }

    @Override
    public List<AutofitPlugin.AvailableFighter> getAvailableFighters() {
        return this.fighters;
    }

    @Override
    public List<AutofitPlugin.AvailableWeapon> getAvailableWeapons() {
        return this.weapons;
    }

    @Override
    public List<String> getAvailableHullmods() {
        return this.hullmods;
    }

    @Override
    public ShipAPI getShip() {
        return null;
    }

    @Override
    public void syncUIWithVariant(ShipVariantAPI variant) {
    }

    @Override
    public boolean isPriority(WeaponSpecAPI weapon) {
        return this.faction.isWeaponPriority(weapon.getWeaponId());
    }

    @Override
    public boolean isPriority(FighterWingSpecAPI wing) {
        return this.faction.isFighterPriority(wing.getId());
    }

    public FleetMemberAPI getMember() {
        return this.currMember;
    }

    public static void main(String[] args) {
        Random random = new Random();
        float total = 0.0f;
        float num = 1000.0f;
        int[] counts = new int[10];
        int i = 0;
        while ((float)i < num) {
            int dmods = 1;
            total += (float)dmods;
            int n = dmods;
            counts[n] = counts[n] + 1;
            ++i;
        }
        System.out.println("Average dmods: " + total / num);
        i = 0;
        while (i <= 5) {
            System.out.println(String.valueOf(i) + ":" + counts[i]);
            ++i;
        }
    }

    @Override
    public FactionAPI getFaction() {
        return this.faction;
    }

    public Long getSeed() {
        return this.p.seed;
    }

    public void setSeed(Long seed) {
        this.p.seed = seed;
    }

    public Boolean getPersistent() {
        return this.p.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.p.persistent = persistent;
    }

    @Override
    public float getQuality() {
        return this.p.quality;
    }

    @Override
    public int getAverageNumSMods() {
        return this.p.averageSMods == null ? 0 : this.p.averageSMods;
    }

    @Override
    public void setQuality(float quality) {
        this.p.quality = quality;
    }

    public Long getTimestamp() {
        return this.p.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.p.timestamp = timestamp;
    }

    @Override
    public Object getParams() {
        return this.p;
    }

    @Override
    public boolean canAddRemoveHullmodInPlayerCampaignRefit(String modId) {
        return true;
    }

    @Override
    public boolean isPlayerCampaignRefit() {
        return false;
    }

    @Override
    public boolean isAllowSlightRandomization() {
        return true;
    }

    public static class AvailableFighterImpl
    implements AutofitPlugin.AvailableFighter {
        protected FighterWingSpecAPI spec;
        protected int quantity = 0;

        public AvailableFighterImpl(FighterWingSpecAPI spec, int quantity) {
            this.spec = spec;
            this.quantity = quantity;
        }

        public AvailableFighterImpl(String wingId, int quantity) {
            this.spec = Global.getSettings().getFighterWingSpec(wingId);
            this.quantity = quantity;
        }

        public String getId() {
            return this.spec.getId();
        }

        public float getPrice() {
            return 0.0f;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public CargoAPI getSource() {
            return null;
        }

        public SubmarketAPI getSubmarket() {
            return null;
        }

        public FighterWingSpecAPI getWingSpec() {
            return this.spec;
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }
    }

    public static class AvailableWeaponImpl
    implements AutofitPlugin.AvailableWeapon {
        protected WeaponSpecAPI spec;
        protected int quantity = 0;
        protected MutableShipStatsAPI savedCostStats = null;
        protected float cachedOPCost = -1.0f;

        public AvailableWeaponImpl(WeaponSpecAPI spec, int quantity) {
            this.spec = spec;
            this.quantity = quantity;
        }

        public String getId() {
            return this.spec.getWeaponId();
        }

        public float getPrice() {
            return 0.0f;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public CargoAPI getSource() {
            return null;
        }

        public SubmarketAPI getSubmarket() {
            return null;
        }

        public WeaponSpecAPI getSpec() {
            return this.spec;
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        public float getOPCost(MutableCharacterStatsAPI stats, MutableShipStatsAPI shipStats) {
            if (this.savedCostStats == shipStats && this.cachedOPCost >= 0.0f) {
                return this.cachedOPCost;
            }
            this.cachedOPCost = this.spec.getOrdnancePointCost(stats, shipStats);
            this.savedCostStats = shipStats;
            return this.cachedOPCost;
        }
    }

    public static class SortedWeapons {
        protected Map<Integer, WeaponsForTier> tierMap = new LinkedHashMap<Integer, WeaponsForTier>();

        public WeaponsForTier getWeapons(int tier) {
            WeaponsForTier data = this.tierMap.get(tier);
            if (data == null) {
                data = new WeaponsForTier();
                this.tierMap.put(tier, data);
            }
            return data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeaponsForSize {
        protected Map<WeaponAPI.WeaponSize, List<AutofitPlugin.AvailableWeapon>> sizeMap = new LinkedHashMap<WeaponAPI.WeaponSize, List<AutofitPlugin.AvailableWeapon>>();

        public List<AutofitPlugin.AvailableWeapon> getWeapons(WeaponAPI.WeaponSize size) {
            List<AutofitPlugin.AvailableWeapon> list = this.sizeMap.get((Object)size);
            if (list == null) {
                list = new ArrayList<AutofitPlugin.AvailableWeapon>();
                this.sizeMap.put(size, list);
            }
            return list;
        }
    }

    public static class WeaponsForTier {
        protected Map<String, WeaponsForSize> catMap = new LinkedHashMap<String, WeaponsForSize>();

        public WeaponsForSize getWeapons(String cat) {
            WeaponsForSize size = this.catMap.get(cat);
            if (size == null) {
                size = new WeaponsForSize();
                this.catMap.put(cat, size);
            }
            return size;
        }
    }
}

