/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DisposableAggroAssignmentAI
implements EveryFrameScript {
    protected StarSystemAPI system;
    protected CampaignFleetAPI fleet;
    protected DisposableFleetManager manager;

    public DisposableAggroAssignmentAI(CampaignFleetAPI fleet, StarSystemAPI system, DisposableFleetManager manager, float probStayInHyper) {
        this.fleet = fleet;
        this.system = system;
        this.manager = manager;
        this.giveInitialAssignments(probStayInHyper);
    }

    protected void giveInitialAssignments(float probStayInHyper) {
        boolean playerInSameLocation = this.fleet.getContainingLocation() == Global.getSector().getCurrentLocation();
        SectorEntityToken target = null;
        if (!playerInSameLocation && !this.fleet.isInHyperspace()) {
            target = DisposableAggroAssignmentAI.pickEntityToGuard(new Random(), this.system, this.fleet);
            if (target != null) {
                Vector2f loc = Misc.getPointAtRadius(target.getLocation(), target.getRadius() + 100.0f);
                this.fleet.setLocation(loc.x, loc.y);
            } else {
                Vector2f loc = Misc.getPointAtRadius(new Vector2f(), 5000.0f);
                this.fleet.setLocation(loc.x, loc.y);
            }
        } else if (this.fleet.isInHyperspace()) {
            SectorEntityToken from = Misc.getSourceEntity(this.fleet);
            if (from != null && this.system != null) {
                float angle = Misc.getAngleInDegrees(this.system.getLocation(), from.getLocationInHyperspace());
                float arc = 90.0f;
                angle = angle - arc / 2.0f + arc * (float)Math.random();
                float dist = (float)Global.getSettings().getMaxSensorRangeHyper() + 1000.0f;
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
                loc.scale(dist);
                Vector2f.add((Vector2f)loc, (Vector2f)this.system.getLocation(), (Vector2f)loc);
                loc = Misc.pickHyperLocationNotNearPlayer(new Vector2f((ReadableVector2f)loc), (float)Global.getSettings().getMaxSensorRangeHyper() + 500.0f);
                this.fleet.setLocation(loc.x, loc.y);
            } else {
                Vector2f loc = Misc.pickHyperLocationNotNearPlayer(this.system.getLocation(), (float)Global.getSettings().getMaxSensorRangeHyper() + 500.0f);
                this.fleet.setLocation(loc.x, loc.y);
            }
        } else {
            target = DisposableAggroAssignmentAI.pickEntityToGuard(new Random(), this.system, this.fleet);
            Vector2f loc = new Vector2f(5000.0f, 0.0f);
            if (target != null) {
                Vector2f from = target.getLocation();
                loc = Misc.pickLocationNotNearPlayer(this.system, from, (float)Global.getSettings().getMaxSensorRange() + 500.0f);
            } else {
                loc = Misc.pickLocationNotNearPlayer(this.system, Misc.getPointAtRadius(new Vector2f(0.0f, 0.0f), 8000.0f), (float)Global.getSettings().getMaxSensorRange() + 500.0f);
            }
            this.fleet.setLocation(loc.x, loc.y);
        }
        this.pickNext(target, probStayInHyper);
    }

    protected void pickNext(SectorEntityToken target, float probStayInHyper) {
        if (this.fleet.isInHyperspace()) {
            Vector2f dest = Misc.getPointAtRadius(this.system.getLocation(), 1000.0f);
            LocationAPI hyper = Global.getSector().getHyperspace();
            SectorEntityToken token = hyper.createToken(dest.x, dest.y);
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, token, 1000.0f, this.manager.getTravelText(this.system, this.fleet));
        }
        if (this.fleet.isInHyperspace() && (float)Math.random() < probStayInHyper) {
            this.fleet.addAssignment(FleetAssignment.RAID_SYSTEM, this.system.getHyperspaceAnchor(), 10000.0f, this.manager.getActionOutsideText(this.system, this.fleet));
        } else {
            if (target == null) {
                target = DisposableAggroAssignmentAI.pickEntityToGuard(new Random(), this.system, this.fleet);
            }
            if (target != null) {
                float speed = Misc.getSpeedForBurnLevel(8.0f);
                float dist = Misc.getDistance(this.fleet.getLocation(), target.getLocation());
                float seconds = dist / speed;
                float days = seconds / Global.getSector().getClock().getSecondsPerDay();
                this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, target, days += 30.0f + 10.0f * (float)Math.random(), this.manager.getActionInsideText(this.system, this.fleet));
                return;
            }
            float days = 5.0f + 5.0f * (float)Math.random();
            this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, null, days, this.manager.getActionInsideText(this.system, this.fleet));
        }
    }

    public void advance(float amount) {
        if (this.fleet.getCurrentAssignment() == null) {
            this.pickNext(null, 0.0f);
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static SectorEntityToken pickEntityToGuard(Random random, StarSystemAPI system, CampaignFleetAPI fleet) {
        float mult;
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(random);
        for (SectorEntityToken entity : system.getJumpPoints()) {
            mult = DisposableAggroAssignmentAI.getWeightMultForPatrols(system, fleet, entity);
            picker.add(entity, 5.0f * mult);
        }
        for (PlanetAPI planet : system.getPlanets()) {
            if (!planet.isGasGiant()) continue;
            mult = DisposableAggroAssignmentAI.getWeightMultForPatrols(system, fleet, planet);
            picker.add(planet, 5.0f * mult);
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarkets(system)) {
            if (market.getFaction() != fleet.getFaction()) continue;
            mult = DisposableAggroAssignmentAI.getWeightMultForPatrols(system, fleet, market.getPrimaryEntity());
            picker.add(market.getPrimaryEntity(), 5.0f * mult);
        }
        return (SectorEntityToken)picker.pick();
    }

    public static float getWeightMultForPatrols(StarSystemAPI system, CampaignFleetAPI fleet, SectorEntityToken entity) {
        float count = DisposableAggroAssignmentAI.countNearbyPatrols(system, fleet, entity);
        return 1.0f / (count * 10.0f + 1.0f);
    }

    public static float countNearbyPatrols(StarSystemAPI system, CampaignFleetAPI fleet, SectorEntityToken entity) {
        float count = 0.0f;
        for (CampaignFleetAPI other : system.getFleets()) {
            float dist = Misc.getDistance(other, entity);
            if (dist > 3000.0f || !Misc.isPatrol(other) || !fleet.isHostileTo(other)) continue;
            count += 1.0f;
        }
        return count;
    }
}

