/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableAggroAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.PlayerVisibleFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.util.LinkedHashMap;

public abstract class DisposableFleetManager
extends PlayerVisibleFleetManager {
    public static boolean DEBUG = false;
    public static final String KEY_SYSTEM = "$core_disposableFleetSpawnSystem";
    public static final String KEY_SPAWN_FP = "$core_disposableFleetSpawnFP";
    public static final float MAX_RANGE_FROM_PLAYER_LY = RouteManager.SPAWN_DIST_LY;
    public static final float DESPAWN_RANGE_LY = MAX_RANGE_FROM_PLAYER_LY + 1.4f;
    protected IntervalUtil tracker2 = new IntervalUtil(0.75f, 1.25f);
    protected LinkedHashMap<String, TimeoutTracker<Boolean>> recentSpawns = new LinkedHashMap();
    protected float spawnRateMult = 1.0f;
    protected StarSystemAPI currSpawnLoc = null;

    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    protected float getExpireDaysPerFleet() {
        return 30.0f;
    }

    protected String getSpawnKey(StarSystemAPI system) {
        return "$core_recentSpawn_" + this.getSpawnId() + "_" + system.getName();
    }

    protected void addRecentSpawn(StarSystemAPI system) {
        String key = this.getSpawnKey(system);
        float e = Global.getSector().getMemoryWithoutUpdate().getExpire(key);
        if (e < 0.0f) {
            e = 0.0f;
        }
        Global.getSector().getMemoryWithoutUpdate().set(key, true);
        Global.getSector().getMemoryWithoutUpdate().expire(key, e += this.getExpireDaysPerFleet());
    }

    protected float getRecentSpawnsForSystem(StarSystemAPI system) {
        String key = this.getSpawnKey(system);
        float e = Global.getSector().getMemoryWithoutUpdate().getExpire(key);
        if (e < 0.0f) {
            e = 0.0f;
        }
        return e / this.getExpireDaysPerFleet();
    }

    protected int getMaxFleets() {
        return 100;
    }

    protected boolean isOkToDespawnAssumingNotPlayerVisible(CampaignFleetAPI fleet) {
        if (this.currSpawnLoc == null) {
            return true;
        }
        String system = fleet.getMemoryWithoutUpdate().getString(KEY_SYSTEM);
        float spawnFP = fleet.getMemoryWithoutUpdate().getFloat(KEY_SPAWN_FP);
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float playerFP = player.getFleetPoints();
        if (system == null || !system.equals(this.currSpawnLoc.getName())) {
            return true;
        }
        if (spawnFP >= (float)fleet.getFleetPoints() * 2.0f) {
            if (fleet.getAI() instanceof CampaignFleetAIAPI) {
                CampaignFleetAIAPI ai = fleet.getAI();
                CampaignFleetAIAPI.EncounterOption option = ai.pickEncounterOption(null, player, true);
                if (option == CampaignFleetAIAPI.EncounterOption.DISENGAGE) {
                    return true;
                }
            } else {
                return (float)fleet.getFleetPoints() <= playerFP * 0.5f;
            }
        }
        return false;
    }

    public float getSpawnRateMult() {
        return this.spawnRateMult;
    }

    public void advance(float amount) {
        if (TutorialMissionIntel.isTutorialInProgress()) {
            return;
        }
        super.advance(amount);
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (DEBUG) {
            days *= 100.0f;
        }
        this.tracker2.advance(days);
        if (this.tracker2.intervalElapsed()) {
            StarSystemAPI closest = this.pickCurrentSpawnLocation();
            if (closest != this.currSpawnLoc) {
                this.currSpawnLoc = closest;
            }
            for (BaseLimitedFleetManager.ManagedFleetData data : this.active) {
                float spawnFP;
                float fp;
                if (Misc.isFleetReturningToDespawn(data.fleet) || !((fp = (float)data.fleet.getFleetPoints()) < (spawnFP = data.fleet.getMemoryWithoutUpdate().getFloat(KEY_SPAWN_FP)) * 0.33f)) continue;
                Misc.giveStandardReturnToSourceAssignments(data.fleet);
            }
            this.updateSpawnRateMult();
        }
    }

    public StarSystemAPI getCurrSpawnLoc() {
        return this.currSpawnLoc;
    }

    protected void updateSpawnRateMult() {
        if (this.currSpawnLoc == null) {
            if (DEBUG) {
                System.out.println("No target system, spawnRateMult is 1");
            }
            this.spawnRateMult = 1.0f;
            return;
        }
        float desiredNumFleets = this.getDesiredNumFleetsForSpawnLocation();
        float recentSpawns = this.getRecentSpawnsForSystem(this.currSpawnLoc);
        if (this.active != null) {
            float activeInSystem = 0.0f;
            for (BaseLimitedFleetManager.ManagedFleetData data : this.active) {
                if (data.spawnedFor != this.currSpawnLoc && data.fleet.getContainingLocation() != this.currSpawnLoc) continue;
                activeInSystem += 1.0f;
            }
            recentSpawns = Math.max(recentSpawns, activeInSystem);
        }
        this.spawnRateMult = (float)Math.pow(Math.max(0.0f, (desiredNumFleets - recentSpawns) * 1.0f), 4.0);
        if (this.spawnRateMult < 0.0f) {
            this.spawnRateMult = 0.0f;
        }
        if (DEBUG) {
            System.out.println(String.format("ID: %s, system: %s, recent: %s, desired: %s, spawnRateMult: %s", this.getSpawnId(), this.currSpawnLoc.getName(), "" + recentSpawns, "" + desiredNumFleets, "" + this.spawnRateMult));
        }
    }

    protected abstract int getDesiredNumFleetsForSpawnLocation();

    protected abstract CampaignFleetAPI spawnFleetImpl();

    protected abstract String getSpawnId();

    protected StarSystemAPI pickCurrentSpawnLocation() {
        return this.pickNearestPopulatedSystem();
    }

    protected StarSystemAPI pickNearestPopulatedSystem() {
        float distToPlayerLY;
        if (Global.getSector().isInNewGameAdvance()) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        StarSystemAPI nearest = null;
        float minDist = Float.MAX_VALUE;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            float distToPlayerLY2;
            if (market.isHidden() || market.getStarSystem() != null && market.getStarSystem().hasTag("system_abyssal") || market.isPlayerOwned() && market.getSize() <= 3 || !market.hasSpaceport() || (distToPlayerLY2 = Misc.getDistanceLY(player.getLocationInHyperspace(), market.getLocationInHyperspace())) > MAX_RANGE_FROM_PLAYER_LY || !(distToPlayerLY2 < minDist) || market.getStarSystem() == null || market.getStarSystem().getStar() != null && market.getStarSystem().getStar().getSpec().isPulsar()) continue;
            nearest = market.getStarSystem();
            minDist = distToPlayerLY2;
        }
        if (nearest == null && this.currSpawnLoc != null && (distToPlayerLY = Misc.getDistanceLY(player.getLocationInHyperspace(), this.currSpawnLoc.getLocation())) <= DESPAWN_RANGE_LY) {
            nearest = this.currSpawnLoc;
        }
        return nearest;
    }

    public CampaignFleetAPI spawnFleet() {
        if (this.currSpawnLoc == null) {
            return null;
        }
        if (Global.getSector().getPlayerFleet() != null && Global.getSector().getPlayerFleet().isInHyperspaceTransition()) {
            return null;
        }
        CampaignFleetAPI fleet = this.spawnFleetImpl();
        if (fleet != null) {
            fleet.getMemoryWithoutUpdate().set(KEY_SYSTEM, this.currSpawnLoc.getName());
            fleet.getMemoryWithoutUpdate().set(KEY_SPAWN_FP, fleet.getFleetPoints());
        }
        this.addRecentSpawn(this.currSpawnLoc);
        this.updateSpawnRateMult();
        return fleet;
    }

    protected String getTravelText(StarSystemAPI system, CampaignFleetAPI fleet) {
        return "\u6b63\u5728\u524d\u5f80 " + system.getBaseName() + " \u661f\u7cfb";
    }

    protected String getActionInsideText(StarSystemAPI system, CampaignFleetAPI fleet) {
        boolean patrol = fleet.getMemoryWithoutUpdate().getBoolean("$isPatrol");
        String verb = "\u6b63\u5728\u63a0\u593a";
        if (patrol) {
            verb = "\u6b63\u5728\u5de1\u903b";
        }
        return String.valueOf(verb) + " " + system.getBaseName() + " \u661f\u7cfb";
    }

    protected String getActionOutsideText(StarSystemAPI system, CampaignFleetAPI fleet) {
        boolean patrol = fleet.getMemoryWithoutUpdate().getBoolean("$isPatrol");
        String verb = "\u6b63\u5728\u63a0\u593a";
        if (patrol) {
            verb = "\u6b63\u5728\u5de1\u903b";
        }
        return String.valueOf(verb) + " " + system.getBaseName() + " \u661f\u7cfb";
    }

    protected void setLocationAndOrders(CampaignFleetAPI fleet, float probStartInHyper, float probStayInHyper) {
        StarSystemAPI system = this.getCurrSpawnLoc();
        if ((float)Math.random() < probStartInHyper || Global.getSector().getPlayerFleet() != null && Global.getSector().getPlayerFleet().isInHyperspace()) {
            Global.getSector().getHyperspace().addEntity(fleet);
        } else {
            system.addEntity(fleet);
        }
        fleet.addScript(new DisposableAggroAssignmentAI(fleet, system, this, probStayInHyper));
    }
}

