/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCells;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.util.Misc;

public class DisposableLuddicPathFleetManager
extends DisposableFleetManager {
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    protected String getSpawnId() {
        return "luddic_path";
    }

    protected int getDesiredNumFleetsForSpawnLocation() {
        MarketAPI pather = this.getLargestMarket("luddic_path");
        MarketAPI church = this.getLargestMarket("luddic_church");
        float desiredNumFleets = 1.0f;
        if (church != null) {
            desiredNumFleets += 1.0f;
        }
        if (pather != null) {
            desiredNumFleets += (float)pather.getSize();
        }
        int cells = this.getPatherCellsLevel();
        return Math.round(desiredNumFleets += (float)cells);
    }

    protected int getPatherCellsLevel() {
        if (this.currSpawnLoc == null) {
            return 0;
        }
        int total = 0;
        for (MarketAPI market : Global.getSector().getEconomy().getMarkets(this.currSpawnLoc)) {
            LuddicPathCells cells;
            MarketConditionAPI mc;
            if (market.isHidden() || (mc = market.getCondition("pather_cells")) == null || !(mc.getPlugin() instanceof LuddicPathCells) || (cells = (LuddicPathCells)mc.getPlugin()).getIntel() == null) continue;
            if (cells.getIntel().isSleeper()) {
                ++total;
                continue;
            }
            total += 2;
        }
        return 0;
    }

    protected MarketAPI getLargestMarket(String faction) {
        if (this.currSpawnLoc == null) {
            return null;
        }
        MarketAPI largest = null;
        int maxSize = 0;
        for (MarketAPI market : Global.getSector().getEconomy().getMarkets(this.currSpawnLoc)) {
            if (market.isHidden() || !market.getFactionId().equals(faction) || market.getSize() <= maxSize) continue;
            maxSize = market.getSize();
            largest = market;
        }
        return largest;
    }

    protected CampaignFleetAPI spawnFleetImpl() {
        StarSystemAPI system = this.currSpawnLoc;
        if (system == null) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        int num = Misc.getMarketsInLocation(system).size();
        if (Misc.getMarketsInLocation(system, "player").size() == num && num > 0) {
            return null;
        }
        String fleetType = "patrolSmall";
        float combat = 1.0f;
        int i = 0;
        while (i < 3) {
            if ((float)Math.random() > 0.5f) {
                combat += 1.0f;
            }
            ++i;
        }
        float desired = this.getDesiredNumFleetsForSpawnLocation();
        if (desired > 2.0f) {
            float timeFactor = (PirateBaseManager.getInstance().getDaysSinceStart() - 180.0f) / 730.0f;
            if (timeFactor < 0.0f) {
                timeFactor = 0.0f;
            }
            if (timeFactor > 1.0f) {
                timeFactor = 1.0f;
            }
            combat += (desired - 2.0f) * (0.5f + (float)Math.random() * 0.5f) * 1.0f * timeFactor;
        }
        FleetParamsV3 params = new FleetParamsV3(null, system.getLocation(), "luddic_path", null, fleetType, combat *= 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        params.ignoreMarketFleetSizeMult = true;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$core_fleetNoMilitaryResponse", true);
        float nf = this.getDesiredNumFleetsForSpawnLocation();
        if (nf == 1.0f) {
            this.setLocationAndOrders(fleet, 1.0f, 1.0f);
        } else {
            this.setLocationAndOrders(fleet, 0.5f, 1.0f);
        }
        return fleet;
    }
}

