/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.FactoryAPI;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FleetFactory {
    public static Logger log = Global.getLogger(FleetFactory.class);
    private static List<String> startingAbilities = null;
    public static final float SUPPLIES_FRACTION = 0.0f;
    public static final float FUEL_FRACTION = 0.0f;

    public static CampaignFleetAPI createPatrol(MarketAPI market, PatrolType type) {
        float stability = market.getStabilityValue();
        String factionId = market.getFactionId();
        FactionAPI faction = Global.getSector().getFaction(factionId);
        float qf = market.getShipQualityFactor();
        return FleetFactory.createPatrol(type, faction, stability, qf, market);
    }

    public static CampaignFleetAPI createPatrol(PatrolType type, FactionAPI faction, float stability, float qf, MarketAPI market) {
        String fleetType = "patrolSmall";
        switch (type) {
            case FAST: {
                fleetType = "patrolSmall";
                break;
            }
            case COMBAT: {
                fleetType = "patrolMedium";
                break;
            }
            case HEAVY: {
                fleetType = "patrolLarge";
            }
        }
        CampaignFleetAPI fleet = FleetFactory.createEmptyFleet(faction.getId(), fleetType, market);
        switch (type) {
            case FAST: {
                faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability > (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                break;
            }
            case COMBAT: {
                faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("freighterSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("tankerSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability > (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                break;
            }
            case HEAVY: {
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                if ((float)Math.random() > 0.5f) {
                    faction.pickShipAndAddToFleet("carrierMedium", FactionAPI.ShipPickParams.all(), fleet);
                } else {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("combatLarge", FactionAPI.ShipPickParams.all(), fleet);
                }
                faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("combatLarge", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("freighterMedium", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("tankerMedium", FactionAPI.ShipPickParams.all(), fleet);
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability > (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability > (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("combatLarge", FactionAPI.ShipPickParams.all(), fleet);
            }
        }
        FleetFactory.setAIMode(fleet, true);
        return fleet;
    }

    public static CampaignFleetAPI createMerc(MarketAPI market, float qf, MercType type, String factionIdForShipPicking) {
        float stability = market.getStabilityValue();
        String factionId = "independent";
        FactionAPI faction = Global.getSector().getFaction(factionIdForShipPicking);
        CampaignFleetAPI fleet = FleetFactory.createEmptyFleet(factionIdForShipPicking, type.fleetType, market);
        switch (type) {
            case SCOUT: {
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                if ((float)Math.random() > 0.5f) {
                    faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability < (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                break;
            }
            case PRIVATEER: {
                faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability < (float)Math.random() * 20.0f)) break;
                if ((float)Math.random() > 0.5f) {
                    faction.pickShipAndAddToFleet("combatFreighterMedium", FactionAPI.ShipPickParams.all(), fleet);
                    break;
                }
                faction.pickShipAndAddToFleet("freighterMedium", FactionAPI.ShipPickParams.all(), fleet);
                break;
            }
            case BOUNTY_HUNTER: {
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                if ((float)Math.random() > 0.5f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("fastAttack", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability < (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("tankerSmall", FactionAPI.ShipPickParams.all(), fleet);
                break;
            }
            case PATROL: {
                if ((float)Math.random() > 0.33f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("escortSmall", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                } else {
                    faction.pickShipAndAddToFleet("carrierSmall", FactionAPI.ShipPickParams.all(), fleet);
                    if (stability < (float)Math.random() * 20.0f) {
                        faction.pickShipAndAddToFleet("carrierSmall", FactionAPI.ShipPickParams.all(), fleet);
                    }
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("escortSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("escortSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("freighterMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability < (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("tankerSmall", FactionAPI.ShipPickParams.all(), fleet);
                break;
            }
            case ARMADA: {
                if ((float)Math.random() > 0.33f) {
                    faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("escortSmall", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("escortMedium", FactionAPI.ShipPickParams.all(), fleet);
                    faction.pickShipAndAddToFleet("combatLarge", FactionAPI.ShipPickParams.all(), fleet);
                } else {
                    faction.pickShipAndAddToFleet("carrierMedium", FactionAPI.ShipPickParams.all(), fleet);
                    if (stability < (float)Math.random() * 20.0f) {
                        faction.pickShipAndAddToFleet("carrierSmall", FactionAPI.ShipPickParams.all(), fleet);
                    }
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("escortMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatLarge", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("escortSmall", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("combatMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (stability < (float)Math.random() * 20.0f) {
                    faction.pickShipAndAddToFleet("freighterMedium", FactionAPI.ShipPickParams.all(), fleet);
                }
                if (!(stability < (float)Math.random() * 20.0f)) break;
                faction.pickShipAndAddToFleet("tankerMedium", FactionAPI.ShipPickParams.all(), fleet);
            }
        }
        FleetFactory.setAIMode(fleet, true);
        return fleet;
    }

    public static CampaignFleetAPI createEmptyFleet(String factionId, String fleetType, MarketAPI market) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        String fleetName = null;
        if (fleetType != null) {
            fleetName = faction.getFleetTypeName(fleetType);
        }
        CampaignFleetAPI fleet = Global.getFactory().createEmptyFleet(factionId, fleetName, true);
        if (fleetType != null) {
            fleet.getMemoryWithoutUpdate().set("$fleetType", fleetType);
        }
        if (market != null) {
            fleet.getMemoryWithoutUpdate().set("$sourceMarket", market.getId());
        }
        if (startingAbilities == null) {
            startingAbilities = new ArrayList<String>();
            for (String id : Global.getSettings().getSortedAbilityIds()) {
                AbilitySpecAPI spec = Global.getSettings().getAbilitySpec(id);
                if (!spec.isAIDefault()) continue;
                startingAbilities.add(id);
            }
        }
        for (String id : startingAbilities) {
            fleet.addAbility(id);
        }
        return fleet;
    }

    public static void finishAndSync(CampaignFleetAPI fleet) {
        FleetFactory.setAIMode(fleet, false);
    }

    private static void setAIMode(CampaignFleetAPI fleet, boolean addSuppliesAndFuel) {
        fleet.forceSync();
    }

    public static CampaignFleetAPI createGenericFleet(String factionId, String name, float qualityFactor, int maxFP) {
        boolean added;
        String role;
        FactionAPI faction = Global.getSector().getFaction(factionId);
        CampaignFleetAPI fleet = Global.getFactory().createEmptyFleet(factionId, name, true);
        WeightedRandomPicker<String> main = new WeightedRandomPicker<String>();
        main.add("combatSmall", 5.0f);
        main.add("combatSmall", 5.0f);
        main.add("escortSmall", 6.0f);
        main.add("combatSmall", 20.0f);
        main.add("fastAttack", 10.0f);
        if (maxFP >= 20) {
            main.add("combatMedium", 10.0f);
            main.add("escortMedium", 10.0f);
        }
        if (maxFP >= 40) {
            main.add("combatLarge", 5.0f);
            main.add("combatSmall", 5.0f);
        }
        if (maxFP >= 60) {
            main.add("combatLarge", 5.0f);
            main.add("combatCapital", 3.0f);
        }
        int failCount = 0;
        while ((float)fleet.getFleetPoints() < (float)maxFP * 0.75f) {
            boolean added2;
            String role2 = (String)main.pick();
            boolean bl = added2 = faction.pickShipAndAddToFleet(role2, FactionAPI.ShipPickParams.all(), fleet) > 0.0f;
            if (added2) {
                failCount = 0;
                continue;
            }
            if (++failCount >= 10) break;
        }
        if (fleet.getFlagship() == null) {
            faction.pickShipAndAddToFleet("combatSmall", FactionAPI.ShipPickParams.all(), fleet);
            if (fleet.getFlagship() == null) {
                FactoryAPI f = Global.getFactory();
                FleetMemberAPI flagship = f.createFleetMember(FleetMemberType.SHIP, "tempest_Attack");
                fleet.getFleetData().addFleetMember(flagship);
            }
        }
        int fighterFP = 0;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (!member.isFighterWing()) continue;
            fighterFP += member.getFleetPointCost();
        }
        float pointsLeft = maxFP - fleet.getFleetPoints();
        float carrierPoints = Math.min(pointsLeft, (float)fighterFP * 0.33f);
        WeightedRandomPicker<String> carriers = new WeightedRandomPicker<String>();
        if (fighterFP >= 10) {
            carriers.add("carrierSmall", 5.0f);
        }
        if (fighterFP >= 30) {
            carriers.add("carrierMedium", 5.0f);
        }
        if (fighterFP >= 50) {
            carriers.add("carrierLarge", 5.0f);
        }
        failCount = 0;
        int startingFP = fleet.getFleetPoints();
        while ((float)fleet.getFleetPoints() < (float)startingFP + carrierPoints) {
            role = (String)carriers.pick();
            boolean bl = added = faction.pickShipAndAddToFleet(role, FactionAPI.ShipPickParams.all(), fleet) > 0.0f;
            if (added) {
                failCount = 0;
                continue;
            }
            if (++failCount >= 10) break;
        }
        failCount = 0;
        while (fleet.getFleetPoints() < maxFP) {
            role = (String)main.pick();
            boolean bl = added = faction.pickShipAndAddToFleet(role, FactionAPI.ShipPickParams.all(), fleet) > 0.0f;
            if (added) {
                failCount = 0;
                continue;
            }
            if (++failCount >= 10) break;
        }
        FleetFactory.finishAndSync(fleet);
        return fleet;
    }

    public static void addGenericCombatShips(CampaignFleetAPI fleet, FactionAPI faction, MarketAPI market, int extraFP) {
        float qualityFactor = market.getShipQualityFactor();
        WeightedRandomPicker<String> main = new WeightedRandomPicker<String>();
        main.add("combatSmall", 5.0f);
        main.add("combatSmall", 5.0f);
        main.add("escortSmall", 6.0f);
        main.add("combatSmall", 20.0f);
        main.add("fastAttack", 10.0f);
        if (extraFP >= 20) {
            main.add("combatMedium", 10.0f);
            main.add("escortMedium", 10.0f);
        }
        if (extraFP >= 40) {
            main.add("combatLarge", 5.0f);
            main.add("combatSmall", 5.0f);
        }
        if (extraFP >= 60) {
            main.add("combatLarge", 5.0f);
            main.add("combatCapital", 3.0f);
        }
        int failCount = 0;
        int starting = fleet.getFleetPoints();
        while (fleet.getFleetPoints() < starting + extraFP) {
            boolean added;
            String role = (String)main.pick();
            boolean bl = added = faction.pickShipAndAddToFleet(role, FactionAPI.ShipPickParams.all(), fleet) > 0.0f;
            if (added) {
                failCount = 0;
                continue;
            }
            if (++failCount >= 10) break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MercType {
        SCOUT("mercScout"),
        BOUNTY_HUNTER("mercBountyHunter"),
        PRIVATEER("mercPrivateer"),
        PATROL("mercPatrol"),
        ARMADA("mercArmada");

        public String fleetType;

        private MercType(String fleetType) {
            this.fleetType = fleetType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PatrolType {
        FAST("patrolSmall"),
        COMBAT("patrolMedium"),
        HEAVY("patrolLarge");

        private String fleetType;

        private PatrolType(String fleetType) {
            this.fleetType = fleetType;
        }

        public String getFleetType() {
            return this.fleetType;
        }
    }
}

