/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.GenerateFleetOfficersPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.plugins.CreateFleetPlugin;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetFactoryV3 {
    public static String KEY_SPAWN_FP_MULT = "$spawnFPMult";
    public static float BASE_QUALITY_WHEN_NO_MARKET = 0.5f;
    public static int FLEET_POINTS_THRESHOLD_FOR_ANNOYING_SHIPS = 50;
    public static float MIN_NUM_SHIPS_DEFICIT_MULT = 0.25f;
    public static int[][] BASE_COUNTS_WITH_4;
    public static int[][] MAX_EXTRA_WITH_4;
    public static int[][] BASE_COUNTS_WITH_3;
    public static int[][] MAX_EXTRA_WITH_3;
    public static Logger log;
    private static List<String> startingAbilities;
    protected static int sizeOverride;

    static {
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[4];
        nArray[0] = 9;
        nArray[1] = 4;
        nArray[2] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 7;
        nArray2[1] = 4;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 4;
        nArray3[1] = 3;
        nArray3[2] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[]{1, 1, 1, 1};
        BASE_COUNTS_WITH_4 = nArrayArray;
        MAX_EXTRA_WITH_4 = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 2, 2, 1}, {2, 2, 2, 3}, {1, 1, 1, 1}};
        BASE_COUNTS_WITH_3 = new int[][]{{6, 2, 1}, {4, 2, 1}, {3, 2, 1}, {1, 1, 1}, {1, 1, 1}};
        int[][] nArrayArray2 = new int[5][];
        int[] nArray5 = new int[3];
        nArray5[0] = 2;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 2;
        nArray6[1] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[0] = 2;
        nArray7[1] = 2;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 2;
        nArray8[1] = 2;
        nArrayArray2[3] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 1;
        nArray9[1] = 1;
        nArrayArray2[4] = nArray9;
        MAX_EXTRA_WITH_3 = nArrayArray2;
        log = Global.getLogger(FleetFactoryV3.class);
        startingAbilities = null;
        sizeOverride = 0;
    }

    public static float getShipQualityModForStability(float stability) {
        return (stability - 5.0f) * 0.05f;
    }

    public static float getNumShipsMultForStability(float stability) {
        return 1.0f + (stability - 5.0f) * 0.05f;
    }

    public static float getNumShipsMultForMarketSize(float marketSize) {
        if (marketSize < 3.0f) {
            marketSize = 3.0f;
        }
        switch ((int)marketSize) {
            case 3: {
                return 0.5f;
            }
            case 4: {
                return 0.75f;
            }
            case 5: {
                return 1.0f;
            }
            case 6: {
                return 1.25f;
            }
            case 7: {
                return 1.5f;
            }
            case 8: {
                return 1.75f;
            }
            case 9: {
                return 2.0f;
            }
            case 10: {
                return 2.5f;
            }
        }
        return marketSize / 6.0f;
    }

    public static float getDoctrineNumShipsMult(int doctrineNumShips) {
        float max = Global.getSettings().getFloat("maxDoctrineNumShipsMult");
        return 1.0f + ((float)doctrineNumShips - 1.0f) * (max - 1.0f) / 4.0f;
    }

    public static CampaignFleetAPI createFleet(FleetParamsV3 params) {
        CreateFleetPlugin plugin = Global.getSector().getGenericPlugins().pickPlugin(CreateFleetPlugin.class, params);
        if (plugin != null) {
            return plugin.createFleet(params);
        }
        Global.getSettings().profilerBegin("FleetFactoryV3.createFleet()");
        try {
            float extra;
            boolean banPhaseShipsEtc;
            String factionId;
            boolean fakeMarket = false;
            MarketAPI market = FleetFactoryV3.pickMarket(params);
            if (market == null) {
                market = Global.getFactory().createMarket("fake", "fake", 5);
                market.getStability().modifyFlat("fake", 10000.0f);
                market.setFactionId(params.factionId);
                SectorEntityToken token = Global.getSector().getHyperspace().createToken(0.0f, 0.0f);
                market.setPrimaryEntity(token);
                market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlat("fake", BASE_QUALITY_WHEN_NO_MARKET);
                market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat("fake", 1.0f);
                fakeMarket = true;
            }
            boolean sourceWasNull = params.source == null;
            params.source = market;
            if (sourceWasNull && params.qualityOverride == null) {
                params.updateQualityAndProducerFromSourceMarket();
            }
            if ((factionId = params.factionId) == null) {
                factionId = params.source.getFactionId();
            }
            FactionAPI.ShipPickMode mode = Misc.getShipPickMode(market, factionId);
            if (params.modeOverride != null) {
                mode = params.modeOverride;
            }
            CampaignFleetAPI fleet = FleetFactoryV3.createEmptyFleet(factionId, params.fleetType, market);
            fleet.getFleetData().setOnlySyncMemberLists(true);
            Misc.getSalvageSeed(fleet);
            FactionDoctrineAPI doctrine = fleet.getFaction().getDoctrine();
            if (params.doctrineOverride != null) {
                doctrine = params.doctrineOverride;
            }
            float numShipsMult = 1.0f;
            if (params.ignoreMarketFleetSizeMult == null || !params.ignoreMarketFleetSizeMult.booleanValue()) {
                numShipsMult = market.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
            }
            float quality = params.quality + params.qualityMod;
            if (params.qualityOverride != null) {
                quality = params.qualityOverride.floatValue();
            }
            Random random = new Random();
            if (params.random != null) {
                random = params.random;
            }
            float combatPts = params.combatPts * numShipsMult;
            if (params.onlyApplyFleetSizeToCombatShips != null && params.onlyApplyFleetSizeToCombatShips.booleanValue()) {
                numShipsMult = 1.0f;
            }
            float freighterPts = params.freighterPts * numShipsMult;
            float tankerPts = params.tankerPts * numShipsMult;
            float transportPts = params.transportPts * numShipsMult;
            float linerPts = params.linerPts * numShipsMult;
            float utilityPts = params.utilityPts * numShipsMult;
            if (combatPts < 10.0f && combatPts > 0.0f) {
                combatPts = Math.max(combatPts, (float)(5 + random.nextInt(6)));
            }
            float dW = (float)doctrine.getWarships() + (float)random.nextInt(3) - 2.0f;
            float dC = (float)doctrine.getCarriers() + (float)random.nextInt(3) - 2.0f;
            float dP = (float)doctrine.getPhaseShips() + (float)random.nextInt(3) - 2.0f;
            boolean strict = doctrine.isStrictComposition();
            if (strict) {
                dW = (float)doctrine.getWarships() - 1.0f;
                dC = (float)doctrine.getCarriers() - 1.0f;
                dP = (float)doctrine.getPhaseShips() - 1.0f;
            }
            if (!strict) {
                float r1 = random.nextFloat();
                float r2 = random.nextFloat();
                float min = Math.min(r1, r2);
                float max = Math.max(r1, r2);
                float mag = 1.0f;
                float v1 = min;
                float v2 = max - min;
                float v3 = 1.0f - max;
                v1 *= mag;
                v2 *= mag;
                v3 *= mag;
                dW += (v1 -= mag / 3.0f);
                dC += (v2 -= mag / 3.0f);
                dP += (v3 -= mag / 3.0f);
            }
            if (doctrine.getWarships() <= 0) {
                dW = 0.0f;
            }
            if (doctrine.getCarriers() <= 0) {
                dC = 0.0f;
            }
            if (doctrine.getPhaseShips() <= 0) {
                dP = 0.0f;
            }
            boolean bl = banPhaseShipsEtc = !fleet.getFaction().isPlayerFaction() && combatPts < (float)FLEET_POINTS_THRESHOLD_FOR_ANNOYING_SHIPS;
            if (params.forceAllowPhaseShipsEtc != null && params.forceAllowPhaseShipsEtc.booleanValue()) {
                banPhaseShipsEtc = params.forceAllowPhaseShipsEtc == false;
            }
            params.mode = mode;
            params.banPhaseShipsEtc = banPhaseShipsEtc;
            if (dW < 0.0f) {
                dW = 0.0f;
            }
            if (dC < 0.0f) {
                dC = 0.0f;
            }
            if (dP < 0.0f) {
                dP = 0.0f;
            }
            if ((extra = 7.0f - (dC + dP + dW)) < 0.0f) {
                extra = 0.0f;
            }
            if (doctrine.getWarships() > doctrine.getCarriers() && doctrine.getWarships() > doctrine.getPhaseShips()) {
                dW += extra;
            } else if (doctrine.getCarriers() > doctrine.getWarships() && doctrine.getCarriers() > doctrine.getPhaseShips()) {
                dC += extra;
            } else if (doctrine.getPhaseShips() > doctrine.getWarships() && doctrine.getPhaseShips() > doctrine.getCarriers()) {
                dP += extra;
            }
            float doctrineTotal = dW + dC + dP;
            combatPts = (int)combatPts;
            int warships = (int)(combatPts * dW / doctrineTotal);
            int carriers = (int)(combatPts * dC / doctrineTotal);
            int phase = (int)(combatPts * dP / doctrineTotal);
            warships = (int)((float)warships + (combatPts - (float)warships - (float)carriers - (float)phase));
            if (params.addShips != null) {
                for (String variantId : params.addShips) {
                    ShipRolePick pick = new ShipRolePick(variantId);
                    warships = (int)((float)warships - FleetFactoryV3.addToFleet(pick, fleet, random));
                }
                if (warships < 0) {
                    warships = 0;
                }
            }
            if (params.treatCombatFreighterSettingAsFraction != null && params.treatCombatFreighterSettingAsFraction.booleanValue()) {
                float combatFreighters = (float)((int)Math.min(freighterPts * 1.5f, (float)warships * 1.5f)) * doctrine.getCombatFreighterProbability();
                float added = FleetFactoryV3.addCombatFreighterFleetPoints(fleet, random, combatFreighters, params);
                freighterPts -= added * 0.5f;
                warships = (int)((float)warships - added * 0.5f);
            } else if (freighterPts > 0.0f && random.nextFloat() < doctrine.getCombatFreighterProbability()) {
                float combatFreighters = (int)Math.min(freighterPts * 1.5f, (float)warships * 1.5f);
                float added = FleetFactoryV3.addCombatFreighterFleetPoints(fleet, random, combatFreighters, params);
                freighterPts -= added * 0.5f;
                warships = (int)((float)warships - added * 0.5f);
            }
            FleetFactoryV3.addCombatFleetPoints(fleet, random, warships, carriers, phase, params);
            FleetFactoryV3.addFreighterFleetPoints(fleet, random, freighterPts, params);
            FleetFactoryV3.addTankerFleetPoints(fleet, random, tankerPts, params);
            FleetFactoryV3.addTransportFleetPoints(fleet, random, transportPts, params);
            FleetFactoryV3.addLinerFleetPoints(fleet, random, linerPts, params);
            FleetFactoryV3.addUtilityFleetPoints(fleet, random, utilityPts, params);
            int maxShips = Global.getSettings().getInt("maxShipsInAIFleet");
            if (params.maxNumShips != null) {
                maxShips = params.maxNumShips;
            }
            if (fleet.getFleetData().getNumMembers() > maxShips) {
                if (params.doNotPrune == null || !params.doNotPrune.booleanValue()) {
                    float targetFP = FleetFactoryV3.getFP(fleet);
                    if (params.doNotAddShipsBeforePruning == null || !params.doNotAddShipsBeforePruning.booleanValue()) {
                        sizeOverride = 5;
                        FleetFactoryV3.addCombatFleetPoints(fleet, random, warships, carriers, phase, params);
                        FleetFactoryV3.addFreighterFleetPoints(fleet, random, freighterPts, params);
                        FleetFactoryV3.addTankerFleetPoints(fleet, random, tankerPts, params);
                        FleetFactoryV3.addTransportFleetPoints(fleet, random, transportPts, params);
                        FleetFactoryV3.addLinerFleetPoints(fleet, random, linerPts, params);
                        FleetFactoryV3.addUtilityFleetPoints(fleet, random, utilityPts, params);
                        sizeOverride = 0;
                    }
                    int size = doctrine.getShipSize();
                    FleetFactoryV3.pruneFleet(maxShips, size, fleet, targetFP, random);
                    float f = FleetFactoryV3.getFP(fleet);
                }
                fleet.getFleetData().sort();
            } else {
                fleet.getFleetData().sort();
            }
            fleet.getFleetData().sort();
            if (params.withOfficers) {
                FleetFactoryV3.addCommanderAndOfficers(fleet, params, random);
            }
            if (fleet.getFlagship() != null) {
                if (params.flagshipVariantId != null) {
                    fleet.getFlagship().setVariant(Global.getSettings().getVariant(params.flagshipVariantId), false, true);
                } else if (params.flagshipVariant != null) {
                    fleet.getFlagship().setVariant(params.flagshipVariant, false, true);
                }
            }
            if (params.onlyRetainFlagship != null && params.onlyRetainFlagship.booleanValue()) {
                for (FleetMemberAPI curr : fleet.getFleetData().getMembersListCopy()) {
                    if (curr.isFlagship()) continue;
                    fleet.getFleetData().removeFleetMember(curr);
                }
            }
            fleet.forceSync();
            if (fleet.getFleetData().getNumMembers() > 0) {
                fleet.getFleetData().getNumMembers();
                fleet.getNumFighters();
            }
            if (fakeMarket) {
                params.source = null;
            }
            DefaultFleetInflaterParams p = new DefaultFleetInflaterParams();
            p.quality = quality;
            if (params.averageSMods != null) {
                p.averageSMods = params.averageSMods;
            }
            p.persistent = true;
            p.seed = random.nextLong();
            p.mode = mode;
            p.timestamp = params.timestamp;
            p.allWeapons = params.allWeapons;
            if (params.doctrineOverride != null) {
                p.rProb = Float.valueOf(params.doctrineOverride.getAutofitRandomizeProbability());
            }
            if (params.factionId != null) {
                p.factionId = params.factionId;
            }
            FleetInflater inflater = Misc.getInflater(fleet, p);
            fleet.setInflater(inflater);
            fleet.getFleetData().setOnlySyncMemberLists(false);
            fleet.getFleetData().sort();
            List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
            for (FleetMemberAPI member : members) {
                member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
            }
            float requestedPoints = params.getTotalPts();
            float actualPoints = fleet.getFleetPoints();
            Misc.setSpawnFPMult(fleet, actualPoints / Math.max(1.0f, requestedPoints));
            CampaignFleetAPI campaignFleetAPI = fleet;
            return campaignFleetAPI;
        }
        finally {
            Global.getSettings().profilerEnd();
        }
    }

    public static void pruneFleet(int maxShips, int doctrineSize, CampaignFleetAPI fleet, float targetFP, Random random) {
        int extra;
        float combatFP = 0.0f;
        float civFP = 0.0f;
        List<FleetMemberAPI> copy = fleet.getFleetData().getMembersListCopy();
        ArrayList<FleetMemberAPI> combat = new ArrayList<FleetMemberAPI>();
        ArrayList<FleetMemberAPI> tanker = new ArrayList<FleetMemberAPI>();
        ArrayList<FleetMemberAPI> freighter = new ArrayList<FleetMemberAPI>();
        ArrayList<FleetMemberAPI> liner = new ArrayList<FleetMemberAPI>();
        ArrayList<FleetMemberAPI> other = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI member : copy) {
            if (member.isCivilian()) {
                civFP += (float)member.getFleetPointCost();
                if (member.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.FREIGHTER)) {
                    freighter.add(member);
                    continue;
                }
                if (member.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.TANKER)) {
                    tanker.add(member);
                    continue;
                }
                if (member.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.TRANSPORT) || member.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.LINER)) {
                    liner.add(member);
                    continue;
                }
                other.add(member);
                continue;
            }
            combatFP += (float)member.getFleetPointCost();
            combat.add(member);
        }
        if (civFP < 1.0f) {
            civFP = 1.0f;
        }
        if (combatFP < 1.0f) {
            combatFP = 1.0f;
        }
        int keepCombat = (int)((float)maxShips * combatFP / (civFP + combatFP));
        int keepCiv = maxShips - keepCombat;
        if (civFP > 10.0f && keepCiv < 2) {
            keepCiv = 2;
            if (!freighter.isEmpty()) {
                ++keepCiv;
            }
            if (!tanker.isEmpty()) {
                ++keepCiv;
            }
            if (!liner.isEmpty()) {
                ++keepCiv;
            }
            if (!other.isEmpty()) {
                ++keepCiv;
            }
            keepCiv = maxShips - keepCiv;
        }
        float f = 0.0f;
        float t = 0.0f;
        float l = 0.0f;
        float o = 0.0f;
        float total = freighter.size() + tanker.size() + liner.size() + other.size();
        if (total < 1.0f) {
            total = 1.0f;
        }
        f = (float)freighter.size() / total;
        t = (float)tanker.size() / total;
        l = (float)liner.size() / total;
        o = (float)other.size() / total;
        f *= (float)keepCiv;
        t *= (float)keepCiv;
        l *= (float)keepCiv;
        o *= (float)keepCiv;
        if (f > 0.0f) {
            f = Math.round(f);
        }
        if (t > 0.0f) {
            t = Math.round(t);
        }
        if (l > 0.0f) {
            l = Math.round(l);
        }
        if (o > 0.0f) {
            o = Math.round(o);
        }
        if (freighter.size() > 0 && f < 1.0f) {
            f = 1.0f;
        }
        if (tanker.size() > 0 && t < 1.0f) {
            t = 1.0f;
        }
        if (liner.size() > 0 && l < 1.0f) {
            l = 1.0f;
        }
        if (other.size() > 0 && o < 1.0f) {
            o = 1.0f;
        }
        if ((extra = (int)(f + t + l + o - (float)keepCiv)) > 0 && o >= 2.0f) {
            --extra;
            o -= 1.0f;
        }
        if (extra > 0 && l >= 2.0f) {
            --extra;
            l -= 1.0f;
        }
        if (extra > 0 && t >= 2.0f) {
            --extra;
            t -= 1.0f;
        }
        if (extra > 0 && f >= 2.0f) {
            --extra;
            f -= 1.0f;
        }
        LinkedHashSet<FleetMemberAPI> keep = new LinkedHashSet<FleetMemberAPI>();
        Comparator<FleetMemberAPI> c = new Comparator<FleetMemberAPI>(){

            @Override
            public int compare(FleetMemberAPI o1, FleetMemberAPI o2) {
                return o2.getHullSpec().getHullSize().ordinal() - o1.getHullSpec().getHullSize().ordinal();
            }
        };
        Collections.sort(combat, c);
        Collections.sort(freighter, c);
        Collections.sort(tanker, c);
        Collections.sort(liner, c);
        Collections.sort(other, c);
        int[] ratio = new int[]{4, 2, 1, 1};
        FleetFactoryV3.addAll(ratio, combat, keep, keepCombat, random);
        FleetFactoryV3.addAll(ratio, freighter, keep, (int)f, random);
        FleetFactoryV3.addAll(ratio, tanker, keep, (int)t, random);
        FleetFactoryV3.addAll(ratio, liner, keep, (int)l, random);
        FleetFactoryV3.addAll(ratio, other, keep, (int)o, random);
        for (FleetMemberAPI member : copy) {
            if (keep.contains(member)) continue;
            fleet.getFleetData().removeFleetMember(member);
        }
        float currFP = FleetFactoryV3.getFP(fleet);
        if (currFP > targetFP) {
            fleet.getFleetData().sort();
            copy = fleet.getFleetData().getMembersListCopy();
            int i = 0;
            while (i < copy.size() / 2) {
                FleetMemberAPI f1 = copy.get(i);
                FleetMemberAPI f2 = copy.get(copy.size() - 1 - i);
                copy.set(i, f2);
                copy.set(copy.size() - 1 - i, f1);
                i += 2;
            }
            float fpGoal = currFP - targetFP;
            float fpDone = 0.0f;
            for (FleetMemberAPI curr : copy) {
                if (curr.isCivilian()) continue;
                FleetMemberAPI best = null;
                float bestDiff = 0.0f;
                for (FleetMemberAPI replace : combat) {
                    float fpReplace;
                    float fpCurr = curr.getFleetPointCost();
                    if (!(fpCurr > (fpReplace = (float)replace.getFleetPointCost()))) continue;
                    float fpDiff = fpCurr - fpReplace;
                    if (fpDone + fpDiff <= fpGoal) {
                        best = replace;
                        bestDiff = fpDiff;
                        break;
                    }
                    if (!(fpDiff < bestDiff)) continue;
                    best = replace;
                    bestDiff = fpDiff;
                }
                if (best != null) {
                    fpDone += bestDiff;
                    combat.remove(best);
                    fleet.getFleetData().removeFleetMember(curr);
                    fleet.getFleetData().addFleetMember(best);
                }
                if (fpDone >= fpGoal) break;
            }
        }
    }

    public static void addAll(int[] ratio, List<FleetMemberAPI> from, LinkedHashSet<FleetMemberAPI> to, int num, Random random) {
        int added = 0;
        if (num <= 5) {
            while (added < num && !from.isEmpty()) {
                to.add(from.remove(0));
                ++added;
            }
            return;
        }
        WeightedRandomPicker<ShipAPI.HullSize> picker = FleetFactoryV3.makePicker(ratio, random);
        int i = 0;
        while (i < num) {
            if (picker.isEmpty()) {
                picker = FleetFactoryV3.makePicker(ratio, random);
            }
            block2: while (!picker.isEmpty()) {
                ShipAPI.HullSize size = picker.pickAndRemove();
                for (FleetMemberAPI member : from) {
                    if (member.getHullSpec().getHullSize() != size) continue;
                    to.add(member);
                    from.remove(member);
                    ++added;
                    break block2;
                }
            }
            ++i;
        }
        while (added < num && !from.isEmpty()) {
            to.add(from.remove(0));
            ++added;
        }
    }

    public static WeightedRandomPicker<ShipAPI.HullSize> makePicker(int[] ratio, Random random) {
        WeightedRandomPicker<ShipAPI.HullSize> picker = new WeightedRandomPicker<ShipAPI.HullSize>(random);
        int i = 0;
        while (i < ratio[0]) {
            picker.add(ShipAPI.HullSize.CAPITAL_SHIP);
            ++i;
        }
        i = 0;
        while (i < ratio[1]) {
            picker.add(ShipAPI.HullSize.CRUISER);
            ++i;
        }
        i = 0;
        while (i < ratio[2]) {
            picker.add(ShipAPI.HullSize.DESTROYER);
            ++i;
        }
        i = 0;
        while (i < ratio[3]) {
            picker.add(ShipAPI.HullSize.FRIGATE);
            ++i;
        }
        return picker;
    }

    public static int getFP(CampaignFleetAPI fleet) {
        int fp = 0;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            fp += member.getFleetPointCost();
        }
        return fp;
    }

    public static List<FleetMemberAPI> getRemoveOrder(CampaignFleetAPI fleet) {
        FleetMemberAPI member;
        ArrayList<FleetMemberAPI> remove = new ArrayList<FleetMemberAPI>();
        List<FleetMemberAPI> copy = fleet.getFleetData().getMembersListCopy();
        Collections.reverse(copy);
        Iterator<FleetMemberAPI> iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (!member.isCivilian() || member.getHullSpec().getHullSize().ordinal() > ShipAPI.HullSize.FRIGATE.ordinal()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (member.isCivilian() || member.getHullSpec().getHullSize().ordinal() > ShipAPI.HullSize.FRIGATE.ordinal()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (!member.isCivilian() || member.getHullSpec().getHullSize().ordinal() > ShipAPI.HullSize.DESTROYER.ordinal()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (member.isCivilian() || member.getHullSpec().getHullSize().ordinal() > ShipAPI.HullSize.DESTROYER.ordinal()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (!member.isCivilian() || member.getHullSpec().getHullSize().ordinal() > ShipAPI.HullSize.CRUISER.ordinal()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (member.isCivilian() || member.getHullSpec().getHullSize().ordinal() > ShipAPI.HullSize.CRUISER.ordinal()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (!member.isCivilian()) continue;
            remove.add(member);
            iter.remove();
        }
        iter = copy.iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (member.isCivilian()) continue;
            remove.add(member);
            iter.remove();
        }
        return remove;
    }

    public static void addCommanderAndOfficers(CampaignFleetAPI fleet, FleetParamsV3 params, Random random) {
        FleetFactoryV3.addCommanderAndOfficersV2(fleet, params, random);
    }

    public static void addCommanderAndOfficersV2(CampaignFleetAPI fleet, FleetParamsV3 params, Random random) {
        int maxOfficerLevel;
        List<FleetMemberAPI> members;
        GenerateFleetOfficersPlugin.GenerateFleetOfficersPickData pickData = new GenerateFleetOfficersPlugin.GenerateFleetOfficersPickData(fleet, params);
        GenerateFleetOfficersPlugin genPlugin = Global.getSector().getGenericPlugins().pickPlugin(GenerateFleetOfficersPlugin.class, pickData);
        if (genPlugin != null) {
            genPlugin.addCommanderAndOfficers(fleet, params, random);
            return;
        }
        FactionAPI faction = fleet.getFaction();
        FactionDoctrineAPI doctrine = faction.getDoctrine();
        if (params.doctrineOverride != null) {
            doctrine = params.doctrineOverride;
        }
        if ((members = fleet.getFleetData().getMembersListCopy()).isEmpty()) {
            return;
        }
        float combatPoints = 0.0f;
        float combatShips = 0.0f;
        for (FleetMemberAPI member : members) {
            if (member.isCivilian() || member.isFighterWing()) continue;
            combatPoints += (float)member.getFleetPointCost();
            combatShips += 1.0f;
        }
        if (combatPoints < 1.0f) {
            combatPoints = 1.0f;
        }
        if (combatShips < 1.0f) {
            combatShips = 1.0f;
        }
        boolean debug = true;
        debug = false;
        int maxCommanderLevel = Global.getSettings().getInt("maxAIFleetCommanderLevel");
        float mercMult = Global.getSettings().getFloat("officerAIMaxMercsMult");
        int maxOfficers = Global.getSettings().getInt("officerAIMax");
        int baseMaxOfficerLevel = Global.getSettings().getInt("officerMaxLevel");
        OfficerLevelupPlugin plugin = (OfficerLevelupPlugin)Global.getSettings().getPlugin("officerLevelUp");
        float officerQualityMult = ((float)doctrine.getOfficerQuality() - 1.0f) / 4.0f;
        if (officerQualityMult > 1.0f) {
            officerQualityMult = 1.0f;
        }
        float baseShipsForMaxOfficerLevel = Global.getSettings().getFloat("baseCombatShipsForMaxOfficerLevel");
        float baseCombatShipsPerOfficer = Global.getSettings().getFloat("baseCombatShipsPerOfficer");
        float combatShipsPerOfficer = baseCombatShipsPerOfficer * (1.0f - officerQualityMult * 0.5f);
        float fleetSizeOfficerQualityMult = combatShips / (baseShipsForMaxOfficerLevel * (1.0f - officerQualityMult * 0.5f));
        if (fleetSizeOfficerQualityMult > 1.0f) {
            fleetSizeOfficerQualityMult = 1.0f;
        }
        int numOfficers = (int)Math.min((float)(maxOfficers += (int)((float)doctrine.getOfficerQuality() * mercMult) + params.officerNumberBonus), combatShips / combatShipsPerOfficer);
        numOfficers += params.officerNumberBonus;
        numOfficers = Math.round((float)numOfficers * params.officerNumberMult);
        if (debug) {
            System.out.println("numOfficers: " + numOfficers);
        }
        if (numOfficers > maxOfficers) {
            numOfficers = maxOfficers;
        }
        if (params.commander != null && params.commander.isPlayer()) {
            numOfficers = params.commander.getStats().getOfficerNumber().getModifiedInt();
        }
        if (params.maxOfficersToAdd != null) {
            numOfficers = Math.min(numOfficers, params.maxOfficersToAdd);
        }
        if ((maxOfficerLevel = Math.round((float)doctrine.getOfficerQuality() / 2.0f + fleetSizeOfficerQualityMult * 1.0f * (float)baseMaxOfficerLevel)) < 1) {
            maxOfficerLevel = 1;
        }
        if ((maxOfficerLevel += params.officerLevelBonus) < 1) {
            maxOfficerLevel = 1;
        }
        if (debug) {
            System.out.println("maxOfficers: " + maxOfficers);
        }
        if (debug) {
            System.out.println("maxOfficerLevel: " + maxOfficerLevel);
        }
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>(random);
        WeightedRandomPicker<FleetMemberAPI> flagshipPicker = new WeightedRandomPicker<FleetMemberAPI>(random);
        int maxSize = 0;
        for (FleetMemberAPI member : members) {
            int size;
            if (member.isFighterWing() || member.isFlagship() || member.isCivilian() || !member.getCaptain().isDefault() || (size = member.getHullSpec().getHullSize().ordinal()) <= maxSize) continue;
            maxSize = size;
        }
        for (FleetMemberAPI member : members) {
            if (member.isFighterWing() || member.isFlagship() || member.isCivilian() || !member.getCaptain().isDefault()) continue;
            float weight = member.getFleetPointCost();
            int size = member.getHullSpec().getHullSize().ordinal();
            if (size >= maxSize) {
                flagshipPicker.add(member, weight);
            }
            picker.add(member, weight);
        }
        if (picker.isEmpty()) {
            picker.add(members.get(0), 1.0f);
        }
        if (flagshipPicker.isEmpty()) {
            flagshipPicker.add(members.get(0), 1.0f);
        }
        FleetMemberAPI flagship = (FleetMemberAPI)flagshipPicker.pickAndRemove();
        picker.remove(flagship);
        int commanderLevel = maxOfficerLevel;
        int commanderLevelLimit = maxCommanderLevel;
        if (params.commanderLevelLimit != 0) {
            commanderLevelLimit = params.commanderLevelLimit;
        }
        if (commanderLevel > commanderLevelLimit) {
            commanderLevel = commanderLevelLimit;
        }
        OfficerManagerEvent.SkillPickPreference pref = FleetFactoryV3.getSkillPrefForShip(flagship);
        PersonAPI commander = params.commander;
        if (commander == null) {
            commander = OfficerManagerEvent.createOfficer(fleet.getFaction(), commanderLevel, pref, false, null, true, true, -1, random);
            if (commander.getPersonalityAPI().getId().equals("timid")) {
                commander.setPersonality("cautious");
            }
            FleetFactoryV3.addCommanderSkills(commander, fleet, params, random);
        }
        if (params.commander == null) {
            commander.setRankId(Ranks.SPACE_COMMANDER);
            commander.setPostId(Ranks.POST_FLEET_COMMANDER);
        }
        fleet.setCommander(commander);
        fleet.getFleetData().setFlagship(flagship);
        int commanderOfficerLevelBonus = (int)commander.getStats().getDynamic().getMod("officer_max_level_mod").computeEffective(0.0f);
        int officerLevelLimit = plugin.getMaxLevel(null) + commanderOfficerLevelBonus;
        if (params.officerLevelLimit != 0) {
            officerLevelLimit = params.officerLevelLimit;
        }
        if (debug) {
            System.out.println("Created level " + commander.getStats().getLevel() + " commander");
            System.out.println("Max officer level bonus: " + commanderOfficerLevelBonus + " (due to commander skill)");
            System.out.println("Adding up to " + numOfficers + " officers");
        }
        int added = 0;
        int i = 0;
        while (i < numOfficers) {
            FleetMemberAPI member = (FleetMemberAPI)picker.pickAndRemove();
            if (member == null) break;
            int level = maxOfficerLevel - random.nextInt(3);
            if (Misc.isEasy()) {
                level = (int)Math.ceil((float)level * Global.getSettings().getFloat("easyOfficerLevelMult"));
            }
            if (level < 1) {
                level = 1;
            }
            if (level > officerLevelLimit) {
                level = officerLevelLimit;
            }
            if (params.commander != null && params.commander.isPlayer()) {
                level = (int)params.commander.getStats().getDynamic().getMod("officer_max_level_mod").computeEffective(Global.getSettings().getInt("officerMaxLevel"));
            }
            pref = FleetFactoryV3.getSkillPrefForShip(member);
            PersonAPI person = OfficerManagerEvent.createOfficer(fleet.getFaction(), level, pref, false, fleet, true, true, -1, random);
            if (person.getPersonalityAPI().getId().equals("timid")) {
                person.setPersonality("cautious");
            }
            if (debug) {
                System.out.println("Added level " + person.getStats().getLevel() + " officer");
            }
            ++added;
            member.setCaptain(person);
            if (params.commander != null && params.commander.isPlayer()) {
                fleet.getFleetData().addOfficer(person);
            }
            ++i;
        }
        if (debug) {
            System.out.println("Added " + added + " officers total");
        }
    }

    public static OfficerManagerEvent.SkillPickPreference getSkillPrefForShip(FleetMemberAPI member) {
        boolean b;
        float energy = 0.0f;
        float ballistic = 0.0f;
        float missile = 0.0f;
        float total = 0.0f;
        for (WeaponSlotAPI slot : member.getHullSpec().getAllWeaponSlotsCopy()) {
            float w = 1.0f;
            switch (slot.getSlotSize()) {
                case LARGE: {
                    w = 4.0f;
                    break;
                }
                case MEDIUM: {
                    w = 2.0f;
                    break;
                }
                case SMALL: {
                    w = 1.0f;
                }
            }
            WeaponAPI.WeaponType type = slot.getWeaponType();
            if (type == WeaponAPI.WeaponType.BALLISTIC || type == WeaponAPI.WeaponType.HYBRID) {
                ballistic += w;
                total += w;
                continue;
            }
            if (type == WeaponAPI.WeaponType.ENERGY) {
                energy += w;
                total += w;
                continue;
            }
            if (type != WeaponAPI.WeaponType.MISSILE && type != WeaponAPI.WeaponType.SYNERGY && type != WeaponAPI.WeaponType.COMPOSITE) continue;
            missile += w;
            total += w;
        }
        if (total <= 0.0f) {
            total = 1.0f;
        }
        boolean e = energy >= total * 0.33f;
        boolean bl = b = ballistic >= total * 0.33f;
        if (b && e) {
            if (ballistic * 1.5f >= energy) {
                e = false;
            } else {
                b = false;
            }
        }
        boolean m = missile >= total * 0.17f;
        boolean d = member.getHullSpec().getShieldType() == ShieldAPI.ShieldType.FRONT || member.getHullSpec().getShieldType() == ShieldAPI.ShieldType.OMNI || member.getHullSpec().isPhase();
        String n1 = e ? "YES_ENERGY" : "NO_ENERGY";
        String n2 = b ? "YES_BALLISTIC" : "NO_BALLISTIC";
        String n3 = m ? "YES_MISSILE" : "NO_MISSILE";
        String n4 = d ? "YES_DEFENSE" : "NO_DEFENSE";
        OfficerManagerEvent.SkillPickPreference pref = OfficerManagerEvent.SkillPickPreference.valueOf(String.valueOf(n1) + "_" + n2 + "_" + n3 + "_" + n4);
        return pref;
    }

    public static void addCommanderSkills(PersonAPI commander, CampaignFleetAPI fleet, FleetParamsV3 params, Random random) {
        if (params != null && params.noCommanderSkills != null && params.noCommanderSkills.booleanValue()) {
            return;
        }
        if (random == null) {
            random = new Random();
        }
        MutableCharacterStatsAPI stats = commander.getStats();
        int level = stats.getLevel();
        int forOne = Global.getSettings().getInt("commanderLevelForOneSkill");
        int forTwo = Global.getSettings().getInt("commanderLevelForTwoSkills");
        int numSkills = 0;
        if (level >= forTwo) {
            numSkills = 2;
        } else if (level >= forOne) {
            numSkills = 1;
        }
        if (numSkills <= 0) {
            return;
        }
        FactionDoctrineAPI doctrine = fleet.getFaction().getDoctrine();
        if (params != null && params.doctrineOverride != null) {
            doctrine = params.doctrineOverride;
        }
        ArrayList<String> skills = new ArrayList<String>(doctrine.getCommanderSkills());
        Iterator iter = skills.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            SkillSpecAPI spec = Global.getSettings().getSkillSpec(id);
            if (spec == null || !spec.hasTag("player_only")) continue;
            iter.remove();
        }
        if (skills.isEmpty()) {
            return;
        }
        if (random.nextFloat() < doctrine.getCommanderSkillsShuffleProbability()) {
            Collections.shuffle(skills, random);
        }
        stats.setSkipRefresh(true);
        boolean debug = true;
        debug = false;
        if (debug) {
            System.out.println("Generating commander skills, person level " + stats.getLevel() + ", skills: " + numSkills);
        }
        int picks = 0;
        for (String skillId : skills) {
            if (debug) {
                System.out.println("Selected skill: [" + skillId + "]");
            }
            stats.setSkillLevel(skillId, 1.0f);
            if (++picks >= numSkills) break;
        }
        if (debug) {
            System.out.println("Done generating commander skills\n");
        }
        stats.setSkipRefresh(false);
        stats.refreshCharacterStatsEffects();
    }

    public static float getMemberWeight(FleetMemberAPI member) {
        boolean nonCombat = member.getVariant().isCivilian();
        float weight = 0.0f;
        switch (member.getVariant().getHullSize()) {
            case CAPITAL_SHIP: {
                weight += 8.0f;
                break;
            }
            case CRUISER: {
                weight += 4.0f;
                break;
            }
            case DESTROYER: {
                weight += 2.0f;
                break;
            }
            case FRIGATE: {
                weight += 1.0f;
                break;
            }
            case FIGHTER: {
                weight += 1.0f;
            }
        }
        if (nonCombat) {
            weight *= 0.1f;
        }
        return weight;
    }

    public static MarketAPI pickMarket(FleetParamsV3 params) {
        if (params.source != null) {
            return params.source;
        }
        if (params.locInHyper == null) {
            return null;
        }
        List<MarketAPI> allMarkets = Global.getSector().getEconomy().getMarketsCopy();
        int size = FleetFactoryV3.getMinPreferredMarketSize(params);
        float distToClosest = Float.MAX_VALUE;
        MarketAPI closest = null;
        float distToClosestMatchingSize = Float.MAX_VALUE;
        MarketAPI closestMatchingSize = null;
        FactionAPI creationFaction = Global.getSector().getFaction(params.factionId);
        boolean independent = "independent".equals(params.factionId) || "scavengers".equals(params.factionId) || creationFaction.getCustomBoolean("spawnsAsIndependent");
        for (MarketAPI market : allMarkets) {
            boolean hostileToIndependent;
            if (market.getPrimaryEntity() == null || (!independent ? !market.getFactionId().equals(params.factionId) : (hostileToIndependent = market.getFaction().isHostileTo("independent")))) continue;
            float currDist = Misc.getDistance(market.getPrimaryEntity().getLocationInHyperspace(), params.locInHyper);
            if (currDist < distToClosest) {
                distToClosest = currDist;
                closest = market;
            }
            if (market.getSize() < size || !(currDist < distToClosestMatchingSize)) continue;
            distToClosestMatchingSize = currDist;
            closestMatchingSize = market;
        }
        if (closestMatchingSize != null) {
            return closestMatchingSize;
        }
        if (closest != null) {
            return closest;
        }
        return null;
    }

    public static int getMinPreferredMarketSize(FleetParamsV3 params) {
        float fp = params.getTotalPts();
        if (fp <= 20.0f) {
            return 1;
        }
        if (fp <= 50.0f) {
            return 3;
        }
        if (fp <= 100.0f) {
            return 5;
        }
        if (fp <= 150.0f) {
            return 7;
        }
        return 8;
    }

    public static CampaignFleetAPI createEmptyFleet(String factionId, String fleetType, MarketAPI market) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        String fleetName = faction.getFleetTypeName(fleetType);
        CampaignFleetAPI fleet = Global.getFactory().createEmptyFleet(factionId, fleetName, true);
        fleet.getMemoryWithoutUpdate().set("$fleetType", fleetType);
        if (market != null && !market.getId().equals("fake")) {
            fleet.getMemoryWithoutUpdate().set("$sourceMarket", market.getId());
        }
        if (startingAbilities == null) {
            startingAbilities = new ArrayList<String>();
            for (String id : Global.getSettings().getSortedAbilityIds()) {
                AbilitySpecAPI spec = Global.getSettings().getAbilitySpec(id);
                if (!spec.isAIDefault()) continue;
                startingAbilities.add(id);
            }
        }
        for (String id : startingAbilities) {
            fleet.addAbility(id);
        }
        return fleet;
    }

    public static float addToFleet(String role, MarketAPI market, Random random, CampaignFleetAPI fleet, int maxFP, FleetParamsV3 params) {
        float total = 0.0f;
        List<ShipRolePick> picks = market.pickShipsForRole(role, fleet.getFaction().getId(), new FactionAPI.ShipPickParams(params.mode, maxFP, params.timestamp, params.blockFallback), random, null);
        for (ShipRolePick pick : picks) {
            total += FleetFactoryV3.addToFleet(pick, fleet, random);
        }
        return total;
    }

    protected static float addToFleet(ShipRolePick pick, CampaignFleetAPI fleet, Random random) {
        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, pick.variantId);
        String name = fleet.getFleetData().pickShipName(member, random);
        member.setShipName(name);
        fleet.getFleetData().addFleetMember(member);
        return member.getFleetPointCost();
    }

    public static boolean addShips(String role, int count, MarketAPI market, Random random, CampaignFleetAPI fleet, FPRemaining rem, FleetParamsV3 params) {
        boolean addedSomething = false;
        int i = 0;
        while (i < count) {
            if (rem.fp <= 0) break;
            float added = FleetFactoryV3.addToFleet(role, market, random, fleet, rem.fp, params);
            if (added > 0.0f) {
                rem.fp = (int)((float)rem.fp - added);
                addedSomething = true;
            }
            ++i;
        }
        return addedSomething;
    }

    public static float addPhaseFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.SMALL_IS_FRIGATE, "phaseSmall", "phaseMedium", "phaseLarge");
    }

    public static float addCarrierFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.SMALL_IS_DESTROYER, "carrierSmall", "carrierMedium", "carrierLarge");
    }

    public static float addPriorityOnlyThenAll(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params, SizeFilterMode sizeFilterMode, String roleSmall, String roleMedium, String roleLarge) {
        if (fp <= 0.0f) {
            return 0.0f;
        }
        float added = 0.0f;
        if (params.mode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) {
            int numPriority = fleet.getFaction().getNumAvailableForRole(roleSmall, FactionAPI.ShipPickMode.PRIORITY_ONLY) + fleet.getFaction().getNumAvailableForRole(roleMedium, FactionAPI.ShipPickMode.PRIORITY_ONLY) + fleet.getFaction().getNumAvailableForRole(roleLarge, FactionAPI.ShipPickMode.PRIORITY_ONLY);
            if (numPriority > 0) {
                params.mode = FactionAPI.ShipPickMode.PRIORITY_ONLY;
                added = FleetFactoryV3.addFleetPoints(fleet, random, fp, params, sizeFilterMode, roleSmall, roleMedium, roleLarge);
                params.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
            } else {
                params.mode = FactionAPI.ShipPickMode.ALL;
                added = FleetFactoryV3.addFleetPoints(fleet, random, fp, params, sizeFilterMode, roleSmall, roleMedium, roleLarge);
                params.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
            }
        } else {
            added = FleetFactoryV3.addFleetPoints(fleet, random, fp, params, sizeFilterMode, roleSmall, roleMedium, roleLarge);
        }
        return added;
    }

    public static float addTankerFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.SMALL_IS_DESTROYER, "tankerSmall", "tankerMedium", "tankerLarge");
    }

    public static float addFreighterFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.NONE, "freighterSmall", "freighterMedium", "freighterLarge");
    }

    public static float addLinerFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.NONE, "linerSmall", "linerMedium", "linerLarge");
    }

    public static float addCombatFreighterFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.SMALL_IS_FRIGATE, "combatFreighterSmall", "combatFreighterMedium", "combatFreighterLarge");
    }

    public static float addTransportFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.NONE, "personnelSmall", "personnelMedium", "personnelLarge");
    }

    public static float addUtilityFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params) {
        return FleetFactoryV3.addPriorityOnlyThenAll(fleet, random, fp, params, SizeFilterMode.NONE, "utility", "utility", "utility");
    }

    public static int getAdjustedDoctrineSize(int size, CampaignFleetAPI fleetSoFar) {
        if (sizeOverride > 0) {
            return sizeOverride;
        }
        return size;
    }

    public static float addFleetPoints(CampaignFleetAPI fleet, Random random, float fp, FleetParamsV3 params, SizeFilterMode sizeFilterMode, String ... roles) {
        FactionDoctrineAPI doctrine = fleet.getFaction().getDoctrine();
        if (params.doctrineOverride != null) {
            doctrine = params.doctrineOverride;
        }
        int size = doctrine.getShipSize();
        boolean addedSomething = true;
        FPRemaining rem = new FPRemaining();
        rem.fp = (int)fp;
        while (addedSomething && rem.fp > 0) {
            size = FleetFactoryV3.getAdjustedDoctrineSize(size, fleet);
            int small = BASE_COUNTS_WITH_3[size - 1][0] + random.nextInt(MAX_EXTRA_WITH_3[size - 1][0] + 1);
            int medium = BASE_COUNTS_WITH_3[size - 1][1] + random.nextInt(MAX_EXTRA_WITH_3[size - 1][1] + 1);
            int large = BASE_COUNTS_WITH_3[size - 1][2] + random.nextInt(MAX_EXTRA_WITH_3[size - 1][2] + 1);
            if (sizeFilterMode == SizeFilterMode.SMALL_IS_FRIGATE) {
                if (params.maxShipSize <= 1) {
                    medium = 0;
                }
                if (params.maxShipSize <= 2) {
                    large = 0;
                }
            } else if (sizeFilterMode == SizeFilterMode.SMALL_IS_DESTROYER) {
                if (params.maxShipSize <= 2) {
                    medium = 0;
                }
                if (params.maxShipSize <= 3) {
                    large = 0;
                }
            }
            int smallPre = small / 2;
            small -= smallPre;
            int mediumPre = medium / 2;
            medium -= mediumPre;
            addedSomething = false;
            addedSomething |= FleetFactoryV3.addShips(roles[0], smallPre, params.source, random, fleet, rem, params);
            addedSomething |= FleetFactoryV3.addShips(roles[1], mediumPre, params.source, random, fleet, rem, params);
            addedSomething |= FleetFactoryV3.addShips(roles[0], small, params.source, random, fleet, rem, params);
            addedSomething |= FleetFactoryV3.addShips(roles[2], large, params.source, random, fleet, rem, params);
            addedSomething |= FleetFactoryV3.addShips(roles[1], medium, params.source, random, fleet, rem, params);
        }
        return fp - (float)rem.fp;
    }

    public static void addCombatFleetPoints(CampaignFleetAPI fleet, Random random, float warshipFP, float carrierFP, float phaseFP, FleetParamsV3 params) {
        FactionAPI faction = fleet.getFaction();
        FactionDoctrineAPI doctrine = faction.getDoctrine();
        if (params.doctrineOverride != null) {
            doctrine = params.doctrineOverride;
        }
        WeightedRandomPicker<String> smallPicker = new WeightedRandomPicker<String>(random);
        WeightedRandomPicker<String> mediumPicker = new WeightedRandomPicker<String>(random);
        WeightedRandomPicker<String> largePicker = new WeightedRandomPicker<String>(random);
        WeightedRandomPicker<String> capitalPicker = new WeightedRandomPicker<String>(random);
        WeightedRandomPicker<String> priorityCapitalPicker = new WeightedRandomPicker<String>(random);
        String smallRole = "combatSmallForSmallFleet";
        if (!params.banPhaseShipsEtc) {
            smallRole = "combatSmall";
        }
        smallPicker.add(smallRole, warshipFP);
        smallPicker.add("phaseSmall", phaseFP);
        mediumPicker.add("combatMedium", warshipFP);
        mediumPicker.add("phaseMedium", phaseFP);
        mediumPicker.add("carrierSmall", carrierFP);
        largePicker.add("combatLarge", warshipFP);
        largePicker.add("phaseLarge", phaseFP);
        largePicker.add("carrierMedium", carrierFP);
        capitalPicker.add("combatCapital", warshipFP);
        capitalPicker.add("phaseCapital", phaseFP);
        capitalPicker.add("carrierLarge", carrierFP);
        HashSet<String> usePriorityOnly = new HashSet<String>();
        if (params.mode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) {
            float num = faction.getVariantWeightForRole("combatCapital", FactionAPI.ShipPickMode.PRIORITY_ONLY);
            if (num > 0.0f) {
                priorityCapitalPicker.add("combatCapital", num);
            }
            if ((num = faction.getVariantWeightForRole("carrierLarge", FactionAPI.ShipPickMode.PRIORITY_ONLY)) > 0.0f) {
                priorityCapitalPicker.add("carrierLarge", num);
            }
            if ((num = faction.getVariantWeightForRole("phaseCapital", FactionAPI.ShipPickMode.PRIORITY_ONLY)) > 0.0f) {
                priorityCapitalPicker.add("phaseCapital", num);
            }
            if (params.mode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) {
                FleetFactoryV3.addToPriorityOnlySet(fleet, usePriorityOnly, "phaseSmall", "phaseMedium", "phaseLarge");
                FleetFactoryV3.addToPriorityOnlySet(fleet, usePriorityOnly, "carrierSmall", "carrierMedium", "carrierLarge");
            }
        }
        HashMap<String, FPRemaining> remaining = new HashMap<String, FPRemaining>();
        FPRemaining remWarship = new FPRemaining((int)warshipFP);
        FPRemaining remCarrier = new FPRemaining((int)carrierFP);
        FPRemaining remPhase = new FPRemaining((int)phaseFP);
        remaining.put("combatSmallForSmallFleet", remWarship);
        remaining.put("combatSmall", remWarship);
        remaining.put("combatMedium", remWarship);
        remaining.put("combatLarge", remWarship);
        remaining.put("combatCapital", remWarship);
        remaining.put("carrierSmall", remCarrier);
        remaining.put("carrierMedium", remCarrier);
        remaining.put("carrierLarge", remCarrier);
        remaining.put("phaseSmall", remPhase);
        remaining.put("phaseMedium", remPhase);
        remaining.put("phaseLarge", remPhase);
        remaining.put("phaseCapital", remPhase);
        if (params.maxShipSize <= 1) {
            mediumPicker.clear();
        }
        if (params.maxShipSize <= 2) {
            largePicker.clear();
        }
        if (params.maxShipSize <= 3) {
            capitalPicker.clear();
        }
        if (params.minShipSize >= 2) {
            smallPicker.clear();
        }
        if (params.minShipSize >= 3) {
            mediumPicker.clear();
        }
        if (params.minShipSize >= 4) {
            largePicker.clear();
        }
        int size = doctrine.getShipSize();
        int numFails = 0;
        while (numFails < 2) {
            size = FleetFactoryV3.getAdjustedDoctrineSize(size, fleet);
            int small = BASE_COUNTS_WITH_4[size - 1][0] + random.nextInt(MAX_EXTRA_WITH_4[size - 1][0] + 1);
            int medium = BASE_COUNTS_WITH_4[size - 1][1] + random.nextInt(MAX_EXTRA_WITH_4[size - 1][1] + 1);
            int large = BASE_COUNTS_WITH_4[size - 1][2] + random.nextInt(MAX_EXTRA_WITH_4[size - 1][2] + 1);
            int capital = BASE_COUNTS_WITH_4[size - 1][3] + random.nextInt(MAX_EXTRA_WITH_4[size - 1][3] + 1);
            if (size < 5 && capital > 1) {
                capital = 1;
            }
            if (params.maxShipSize <= 1) {
                medium = 0;
            }
            if (params.maxShipSize <= 2) {
                large = 0;
            }
            if (params.maxShipSize <= 3) {
                capital = 0;
            }
            if (params.minShipSize >= 2) {
                small = 0;
            }
            if (params.minShipSize >= 3) {
                medium = 0;
            }
            if (params.minShipSize >= 4) {
                large = 0;
            }
            int smallPre = small / 2;
            small -= smallPre;
            int mediumPre = medium / 2;
            medium -= mediumPre;
            boolean addedSomething = false;
            addedSomething |= FleetFactoryV3.addShips(smallPicker, usePriorityOnly, remaining, null, smallPre, fleet, random, params);
            addedSomething |= FleetFactoryV3.addShips(mediumPicker, usePriorityOnly, remaining, null, mediumPre, fleet, random, params);
            addedSomething |= FleetFactoryV3.addShips(smallPicker, usePriorityOnly, remaining, null, small, fleet, random, params);
            addedSomething |= FleetFactoryV3.addShips(largePicker, usePriorityOnly, remaining, null, large, fleet, random, params);
            addedSomething |= FleetFactoryV3.addShips(mediumPicker, usePriorityOnly, remaining, null, medium, fleet, random, params);
            if (!priorityCapitalPicker.isEmpty()) {
                params.mode = FactionAPI.ShipPickMode.PRIORITY_ONLY;
                params.blockFallback = true;
                FPRemaining combined = new FPRemaining(remWarship.fp + remCarrier.fp + remPhase.fp);
                boolean addedCapital = FleetFactoryV3.addShips(priorityCapitalPicker, usePriorityOnly, remaining, combined, capital, fleet, random, params);
                addedSomething |= addedCapital;
                if (addedCapital) {
                    FleetFactoryV3.redistributeFP(remWarship, remCarrier, remPhase, combined.fp);
                }
                params.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
                params.blockFallback = null;
            } else {
                addedSomething |= FleetFactoryV3.addShips(capitalPicker, usePriorityOnly, remaining, null, capital, fleet, random, params);
            }
            if (addedSomething || ++numFails != 2) continue;
            boolean goAgain = false;
            if (remPhase.fp > 0) {
                remWarship.fp += remPhase.fp;
                remPhase.fp = 0;
                goAgain = true;
            }
            if (remCarrier.fp > 0) {
                remWarship.fp += remCarrier.fp;
                remCarrier.fp = 0;
                goAgain = true;
            }
            if (!goAgain) continue;
            numFails = 0;
            smallPicker.add(smallRole, 1.0f);
            mediumPicker.add("combatMedium", 1.0f);
            largePicker.add("combatLarge", 1.0f);
            capitalPicker.add("combatCapital", 1.0f);
        }
    }

    protected static void addToPriorityOnlySet(CampaignFleetAPI fleet, Set<String> set, String small, String medium, String large) {
        int numPriority = fleet.getFaction().getNumAvailableForRole(small, FactionAPI.ShipPickMode.PRIORITY_ONLY) + fleet.getFaction().getNumAvailableForRole(medium, FactionAPI.ShipPickMode.PRIORITY_ONLY) + fleet.getFaction().getNumAvailableForRole(large, FactionAPI.ShipPickMode.PRIORITY_ONLY);
        if (numPriority > 0) {
            set.add(small);
            set.add(medium);
            set.add(large);
        }
    }

    protected static void redistributeFP(FPRemaining one, FPRemaining two, FPRemaining three, int newTotal) {
        float total = one.fp + two.fp + three.fp;
        if (total <= 0.0f) {
            return;
        }
        int f1 = Math.round((float)one.fp / total * (float)newTotal);
        int f2 = Math.round((float)two.fp / total * (float)newTotal);
        int f3 = Math.round((float)three.fp / total * (float)newTotal);
        f1 += newTotal - f1 - f2 - f3;
        one.fp = f1;
        two.fp = f2;
        three.fp = f3;
    }

    public static boolean addShips(WeightedRandomPicker<String> rolePicker, Set<String> usePriorityOnly, Map<String, FPRemaining> remaining, FPRemaining remOverride, int count, CampaignFleetAPI fleet, Random random, FleetParamsV3 params) {
        if (rolePicker.isEmpty()) {
            return false;
        }
        boolean addedSomething = false;
        int i = 0;
        while (i < count) {
            FPRemaining rem;
            String role = rolePicker.pick();
            if (role == null) break;
            FPRemaining remForProperRole = rem = remaining.get(role);
            if (remOverride != null) {
                rem = remOverride;
            }
            if (usePriorityOnly.contains(role)) {
                params.mode = FactionAPI.ShipPickMode.PRIORITY_ONLY;
            }
            int fpPrePick = rem.fp;
            boolean added = FleetFactoryV3.addShips(role, 1, params.source, random, fleet, rem, params);
            if (added && remOverride != null) {
                int fpSpent = fpPrePick - rem.fp;
                int maxToTakeFromProperRole = Math.min(remForProperRole.fp, fpSpent);
                remForProperRole.fp -= maxToTakeFromProperRole;
            }
            if (usePriorityOnly.contains(role)) {
                params.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
            }
            if (!added) {
                rolePicker.remove(role);
                --i;
                if (rolePicker.isEmpty()) break;
            }
            addedSomething |= added;
            ++i;
        }
        return addedSomething;
    }

    public static float getShipDeficitFleetSizeMult(MarketAPI market) {
        float mult = 1.0f;
        CommodityOnMarketAPI com = market.getCommodityData("ships");
        float available = com.getAvailable();
        float demand = com.getMaxDemand();
        if (demand > 0.0f) {
            float f = available / demand;
            if (f < MIN_NUM_SHIPS_DEFICIT_MULT) {
                f = MIN_NUM_SHIPS_DEFICIT_MULT;
            }
            mult *= f;
        }
        if (mult < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        return mult;
    }

    public static void addCommanderSkills(PersonAPI commander, CampaignFleetAPI fleet, Random random) {
        FleetFactoryV3.addCommanderSkills(commander, fleet, null, random);
    }

    public static void applyDamageToFleet(CampaignFleetAPI fleet, float damage, boolean damageRemainingShips, Random random) {
        if (random == null) {
            random = Misc.random;
        }
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : members) {
            float w = 1.0f;
            if (member.isCivilian()) {
                w *= 0.25f;
            }
            picker.add(member, w);
        }
        ArrayList<FleetMemberAPI> remove = new ArrayList<FleetMemberAPI>();
        float removedFP = 0.0f;
        float fpToRemove = (float)fleet.getFleetPoints() * damage * 0.8f;
        while (removedFP < fpToRemove && remove.size() < members.size() - 1 && !picker.isEmpty()) {
            FleetMemberAPI member = (FleetMemberAPI)picker.pickAndRemove();
            removedFP += (float)member.getFleetPointCost();
            remove.add(member);
        }
        for (FleetMemberAPI member : remove) {
            fleet.getFleetData().removeFleetMember(member);
        }
        if (damageRemainingShips) {
            int numStrikes = Math.round((float)picker.getItems().size() * damage);
            int i = 0;
            while (i < numStrikes) {
                FleetMemberAPI member = (FleetMemberAPI)picker.pick();
                if (member == null) {
                    return;
                }
                if (!(random.nextFloat() > damage)) {
                    float crPerDep = member.getDeployCost();
                    float suppliesPerDep = member.getStats().getSuppliesToRecover().getModifiedValue();
                    if (suppliesPerDep <= 0.0f || crPerDep <= 0.0f) {
                        return;
                    }
                    float suppliesPer100CR = suppliesPerDep * 1.0f / Math.max(0.01f, crPerDep);
                    float strikeSupplies = suppliesPer100CR * damage * (0.25f + 0.75f * random.nextFloat());
                    float strikeDamage = strikeSupplies / suppliesPer100CR * (0.75f + (float)Math.random() * 0.5f);
                    if (strikeDamage > HyperspaceTerrainPlugin.STORM_MAX_STRIKE_DAMAGE) {
                        strikeDamage = HyperspaceTerrainPlugin.STORM_MAX_STRIKE_DAMAGE;
                    }
                    if (strikeDamage > 0.0f) {
                        float currCR = member.getRepairTracker().getBaseCR();
                        float crDamage = Math.min(currCR, strikeDamage);
                        member.getRepairTracker().setCR(currCR - crDamage);
                        float hitStrength = member.getStats().getArmorBonus().computeEffective(member.getHullSpec().getArmorRating());
                        int numHits = (int)(strikeDamage / 0.1f);
                        if (numHits < 1) {
                            numHits = 1;
                        }
                        int j = 0;
                        while (j < numHits) {
                            member.getStatus().applyDamage(hitStrength);
                            ++j;
                        }
                        if (member.getStatus().getHullFraction() < 0.01f) {
                            member.getStatus().setHullFraction(0.01f);
                            picker.remove(member);
                        } else {
                            float w = picker.getWeight(member);
                            picker.setWeight(picker.getItems().indexOf(member), w * 0.5f);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static class FPRemaining {
        public int fp;

        public FPRemaining(int fp) {
            this.fp = fp;
        }

        public FPRemaining() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizeFilterMode {
        NONE,
        SMALL_IS_FRIGATE,
        SMALL_IS_DESTROYER;

    }
}

