/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManager;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class PatrolAssignmentAI
implements EveryFrameScript {
    private CampaignFleetAPI fleet;
    private PatrolFleetManager.PatrolFleetData data;
    private IntervalUtil tracker = new IntervalUtil(0.5f, 1.5f);
    private boolean orderedReturn = false;
    private CampaignFleetAPI inspectionTarget = null;

    public PatrolAssignmentAI(CampaignFleetAPI fleet, PatrolFleetManager.PatrolFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    private void giveInitialAssignment() {
        float daysToOrbit = this.getDaysToOrbit() * 0.25f;
        if (daysToOrbit < 0.2f) {
            daysToOrbit = 0.2f;
        }
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u6b63\u51c6\u5907\u5de1\u903b\u6267\u52e4");
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.fleet.getAI().getCurrentAssignment() != null) {
            float fp = this.fleet.getFleetPoints();
            if (fp < this.data.startingFleetPoints && !this.orderedReturn) {
                this.orderedReturn = true;
                this.fleet.clearAssignments();
                this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), 1.0f, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
                this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.data.sourceMarket.getPrimaryEntity(), 1000.0f);
            }
        } else {
            float daysToOrbit = this.getDaysToOrbit();
            StarSystemAPI system = this.data.sourceMarket.getStarSystem();
            if (system == null) {
                this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 20.0f, "\u6b63\u5728\u5de1\u903b\u4e8e " + this.data.sourceMarket.getName());
                this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
            } else if ((float)Math.random() > 0.95f) {
                this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, system.getHyperspaceAnchor(), 20.0f, "\u6b63\u5728\u5de1\u903b\u4e8e " + system.getBaseName() + " \u661f\u7cfb");
                this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
            } else {
                WeightedRandomPicker<SectorEntityToken> defenseTargets = new WeightedRandomPicker<SectorEntityToken>();
                SectorEntityToken generalPatrol = this.data.sourceMarket.getPrimaryEntity().getContainingLocation().createToken(0.0f, 0.0f);
                defenseTargets.add(generalPatrol, 30.0f);
                SectorEntityToken pick = (SectorEntityToken)defenseTargets.pick();
                if (pick == generalPatrol) {
                    this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, (SectorEntityToken)system.getStar(), 30.0f, "\u6b63\u5728\u5de1\u903b " + system.getBaseName() + " \u661f\u7cfb");
                    this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                    this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
                } else {
                    this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, pick, 30.0f, "\u6b63\u5728\u5de1\u903b\u4e8e " + pick.getName());
                    this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                    this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
                }
            }
        }
    }

    private void performInspectionIfNeeded() {
        if (this.inspectionTarget != null) {
            float dist;
            List<CampaignFleetAPI> hostiles = Misc.findNearbyFleets(this.fleet, 200.0f, new Misc.FleetFilter(){

                public boolean accept(CampaignFleetAPI curr) {
                    return curr.isHostileTo(PatrolAssignmentAI.this.fleet);
                }
            });
            if (this.inspectionTarget != null && ((dist = Misc.getDistance(this.inspectionTarget.getLocation(), this.fleet.getLocation())) > 2000.0f || this.inspectionTarget.getContainingLocation() != this.fleet.getContainingLocation())) {
                this.inspectionTarget.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.FOLLOW);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.FOLLOW);
                this.inspectionTarget = null;
                this.fleet.getMemoryWithoutUpdate().unset("$performingNPCInspection");
                return;
            }
            if (this.fleet.getMemoryWithoutUpdate().contains("$performingNPCInspection") && hostiles.isEmpty()) {
                dist = Misc.getDistance(this.inspectionTarget.getLocation(), this.fleet.getLocation());
                float radSum = this.inspectionTarget.getRadius() + this.fleet.getRadius();
                FleetAssignmentDataAPI curr = this.fleet.getAI().getCurrentAssignment();
                Vector2f offset = Vector2f.sub((Vector2f)this.fleet.getLocation(), (Vector2f)this.inspectionTarget.getLocation(), (Vector2f)new Vector2f());
                Misc.normalise(offset);
                offset.scale(radSum);
                Vector2f.add((Vector2f)this.inspectionTarget.getLocation(), (Vector2f)offset, (Vector2f)offset);
                SectorEntityToken loc = this.fleet.getContainingLocation().createToken(offset.x, offset.y);
                boolean forceReapproach = false;
                if (curr != null && curr.getTarget() != null) {
                    float locDist = Misc.getDistance(this.inspectionTarget.getLocation(), curr.getTarget().getLocation());
                    boolean bl = forceReapproach = locDist > radSum + 5.0f;
                }
                if ((dist - radSum > 5.0f || dist - radSum < -5.0f) && (curr == null || curr.getAssignment() != FleetAssignment.FOLLOW || forceReapproach)) {
                    this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                    this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.FOLLOW);
                    if (dist - radSum <= 50.0f) {
                        this.fleet.getAI().addAssignmentAtStart(FleetAssignment.FOLLOW, loc, 0.1f, "\u6b63\u6267\u884c\u6d77\u5173\u68c0\u67e5", null);
                    } else {
                        this.fleet.getAI().addAssignmentAtStart(FleetAssignment.FOLLOW, loc, 0.1f, "\u6b63\u5728\u63a5\u8fd1 " + this.inspectionTarget.getName(), null);
                    }
                } else if (dist - radSum <= 5.0f && dist - radSum >= -5.0f && (curr == null || curr.getAssignment() != FleetAssignment.HOLD)) {
                    this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.FOLLOW);
                    this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                    this.fleet.getAI().addAssignmentAtStart(FleetAssignment.HOLD, null, 0.1f, "\u6b63\u6267\u884c\u6d77\u5173\u68c0\u67e5", null);
                }
            } else {
                this.inspectionTarget.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.FOLLOW);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.HOLD);
                this.fleet.getAI().removeFirstAssignmentIfItIs(FleetAssignment.FOLLOW);
                this.inspectionTarget = null;
                this.fleet.getMemoryWithoutUpdate().unset("$performingNPCInspection");
            }
        }
    }

    private void checkNPCCustomsInspection() {
        if (this.inspectionTarget != null) {
            return;
        }
        if (this.fleet.getMemoryWithoutUpdate().contains("$core_fleetBusy")) {
            return;
        }
        if (!this.fleet.getMemoryWithoutUpdate().contains("$isCustomsInspector")) {
            return;
        }
        if (this.fleet.getAI() != null && !this.fleet.getAI().isCurrentAssignment(FleetAssignment.PATROL_SYSTEM) && !this.fleet.getAI().isCurrentAssignment(FleetAssignment.DEFEND_LOCATION)) {
            return;
        }
        MarketAPI closest = Misc.findNearestLocalMarketWithSameFaction(this.fleet, 1500.0f);
        if (closest == null || !closest.getFactionId().equals(this.fleet.getFaction().getId())) {
            return;
        }
        List<CampaignFleetAPI> hostiles = Misc.findNearbyFleets(this.fleet, 600.0f, new Misc.FleetFilter(){

            public boolean accept(CampaignFleetAPI curr) {
                return curr.isHostileTo(PatrolAssignmentAI.this.fleet);
            }
        });
        if (!hostiles.isEmpty()) {
            return;
        }
        ArrayList<CampaignFleetAPI> allFleets = new ArrayList<CampaignFleetAPI>(this.fleet.getContainingLocation().getFleets());
        allFleets.addAll(this.fleet.getContainingLocation().getFleets());
        WeightedRandomPicker<CampaignFleetAPI> picker = new WeightedRandomPicker<CampaignFleetAPI>();
        for (CampaignFleetAPI curr : allFleets) {
            if (curr == this.fleet || curr.isHostileTo(this.fleet) || curr.isInHyperspaceTransition() || !curr.getMemoryWithoutUpdate().contains("$isSmuggler") && !curr.getMemoryWithoutUpdate().contains("$isTradeFleet")) continue;
            if (curr.getMemoryWithoutUpdate().contains("$recentlyInspected")) {
                return;
            }
            if (curr.getMemoryWithoutUpdate().contains("$core_fleetBusy")) {
                return;
            }
            float dist = Misc.getDistance(curr.getLocation(), this.fleet.getLocation());
            if (dist > 1000.0f) continue;
            if (dist < 100.0f) {
                dist = 100.0f;
            }
            if (!(hostiles = Misc.findNearbyFleets(curr, 600.0f, new Misc.FleetFilter(){

                public boolean accept(CampaignFleetAPI curr) {
                    return curr.isHostileTo(PatrolAssignmentAI.this.fleet);
                }
            })).isEmpty()) continue;
            picker.add(curr, 1000.0f / dist);
        }
        if (picker.isEmpty()) {
            return;
        }
        CampaignFleetAPI target = (CampaignFleetAPI)picker.pick();
        target.getMemoryWithoutUpdate().set("$recentlyInspected", true, 15.0f);
        target.getMemoryWithoutUpdate().set("$core_fleetBusy", true, 3.0f);
        this.fleet.getMemoryWithoutUpdate().set("$core_fleetBusy", true, 3.0f);
        this.fleet.getMemoryWithoutUpdate().set("$performingNPCInspection", true, 2.0f);
        target.getAI().addAssignmentAtStart(FleetAssignment.HOLD, null, 2.0f, "\u6b63\u63a5\u53d7\u68c0\u67e5", null);
        this.inspectionTarget = target;
    }

    private float getDaysToOrbit() {
        float daysToOrbit = 0.0f;
        switch (this.data.type) {
            case FAST: {
                daysToOrbit += 2.0f;
                break;
            }
            case COMBAT: {
                daysToOrbit += 4.0f;
                break;
            }
            case HEAVY: {
                daysToOrbit += 6.0f;
            }
        }
        return daysToOrbit *= 0.5f + (float)Math.random() * 0.5f;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

