/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetOrStubAPI;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManagerV2;
import com.fs.starfarer.api.util.WeightedRandomPicker;

public class PatrolAssignmentAIV2
implements EveryFrameScript {
    private FleetStubAPI stub;
    private PatrolFleetManagerV2.PatrolFleetData data;
    private boolean orderedReturn = false;

    public PatrolAssignmentAIV2(FleetStubAPI stub, PatrolFleetManagerV2.PatrolFleetData data) {
        this.stub = stub;
        this.data = data;
        this.giveInitialAssignment();
    }

    private void giveInitialAssignment() {
        float daysToOrbit = this.getDaysToOrbit() * 0.25f;
        if (daysToOrbit < 0.2f) {
            daysToOrbit = 0.2f;
        }
        FleetOrStubAPI fleet = this.getAssignable();
        fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u6b63\u51c6\u5907\u5de1\u903b\u6267\u52e4");
    }

    private FleetOrStubAPI getAssignable() {
        FleetOrStubAPI fleet = this.stub;
        if (this.stub.getFleet() != null) {
            fleet = this.stub.getFleet();
        }
        return fleet;
    }

    public void advance(float amount) {
        FleetOrStubAPI fleet = this.getAssignable();
        if (fleet.getCurrentAssignment() != null) {
            float fp;
            if (fleet instanceof CampaignFleetAPI && (fp = (float)((CampaignFleetAPI)fleet).getFleetPoints()) < this.data.startingFleetPoints && !this.orderedReturn) {
                this.orderedReturn = true;
                fleet.clearAssignments();
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), 1.0f, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.data.sourceMarket.getPrimaryEntity(), 1000.0f);
            }
        } else {
            float daysToOrbit = this.getDaysToOrbit();
            StarSystemAPI system = this.data.sourceMarket.getStarSystem();
            if (system == null) {
                fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 20.0f, "\u6b63\u5728\u5de1\u903b\u4e8e " + this.data.sourceMarket.getName());
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
            } else if ((float)Math.random() > 0.95f) {
                fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, system.getHyperspaceAnchor(), 20.0f, "\u6b63\u5728\u5de1\u903b\u4e8e " + system.getBaseName() + " \u661f\u7cfb");
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
            } else {
                WeightedRandomPicker<SectorEntityToken> defenseTargets = new WeightedRandomPicker<SectorEntityToken>();
                SectorEntityToken generalPatrol = this.data.sourceMarket.getPrimaryEntity().getContainingLocation().createToken(0.0f, 0.0f);
                defenseTargets.add(generalPatrol, 30.0f);
                SectorEntityToken pick = (SectorEntityToken)defenseTargets.pick();
                if (pick == generalPatrol) {
                    fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, (SectorEntityToken)system.getStar(), 30.0f, "\u6b63\u5728\u5de1\u903b " + system.getBaseName() + " \u661f\u7cfb");
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
                } else {
                    fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, pick, 30.0f, "\u6b63\u5728\u5de1\u903b\u4e8e " + pick.getName());
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.data.sourceMarket.getPrimaryEntity(), 1000.0f, "\u6b63\u5728\u8fd4\u56de " + this.data.sourceMarket.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.sourceMarket.getPrimaryEntity(), daysToOrbit, "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de");
                }
            }
        }
    }

    private float getDaysToOrbit() {
        float daysToOrbit = 0.0f;
        switch (this.data.type) {
            case FAST: {
                daysToOrbit += 2.0f;
                break;
            }
            case COMBAT: {
                daysToOrbit += 4.0f;
                break;
            }
            case HEAVY: {
                daysToOrbit += 6.0f;
            }
        }
        return daysToOrbit *= 0.5f + (float)Math.random() * 0.5f;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

