/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FleetActionTextProvider;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.MilitaryBase;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import java.util.Random;

public class PatrolAssignmentAIV4
extends RouteFleetAssignmentAI
implements FleetActionTextProvider {
    public static final String PREP_STAGE = "a";
    public static final String TRAVEL_TO_STAGE = "b";
    public static final String PATROL_STAGE = "c";
    public static final String RETURN_STAGE = " \u5929\u540e\u7ed3\u675f";
    public static final String STAND_DOWN_STAGE = "e";

    public PatrolAssignmentAIV4(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        super(fleet, route);
    }

    protected void giveInitialAssignments() {
        SectorEntityToken target = this.pickEntityToGuard();
        if (target == null) {
            return;
        }
        RouteManager.RouteSegment current = this.route.getCurrent();
        SectorEntityToken source = this.route.getMarket().getPrimaryEntity();
        RouteLocationCalculator.TaskInterval[] intervals = new RouteLocationCalculator.TaskInterval[]{RouteLocationCalculator.TaskInterval.days(3.0f + (float)Math.random() * 3.0f), RouteLocationCalculator.TaskInterval.travel(), RouteLocationCalculator.TaskInterval.remaining(1.0f), RouteLocationCalculator.TaskInterval.travel(), RouteLocationCalculator.TaskInterval.days(3.0f + (float)Math.random() * 3.0f)};
        RouteLocationCalculator.computeIntervalsAndSetLocation(this.fleet, current.elapsed, current.daysMax, false, intervals, source, source, target, target, source, source);
        this.fleet.clearAssignments();
        float combinedTravelAndPatrolTime = intervals[1].value + intervals[2].value;
        if (intervals[0].value > 0.0f) {
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, source, intervals[0].value, PREP_STAGE);
        }
        if (intervals[1].value > 0.0f) {
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, target, combinedTravelAndPatrolTime, TRAVEL_TO_STAGE, true, null, null);
            combinedTravelAndPatrolTime = 0.0f;
        }
        if (intervals[2].value > 0.0f) {
            this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, target, combinedTravelAndPatrolTime, PATROL_STAGE, false, target.isSystemCenter() ? new Script(){

                public void run() {
                    PatrolAssignmentAIV4.this.fleet.getMemoryWithoutUpdate().set("$cfai_longPursuit", true);
                }
            } : null, target.isSystemCenter() ? new Script(){

                public void run() {
                    PatrolAssignmentAIV4.this.fleet.getMemoryWithoutUpdate().unset("$cfai_longPursuit");
                }
            } : null);
        }
        if (intervals[3].value > 0.0f) {
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, source, 1000.0f, RETURN_STAGE);
        }
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, source, intervals[4].value, STAND_DOWN_STAGE);
        this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, source, 1000.0f, STAND_DOWN_STAGE, this.goNextScript(current));
        this.fleet.getAI().setActionTextProvider(this);
    }

    public String getActionText(CampaignFleetAPI fleet) {
        boolean pirate;
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr == null) {
            return null;
        }
        String stage = curr.getActionText();
        SectorEntityToken target = curr.getTarget();
        String name = "";
        if (target != null) {
            CustomCampaignEntityAPI cce;
            name = target.getName();
            if (target instanceof CustomCampaignEntityAPI && name.equals((cce = (CustomCampaignEntityAPI)target).getCustomEntitySpec().getDefaultName())) {
                name = cce.getCustomEntitySpec().getNameInText();
            }
        }
        if (pirate = fleet.getMemoryWithoutUpdate().getBoolean("$isPirate")) {
            if (PREP_STAGE.equals(stage)) {
                return "\u6b63\u51c6\u5907\u5de1\u903b\u6267\u52e4";
            }
            if (TRAVEL_TO_STAGE.equals(stage) && target != null && !target.isSystemCenter() && !target.isInHyperspace()) {
                return "\u6b63\u5728\u524d\u5f80 " + name;
            }
            if (TRAVEL_TO_STAGE.equals(stage)) {
                return "\u884c\u52a8\u4e2d";
            }
            if (PATROL_STAGE.equals(stage) && target != null) {
                if (target.hasTag("objective")) {
                    return "\u6b63\u5728\u4fdd\u62a4 " + name;
                }
                if (target.hasTag("jump_point")) {
                    return "\u6b63\u5728\u4fdd\u62a4 " + name;
                }
                if (target.getMarket() != null) {
                    return "\u6b63\u5728\u4fdd\u536b " + name;
                }
                return "\u6b63\u5728\u5de1\u903b";
            }
            if (RETURN_STAGE.equals(stage) && target != null && !target.isSystemCenter()) {
                return "\u6b63\u5728\u8fd4\u56de " + name;
            }
            if (STAND_DOWN_STAGE.equals(stage)) {
                return "\u6b63\u5728\u79bb\u5f00";
            }
        } else {
            if (PREP_STAGE.equals(stage)) {
                return "\u6b63\u51c6\u5907\u5de1\u903b\u6267\u52e4";
            }
            if (TRAVEL_TO_STAGE.equals(stage) && target != null && !target.isSystemCenter() && !target.isInHyperspace()) {
                return "\u6b63\u5728\u524d\u5f80 " + name;
            }
            if (TRAVEL_TO_STAGE.equals(stage)) {
                return "\u884c\u52a8\u4e2d";
            }
            if (PATROL_STAGE.equals(stage) && target != null) {
                if (target.hasTag("objective")) {
                    return "\u6b63\u5728\u4fdd\u62a4 " + name;
                }
                if (target.hasTag("jump_point")) {
                    return "\u6b63\u5728\u4fdd\u62a4 " + name;
                }
                if (target.getMarket() != null) {
                    return "\u6b63\u5728\u5de1\u903b\u4e8e " + name;
                }
                return "\u6b63\u5728\u5de1\u903b";
            }
            if (RETURN_STAGE.equals(stage) && target != null && !target.isSystemCenter()) {
                return "\u6b63\u5728\u8fd4\u56de " + name;
            }
            if (STAND_DOWN_STAGE.equals(stage)) {
                return "\u5de1\u903b\u7ed3\u675f\uff0c\u6b63\u5728\u8fd4\u56de";
            }
        }
        return null;
    }

    public void advance(float amount) {
        super.advance(amount);
        this.checkCapture(amount);
        this.checkBuild(amount);
    }

    public SectorEntityToken pickEntityToGuard() {
        SectorEntityToken target;
        StarSystemAPI system;
        int i;
        float w;
        Random random = this.route.getRandom(1);
        MilitaryBase.PatrolFleetData custom = (MilitaryBase.PatrolFleetData)this.route.getCustom();
        FleetFactory.PatrolType type = custom.type;
        LocationAPI loc = this.fleet.getContainingLocation();
        if (loc == null) {
            return null;
        }
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(random);
        CountingMap<SectorEntityToken> existing = new CountingMap<SectorEntityToken>();
        for (RouteManager.RouteData data : RouteManager.getInstance().getRoutesForSource(this.route.getSource())) {
            FleetAssignmentDataAPI curr;
            CampaignFleetAPI other = data.getActiveFleet();
            if (other == null || (curr = other.getCurrentAssignment()) == null || curr.getTarget() == null || curr.getAssignment() != FleetAssignment.PATROL_SYSTEM) continue;
            existing.add(curr.getTarget());
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(this.fleet.getContainingLocation());
        int hostileMax = 0;
        int ourMax = 0;
        for (MarketAPI market : markets) {
            if (market.getFaction().isHostileTo(this.fleet.getFaction())) {
                hostileMax = Math.max(hostileMax, market.getSize());
                continue;
            }
            if (market.getFaction() != this.fleet.getFaction()) continue;
            ourMax = Math.max(ourMax, market.getSize());
        }
        boolean inControl = ourMax > hostileMax;
        for (SectorEntityToken entity : loc.getEntitiesWithTag("objective")) {
            if (entity.getFaction() != this.fleet.getFaction()) continue;
            w = 2.0f;
            i = 0;
            while (i < existing.getCount(entity)) {
                w *= 0.1f;
                ++i;
            }
            if (type == FleetFactory.PatrolType.HEAVY) {
                w *= 0.1f;
            }
            picker.add(entity, w);
        }
        for (SectorEntityToken entity : loc.getEntitiesWithTag("stable_location")) {
            w = 2.0f;
            i = 0;
            while (i < existing.getCount(entity)) {
                w *= 0.1f;
                ++i;
            }
            if (type == FleetFactory.PatrolType.HEAVY) {
                w *= 0.1f;
            }
            picker.add(entity, w);
        }
        if (inControl) {
            for (SectorEntityToken entity : loc.getJumpPoints()) {
                w = 2.0f;
                i = 0;
                while (i < existing.getCount(entity)) {
                    w *= 0.1f;
                    ++i;
                }
                if (type == FleetFactory.PatrolType.HEAVY) {
                    w *= 0.1f;
                }
                picker.add(entity, w);
            }
            if (loc instanceof StarSystemAPI && custom.type == FleetFactory.PatrolType.HEAVY && (system = (StarSystemAPI)loc).getHyperspaceAnchor() != null) {
                float w2 = 3.0f;
                int i2 = 0;
                while (i2 < existing.getCount(system.getHyperspaceAnchor())) {
                    w2 *= 0.1f;
                    ++i2;
                }
                picker.add(system.getHyperspaceAnchor(), w2);
            }
        }
        for (MarketAPI market : markets) {
            if (market.getFaction().isHostileTo(this.fleet.getFaction())) continue;
            float w3 = 0.0f;
            if (market == this.route.getMarket()) {
                w3 = 5.0f;
            } else if (market.getMemoryWithoutUpdate().getBoolean("$patrol")) {
                w3 = market.getFaction() != this.fleet.getFaction() ? 0.0f : 4.0f;
            }
            i = 0;
            while (i < existing.getCount(market.getPrimaryEntity())) {
                w3 *= 0.1f;
                ++i;
            }
            picker.add(market.getPrimaryEntity(), w3);
        }
        if (this.fleet.getContainingLocation() instanceof StarSystemAPI && type != FleetFactory.PatrolType.HEAVY) {
            system = (StarSystemAPI)this.fleet.getContainingLocation();
            float w4 = 1.0f;
            int i3 = 0;
            while (i3 < existing.getCount(system.getCenter())) {
                w4 *= 0.1f;
                ++i3;
            }
            picker.add(system.getCenter(), w4);
        }
        if ((target = (SectorEntityToken)picker.pick()) == null) {
            target = this.route.market.getPrimaryEntity();
        }
        return target;
    }
}

