/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetOrStubAPI;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolAssignmentAIV2;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.RollingAverageTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PatrolFleetManagerV2
extends BaseCampaignEventListener
implements EveryFrameScript,
FleetEventListener {
    public static Logger log = Global.getLogger(PatrolFleetManagerV2.class);
    private MarketAPI market;
    private List<PatrolFleetData> activePatrols = new ArrayList<PatrolFleetData>();
    private IntervalUtil tracker;
    private int maxPatrols;
    private RollingAverageTracker patrolBattlesLost;

    public PatrolFleetManagerV2(MarketAPI market) {
        super(true);
        this.market = market;
        float interval = Global.getSettings().getFloat("averagePatrolSpawnInterval");
        this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        this.readResolve();
    }

    protected Object readResolve() {
        if (this.patrolBattlesLost == null) {
            float patrolStrengthCheckInterval = Global.getSettings().getFloat("economyIntervalnGameDays");
            float min = patrolStrengthCheckInterval - Math.min(patrolStrengthCheckInterval * 0.5f, 2.0f);
            float max = patrolStrengthCheckInterval + Math.min(patrolStrengthCheckInterval * 0.5f, 2.0f);
            this.patrolBattlesLost = new RollingAverageTracker(min, max, Misc.getGenericRollingAverageFactor());
        }
        return this;
    }

    public void advance(float amount) {
        boolean hasStationOrSpaceport;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.patrolBattlesLost.advance(days);
        float losses = this.patrolBattlesLost.getAverage();
        this.tracker.advance(days * Math.max(1.0f, losses));
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (this.market.hasCondition("decivilized")) {
            return;
        }
        ArrayList<PatrolFleetData> remove = new ArrayList<PatrolFleetData>();
        for (PatrolFleetData data : this.activePatrols) {
            if (data.stub.getContainingLocation() != null && (data.stub.getContainingLocation().getFleets().contains(data.stub.getFleet()) || data.stub.getContainingLocation().getFleetStubs().contains(data.stub))) continue;
            remove.add(data);
            log.info((Object)("Cleaning up orphaned patrol [" + data.stub.getId() + "] for market [" + this.market.getName() + "]"));
        }
        this.activePatrols.removeAll(remove);
        this.maxPatrols = (int)((float)Math.max(1, this.market.getSize() - 3) * (this.market.getStabilityValue() / 10.0f)) + (int)Math.max(0.0f, Math.min(losses, 5.0f));
        if (this.maxPatrols < 1) {
            this.maxPatrols = 1;
        }
        boolean bl = hasStationOrSpaceport = this.market.hasIndustry("orbitalstation") || this.market.hasSpaceport() || this.market.hasIndustry("battlestation");
        if (this.market.hasIndustry("militarybase")) {
            ++this.maxPatrols;
            if (hasStationOrSpaceport) {
                ++this.maxPatrols;
            }
        }
        if (hasStationOrSpaceport) {
            ++this.maxPatrols;
        }
        log.debug((Object)"");
        log.debug((Object)("Checking whether to spawn patrol for market [" + this.market.getName() + "]"));
        if (this.activePatrols.size() < this.maxPatrols) {
            log.info((Object)(String.valueOf(this.activePatrols.size()) + " out of a maximum " + this.maxPatrols + " patrols in play for market [" + this.market.getName() + "]"));
            WeightedRandomPicker<FleetFactory.PatrolType> picker = new WeightedRandomPicker<FleetFactory.PatrolType>();
            picker.add(FleetFactory.PatrolType.FAST, Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.COMBAT, FleetFactory.PatrolType.HEAVY)));
            picker.add(FleetFactory.PatrolType.COMBAT, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.FAST, FleetFactory.PatrolType.HEAVY) + this.market.getSize()) + losses * 0.5f);
            if (this.market.getSize() >= 5) {
                picker.add(FleetFactory.PatrolType.HEAVY, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.FAST, FleetFactory.PatrolType.COMBAT) + this.market.getSize() - 5) + losses);
            }
            FleetFactory.PatrolType type = (FleetFactory.PatrolType)((Object)picker.pick());
            float combat = 0.0f;
            float tanker = 0.0f;
            float freighter = 0.0f;
            String fleetType = "patrolSmall";
            switch (type) {
                case FAST: {
                    fleetType = "patrolSmall";
                    combat = Math.round(3.0f + (float)Math.random() * 2.0f);
                    combat += Math.min(5.0f, losses * 2.0f);
                    break;
                }
                case COMBAT: {
                    fleetType = "patrolMedium";
                    combat = Math.round(6.0f + (float)Math.random() * 3.0f);
                    combat += Math.min(15.0f, losses * 4.0f);
                    tanker = Math.round((float)Math.random());
                    break;
                }
                case HEAVY: {
                    fleetType = "patrolLarge";
                    combat = Math.round(10.0f + (float)Math.random() * 5.0f);
                    combat += Math.min(25.0f, losses * 6.0f);
                    tanker = 2.0f;
                    freighter = 2.0f;
                }
            }
            SectorEntityToken entity = this.market.getPrimaryEntity();
            FleetOrStubAPI stub = null;
            PatrolFleetData data = new PatrolFleetData((FleetStubAPI)stub, type);
            data.startingFleetPoints = (combat *= 1.0f + this.market.getStabilityValue() / 20.0f) * 3.0f;
            data.sourceMarket = this.market;
            this.activePatrols.add(data);
            PatrolAssignmentAIV2 ai = new PatrolAssignmentAIV2((FleetStubAPI)stub, data);
            stub.addScript(ai);
            stub.getMemoryWithoutUpdate().set("$isPatrol", true);
            if (type == FleetFactory.PatrolType.FAST || type == FleetFactory.PatrolType.COMBAT) {
                stub.getMemoryWithoutUpdate().set("$isCustomsInspector", true);
            }
            stub.setAdmiralPost(Ranks.POST_PATROL_COMMANDER);
            switch (type) {
                case FAST: {
                    stub.setAdmiralRank(Ranks.SPACE_LIEUTENANT);
                    break;
                }
                case COMBAT: {
                    stub.setAdmiralRank(Ranks.SPACE_COMMANDER);
                    break;
                }
                case HEAVY: {
                    stub.setAdmiralRank(Ranks.SPACE_CAPTAIN);
                }
            }
            log.info((Object)("Spawned patrol fleet [" + stub.getId() + "] from market " + this.market.getName()));
        } else {
            log.debug((Object)("Maximum number of " + this.maxPatrols + " patrols already in play for market [" + this.market.getName() + "]"));
        }
    }

    private int getCount(FleetFactory.PatrolType ... types) {
        int count = 0;
        FleetFactory.PatrolType[] patrolTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            FleetFactory.PatrolType type = patrolTypeArray[n2];
            for (PatrolFleetData data : this.activePatrols) {
                if (data.type != type) continue;
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        for (PatrolFleetData data : this.activePatrols) {
            if (data.stub.getId() != fleet.getId()) continue;
            this.activePatrols.remove(data);
            break;
        }
    }

    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    public static class PatrolFleetData {
        public float startingFleetPoints = 0.0f;
        public FleetStubAPI stub;
        public FleetFactory.PatrolType type;
        public MarketAPI sourceMarket;

        public PatrolFleetData(FleetStubAPI fleet, FleetFactory.PatrolType type) {
            this.stub = fleet;
            this.type = type;
        }
    }
}

